<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xalan="http://xml.apache.org/xalan"
	xmlns:utils="ru.bitel.common.Utils"
	xmlns:common="http://common.bitel.ru">
<xsl:import href="layout.xsl"/>

<xsl:template name="title">
	<xsl:choose>	
		<xsl:when test="data/@action = 'SessionReport'">Просмотр сессий</xsl:when>
		<xsl:when test="data/@action = 'TrafficReport'">Просмотр трафиков</xsl:when>
		<xsl:when test="data/@action = 'TrafficMaxReport'">Просмотр превалирующих трафиков</xsl:when>
		<xsl:when test="data/@action = 'TrafficRangeReport'">Просмотр пакетов трафиков</xsl:when>
		<xsl:when test="data/@action = 'ChangeLoginPassword'">Смена пароля на логины</xsl:when>
		<xsl:when test="data/@action = 'ShowPeriods'">Учетные периоды inet</xsl:when>
	</xsl:choose>
</xsl:template>

<xsl:template match="/data">
	<xsl:choose>
		<xsl:when test="@action = 'SessionReport'">
		 	<xsl:call-template name="SessionReport"/>
		</xsl:when>
		<xsl:when test="@action = 'TrafficReport'">
		 	<xsl:call-template name="TrafficReport"/>
		</xsl:when>
		<xsl:when test="@action = 'TrafficMaxReport'">
		 	<xsl:call-template name="TrafficMaxReport"/>
		</xsl:when>
		<xsl:when test="@action = 'TrafficRangeReport'">
		 	<xsl:call-template name="TrafficRangeReport"/>
		</xsl:when>
		<xsl:when test="@action = 'ChangeLoginPassword'">
		 	<xsl:call-template name="ChangeLoginPassword"/>
		</xsl:when>
		<xsl:when test="@action = 'ShowPeriods'">
	 		<xsl:call-template name="ShowPeriods"/>
		</xsl:when>
	</xsl:choose>
</xsl:template>

<xsl:template name="head">
	<script language="javascript" type="text/javascript">
			<xsl:text disable-output-escaping="yes">
	<![CDATA[
	window.onload = function()
	{
		filterAccountDetail();
	}
	
	function filterAccountDetail()
	{
		var table;
		for ( i=1; (table=document.getElementById("sessionDetailTable_" + i))!=null; i++ )
		{
			if (table.rows[0].cells.length < 2)
			{
				document.getElementById("sessionDetailLink_" + i).style.display='none';
			}
		}
	}
	
	function reportExportRequest( format, zip )
	{
		$("oper").value = "historyExport"; 
		$("exportFormat").value = format;
		$("zip").value = zip;
		$("reportForm").submit();
	}
	
	function clearSelection( select ) {
		for (var i=0; i<select.options.length; i++) {
			select.options[i].selected = false;
		}
	}
	
	function toggleAccount( a, count ) {
		accountTR = window["sessionDetail_"+count];
		
		if (accountTR.style.display=='') {
			accountTR.style.display='none';
			a.innerHTML = '>>';
		} else {
			accountTR.style.display='';
			a.innerHTML = '&lt;&lt;';
		}
	}
	]]>
			</xsl:text>
		</script>
</xsl:template>
	
<xsl:template name="sessionFilter">
	<td>Сервис:<br/><select class="gradbtn" style="width: 100%" name="inetServId"><xsl:call-template name="servList"/></select></td>
	<td style="padding-left: 5px; padding-right: 5px;">Ед. измерения:<br/><select class="gradbtn"  style="width: 100%" name='unit'><xsl:call-template name="unit_list"/></select></td>
</xsl:template>		
	
<xsl:template name="servList">
   	<xsl:for-each select="/data/servs/data/item">
		<option>				
			<xsl:if test="/data/inetServId=@id"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
			<xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
			<xsl:value-of select="@title"/>				
		</option>
   	</xsl:for-each>
</xsl:template>
	
<xsl:template name="SessionReport">

	<xsl:variable name="URI"><xsl:value-of select="$WEBEXECUTER"/>?action=<xsl:value-of select="/data/@action"/>&amp;module=<xsl:value-of select="/data/@module"/>&amp;mid=<xsl:value-of select="/data/@mid"/>&amp;contractId=<xsl:value-of select="/data/@id"/></xsl:variable>

	<form method="post" action='{$WEBEXECUTER}#idDivReport' name="sessions" id="reportForm">
		<input type="hidden" name="pageIndex"><xsl:attribute name="value"><xsl:value-of select="page/@pageIndex"/></xsl:attribute></input>
		<input type="hidden" name="pageSize"><xsl:attribute name="value"><xsl:value-of select="page/@pageSize"/></xsl:attribute></input>

	<xsl:choose>
		<xsl:when test="/data/@operation='history'">
		
			<table class="filter" style="margin-bottom: 5pt;">
				<tr>
					<td style="padding-right:5pt;"><a href="#" onclick="document.location='{$URI}&amp;operation=execute'; return false;">Текущие сессии</a></td>
					<td><b>История сессий</b></td>
				</tr>
			</table>		
		
			<input id="oper" type="hidden" name="operation" value="history"/>
			<xsl:variable name="module" select="/data/@module"/>
			<xsl:call-template name="action"/>
			<table class="filter"><tr>
			<xsl:call-template name="sessionFilter"/>
			<xsl:call-template name="periodFilter"/>
			</tr></table>
			<xsl:call-template name="AddReportReferences"/>
		</xsl:when>
		<xsl:otherwise>

			<table class="filter" style="margin-bottom: 5pt;">
				<tr>
					<td style="padding-right:5pt;"><b>Текущие сессии</b></td>
					<td><a href="#" onclick="document.location='{$URI}&amp;operation=history'; return false;">История сессий</a></td>
				</tr>
			</table>	

			<input id="oper" type="hidden" name="operation" value="execute"/>   
			<xsl:variable name="module" select="/data/@module"/>
			<div class="filter" style="margin-bottom: 10pt">
			<xsl:call-template name="action"/>
			<table class="filter"><tr>
			<xsl:call-template name="sessionFilter"/>
			<td><br/>
				<xsl:call-template name="submit">
					<xsl:with-param name="title" select="'Применить'"/>
					<xsl:with-param name="guid" select="'_v'"/>
				</xsl:call-template></td></tr></table>
			</div>
		</xsl:otherwise>
	</xsl:choose>

	<xsl:if test="/data/inetServId &gt; 0">
	
		<xsl:variable name="realm" select="boolean(common:result/data/item/@realm and common:result/data/item/@realm != '')"/>
		<xsl:variable name="ip" select="boolean(common:result/data/item/@ip and common:result/data/item/@ip != '')"/>
		<xsl:variable name="cncdsId" select="boolean(common:result/data/item/@cdsId or common:result/data/item/@cnsId)"/>
		
		<xsl:variable name="colspan">
   			<xsl:choose><xsl:when test="$realm and $cncdsId and $ip">5</xsl:when>
   			<xsl:when test="($realm and $cncdsId) or ($realm and $ip) or ($cncdsId and $ip)">4</xsl:when>
   			<xsl:when test="$realm or $cncdsId or $ip">3</xsl:when>
   			<xsl:otherwise>2</xsl:otherwise></xsl:choose>
   		</xsl:variable>
		
		<table class="table800">
			<thead>
				<tr>
<!--				<td>Устройство</td>
					<td>Порт</td>
					<td>Сервис</td>-->
					<xsl:if test="$realm"><td>Реалм</td></xsl:if>
					<xsl:if test="$cncdsId"><td nowrap="1">C номера/На номер</td></xsl:if>
					<xsl:if test="$ip"><td>IP</td></xsl:if>
					<td>Время входа</td>
					<td>Время выхода</td>
					<!--<td>Активность</td>-->
					<td>Длительность</td>
					<td>Сумма, руб.</td>
					<!--<td>Статус</td>-->
					<td>&#160;</td>
				</tr>
			</thead>
			<xsl:if test="common:result/data/item">
				<tbody>
					<xsl:for-each select="common:result/data/item">
					
					<xsl:variable name="count" select="position()"/>
					
					<tr>
<!--						<td><xsl:value-of select="@deviceId"/></td>	
						<td><xsl:value-of select="@devicePort"/></td>
						<td>
							<xsl:variable name="sericeId"><xsl:value-of select="@servId"/></xsl:variable>
							<xsl:for-each select="/data/servs/data/item">
								<xsl:if test="@id=$sericeId"><xsl:value-of select="@deviceTitle"/>/<xsl:value-of select="@typeTitle "/></xsl:if>
							</xsl:for-each>
						</td>			-->
						<xsl:if test="$realm"><td><xsl:value-of select="@realm"/></td></xsl:if>
						<xsl:if test="$cncdsId"><td>
							<xsl:if test="@cdsId">
								<xsl:value-of select="@cnsId"/>/<xsl:value-of select="@cdsId"/>
							</xsl:if>
						</td></xsl:if>
						<xsl:if test="$ip"><td><xsl:value-of select="@ip"/></td></xsl:if>
						<td nowrap="1"><xsl:value-of select="@start"/></td>
						<td nowrap="1"><xsl:value-of select="@stop"/></td>
						<!-- <td><xsl:value-of select="@last"/></td> -->
						
						<!--<td>
							 <xsl:value-of select="@statusName"/>
						</td>-->
						
						<xsl:variable name="session" select="."/>
						
						<xsl:for-each select="/data/trafficTypes/data/item[@id=0]">
							<td nowrap="1">
								<xsl:variable name="typeId"><xsl:value-of select="@id"/></xsl:variable>
								<xsl:variable name="val" select="$session/trafficMap/entry[key/text()=$typeId]/value/text()"/>
								<xsl:choose>
									<xsl:when test="$typeId=0"><xsl:value-of select="utils:formatSessionTime( $val )"/></xsl:when>
									<xsl:when test="number($val)!=number($val)">0.000</xsl:when>
									<xsl:otherwise><xsl:value-of select="format-number(($val div /data/unit), '### ### ### ##0.000', 'summa')"/></xsl:otherwise>
								</xsl:choose>
							</td>
						</xsl:for-each>		
						
						<td><xsl:value-of select="format-number(@cost, '### ### ### ##0.00000', 'summa')"/></td>
						
						<td><a id="sessionDetailLink_{$count}" href="#a" onclick="toggleAccount(this, {$count});">>></a></td>				
					</tr>
					<tr style="display: none" id="sessionDetail_{$count}">
						<td colspan="{$colspan + 4}">
						
						<xsl:variable name="session" select="."/>
					
						<table class="table800" id="sessionDetailTable_{$count}" style="width:auto;"><thead><tr><td style="width: 10em">Услуга</td>
						
						<xsl:for-each select="/data/services/data/item">
							<xsl:variable name="serviceId"><xsl:value-of select="@id"/></xsl:variable>
							<xsl:variable name="serviceAmount" select="$session/accountMap/entry[key/text()=$serviceId]/value/@amount + sum($session/children/child/accountMap/entry[key/text()=$serviceId]/value/@amount)"/>
							
							<xsl:if test="$serviceAmount>0">
								<td><xsl:value-of select="@title"/></td>
							</xsl:if>
						</xsl:for-each>

						</tr></thead><tbody><tr><td>Наработка</td>

						<xsl:for-each select="/data/services/data/item">
							<xsl:variable name="serviceId"><xsl:value-of select="@id"/></xsl:variable>
							<xsl:variable name="serviceAmount" select="$session/accountMap/entry[key/text()=$serviceId]/value/@amount + sum($session/children/child/accountMap/entry[key/text()=$serviceId]/value/@amount)"/>

							<xsl:if test="$serviceAmount>0">
								<xsl:choose><xsl:when test="number(@unit) = 20000">
									<td><xsl:value-of select="utils:formatSessionTime($serviceAmount)"/></td>
								</xsl:when><xsl:otherwise>
									<td><xsl:value-of select="format-number(($serviceAmount div /data/unit), '### ### ### ##0.000', 'summa')"/></td>
								</xsl:otherwise></xsl:choose>
							</xsl:if>
						</xsl:for-each>

						</tr><tr><td>Сумма, руб.</td>

						<xsl:for-each select="/data/services/data/item">
							<xsl:variable name="serviceId"><xsl:value-of select="@id"/></xsl:variable>
							<xsl:variable name="serviceAmount" select="$session/accountMap/entry[key/text()=$serviceId]/value/@amount + sum($session/children/child/accountMap/entry[key/text()=$serviceId]/value/@amount)"/>
							<xsl:variable name="serviceCost" select="$session/accountMap/entry[key/text()=$serviceId]/value/@account + sum($session/children/child/accountMap/entry[key/text()=$serviceId]/value/@account)"/>
							
							<xsl:if test="$serviceAmount>0">
								<td><xsl:value-of select="format-number($serviceCost, '### ### ### ##0.00000', 'summa')"/></td>
							</xsl:if>
						</xsl:for-each>

						</tr></tbody>
						</table>
						
						
						</td>
					</tr>
					</xsl:for-each>
				</tbody>
			</xsl:if>	
			<tfoot>
			   <tr>
			   		<xsl:variable name="totalCount" select="number(common:result/attributes/item[@key='totalCount']/value)"/>
			   		<xsl:variable name="totalCost" select="number(common:result/attributes/item[@key='totalCost']/value)"/>
			   		

			   		
			   		<td colspan="{$colspan}" style="text-align: left;">Итого сессий:&#160;<xsl:value-of select="$totalCount"/></td>
			   		
					<!--<td></td>	-->
					
					<!-- <td>&#160;</td> -->		

					<xsl:for-each select="/data/trafficTypes/data/item[@id=0]">
						<td nowrap="1">
							<xsl:variable name="typeId"><xsl:value-of select="@id"/></xsl:variable>
							<xsl:variable name="val" select="/data/common:result/attributes/item[@key='totalTraffics']/value/data/entry[key/text()=$typeId]/value/text()"/>
							<xsl:choose>
								<xsl:when test="$typeId=0"><xsl:value-of select="utils:formatSessionTime( $val )"/></xsl:when>
								<xsl:when test="number($val)!=number($val)">0.000</xsl:when>
								<xsl:otherwise><xsl:value-of select="format-number(($val div /data/unit), '### ### ### ##0.000', 'summa')"/></xsl:otherwise>
							</xsl:choose>
						</td>
					</xsl:for-each>
					
					<td><xsl:value-of select="format-number($totalCost, '### ### ### ##0.00000', 'summa')"/></td>
					<td>&#160;</td>		
				</tr>
			</tfoot>
		</table>		
	
	
	</xsl:if></form>
</xsl:template>

<xsl:template name="ChangeLoginPassword">
	<form method='post' action='{$WEBEXECUTER}'>
		<xsl:call-template name="action"/>
		<input type="hidden" name="operation" value="change"/>

		<xsl:if test="/data/status/text() = 'ok'"><div class="alert alert-primary">Пароль изменен!</div></xsl:if>

		<div class="report">
			<table cellspacing="1">
			<tbody>
				<tr>
    				<td nowrap="1">Логин:</td>
	    			<td>
     					<select class="gradbtn " name="login">
					   	<xsl:for-each select="/data/servs/data/item">
							<option>
								<xsl:if test="@id=/data/selectedId/text()"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
								<xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
								<xsl:value-of select="@uname"/>
							</option>
					   	</xsl:for-each>
        				</select>
        			</td>
				</tr>  
    			<tr>
    				<td nowrap="1">Старый пароль:</td>
					<td><input type="password" name='old_pswd' maxlength='15'/></td>
				</tr>
    			<tr>
        			<td nowrap="1">Новый пароль:</td>
					<td><input type="password" name='pswd1' maxlength='15'/></td>
				</tr>
				<tr>
					<td nowrap="1">Повторите пароль:</td>
					<td><input type="password" name='pswd2' maxlength='15'/></td>
				</tr>
			</tbody>
			<tfoot>
				<tr>
					<td colspan='2'>
						<xsl:call-template name="submit"><xsl:with-param name="title" select="'Сменить'"/></xsl:call-template>
					</td>
				</tr>
			</tfoot>
			</table>
		</div>
	</form>
</xsl:template>

<xsl:template name="AddReportReferences">
	<div>
		<input type="hidden" id="exportFormat" name="exportFormat" />
		<input type="hidden" id="zip" name="zip" />
		
		Отчет в виде:
		<a title="CSV" href="#" onclick="reportExportRequest( 'csv', 0 );">CSV</a>,
		<a title="HTML" href="#" onclick="reportExportRequest( 'html', 0 );">HTML</a>,
		<a title="CSV/ZIP" href="#" onclick="reportExportRequest( 'csv', 1 );">CSV/ZIP</a>,
		<a title="HTML/ZIP" href="#" onclick="reportExportRequest( 'html', 1 );">HTML/ZIP</a>
	</div>
</xsl:template>

<xsl:template name="TrafficReport">

	<xsl:variable name="URI"><xsl:value-of select="$WEBEXECUTER"/>?module=<xsl:value-of select="/data/@module"/>&amp;mid=<xsl:value-of select="/data/@mid"/>&amp;</xsl:variable>

	<table class="filter" style="margin-bottom: 5pt;">
		<tr>
			<td style="padding-right:5pt;"><b>Обычные трафики</b></td>
			<td style="padding-right:5pt;"><a href="#" onclick="document.location='{$URI}action=TrafficMaxReport&amp;operation=execute'; return false;">Превалирующие трафики</a></td>
			<td><a href="#" onclick="document.location='{$URI}action=TrafficRangeReport&amp;operation=execute'; return false;">Пакеты трафиков</a></td>
		</tr>
	</table>

	<form method='post' action='{$WEBEXECUTER}'>
	<xsl:call-template name="action"/>	
	<xsl:call-template name="error"/>	
	<table class="filter">
	<tr>
		<td colspan="2">
			<table><tr>
				<td>Сервис:</td>
				<td style="width:100%">
					<select name="inetServId" style="width:100%" onchange="clearSelection(this.form.trafficTypeIds);this.form.submit()">
						<xsl:call-template name="servList"/>
					</select>
				</td>
			</tr></table>
		</td>
	</tr>
	<tr>
		<td>Трафик:</td>
		<td></td>
	</tr>
	<tr>
		<td>
			<select size='6' name='trafficTypeIds' multiple='1' style="min-width: 150px;">
		   	<xsl:for-each select="/data/trafficTypes/data/item">
				<option>				
					<xsl:if test="/data/trafficTypeIds/data/item=@id"><xsl:attribute name="selected">1</xsl:attribute></xsl:if>
					<xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
					<xsl:value-of select="@title"/>				
				</option>
		   	</xsl:for-each>
			</select>
		</td>
		<td rowspan="1" style="text-align:right; vertical-align:top;">
			<div align="right"><xsl:call-template name="dayFilterForm"><xsl:with-param name="withSubmit" select="0"></xsl:with-param></xsl:call-template></div>
			<div>
				Ед. измерения:<select style="margin-right:2px" name='unit'>
					<xsl:call-template name="unit_list"/>
				</select>

				<xsl:call-template name="submit">
					<xsl:with-param name="title" select="'Вывести'"/>
				</xsl:call-template>
			</div>
		</td>
	</tr>
	<tr>
		<td colspan="2">
			<em class='comment'>Для выделения сразу нескольких трафиков держите нажатой клавишу 'Ctrl'</em>
		</td>
	</tr>
	</table>
	</form>
	
	<!-- <em class='comment'>Обратите внимание, что в данном отчете выводится информация по трафикам только завершенных сессий.</em>  -->

	<xsl:if test="/data/common:result">
	<xsl:if test="/data/chart">
	<div>
	<img style="margin-top: 15pt; width: 800px; height: 300px;" src="webexecuter?module={/data/@module}&amp;mid={/data/@mid}&amp;action=TrafficReport&amp;operation=chart&amp;chart={/data/chart}"/>
	</div>
	</xsl:if>
	<xsl:if test="/data/chartPie">
	<div>
	<img style="margin-top: 0pt; width: 800px; height: 250px;" src="webexecuter?module={/data/@module}&amp;mid={/data/@mid}&amp;action=TrafficReport&amp;operation=chart&amp;chart={/data/chartPie}"/>
	</div>
	</xsl:if>
	
	<xsl:variable name="unit" select="/data/unit"/>
	
	<table class="table800" style="margin-top: 5pt; margin-bottom: 5pt;">
	
	<xsl:choose><xsl:when test="/data/days/data/item">
		<xsl:call-template name="addStatRow">
			<xsl:with-param name="row" select="1"/>
			<xsl:with-param name="unit" select="$unit"/>
		</xsl:call-template>
		<xsl:call-template name="addStatRow">
			<xsl:with-param name="row" select="2"/>
			<xsl:with-param name="unit" select="$unit"/>
		</xsl:call-template>
		<xsl:call-template name="addStatRow">
			<xsl:with-param name="row" select="3"/>
			<xsl:with-param name="unit" select="$unit"/>
		</xsl:call-template>
		<xsl:call-template name="addStatRow">
			<xsl:with-param name="row" select="4"/>
			<xsl:with-param name="unit" select="$unit"/>
		</xsl:call-template>
	</xsl:when><xsl:otherwise>
		<tr><xsl:call-template name="addStatRowHourHeader">
			<xsl:with-param name="hour" select="0"/>
			<xsl:with-param name="unit" select="$unit"/>
		</xsl:call-template></tr>
		<tr><xsl:call-template name="addStatRowHourValue">
			<xsl:with-param name="hour" select="0"/>
			<xsl:with-param name="unit" select="$unit"/>
		</xsl:call-template></tr>
		<tr><xsl:call-template name="addStatRowHourHeader">
			<xsl:with-param name="hour" select="8"/>
			<xsl:with-param name="unit" select="$unit"/>
		</xsl:call-template></tr>
		<tr><xsl:call-template name="addStatRowHourValue">
			<xsl:with-param name="hour" select="8"/>
			<xsl:with-param name="unit" select="$unit"/>
		</xsl:call-template></tr>
		<tr><xsl:call-template name="addStatRowHourHeader">
			<xsl:with-param name="hour" select="16"/>
			<xsl:with-param name="unit" select="$unit"/>
		</xsl:call-template></tr>
		<tr><xsl:call-template name="addStatRowHourValue">
			<xsl:with-param name="hour" select="16"/>
			<xsl:with-param name="unit" select="$unit"/>
		</xsl:call-template></tr>
	</xsl:otherwise></xsl:choose>
	
	</table>
	
	<div style="font-weight: bold; margin-bottom:15pt;">Итого: <xsl:value-of select="format-number( sum(/data/common:result/data/item/trafficMap/entry/value) div $unit, '### ### ### ##0.###', 'summa')"/>
		&#160;<xsl:call-template name="unit_title"><xsl:with-param name="unit" select="$unit"/></xsl:call-template>.
	</div>
	
	</xsl:if>

</xsl:template>

<xsl:template name="TrafficMaxReport">

	<xsl:variable name="URI"><xsl:value-of select="$WEBEXECUTER"/>?module=<xsl:value-of select="/data/@module"/>&amp;mid=<xsl:value-of select="/data/@mid"/>&amp;</xsl:variable>

	<table class="filter" style="margin-bottom: 5pt;">
		<tr>
			<td style="padding-right:5pt;"><a href="#" onclick="document.location='{$URI}action=TrafficReport&amp;operation=execute'; return false;">Обычные трафики</a></td>
			<td style="padding-right:5pt;"><b>Превалирующие трафики</b></td>
			<td><a href="#" onclick="document.location='{$URI}action=TrafficRangeReport&amp;operation=execute'; return false;">Пакеты трафиков</a></td>
		</tr>
	</table>

	<form method='post' action='{$WEBEXECUTER}'>
	<xsl:call-template name="action"/>	
	<xsl:call-template name="error"/>
	
	<table class="filter">
	<tr>
			<td style="text-align:right; vertical-align:top;">
			<div align="left"><xsl:call-template name="dayFilterForm"><xsl:with-param name="withSubmit" select="0"></xsl:with-param>
			<xsl:with-param name="nowrap" select="0"></xsl:with-param></xsl:call-template></div>
			</td>
			<td style="padding-left: 5px; text-align:right; vertical-align:top;">Ед. измерения:<br/><select class="gradbtn"  style="width: 100%" name='unit'><xsl:call-template name="unit_list"/></select></td>
			<td style="padding-left: 5px; text-align:right; vertical-align:top;">	<br/>			<xsl:call-template name="submit">
					<xsl:with-param name="title" select="'Вывести'"/>
				</xsl:call-template></td>
			</tr>
	</table>

	</form>

	<xsl:variable name="unit" select="/data/unit"/>
	
	<xsl:choose><xsl:when test="/data/common:result/data/item[trafficMaxDetailList]">
		<div>
		<img style="margin-top: 15pt; width: 800px; height: 300px;" src="webexecuter?module={/data/@module}&amp;mid={/data/@mid}&amp;action=TrafficReport&amp;operation=chart&amp;chart={/data/chart}"/>
		</div>
	
	<xsl:for-each select="/data/common:result/data/item[trafficMaxDetailList]">
		<div>
		<p style="font-size:120%; font-weight: bold; margin-bottom: 5px;"><xsl:value-of select="title"/></p>
		</div>
		
		<xsl:choose><xsl:when test="/data/days/data/item">
			<xsl:choose><xsl:when test="mode != '4'">
			<table class="table800" style="margin-top: 5pt; margin-bottom: 5pt;">
			<xsl:call-template name="addStatRowMax">
				<xsl:with-param name="detailList" select="trafficMaxDetailList"/>
				<xsl:with-param name="row" select="1"/>
				<xsl:with-param name="unit" select="$unit"/>
			</xsl:call-template>
			<xsl:call-template name="addStatRowMax">
				<xsl:with-param name="detailList" select="trafficMaxDetailList"/>
				<xsl:with-param name="row" select="2"/>
				<xsl:with-param name="unit" select="$unit"/>
			</xsl:call-template>
			<xsl:call-template name="addStatRowMax">
				<xsl:with-param name="detailList" select="trafficMaxDetailList"/>
				<xsl:with-param name="row" select="3"/>
				<xsl:with-param name="unit" select="$unit"/>
			</xsl:call-template>
			<xsl:call-template name="addStatRowMax">
				<xsl:with-param name="detailList" select="trafficMaxDetailList"/>
				<xsl:with-param name="row" select="4"/>
				<xsl:with-param name="unit" select="$unit"/>
			</xsl:call-template></table>
		</xsl:when><xsl:otherwise><em class='comment'>Для более подробной информации выберите нужный день.</em></xsl:otherwise></xsl:choose>
		</xsl:when><xsl:otherwise>
			<xsl:if test="mode = '4'">
			<table class="table800" style="margin-top: 5pt; margin-bottom: 5pt;">
			<tr><xsl:call-template name="addStatRowHourHeader">
				<xsl:with-param name="hour" select="0"/>
				<xsl:with-param name="unit" select="$unit"/>
			</xsl:call-template></tr>
			<tr><xsl:call-template name="addStatRowHourMaxValue">
				<xsl:with-param name="detailList" select="trafficMaxDetailList"/>
				<xsl:with-param name="hour" select="0"/>
				<xsl:with-param name="unit" select="$unit"/>
			</xsl:call-template></tr>
			<tr><xsl:call-template name="addStatRowHourHeader">
				<xsl:with-param name="hour" select="8"/>
				<xsl:with-param name="unit" select="$unit"/>
			</xsl:call-template></tr>
			<tr><xsl:call-template name="addStatRowHourMaxValue">
				<xsl:with-param name="detailList" select="trafficMaxDetailList"/>
				<xsl:with-param name="hour" select="8"/>
				<xsl:with-param name="unit" select="$unit"/>
			</xsl:call-template></tr>
			<tr><xsl:call-template name="addStatRowHourHeader">
				<xsl:with-param name="hour" select="16"/>
				<xsl:with-param name="unit" select="$unit"/>
			</xsl:call-template></tr>
			<tr><xsl:call-template name="addStatRowHourMaxValue">
				<xsl:with-param name="detailList" select="trafficMaxDetailList"/>
				<xsl:with-param name="hour" select="16"/>
				<xsl:with-param name="unit" select="$unit"/>
			</xsl:call-template></tr></table></xsl:if>
		</xsl:otherwise></xsl:choose>
		
	<div style="font-weight: bold; margin-bottom:15pt;">Итого: <xsl:value-of select="format-number( sum(trafficMaxDetailList/amountMax) div $unit, '### ### ### ##0.####', 'summa')"/>
		&#160;<xsl:call-template name="unit_title"><xsl:with-param name="unit" select="$unit"/></xsl:call-template>.
	</div>

	</xsl:for-each>
	
	</xsl:when><xsl:otherwise>
		<em>На выбранный период нет информации по превалирующим трафикам.<br/>Превалирующие трафики или отчет по ним не предусмотрен тарифом.</em>
	</xsl:otherwise></xsl:choose>

</xsl:template>


<xsl:template name="TrafficRangeReport">

	<xsl:variable name="URI"><xsl:value-of select="$WEBEXECUTER"/>?module=<xsl:value-of select="/data/@module"/>&amp;mid=<xsl:value-of select="/data/@mid"/>&amp;</xsl:variable>

	<table class="filter" style="margin-bottom: 5pt;">
		<tr>
			<td style="padding-right:5pt;"><a href="#" onclick="document.location='{$URI}action=TrafficReport&amp;operation=execute'; return false;">Обычные трафики</a></td>
			<td style="padding-right:5pt;"><a href="#" onclick="document.location='{$URI}action=TrafficMaxReport&amp;operation=execute'; return false;">Превалирующие трафики</a></td>
			<td><b>Пакеты трафиков</b></td>
		</tr>
	</table>

	<form method='get' action='{$WEBEXECUTER}'>
	<xsl:call-template name="action"/>	
	<xsl:call-template name="error"/>
	
	<table class="filter">
	<tr>
			<td style="text-align:right; vertical-align:top;">
			<div align="left"><xsl:call-template name="dayFilterForm"><xsl:with-param name="withSubmit" select="0"/><xsl:with-param name="day" select="0"/>
			<xsl:with-param name="nowrap" select="0"/></xsl:call-template></div>
			</td>
			<td style="padding-left: 5px; text-align:right; vertical-align:top;">Ед. измерения:<br/><select class="gradbtn"  style="width: 100%" name='unit'><xsl:call-template name="unit_list"/></select></td>
			<td style="padding-left: 5px; text-align:right; vertical-align:top;">	<br/>			<xsl:call-template name="submit">
					<xsl:with-param name="title" select="'Вывести'"/>
				</xsl:call-template></td>
			</tr>
	</table>

	</form>

	<xsl:variable name="unit" select="/data/unit"/>
	
	<xsl:choose><xsl:when test="/data/common:result/data/item[detailValueList]">
		<div>
		<img style="margin-top: 15pt; width: 800px; height: 300px;" src="webexecuter?module={/data/@module}&amp;mid={/data/@mid}&amp;action=TrafficReport&amp;operation=chart&amp;chart={/data/chart}"/>
		</div>
	
	<xsl:for-each select="/data/common:result/data/item[detailValueList]">
	
	<xsl:choose>
	<!-- подневной режим объединяем в одну таблицу -->
	<xsl:when test="@mode = '3'">
	
	<div>
	<p style="font-size:120%; font-weight: bold; margin-bottom: 5px;"><xsl:value-of select="@title"/>&#160;(<xsl:call-template name="unit_title"><xsl:with-param name="unit" select="$unit"/></xsl:call-template>)
	</p>
	</div>
	
	<xsl:choose><xsl:when test="/data/days/data/item">
		<table class="table800" style="margin-top: 5pt; margin-bottom: 5pt;">
		<xsl:call-template name="addStatRowRangeDay">
			<xsl:with-param name="report" select="."/>
			<xsl:with-param name="row" select="1"/>
			<xsl:with-param name="unit" select="$unit"/>
		</xsl:call-template>
		<xsl:call-template name="addStatRowRangeDay">
			<xsl:with-param name="report" select="."/>
			<xsl:with-param name="row" select="2"/>
			<xsl:with-param name="unit" select="$unit"/>
		</xsl:call-template>
		<xsl:call-template name="addStatRowRangeDay">
			<xsl:with-param name="report" select="."/>
			<xsl:with-param name="row" select="3"/>
			<xsl:with-param name="unit" select="$unit"/>
		</xsl:call-template>
		<xsl:call-template name="addStatRowRangeDay">
			<xsl:with-param name="report" select="."/>
			<xsl:with-param name="row" select="4"/>
			<xsl:with-param name="unit" select="$unit"/>
		</xsl:call-template></table>
	</xsl:when></xsl:choose>
	
	</xsl:when><xsl:otherwise>
	<!-- подневной режим объединяем в одну таблицу -->

	<xsl:for-each select="detailValueList">
		<div>
		<p style="font-size:120%; font-weight: bold; margin-bottom: 5px;"><xsl:value-of select="../@title"/>
		<xsl:if test="contractTariffOption">:&#160;<xsl:value-of select="contractTariffOption/@timeFrom"/> - <xsl:value-of select="contractTariffOption/@timeTo"/></xsl:if>
		<xsl:if test="accountingPeriod">:&#160;<xsl:value-of select="accountingPeriod/@dateFrom"/> - <xsl:value-of select="accountingPeriod/@dateTo"/></xsl:if>
		</p>
		</div>
		
		<xsl:choose><xsl:when test="/data/days/data/item">
			<table class="table800" style="margin-top: 5pt; margin-bottom: 5pt;">
			<xsl:call-template name="addStatRowRange">
				<xsl:with-param name="detailValueList" select="."/>
				<xsl:with-param name="row" select="1"/>
				<xsl:with-param name="unit" select="$unit"/>
			</xsl:call-template>
			<xsl:call-template name="addStatRowRange">
				<xsl:with-param name="detailValueList" select="."/>
				<xsl:with-param name="row" select="2"/>
				<xsl:with-param name="unit" select="$unit"/>
			</xsl:call-template>
			<xsl:call-template name="addStatRowRange">
				<xsl:with-param name="detailValueList" select="."/>
				<xsl:with-param name="row" select="3"/>
				<xsl:with-param name="unit" select="$unit"/>
			</xsl:call-template>
			<xsl:call-template name="addStatRowRange">
				<xsl:with-param name="detailValueList" select="."/>
				<xsl:with-param name="row" select="4"/>
				<xsl:with-param name="unit" select="$unit"/>
			</xsl:call-template></table>
		</xsl:when></xsl:choose>
		
	<div style="font-weight: bold; margin-bottom:15pt;">
	Итого: <xsl:value-of select="format-number( sum(@amount) div $unit, '### ### ### ##0.####', 'summa')"/>
	из <xsl:value-of select="format-number( sum(@maxAmount) div $unit, '### ### ### ##0.####', 'summa')"/>&#160;<xsl:call-template name="unit_title"><xsl:with-param name="unit" select="$unit"/></xsl:call-template>.
	</div>

	</xsl:for-each>	
	
	</xsl:otherwise>
	</xsl:choose>

	</xsl:for-each>
	
	</xsl:when><xsl:otherwise>
		<em>На выбранный период нет информации по пакетам трафиков.<br/>Пакеты трафиков или отчет по ним не предусмотрен тарифом.</em>
	</xsl:otherwise></xsl:choose>

</xsl:template>


<xsl:template name="addStatRow">
<xsl:param name="row"/>
<xsl:param name="unit"/>

<xsl:variable name="days" select="/data/days/data/item[ floor((number(text())-1) div 10) = ($row - 1) ]"/>

<xsl:if test="$days">
<tr>
<xsl:for-each select="$days">
	<xsl:variable name="day" select="number(.)"/>
	<th style="width: 10%"><xsl:value-of select="$day"/></th>
</xsl:for-each>
</tr>
<tr>
<xsl:for-each select="$days">
	<xsl:variable name="day" select="number(.)"/>
	<td><xsl:value-of select="format-number( sum(/data/common:result/data/item[periodDay=$day]/trafficMap/entry/value) div $unit, '### ### ### ##0.####', 'summa')"/></td>
</xsl:for-each>
</tr>
</xsl:if>
</xsl:template>

<xsl:template name="addStatRowMax">
<xsl:param name="detailList"/>
<xsl:param name="row"/>
<xsl:param name="unit"/>

<xsl:variable name="days" select="/data/days/data/item[ floor((number(text())-1) div 10) = ($row - 1) ]"/>

<xsl:if test="$days">
<tr>
<xsl:for-each select="$days">
	<xsl:variable name="day" select="number(.)"/>
	<th style="width: 10%"><xsl:value-of select="$day"/></th>
</xsl:for-each>
</tr>
<tr>
<xsl:for-each select="$days">
	<xsl:variable name="day" select="number(.)"/>
	<xsl:variable name="dayDetailList" select="$detailList[day=$day]"/>
	<xsl:variable name="amount1" select="sum($dayDetailList/amount1)"/>
	<xsl:variable name="amount2" select="sum($dayDetailList/amount2)"/>
	<xsl:variable name="amountMax" select="sum($dayDetailList/amountMax)"/>
	
	<td><xsl:choose><xsl:when test="$amount1 >= $amount2">
	<span class="nowrap"><b><xsl:value-of select="format-number( $amountMax div $unit, '### ### ### ##0.####', 'summa')"/></b></span>/<xsl:value-of select="format-number( $amount2 div $unit, '### ### ### ##0.####', 'summa')"/>	
	</xsl:when><xsl:otherwise>
	<span class="nowrap"><xsl:value-of select="format-number( $amount1 div $unit, '### ### ### ##0.####', 'summa')"/></span>/<b><xsl:value-of select="format-number( $amountMax div $unit, '### ### ### ##0.####', 'summa')"/></b>
	</xsl:otherwise></xsl:choose></td>
	
</xsl:for-each>
</tr>
</xsl:if>
</xsl:template>

<!-- учетные периоды -->
<xsl:template name="ShowPeriods" >
	<div class="report" >
		<table cellspacing='1' class="table800">
		<thead>
			<tr>
				<td>Начало</td>
				<td>Окончание</td>
			</tr>
		</thead>
		<tbody>
			<xsl:for-each select="periods/row">
			<tr>
				<td><xsl:value-of select="@start"/></td>	
				<td><xsl:value-of select="@end"/></td>
			</tr>
			</xsl:for-each>
		</tbody>
		</table>
	</div>
</xsl:template>

<xsl:template name="addStatRowRange">
<xsl:param name="detailValueList"/>
<xsl:param name="row"/>
<xsl:param name="unit"/>

<xsl:variable name="days" select="/data/days/data/item[ floor((number(text())-1) div 10) = ($row - 1) ]"/>

<xsl:if test="$days">
<tr>
<xsl:for-each select="$days">
	<xsl:variable name="day" select="number(.)"/>
	<th style="width: 10%"><xsl:value-of select="$day"/></th>
</xsl:for-each>
</tr>
<tr>
<xsl:for-each select="$days">
	<xsl:variable name="day" select="number(.)"/>
	<td><xsl:value-of select="format-number( sum($detailValueList/detailList[@day=$day]/@amount) div $unit, '### ### ### ##0.####', 'summa')"/></td>
</xsl:for-each>
</tr>
</xsl:if>
</xsl:template>

<xsl:template name="addStatRowRangeDay">
<xsl:param name="report"/>
<xsl:param name="row"/>
<xsl:param name="unit"/>

<xsl:variable name="days" select="/data/days/data/item[ floor((number(text())-1) div 10) = ($row - 1) ]"/>

<xsl:if test="$days">
<tr>
<xsl:for-each select="$days">
	<xsl:variable name="day" select="number(.)"/>
	<th style="width: 10%"><xsl:value-of select="$day"/></th>
</xsl:for-each>
</tr>
<tr>
<xsl:for-each select="$days">
	<xsl:variable name="day" select="number(.)"/>
	<xsl:variable name="detailValueList" select="$report/detailValueList[detailList/@day=$day]"/>
	<td><span class="nowrap"><b><xsl:value-of select="format-number( sum($detailValueList/detailList[@day=$day]/@amount) div $unit, '### ### ### ##0.###', 'summa')"/></b></span>
	<xsl:if test="$detailValueList">/<xsl:value-of select="format-number( sum($detailValueList/@maxAmount) div $unit, '### ### ### ##0.###', 'summa')"/></xsl:if>	
	</td>
</xsl:for-each>
</tr>
</xsl:if>
</xsl:template>

<xsl:template name="addStatRowHourHeader">
<xsl:param name="hour"/>
<xsl:param name="unit"/>

<th style="width: 10%"><xsl:value-of select="$hour"/></th>

<xsl:if test="($hour + 1) mod 8 != 0">
	<xsl:call-template name="addStatRowHourHeader">
		<xsl:with-param name="hour" select="$hour+1"/>
		<xsl:with-param name="unit" select="$unit"/>
	</xsl:call-template>
</xsl:if>
</xsl:template>

<xsl:template name="addStatRowHourValue">
<xsl:param name="hour"/>
<xsl:param name="unit"/>

<td><xsl:value-of select="format-number( sum(/data/common:result/data/item[periodHour=$hour]/trafficMap/entry/value) div $unit, '### ### ### ##0.###', 'summa')"/></td>

<xsl:if test="($hour + 1) mod 8 != 0">
	<xsl:call-template name="addStatRowHourValue">
		<xsl:with-param name="hour" select="$hour+1"/>
		<xsl:with-param name="unit" select="$unit"/>
	</xsl:call-template>
</xsl:if>
</xsl:template>

<xsl:template name="addStatRowHourMaxValue">
<xsl:param name="detailList"/>
<xsl:param name="hour"/>
<xsl:param name="unit"/>

<xsl:variable name="hourDetailList" select="$detailList[hour=$hour]"/>
<xsl:variable name="amount1" select="sum($hourDetailList/amount1)"/>
<xsl:variable name="amount2" select="sum($hourDetailList/amount2)"/>
<xsl:variable name="amountMax" select="sum($hourDetailList/amountMax)"/>

<td><xsl:choose><xsl:when test="$amount1 >= $amount2">
<b><xsl:value-of select="format-number( $amountMax div $unit, '### ### ### ##0.###', 'summa')"/></b>/<xsl:value-of select="format-number( $amount2 div $unit, '### ### ### ##0.###', 'summa')"/>	
</xsl:when><xsl:otherwise>
<xsl:value-of select="format-number( $amount1 div $unit, '### ### ### ##0.###', 'summa')"/>/<b><xsl:value-of select="format-number( $amountMax div $unit, '### ### ### ##0.###', 'summa')"/></b>
</xsl:otherwise></xsl:choose></td>

<xsl:if test="($hour + 1) mod 8 != 0">
	<xsl:call-template name="addStatRowHourMaxValue">
		<xsl:with-param name="detailList" select="$detailList"/>
		<xsl:with-param name="hour" select="$hour+1"/>
		<xsl:with-param name="unit" select="$unit"/>
	</xsl:call-template>
</xsl:if>
</xsl:template>

</xsl:stylesheet>
