/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.common.event.sa;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import javax.jms.JMSException;
import javax.jms.Message;
import ru.bitel.bgbilling.kernel.event.EventType;
import ru.bitel.bgbilling.kernel.event.PartitionedQueueEvent;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.event.sa.InetSaServModifyEvent;

@EventType(autoAcknowledge=false, timeToLive=432000000L, deliveryMode=1)
@XmlRootElement
public class InetSaAccountingEvent
extends PartitionedQueueEvent {
    public static final int TYPE_START = 1;
    public static final int TYPE_STOP = 2;
    @XmlAttribute
    private final int type;
    private final InetConnection connection;

    protected InetSaAccountingEvent() {
        this.type = -1;
        this.connection = null;
    }

    public InetSaAccountingEvent(int moduleId, int contractId, InetConnection connection, int type) {
        super(moduleId, contractId, 0);
        this.type = type;
        this.connection = connection;
    }

    public void prepareMessage(Message message) throws JMSException {
        super.prepareMessage(message);
        message.setIntProperty("type", this.type);
        message.setIntProperty("deviceId", this.connection.getDeviceId());
    }

    public InetConnection getConnection() {
        return this.connection;
    }

    public int getType() {
        return this.type;
    }

    protected void toString(StringBuilder sb) {
        sb.append("; type: ");
        sb.append(this.type);
        sb.append("; deviceId: ");
        sb.append(this.connection.getDeviceId());
        sb.append("; connectionId: ");
        sb.append(this.connection.getId());
    }

    protected String getPackageName() {
        return InetSaServModifyEvent.PACKAGE_NAME;
    }

    protected int getPartitionValue() {
        return this.connection.getDeviceId();
    }
}

