/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.proccess;

import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.ConnectionMapCall;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionCallRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.bean.TrafficAmountDelta;
import ru.bitel.bgbilling.apps.inet.accounting.bean.TrafficAmountKey;
import ru.bitel.bgbilling.apps.inet.accounting.proccess.AbstactHourLogProccessor;
import ru.bitel.bgbilling.apps.inet.accounting.proccess.AbstractNetflowLogParser;
import ru.bitel.bgbilling.apps.inet.accounting.proccess.ConnectionMapCallProccess;
import ru.bitel.bgbilling.apps.inet.accounting.proccess.NetflowLogParser;
import ru.bitel.bgbilling.apps.inet.accounting.proccess.ProcessUtil;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.sql.ConnectionSet;

public class NetflowHourLogProcessor
extends AbstactHourLogProccessor {
    protected final ConnectionMapCall connectionMapCall;
    protected AbstractNetflowLogParser netflowLogParser;

    public NetflowHourLogProcessor(Date hour, Accounting accounting, int deviceId) {
        super(hour, accounting, deviceId);
        this.connectionMapCall = accounting.connectionMapCall;
    }

    @Override
    public void init(Connection con) throws BGException {
        this.netflowLogParser = new NetflowLogParser(this.setup, this.deviceId, this.accounting.moduleId, this.accounting);
        this.currentSessionSet.addAll(((ConnectionMapCallProccess)this.accounting.connectionMapCall).getCurrentSessionSet());
    }

    @Override
    public void getAmountsFromLogs(ConnectionSet connectionSet, Date hour) throws BGException {
        this.sessionHourAmountMap.clear();
        this.netflowLogParser.parseHour(hour, ProcessUtil.getZoneDelta(this.setup, hour, this.accounting.moduleId));
        this.fillTRafficMaps(hour);
    }

    private void fillTRafficMaps(Date hour) {
        this.sessionHourAmountMap.clear();
        long millis = hour.getTime();
        for (InetConnectionCallRuntime connection : this.accounting.connectionMapCall.values()) {
            Map traffMap = (Map)connection.trafficsDelta.get(millis);
            if (traffMap == null) continue;
            for (Map.Entry entry : traffMap.entrySet()) {
                TrafficAmountKey key = (TrafficAmountKey)entry.getKey();
                TrafficAmountDelta delta = (TrafficAmountDelta)entry.getValue();
                int trafficTypeId = key.trafficTypeId;
                long amount = delta.flushAmountDelta;
                HashMap<Integer, Long> sessionTypeMap = (HashMap<Integer, Long>)this.sessionHourAmountMap.get(connection.sessionId);
                if (sessionTypeMap == null) {
                    sessionTypeMap = new HashMap<Integer, Long>();
                    this.sessionHourAmountMap.put(connection.sessionId, sessionTypeMap);
                }
                sessionTypeMap.put(trafficTypeId, amount);
            }
            connection.trafficsDelta.remove(millis);
        }
    }

    @Override
    public void dayFinished(ConnectionSet connectionSet, boolean isCurrentDay) {
    }
}

