/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.gazprombank.server.bean;

import java.math.BigDecimal;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.bean.BGAbstractTransaction;
import ru.bitel.bgbilling.common.bean.BGTransactionType;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.gazprombank.common.bean.Transaction;
import ru.bitel.bgbilling.modules.gazprombank.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.gazprombank.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.gazprombank.server.event.GazprombankAutopaymentSumEvent;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    private ParameterMap moduleSetup = null;
    static final Map<String, String> PAYMENT_DATA = new HashMap<String, String>(){
        {
            this.put("/token", "gazprombank.token");
            this.put("/src/type", "gazprombank.payment_method.type");
            this.put("/src/paymentSystem", "gazprombank.card_type");
            this.put("/src/issuerName", "gazprombank.card_issuer_name");
            this.put("/src/pan", "gazprombank.card_pan");
            this.put("/src/title", "gazprombank.card_title");
        }
    };

    public TransactionManager(Connection con, int moduleId) {
        super(con, "gazprombank_transaction", moduleId);
        this.moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
        this.fields = Map.of("id", "id", "createDate", "create_date", "transactionDate", "transaction_date", "sum", "sum");
    }

    protected void queryStatus(StringBuilder query, String status) {
        if (Utils.notBlankString((String)status) && !TransactionStatus.ALL.getCode().equals(status)) {
            query.append(" AND pt.result=?");
        }
    }

    protected int psSetStatus(PreparedStatement ps, int index, String status) throws SQLException {
        if (Utils.notBlankString((String)status) && !TransactionStatus.ALL.getCode().equals(status)) {
            ps.setString(index++, status);
        }
        return index;
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        boolean contractTitleColumn = false;
        for (int i = 1; i <= metaData.getColumnCount(); ++i) {
            if (!"contract_title".equals(metaData.getColumnLabel(i))) continue;
            contractTitleColumn = true;
            break;
        }
        BGTransactionType type = switch (rs.getString("payment_type")) {
            case "bank_card" -> BGTransactionType.CARD;
            case "sbp" -> BGTransactionType.QR_SBP;
            default -> BGTransactionType.OTHER;
        };
        return new Transaction().setId(rs.getInt("id")).setContractId(rs.getInt("contract_id")).setContractTitle(contractTitleColumn ? rs.getString("contract_title") : "").setPaymentId(rs.getInt("payment_id")).setTransactionType(type).setCreateDate((Date)rs.getTimestamp("create_date")).setTransactionDate((Date)rs.getTimestamp("transaction_date")).setTransactionId(rs.getString("transaction_id")).setStatus(rs.getString("result")).setParameters(rs.getString("params")).setSum(rs.getBigDecimal("sum")).setAutopayment(rs.getBoolean("autopayment"));
    }

    protected void updateImpl(Transaction transaction) throws SQLException {
        String querySet = "contract_id=?, payment_id=?, create_date=?, transaction_date=?, transaction_id=?, result=?, params=?, sum=?, autopayment=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)transaction, querySet);){
            int index = 1;
            ps.setInt(index++, transaction.getContractId());
            ps.setInt(index++, transaction.getPaymentId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getCreateDate()));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
            ps.setString(index++, transaction.getTransactionId());
            ps.setString(index++, transaction.getStatus());
            ps.setString(index++, transaction.getParameters());
            ps.setBigDecimal(index++, transaction.getSum());
            ps.setBoolean(index++, transaction.isAutopayment());
            this.executeUpdate((Id)transaction, index, ps);
        }
    }

    public Transaction registerOrder(int contractId, String contractTitle, BigDecimal sum, Map<String, Object> dataMap, boolean autopaymentTransaction, boolean requestBindingId) throws Exception {
        String portalId;
        if (autopaymentTransaction || requestBindingId) {
            GazprombankAutopaymentSumEvent event = new GazprombankAutopaymentSumEvent(this.moduleId, contractId, sum);
            BigDecimal newSum = ((GazprombankAutopaymentSumEvent)EventProcessor.getInstance().request((QueueEvent)event)).getSum();
            if (newSum != null) {
                sum = newSum;
            }
        }
        if ((portalId = this.moduleSetup.get("gazprombank.portal_id", null)) == null) {
            this.getLogger().error("Not set \"PORTAL_ID\" in config!!!");
            return null;
        }
        String merchantId = this.moduleSetup.get("gazprombank.merchant_id", null);
        if (merchantId == null) {
            this.getLogger().error("Not set \"merchantId\" in config!!!");
            return null;
        }
        String token = this.getToken(portalId);
        if (token == null) {
            return null;
        }
        Transaction transaction = new Transaction().setSum(sum).setContractId(contractId).setCreateDate(new Date()).setAutopayment(autopaymentTransaction).setTransactionId(token);
        this.update(transaction);
        String accountId = this.moduleSetup.get("gazprombank.account_id", null);
        String description = this.moduleSetup.get("gazprombank.description", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contractTitle);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("merchantId", merchantId);
        Optional.ofNullable(accountId).ifPresent(a -> parameters.put("accountId", (String)a));
        parameters.put("description", description);
        parameters.put("amount", String.valueOf(sum.multiply(new BigDecimal(100)).longValue()));
        parameters.put("currency", "RUB");
        parameters.put("state.in_progress", "no");
        parameters.put("merchantTrx", String.valueOf(transaction.getId()));
        parameters.put("3ds2.supported", "true");
        parameters.put("params.order_id", String.valueOf(transaction.getId()));
        parameters.put("back_url_f", this.moduleSetup.get("gazprombank.back_url_fail", ""));
        parameters.put("back_url_s", this.moduleSetup.get("gazprombank.back_url_success", ""));
        parameters.put("lang", "ru");
        parameters.put("state.redirect", autopaymentTransaction ? "url_only" : "payment_page");
        if (requestBindingId) {
            parameters.put("addCardAllowed", "true");
        }
        if (autopaymentTransaction) {
            parameters.put("recurrent", "true");
            parameters.put("params.card_on_file", "MIT");
            parameters.put("src.type", "card_id");
            Optional.ofNullable(this.moduleSetup.get("gazprombank.return_url")).ifPresent(a -> parameters.put("returnUrl", (String)a));
            Optional.ofNullable(dataMap.get("cardId")).ifPresent(a -> parameters.put("src.cardId", String.valueOf(a)));
        }
        String formData = parameters.entrySet().stream().map(e -> (String)e.getKey() + "=" + URLEncoder.encode((String)e.getValue(), StandardCharsets.UTF_8)).collect(Collectors.joining("&"));
        String uri = this.moduleSetup.get("gazprombank.api.uri", "https://lt.pga.gazprombank.ru/api/v4/") + portalId + "/payment/" + token + "/start";
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(uri)).header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.ofString(formData)).build();
        HttpResponse<String> httpResponse = HttpClient.newHttpClient().send(httpRequest, HttpResponse.BodyHandlers.ofString());
        JSONObject jsonObject = new JSONObject(httpResponse.body());
        if (jsonObject.has("error")) {
            transaction.setStatus(TransactionStatus.ERROR.getCode());
            transaction.setParameters(jsonObject.toString(2));
            this.update(transaction);
        } else if (jsonObject.optString("state").equals("offer")) {
            dataMap.put("formUrl", jsonObject.optJSONObject("options").optString("paymentPageUrl"));
        }
        return transaction;
    }

    public void doAutopayment(int contractId, String contractTitle, BigDecimal sum, Autopayment autopayment) throws Exception {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        if (sum != null && autopayment != null) {
            String bindingId = autopayment.getAccessToken();
            if (bindingId != null) {
                dataMap.put("cardId", bindingId);
                this.registerOrder(contractId, contractTitle, sum, dataMap, true, false);
            } else {
                this.getLogger().error("\u0417\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d, \u0442\u0430\u043a \u043a\u0430 \u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d bindingId = " + bindingId);
            }
        }
    }

    public String getToken(String portalId) {
        String uri = this.moduleSetup.get("gazprombank.api.uri", "https://lt.pga.gazprombank.ru/api/v4/") + portalId + "/token";
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(uri)).POST(HttpRequest.BodyPublishers.noBody()).build();
        try {
            HttpResponse<String> httpResponse = HttpClient.newHttpClient().send(httpRequest, HttpResponse.BodyHandlers.ofString());
            return new JSONObject(httpResponse.body()).optString("token", null);
        }
        catch (Exception ex) {
            this.logError(ex);
            return null;
        }
    }

    public void doCheckRequest(Transaction transaction) {
        String portalId = this.moduleSetup.get("gazprombank.portal_id", null);
        if (portalId == null) {
            this.getLogger().error("Not set \"PORTAL_ID\" in config!!!");
            return;
        }
        String uri = this.moduleSetup.get("gazprombank.api.uri", "https://lt.pga.gazprombank.ru/api/v4/") + portalId + "/payment/" + transaction.getTransactionId();
        HttpRequest httpRequest = HttpRequest.newBuilder().uri(URI.create(uri)).GET().build();
        try {
            JSONObject result;
            String status;
            HttpResponse<String> httpResponse = HttpClient.newHttpClient().send(httpRequest, HttpResponse.BodyHandlers.ofString());
            JSONObject json = new JSONObject(httpResponse.body());
            if (json.has("error")) {
                transaction.setStatus(TransactionStatus.ERROR.getCode());
                transaction.setParameters(json.toString(2));
                this.update(transaction);
                return;
            }
            String state = json.optString("state", null);
            if ("result".equals(state) && "SUCCESS".equals(status = (result = json.optJSONObject("result")).optString("status"))) {
                PeriodWithTime period;
                AutopaymentManager autopaymentManager;
                Autopayment autopayment;
                String cardId;
                JSONObject src = result.optJSONObject("src");
                transaction.setStatus(TransactionStatus.OK.getCode());
                transaction.setTransactionDate(new Date(json.optLong("finishedAt")));
                transaction.setParameters(json.toString(2));
                if (transaction.getPaymentId() < 0) {
                    Payment payment = new Payment().setDate(transaction.getTransactionDate()).setTypeId(this.moduleSetup.getInt("gazprombank.payment.type.id", 0)).setContractId(transaction.getContractId()).setSum(transaction.getSum()).setUserId(0).setModuleId(Integer.valueOf(this.moduleId)).setTransactionId(String.valueOf(transaction.getId())).setComment("\u041f\u043b\u0430\u0442\u0435\u0436 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u0443\u044e \u0441\u0438\u0441\u0442\u0435\u043c\u0443 \u0413\u0430\u0437\u043f\u0440\u043e\u043c\u0431\u0430\u043d\u043a\u0430").setData(this.getPaymentData(transaction));
                    new PaymentDao(this.con).update((Object)payment);
                    ServerUtils.commitConnection((Connection)this.con);
                    try (BalanceUtils balanceUtils = new BalanceUtils(this.con);){
                        balanceUtils.updateBalance(payment.getDate(), payment.getContractId());
                    }
                    ServerUtils.commitConnection((Connection)this.con);
                    if (src != null) {
                        Optional.ofNullable(src.optString("type", null)).ifPresent(a -> transaction.setPaymentType(a));
                    }
                    transaction.setPaymentId(payment.getId());
                    this.update(transaction);
                    EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
                    EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum()));
                }
                if (src != null && !(cardId = src.optString("cardId")).isEmpty() && (autopayment = (autopaymentManager = new AutopaymentManager(this.con, this.moduleId)).getCurrentAutopayment(transaction.getContractId())) != null && (period = autopayment.getPeriod()) != null && period.getDateFrom() == null) {
                    period.setLocalDateTimeFrom(LocalDateTime.now());
                    autopayment.setAccessToken(cardId);
                    autopaymentManager.updateAutopayment(autopayment);
                }
            }
            return;
        }
        catch (Exception ex) {
            this.logError(ex);
            return;
        }
    }

    public void doCheckRequest(int contractId, Boolean autopaymentTransaction) throws Exception {
        SearchParam searchParam = new SearchParam().setContractId(contractId).setStatus(TransactionStatus.CREATED.getCode());
        SearchResult searchResult = new SearchResult(new Page(1, 25), new String[]{"createDate:1"});
        this.searchTransaction(searchResult, searchParam);
        for (Transaction transaction : searchResult.getList()) {
            String transactionId = transaction.getTransactionId();
            if (transactionId == null) continue;
            this.doCheckRequest(transaction);
        }
    }

    protected <T extends BGAbstractTransaction> String getPaymentData(T transaction) {
        JSONObject jsonObject = new JSONObject(((Transaction)transaction).getParameters());
        StringBuilder data = new StringBuilder();
        PAYMENT_DATA.entrySet().stream().forEach(a -> Optional.ofNullable(jsonObject.optQuery((String)a.getKey())).ifPresent(b -> data.append((String)a.getValue()).append("=").append(b).append("\n")));
        return data.toString();
    }
}

