/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.server.table;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableColumn;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableRowData;
import ru.bitel.bgbilling.kernel.table.server.bean.BGTableInfoBase;
import ru.bitel.bgbilling.modules.email.common.bean.Domain;
import ru.bitel.bgbilling.modules.email.server.bean.AccountManager;
import ru.bitel.bgbilling.modules.email.server.bean.DomainManager;
import ru.bitel.bgbilling.modules.email.server.bean.EmailUtils;
import ru.bitel.common.TimeUtils;

public class TableAccount
extends BGTableInfoBase {
    public TableAccount() {
        this.columns = new BGUTableColumn[]{BGUTableColumn.buildColumnTextLeft((String)"E-Mail", (String)"email").setMaxWidth(300), BGUTableColumn.buildColumnTextCenter((String)"\u041f\u0435\u0440\u0438\u043e\u0434", (String)"period").setMaxWidth(200), BGUTableColumn.buildColumnTextCenter((String)"\u0421\u0442\u0430\u0442\u0443\u0441", (String)"status_label").setWidth(150), BGUTableColumn.buildColumnTextRight((String)"\u041a\u0432\u043e\u0442\u0430", (String)"quota").setWidth(150), BGUTableColumn.buildColumnTextLeft((String)"\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", (String)"comment").setMaxWidth(-1), BGUTableColumn.buildColumnId()};
    }

    public List<BGUTableRowData> getRows(BGUTableParams tableParams, int moduleId) throws Exception {
        ServerContext serverContext = (ServerContext)ServerContext.get();
        int contractId = tableParams.getContractId();
        if (contractId > 0) {
            Connection con = serverContext.getConnection();
            Map<Long, String> quotas = EmailUtils.getQuotasMap(moduleId);
            DomainManager domainManager = new DomainManager(con, moduleId);
            AccountManager accountManager = new AccountManager(con, moduleId);
            return accountManager.getContractAccountList(contractId, null).stream().map(a -> {
                Domain domain = null;
                try {
                    domain = domainManager.get(a.getDomainId());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                String domainName = Optional.ofNullable(domain).map(d -> d.getName()).orElse("???");
                String quotaStr = (String)quotas.get(a.getQuota());
                return new BGUTableRowData().addValue(this.getId(a.getId())).addValue("email", a.getAccount() + "@" + domainName).addValue("status_label", a.getStringStatus()).addValue("quota", Optional.ofNullable(quotaStr).orElse("???")).addValue("comment", a.getComment()).addValue("period", TimeUtils.formatPeriod((Date)a.getDate1(), (Date)a.getDate2()));
            }).toList();
        }
        return new ArrayList<BGUTableRowData>();
    }
}

