/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.email.server.bean;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Reference;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverManagerConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPool;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.email.common.bean.Domain;
import ru.bitel.bgbilling.modules.email.server.bean.Account;
import ru.bitel.bgbilling.modules.email.server.bean.EmailServiceActivator;
import ru.bitel.bgbilling.modules.email.server.bean.JDBCEmailServiceDao;
import ru.bitel.common.ParameterMap;

public class JDBCEmailServiceActivator
extends EmailServiceActivator {
    private static Map<Reference, SoftReference<DataSource>> dataSourceMap = Collections.synchronizedMap(new HashMap());
    private Domain domain;
    private ParameterMap moduleSetup;
    private Connection con;
    private JDBCEmailServiceDao jdbcEmailServiceDao;

    public JDBCEmailServiceActivator(Domain domain, ParameterMap moduleSetup) throws BGException {
        this.domain = domain;
        this.moduleSetup = moduleSetup;
        ParameterMap params = this.domain.getParameterMap().inherit(moduleSetup).sub("sa.jdbc.");
        String url = params.get("url", null);
        try {
            DataSource dataSource;
            Reference ref = new Reference(url);
            params.toReference(ref);
            SoftReference<DataSource> dataSourceRef = dataSourceMap.get(ref);
            DataSource dataSource2 = dataSource = dataSourceRef != null ? dataSourceRef.get() : null;
            if (dataSource == null) {
                String driverClass = params.get("driver", null);
                String user = params.get("user", null);
                String pswd = params.get("password", null);
                if (driverClass != null) {
                    try {
                        Class.forName(driverClass);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                GenericObjectPool connectionPool = new GenericObjectPool(null);
                connectionPool.setMaxIdle(10);
                connectionPool.setMaxTotal(100);
                connectionPool.setTestOnBorrow(true);
                connectionPool.setTestOnReturn(true);
                DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(url, user, pswd);
                PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, null);
                poolableConnectionFactory.setDefaultAutoCommit(Boolean.valueOf(true));
                poolableConnectionFactory.setDefaultReadOnly(Boolean.valueOf(false));
                poolableConnectionFactory.setValidationQuery("SELECT 1");
                poolableConnectionFactory.setPool((ObjectPool)connectionPool);
                dataSource = new PoolingDataSource((ObjectPool)connectionPool);
                dataSourceMap.put(ref, new SoftReference<DataSource>(dataSource));
            }
            this.con = dataSource.getConnection();
            this.con.setAutoCommit(true);
        }
        catch (SQLException e) {
            throw new BGException("Can't connect to " + params.get("url", null), (Throwable)e);
        }
        this.jdbcEmailServiceDao = new JDBCEmailServiceDao(this.con, domain);
    }

    @Override
    public void close() {
        super.close();
        if (this.con != null) {
            try {
                this.con.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.con = null;
    }

    @Override
    protected void createImpl(Account account) throws Exception {
        this.jdbcEmailServiceDao.createImpl(account);
    }

    @Override
    protected void modifyImpl(Account account) throws Exception {
        this.jdbcEmailServiceDao.modifyImpl(account);
    }

    @Override
    protected void cancelImpl(Account account) throws Exception {
        this.jdbcEmailServiceDao.cancelImpl(account);
    }

    @Override
    protected void removeDomainImpl(Domain domain) throws Exception {
        this.jdbcEmailServiceDao.removeDomainImpl(domain);
    }

    @Override
    protected void updateDomainImpl(Domain domain) throws BGException {
        this.jdbcEmailServiceDao.updateDomainImpl(domain, this.moduleSetup);
    }
}

