/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.task;

import java.sql.Connection;
import java.util.List;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.UserCard;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.UserCardManager;
import ru.bitel.bgbilling.modules.cerbercrypt.server.task.SubscribeSynchronizer;
import ru.bitel.common.Utils;

public class SynchronizerChecker
extends TaskBase {
    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c Cerbercrypt. \u0417\u0430\u0434\u0430\u0447\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0437\u0430\u0434\u0430\u0447\u0438 \u0441\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u0438. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + ".";
    }

    protected boolean initTask() {
        return true;
    }

    protected void executeTask() {
        try (Connection con = this.setup.getDBConnectionFromPool();
             Connection conSlave = this.setup.getDBSlaveConnectionFromPool();){
            this.getLogger().info("Check need-sync...");
            UserCardManager userCardManager = new UserCardManager(conSlave, this.moduleId, 0);
            List<UserCard> usercards = userCardManager.getListNeedSync();
            if (Utils.notEmptyCollection(usercards)) {
                this.getLogger().info("found " + usercards.size() + " need-sync usercards, add Synchronizer task...");
                new RunTaskDataManager(con).addTask((RunTask)new SubscribeSynchronizer(this.moduleId, usercards));
            } else {
                this.getLogger().info("not found need-sync (dirty) usercards");
            }
        }
        catch (Exception e) {
            this.getLogger().error("synchronizer checker execute error", (Throwable)e);
            this.error = e;
        }
    }
}

