var mouse = new Point(0,0);
var screenSize = new Point(0,0);

if (isNetscape4) document.captureEvents(Event.MOUSEMOVE)
if (isMSIE || isOpera7){
  document.onmousemove=function(){
    mouse.x=event.clientX+document.body.scrollLeft;
    mouse.y=event.clientY+document.body.scrollTop;
    return true;
  }
}else if (isOpera){
  document.onmousemove=function(){
    mouse.x=event.clientX;
    mouse.y=event.clientY;
    return true;
  }
}else if (isNetscape4 || isMozilla){
  document.onmousemove=function(e){
    mouse.x = e.pageX;
    mouse.y = e.pageY;
    return true;
  }  
}
function getScreenSize()
{
	if (document.body.clientWidth)
	{
		screenSize.x = document.body.clientWidth;
		screenSize.y = document.body.clientHeight;
	}
	else
	{
		screenSize.x = innerWidth;
		screenSize.y = innerHeight;
	}
	return screenSize;
}
function getRuleBySelector(sel)
{
	var rules;
	if (typeof document.styleSheets[0].cssRules != "undefined")
	{
		rules = document.styleSheets[0].cssRules;
	}
	else
	{
		rules = document.styleSheets[0].rules;
	}
	
	for (var i=0; i<rules.length; i++)
	{
		if ((rules[i].selectorText+"").toLowerCase() == sel)
		{
			return rules[i];
		}
	}
}

var street = "";
var clearTimer = null;

function onKeyDown(key, ev)
{
	var sel = ev.srcElement?ev.srcElement:ev.target;
	if (sel.id=="streetSelect" && key==8)
	{
		var len = street.length-1;
		street = street.substring(0,len>0?len:0);
		_hint(sel, street);
		
		clearTimeout(clearTimer);
		clearTimer = setTimeout("street=\"\"",3000);
		for (var i=0; i<sel.options.length; i++)
		{
			if (sel.options[i].text.toLowerCase().indexOf(street.toLowerCase())>=0)
			{
				sel.selectedIndex = sel.options[i].index; break;	
			}
		}
		return false;
	}
}


function onCityChange(sel)
{	
	var selected = sel.selectedIndex;
	//init( "idealer.xsl", document.getElementById("content") );
	initParams = doAction("Init", "Close", "&find_modes=1&address_list=1&contract_patterns=1&cityid="+sel.options[selected].value);
	newSearch();
	document.forms["ContractFind"].citySelect.options[selected].selected = true;
}

function onKeyPress(key, ev)
{
	var sel = ev.srcElement?ev.srcElement:ev.target;
	if (sel.id=="streetSelect")
	{
		if (key>=32 || key == 27)
		{
			if (key == 27)
			{
				street = "";
			}
			else
			{
				street += String.fromCharCode(key);
			}
			
			_hint(sel, street);
			clearTimeout(clearTimer);
			clearTimer = setTimeout("street=\"\"; _hint(null, street)",3000);
			for (var i=0; i<sel.options.length; i++)
			{
				if (sel.options[i].text.toLowerCase().indexOf(street.toLowerCase())>=0)
				{
					sel.selectedIndex = sel.options[i].index; break;	
				}
			}
		}
	}
	return false;
}

function _hint(sel, street)
{
	var hint = document.getElementById("hint");
	hint.innerHTML = street;
	if (street.length>0)
	{
		hint.style.display = "inline";
	}
	else
	{
		hint.style.display = "none";
	}
}

function onshow(xml)
{
  if (xml != null && xml.documentElement != null)
  {
    if (xml.documentElement.getAttribute("status") == "ok" && xml.documentElement.getAttribute("action") == "PaymentAdd")
    {
      clearHistory();
    }
  }
}
//////////////////////////////////////////////
//								//
//////////////////////////////////////////////
	var initParams;
	var currPage = 1;

	var hideable;

window.onload = function()
{
	/*
	if (window.opener == null)
	{
		open( "https://127.0.0.1:8443/bgbilling/id/idealer.html", "main", "status, width=700, height=550, scrollbars" );
	}
	*/
		
	init( "idealer.xsl", document.getElementById("content") );
	
	initParams = doAction("Init", "Close", "&find_modes=&address_list=&contract_patterns=");

	setDate();
	buildCalendar();

	hideable = getRuleBySelector(".hideable");
	onresize();
	
	checkStatus(initParams);

//	newSearch();
}
///////////////////////////////////////////////
window.onresize = function()
{
	if (hideable) {
		var size = getScreenSize();
		if (size.x > 820)
		{
			hideable.style.display = "block";
		}
		else
		{
			hideable.style.display = "none";
		}
	}
}

function newSearch()
{
	show( initParams );	
}

function createPayment(cid, title, comment, balance, firm_id, tariffs, show)
{
	var xml = createXML();
	var data = xml.createElement("data");
	
	if (xml.documentElement)
	{
		xml.documentElement.appendChild(data);
	}
	else
	{
		xml.appendChild(data);
	}
	
	data.setAttribute("status", "ok");
	data.setAttribute("action", "ContractFind");
	
	var el = xml.createElement("contract");
	data.appendChild(el);
	el.setAttribute("id", cid);
	el.setAttribute("title", title);
	el.setAttribute("comment", comment);
	el.setAttribute("balance", balance);
	el.setAttribute("firm_id", firm_id);
	
	var tars = xml.createElement("tariffs");
	el.appendChild(tars);
	tars.setAttribute("show",show);
	
	var tarifflist = tariffs.split( "," );
	if ( show > 0 )
	{
		for (var i = 0; i < tarifflist.length; ++i)
		{
			var onetariff = xml.createElement( "tariff" );
			tars.appendChild(onetariff);
			onetariff.setAttribute("title",tarifflist[i]);
		}
	}
	
	newPayment(xml);
}

function newPayment(xml)
{
	var ptxml = doAction( 'PaymentTypes', "Close", "" );
	var paymentTypes = ptxml.getElementsByTagName( "type" );
	var types = xml.createElement( "types" );
	var data = xml.getElementsByTagName( "data" )[0];
	data.appendChild( types );
	for ( var i = 0; i < paymentTypes.length; ++i )
	{
		var el = xml.createElement( "type" );
		el.setAttribute( "id", paymentTypes[i].getAttribute( "id" ) );
		el.setAttribute( "title", paymentTypes[i].getAttribute( "title" ) );
		types.appendChild( el );
	}
	
	xml.documentElement.setAttribute("trans", getNextTransactionNumber());
	xml.documentElement.setAttribute("comment", getComment());
	show(xml);
}

function paymentList(page)
{
	if (page == null) page = 1;
	if (page < 1) page = 1;
	
	contractTitle = document.getElementById("contractTitle");
	if ( contractTitle != null )
	{
		contractTitle = contractTitle.value;
	}
	else
	{
		contractTitle = "";
	}
	

	var xml = doAction('PaymentList', "Close", "&from="+formatDate(date1)+"&until="+formatDate(date2) + "&page_size=" + page_size + "&page=" + page
	       + "&pageSize=" + page_size + "&pageIndex=" + page + "&contract=" + contractTitle );
	
	if (xml!=null && checkStatus(xml))
	{
		var maxPages = parseInt(xml.documentElement.firstChild.getAttribute("pageCount"));
		currPage = parseInt(xml.documentElement.firstChild.getAttribute("pageIndex"));
		
		if (maxPages!=maxPages) maxPages = parseInt(xml.documentElement.firstChild.getAttribute("max_pages"));
		if (currPage!=currPage) currPage = parseInt(xml.documentElement.firstChild.getAttribute("page"));
		
		if (maxPages==0)maxPages = 1;
		
		xml.documentElement.setAttribute("current_page", currPage + " из " + maxPages);
		
		xml.documentElement.setAttribute("firstPage", "1");
		xml.documentElement.setAttribute("lastPage", maxPages);
		xml.documentElement.setAttribute("prevPage", currPage>1?currPage-1:1);
		xml.documentElement.setAttribute("nextPage", currPage<maxPages?currPage+1:maxPages);
		
		xml.documentElement.setAttribute("date1", formatDate(date1));
		xml.documentElement.setAttribute("date2", formatDate(date2));
		
		xml.documentElement.setAttribute("contract", contractTitle );

		show( xml );
	}
}

function paymentListPrint()
{
	contractTitle = document.getElementById("contractTitle");
	if ( contractTitle != null )
	{
		contractTitle = contractTitle.value;
	}
	else
	{
		contractTitle = "";
	}
	
	var xml = doAction('PaymentList', "Close", "&from="+formatDate(date1)+"&until="+formatDate(date2)+"&type=1&pageSize=0" + "&contract=" + contractTitle );

	if (xml!=null)
	{
		xml.documentElement.setAttribute("action", "PaymentListPrint");
		xml.documentElement.setAttribute("from", formatDate(date1));
		xml.documentElement.setAttribute("until", formatDate(date2));

		var dir = new String(window.location);
		dir = dir.substring(0, dir.lastIndexOf("/")) + "/";

		var printWin = open("", "print", "status, menubar, scrollbars, resizable");
		printWin.document.write("<html><head><title>BGBilling.    c "+ formatDate(date1) +"  " + formatDate(date1) + "</title><link href=\""+ dir +"stl.css\" rel=\"stylesheet\" type=\"text/css\"></head><body onUnload='close()'>"+ transform(xml) +"</body></html>");
		printWin.document.close();
	}
}

function paymentListExport()
{
	contractTitle = document.getElementById("contractTitle");
	if ( contractTitle != null )
	{
		contractTitle = contractTitle.value;
	}
	else
	{
		contractTitle = "";
	}

	window.location= path + "?mid=" + mid + "&action=PaymentListExport" + "&from="+formatDate(date1)+"&until="+formatDate(date2)+"&type=1&pageSize=0" + 
		"&contract=" + contractTitle + "&" + new Date().getTime();
}

function lastPaymentList()
{
	date1 = new Date();
	date2 = new Date();
	showDate(date1,date2);
	paymentList(-1);
}

function changePage(button)
{
	paymentList( button.getAttribute("page") );
}

function canselPayment(cid, id)
{
	if (confirm("Вы действительно хотите отменить платеж?"))
	{
		if (checkStatus( doAction('PaymentCansel', "Keep-Alive", "&id=" + id + "&cid=" + cid) ))
		{
			paymentList(currPage);
		}
	}
}

function formatDate(date)
{
	if (date!=null)
	{
		var day = date.getDate()>9?date.getDate():"0"+date.getDate();
		var month = (date.getMonth()+1)>9?(date.getMonth()+1):"0"+(date.getMonth()+1)
		return day+"."+month+"."+date.getFullYear();
	}
	else
	{
		return "";	
	}
}

//////////////////////////////////
//						//
//////////////////////////////////
function Point(x,y) {this.x=x; this.y=y;}

var days = [];
var month;
var months = new Array("январь","февраль","март","апрель","май","июнь","июль","август","сентябрь","октябрь","ноябрь","декабрь");
var date1 = new Date();
var date2 = new Date();
var contractTitle = "";
var calendar;
var calendarDate = new Date();
var currentCalendar = 0;

var timerId = 0;

function setDate(but)
{
	if (but!=null)
	{
		if (but.getAttribute("month") != null)
		{
			date1.setTime(but.getAttribute("month"));
			date2.setTime(but.getAttribute("month"));
			date2.setMonth(date2.getMonth()+1);
			date2.setDate(0);
		}
		else
		{
			switch(currentCalendar)
			{
				case 1: date1.setTime(but.getAttribute("date"));
						document.getElementById("date1").innerHTML = formatDate(date1);
						if (date1.getTime() > date2.getTime())
						{
							date2.setTime(date1.getTime());
						}
						break;
				case 2: 
						date2.setTime(but.getAttribute("date"));
						if (date2.getTime() < date1.getTime())
						{
							date1.setTime(date2.getTime());
						}
						break;
			}
			
			if (date2.getFullYear() > date1.getFullYear() || (date2.getFullYear() == date1.getFullYear() && date2.getMonth() > date1.getMonth()))
			{
				date2.setTime(date1.getTime());
				date2.setMonth(date2.getMonth()+1);
				date2.setDate(0);
			}
		}

		calendar.style.visibility = "hidden";
	}

	showDate(date1, date2);
}

function showDate(dt1, dt2)
{
	var datePanel = document.getElementById("date1");
	if (datePanel != null)
	{
		datePanel.innerHTML = formatDate(dt1);
	}
	
	datePanel = document.getElementById("date2");
	if (datePanel != null)
	{
		datePanel.innerHTML = formatDate(dt2);
	}
}

function editDate(n)
{
	currentCalendar = n;
	window.clearTimeout(timerId);
	switch(n)
	{
		case 1: calendarDate.setTime(date1.getTime()); break;
		case 2: calendarDate.setTime(date2.getTime()); break;
	}
	updateCalendar();
	
	showCalendar(mouse.x,mouse.y);
}

function showCalendar(x,y)
{
	var size = getScreenSize();
	calendar.style.left = x+calendar.scrollWidth>size.x?x-calendar.scrollWidth:x;
	calendar.style.top = y;
	calendar.style.visibility = "visible";
	timerId = window.setTimeout("hideCalendar()", 4000);	
}

function calendarOut()
{
	timerId = window.setTimeout("hideCalendar()", 1000);
}

function calendarIn()
{
	window.clearTimeout(timerId);
}

function hideCalendar()
{
	calendar.style.visibility = "hidden";
}

function buildCalendar()
{
	var xml = createXML();
	var el = xml.createElement("calendar");
	
	if (xml.documentElement)
	{
		xml.documentElement.appendChild(el);
	}
	else
	{
		xml.appendChild(el);
	}
	
	append(document.body, xml)

	calendar = document.getElementById("calendar");
	days = calendar.getElementsByTagName("tbody")[0].getElementsByTagName("div");
	month = document.getElementById("month");
	
	updateCalendar();
}

function prevMonth()
{
	calendarDate.setDate(0);
	updateCalendar();
}

function nextMonth()
{
	calendarDate.setDate(1);
	calendarDate.setMonth(calendarDate.getMonth()+1);
	updateCalendar();
}

function updateCalendar()
{
	var tempdate = new Date();
	tempdate.setTime(calendarDate.getTime());
	
	var mon = tempdate.getMonth();
	tempdate.setDate(1);
	
	month.innerHTML = months[tempdate.getMonth()] + " " + tempdate.getFullYear();
	month.setAttribute("month", tempdate.getTime());
	
	var offset = tempdate.getDay()==0?6:tempdate.getDay()-1;
	tempdate.setDate( tempdate.getDate() - offset);

	for (var i=0; i<6; i++)
		for (var j=0; j<7; j++)
		{
			with( days[7*i+j] )
			{
				if (mon != tempdate.getMonth())
				{
					style.color = "#aaaaaa";
				}
				else
				{
					style.color = "#000000";
				}
				
					var curr = new Date();
					switch(currentCalendar)
					{
						case 1: if (date1.getMonth() == tempdate.getMonth() && date1.getDate() == tempdate.getDate())
							style.backgroundColor = "#c0d0e0";
							else
							style.backgroundColor = "";
							break;
						case 2: if (date2.getMonth() == tempdate.getMonth() && date2.getDate() == tempdate.getDate())
							style.backgroundColor = "#c0d0e0";
							else
							style.backgroundColor = "";
							break;
					}

				innerHTML = tempdate.getDate();
				setAttribute("date", tempdate.getTime());
			}
			
			tempdate.setDate( tempdate.getDate() + 1 );
		}
}

var lightColor = "";
function lightOn(but)
{
	lightColor = but.style.backgroundColor;
	but.style.backgroundColor = "#ffffff";
}
function lightOff(but)
{
	but.style.backgroundColor = lightColor;
}

//////////////////////////////////
//			cookie				//
//////////////////////////////////
function readCookie(name)
{
  var cookieValue = "";
  var search = name + "=";

  if (document.cookie.length > 0)
  { 
    offset = document.cookie.indexOf(search);

    if (offset != -1)
    {
      offset += search.length;
      end = document.cookie.indexOf(";", offset);

      if (end == -1) end = document.cookie.length;
      cookieValue = unescape(document.cookie.substring(offset, end))
    }
  }
  return cookieValue;
}

function writeCookie(name, value)
{
  document.cookie = name + "=" + escape(value) + "; expires=Wed, 1 Jan 3000 00:00:00 UTC";
}

function exit()
{
//	close();
	doAction('Exit', "", "" );
}


//////////////////////////////////////
//	TransID   	//
//////////////////////////////////////
function getNextTransactionNumber()
{
	if (typeof prefix != 'undefined' && perfix!=null)
	{
		return prefix;
	}
	else
	{
		var dt = new Date();
		return "" + readCookie("prefix") + dt.getTime();	
	}
}

function getComment()
{
	if (typeof postfix != 'undefined' && postfix!=null)
	{
		return postfix;
	}
	else
	{
		return "" + readCookie("postfix");	
	}
}
