/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGSplitPaneNoBorder;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.field.BGFloatTextField;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.table.client.BGDataSourceTableModel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.modules.card.client.CardAddEditor;
import ru.bitel.bgbilling.modules.card.client.CardDeleteEditor;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;

public class ServiceConfigManagerCard
extends ServiceConfigTabbedPanel {
    private int did = 0;
    private CardAddEditor addEditor = new CardAddEditor(this);
    private CardDeleteEditor delEditor = new CardDeleteEditor(this);
    private BGComboBox<ComboBoxItem> dateTypeCb = new BGComboBox();
    private BGControlPanelPeriodNoB periodPanel = new BGControlPanelPeriodNoB();
    private JCheckBox cbLocked = new JCheckBox("\u043d\u0435 \u0432\u044b\u0434\u0430\u043d\u0430");
    private JCheckBox cbSale = new JCheckBox("\u0432 \u043f\u0440\u043e\u0434\u0430\u0436\u0435");
    private JCheckBox cbContract = new JCheckBox("\u0434\u043e\u0433\u043e\u0432\u043e\u0440");
    private JCheckBox cbBalance = new JCheckBox("\u0431\u0430\u043b\u0430\u043d\u0441");
    private JLabel countLabel = new JLabel();
    private JLabel summaLabel = new JLabel();
    private BGFloatTextField tfFrom = new BGFloatTextField();
    private BGFloatTextField tfTill = new BGFloatTextField();
    private BGTextField sLogin = new BGTextField();
    private BGTextField sPass = new BGTextField(10);
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private JPanel recPanel = new JPanel();
    private JTextField numField = new JTextField();
    private JList<BGUListItem> dealerList = new JList();
    private BGTable table = new BGTable();
    private BGDataSourceTableModel tableModel = new BGDataSourceTableModel("CardManager");

    public ServiceConfigManagerCard() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        this.table.setHeader(this.rb_name, this.moduleDoc, "card");
        this.dateTypeCb.addItem((Object)new ComboBoxItem((Object)"d_date", "\u0432\u044b\u0434\u0430\u043d\u0430 \u0434\u0438\u043b\u0435\u0440\u0443"));
        this.dateTypeCb.addItem((Object)new ComboBoxItem((Object)"date", "\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u0430"));
        this.resetFilter();
    }

    private void jbInit() throws Exception {
        this.sLogin.setHorizontalAlignment(0);
        this.sPass.setHorizontalAlignment(0);
        this.pagePanel.init();
        this.dealerList.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.dealerList.setSelectionMode(0);
        this.tfFrom.setMinimumSize(new Dimension(35, 24));
        this.tfFrom.setPreferredSize(new Dimension(35, 24));
        this.tfTill.setMinimumSize(new Dimension(35, 24));
        this.tfTill.setPreferredSize(new Dimension(35, 24));
        this.countLabel.setText("0");
        this.countLabel.setFont(new Font("Dialog", 0, 14));
        this.summaLabel.setText("0");
        this.summaLabel.setFont(new Font("Dialog", 0, 14));
        JPanel periodFilter = new JPanel(new GridBagLayout());
        periodFilter.setBorder((Border)new BGTitleBorder(" \u041f\u0435\u0440\u0438\u043e\u0434 "));
        periodFilter.add((Component)this.dateTypeCb, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 0), 0, 0));
        periodFilter.add((Component)this.periodPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.recPanel.setLayout(new GridBagLayout());
        this.recPanel.add((Component)new JLabel("\u0412\u0441\u0435\u0433\u043e \u043a\u0430\u0440\u0442: "), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.recPanel.add((Component)this.countLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.recPanel.add((Component)new JLabel("\u043d\u0430 \u0441\u0443\u043c\u043c\u0443: "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        this.recPanel.add((Component)this.summaLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        JPanel moneyPanel = new JPanel(new GridBagLayout());
        moneyPanel.add((Component)new JLabel("\u043e\u0442"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        moneyPanel.add((Component)new JLabel("\u0434\u043e"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        moneyPanel.add((Component)this.tfFrom, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        moneyPanel.add((Component)this.tfTill, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel numFilterPanel = new JPanel(new GridBagLayout());
        numFilterPanel.setBorder((Border)new BGTitleBorder(" \u0424\u0438\u043b\u044c\u0442\u0440 "));
        numFilterPanel.add((Component)new JLabel("\u0421\u0435\u0440\u0438\u0439\u043d\u044b\u0435 \u043d\u043e\u043c\u0435\u0440\u0430"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        numFilterPanel.add((Component)this.numField, new GridBagConstraints(1, 0, 3, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        numFilterPanel.add((Component)new JLabel("\u041b\u043e\u0433\u0438\u043d"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        numFilterPanel.add((Component)this.sLogin, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        numFilterPanel.add((Component)new JLabel("\u041f\u0430\u0440\u043e\u043b\u044c"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        numFilterPanel.add((Component)this.sPass, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        numFilterPanel.add((Component)new JLabel("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        numFilterPanel.add((Component)moneyPanel, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        JPanel statusPanel = new JPanel(new GridBagLayout());
        statusPanel.setBorder((Border)new BGTitleBorder(" C\u0442\u0430\u0442\u0443\u0441 "));
        statusPanel.add((Component)this.cbLocked, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
        statusPanel.add((Component)this.cbSale, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        statusPanel.add((Component)this.cbContract, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        statusPanel.add((Component)this.cbBalance, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        JPanel dealerPanel = new JPanel(new GridBagLayout());
        dealerPanel.setBorder((Border)new BGTitleBorder(" \u0414\u0438\u043b\u0435\u0440\u044b "));
        dealerPanel.add((Component)new JScrollPane(this.dealerList), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        JPanel leftPanel = new JPanel(new GridBagLayout());
        leftPanel.add((Component)numFilterPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        leftPanel.add((Component)statusPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        leftPanel.add((Component)periodFilter, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        leftPanel.add((Component)dealerPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        JPanel rightPanel = new JPanel(new GridBagLayout());
        rightPanel.add((Component)this.getCarlListPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        BGSplitPaneNoBorder bgSplitPaneNoBorder = new BGSplitPaneNoBorder(1, (Component)leftPanel, (Component)rightPanel, 300L);
        this.setLayout(new GridBagLayout());
        this.add((Component)bgSplitPaneNoBorder, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.addEditor.setVisible(false);
        this.delEditor.setVisible(false);
        this.dealerList.addListSelectionListener(e -> this.dealerList_valueChanged(e));
        this.pagePanel.addToHandler(a -> this.setDealerData());
        BGSwingUtilites.handleLDMouseClicked((Component)this.table, this::tableMouseClicked);
        this.numField.addActionListener(e -> this.setDealerData());
    }

    private JPanel getCarlListPanel() {
        BGUTable tableCard = new BGUTable((TableModel)this.tableModel);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(" \u0421\u043f\u0438\u0441\u043e\u043a \u043a\u0430\u0440\u0442 "));
        panel.add((Component)this.getToolBarPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)new JScrollPane((Component)this.table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)new JScrollPane((Component)tableCard), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)((Object)this.addEditor), new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)((Object)this.delEditor), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.recPanel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getToolBarPanel() {
        BGButton bGAdd = new BGButton(" \u041f\u0435\u0440\u0435\u0434\u0430\u0442\u044c \u0434\u0438\u043b\u0435\u0440\u0443 ");
        bGAdd.addActionListener(e -> this.bGAdd_actionPerformed(e));
        BGButton bGDelete = new BGButton(" \u0417\u0430\u0431\u0440\u0430\u0442\u044c \u0443 \u0434\u0438\u043b\u0435\u0440\u0430");
        bGDelete.addActionListener(e -> this.bGDelete_actionPerformed(e));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.pagePanel, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getButtonPanel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)bGAdd, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)bGDelete, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add(Box.createGlue(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getButtonPanel() {
        BGButton bGApplyF = new BGButton(" \u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c ");
        bGApplyF.setRequestFocusEnabled(true);
        bGApplyF.addActionListener(e -> this.applyFilter());
        BGButton bGResetF = new BGButton(" \u0421\u0431\u0440\u043e\u0441 ");
        bGResetF.setMnemonic('0');
        bGResetF.addActionListener(e -> this.resetFilter());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)bGApplyF, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)bGResetF, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    private void tableMouseClicked(MouseEvent event) {
        int contractId = Utils.parseInt((String)ClientUtils.getRowId((BGTable)this.table, null, (String)"cid"));
        if (contractId > 0) {
            ClientUtils.openContract((int)contractId);
        }
    }

    private void dealerList_valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        BGUListItem item = this.dealerList.getSelectedValue();
        if (item != null) {
            this.did = Utils.parseInt((String)((String)item.getAttribute("id")));
        }
        this.pagePanel.init();
    }

    private void setDealerData() {
        Request request = new Request().setModule(this.module).setModuleId(this.getModuleId()).setAction("FilterCardInfo").setPageIndex(this.pagePanel.getPageIndex()).setPageSize(this.pagePanel.getPageSize()).setPeriod(this.periodPanel.getPeriod()).setAttribute("sale", this.cbSale.isSelected() ? "1" : "-1").setAttribute("contract", this.cbContract.isSelected() ? "2" : "-1").setAttribute("balance", this.cbBalance.isSelected() ? "3" : "-1").setAttribute("locked", this.cbLocked.isSelected() ? "0" : "-1").setAttribute("from", this.tfFrom.getText()).setAttribute("till", this.tfTill.getText()).setAttribute("did", this.did).setAttribute("login", this.sLogin.getText()).setAttribute("pass", this.sPass.getText()).setAttribute("date_type", ClientUtils.getIdFromComboBox(this.dateTypeCb));
        int num = -1;
        int count = 0;
        String numCount = this.numField.getText();
        if (numCount.indexOf("+") > 0) {
            StringTokenizer st = new StringTokenizer(numCount, "+");
            if (st.hasMoreTokens()) {
                num = Utils.parseInt((String)st.nextToken(), (int)-1);
            }
            if (st.hasMoreTokens()) {
                count = Utils.parseInt((String)st.nextToken(), (int)1);
            }
        } else {
            num = Utils.parseInt((String)numCount, (int)-1);
        }
        request.setAttribute("num", String.valueOf(num));
        request.setAttribute("count", String.valueOf(count));
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            try {
                Element tableElement = this.table.updateData(doc);
                this.pagePanel.setPageInfo(tableElement);
                this.countLabel.setText(XMLUtils.getAttribute((Element)tableElement, (String)"allRecord", (String)"0"));
                this.summaLabel.setText(XMLUtils.getAttribute((Element)tableElement, (String)"summa", (String)"0"));
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        } else {
            this.countLabel.setText("0");
            this.summaLabel.setText("0");
        }
        BGUTableParams tableParams = new BGUTableParams().setPage(this.pagePanel.getPage()).addParam("dealerId", String.valueOf(this.did)).addParam("login", this.sLogin.getText()).addParam("pass", this.sPass.getText());
        this.tableModel.loadData(this.getContext(), tableParams);
    }

    public void init(String module, int moduleId) {
        super.init(module, moduleId);
    }

    public void setData() throws Exception {
        Request request = new Request().setModule(this.module).setModuleId(this.getModuleId()).setAttribute("type", 1).setAction("ListDealers");
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.setDocument(doc);
        }
        BGUTableParams tableParams = new BGUTableParams();
        this.tableModel.loadData(this.getContext(), tableParams);
    }

    public void setDocument(Document doc) throws Exception {
        ClientUtils.buildList(this.dealerList, (Node)XMLUtils.selectNode((Node)doc, (String)"//dealers"));
    }

    private void resetFilter() {
        this.did = 0;
        this.tfFrom.setText("");
        this.tfTill.setText("");
        this.sLogin.setText("");
        this.sPass.setText("");
        this.dealerList.clearSelection();
        this.numField.setText("");
        this.cbLocked.setSelected(true);
        this.cbContract.setSelected(true);
        this.cbSale.setSelected(true);
        this.cbBalance.setSelected(true);
        this.periodPanel.setDateCalendar1(null);
        this.periodPanel.setDateCalendar2(null);
    }

    private void bGDelete_actionPerformed(ActionEvent e) {
        if (this.did == 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0438\u043b\u0435\u0440\u0430");
            return;
        }
        this.addEditor.setVisible(false);
        this.delEditor.setDealerId(this.did);
        this.delEditor.startEdit();
        this.recPanel.setVisible(false);
    }

    private void bGAdd_actionPerformed(ActionEvent e) {
        if (this.did == 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0438\u043b\u0435\u0440\u0430");
            return;
        }
        this.delEditor.setVisible(false);
        this.addEditor.setDealerId(this.did);
        this.addEditor.startEdit();
        this.recPanel.setVisible(false);
    }

    public void stopCardMove() {
        this.recPanel.setVisible(true);
    }

    private void applyFilter() {
        this.pagePanel.init();
        this.setDealerData();
    }
}

