/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.action.pub;

import bitel.billing.server.contract.bean.CommentPatternManager;
import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.contract.bean.ContractParameterManager;
import bitel.billing.server.util.captcha.Captcha;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractCreateData;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.ContractTariffDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.MultiListParamValues;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.event.events.ContractCreatedEvent;
import ru.bitel.bgbilling.kernel.tariff.common.bean.TariffPlan;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffPlanDao;
import ru.bitel.bgbilling.modules.card.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.card.server.bean.Card;
import ru.bitel.bgbilling.modules.card.server.bean.CardManager;
import ru.bitel.bgbilling.modules.card.server.bean.CardSeriesManager;
import ru.bitel.bgbilling.modules.card.server.event.CardPubActivateEvent;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrBoolean;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrEmail;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrList;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrPhone;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;

public class ActionCreateContract
extends ActionBase {
    private static final String ACTIVATE_TYPE = "bitel.billing.server.card.Pub_ActionCreateContract.activateType";
    private static final String PREFFIX = "bitel.billing.server.card.";
    private Map<Integer, ParamInfo> mapParams;
    private static final Pattern patternTitle = Pattern.compile("\\$\\{(.+?)(?:(?:\\:(.+?))?|(\\d)?)\\}");

    public void doAction() throws Exception {
        boolean useTariff;
        this.session = this.request.getSession(true);
        int activateType = this.getIntParameter("activateType", 0);
        if (this.getParameter("getcaptcha") != null) {
            Captcha.captcha((HttpServletRequest)this.request, (HttpServletResponse)this.response, (HttpSession)this.session, (boolean)false, (boolean)(this.moduleSetup != null ? this.moduleSetup.getInt("activate.login.service." + activateType + ".captcha.useDigist", 0) > 0 : false));
            return;
        }
        this.rootNode.setAttribute("xslt", this.moduleSetup.get("activate.login.xsl", "card_create_contract.xsl"));
        this.rootNode.setAttribute("action", "CreateContract");
        this.rootNode.setAttribute("module", "voiceip");
        this.rootNode.setAttribute("mid", String.valueOf(this.mid));
        this.rootNode.setAttribute("rand", String.valueOf(System.currentTimeMillis() % 1000000L));
        this.createElemPhonesFormats();
        Element errors = this.createElement(this.rootNode, "errors");
        int tariff = 0;
        Map params = null;
        String login = null;
        String pswd = null;
        boolean confirm = this.getParameter("confirm") != null;
        boolean activate = this.getParameter("activate") != null;
        boolean returnFlag = this.getParameter("return") != null;
        boolean accept = this.getIntParameter("accept", 0) == 1;
        this.mapParams = this.getParamsInfo();
        if (confirm || returnFlag) {
            activateType = (Integer)this.request.getSession().getAttribute("bitel.billing.server.card.activateType") != null ? (Integer)this.request.getSession().getAttribute("bitel.billing.server.card.activateType") : 0;
            tariff = (Integer)this.request.getSession().getAttribute("bitel.billing.server.card.tariff") != null ? (Integer)this.request.getSession().getAttribute("bitel.billing.server.card.tariff") : -1;
            params = (Map)this.request.getSession().getAttribute("bitel.billing.server.card.params");
            login = (String)this.request.getSession().getAttribute("bitel.billing.server.card.login");
            pswd = (String)this.request.getSession().getAttribute("bitel.billing.server.card.pswd");
        } else {
            activateType = this.getIntParameter("activateType", 0);
            tariff = this.getIntParameter("tariff", -1);
            params = this.getContractParameters();
            login = this.getParameter("login");
            pswd = this.getParameter("pswd");
            if (activate) {
                this.session.setAttribute("bitel.billing.server.card.activateType", (Object)activateType);
                this.session.setAttribute("bitel.billing.server.card.tariff", (Object)tariff);
                this.session.setAttribute("bitel.billing.server.card.params", (Object)params);
                this.session.setAttribute("bitel.billing.server.card.login", (Object)login);
                this.session.setAttribute("bitel.billing.server.card.pswd", (Object)pswd);
            }
        }
        boolean bl = useTariff = this.moduleSetup.getInt("activate.login.service." + activateType + ".use.tariff", 1) == 1;
        if (this.moduleSetup.getInt("activate.login.service." + activateType + ".mid", 0) <= 0) {
            return;
        }
        String statisticUrl = this.moduleSetup.get("statistics.url", null);
        if (!Utils.isEmptyString((String)statisticUrl)) {
            this.rootNode.setAttribute("statisticUrl", statisticUrl);
        }
        if ((activate || confirm) && (!Integer.valueOf(activateType).equals(this.request.getSession().getAttribute(ACTIVATE_TYPE)) || tariff <= 0 && useTariff)) {
            this.show(activateType, tariff, params, useTariff, login);
            return;
        }
        CardManager cardManager = new CardManager(this.con, this.mid);
        try {
            if (activate) {
                this.activate(activateType, errors, tariff, params, login, pswd, accept, useTariff, cardManager);
            }
            if (confirm) {
                this.confirm(activateType, errors, tariff, params, login, pswd, useTariff, cardManager);
            }
        }
        catch (BGException ex) {
            Element error = this.createElement(errors, "error");
            error.setAttribute("type", "other");
            error.setAttribute("desc", "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430. \u041e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u0432 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044e");
            this.logError(ex);
        }
        this.show(activateType, tariff, params, useTariff, login);
    }

    protected void confirm(int activateType, Element errors, int tariff, Map<Integer, String> params, String login, String pswd, boolean useTariff, CardManager cardManager) throws Exception {
        CardPubActivateEvent event = new CardPubActivateEvent(this.mid, true, activateType, tariff, params, pswd, pswd, useTariff, true);
        EventProcessor.getInstance().request((QueueEvent)event);
        if (event.isWasProcceced()) {
            if (!Utils.isEmptyString((String)event.getError())) {
                Element error = this.createElement(errors, "error");
                error.setAttribute("type", "other");
                error.setAttribute("desc", event.getError());
            } else if (!event.isSuccess()) {
                throw new BGException("Script Error");
            }
            Contract contract = event.getContract();
            if (contract == null) {
                throw new BGException("Contract was not created");
            }
            this.setContactToRequest(contract);
        } else {
            boolean wasError = this.perFormChecks(activateType, errors, tariff, params, pswd, pswd, useTariff, true);
            if (!wasError) {
                int serviceMid = this.moduleSetup.getInt("activate.login.service." + activateType + ".mid", -1);
                if (serviceMid <= 0) {
                    Element error = this.createElement(errors, "error");
                    error.setAttribute("type", "system");
                    error.setAttribute("error", "mid");
                } else {
                    Card card = this.findCard(activateType, cardManager, errors, login, pswd);
                    if (card != null) {
                        Contract contract = null;
                        try {
                            contract = this.createContact(activateType, tariff, params, useTariff, card);
                        }
                        catch (Exception ex) {
                            this.logError(ex);
                            Element error = this.createElement(errors, "error");
                            error.setAttribute("type", "other");
                            error.setAttribute("error", ex.getMessage());
                        }
                        if (contract != null) {
                            this.setContactToRequest(contract);
                        }
                    }
                }
            }
        }
    }

    protected void activate(int activateType, Element errors, int tariff, Map<Integer, String> params, String login, String pswd, boolean accept, boolean useTariff, CardManager cardManager) throws Exception {
        Element error;
        String pswd2 = this.getParameter("pswd2");
        CardPubActivateEvent event = new CardPubActivateEvent(this.mid, false, activateType, tariff, params, pswd, pswd2, useTariff, accept);
        event = (CardPubActivateEvent)EventProcessor.getInstance().request((QueueEvent)event);
        boolean wasError = false;
        if (event.isWasProcceced()) {
            boolean bl = wasError = !Utils.isEmptyString((String)event.getError());
            if (wasError) {
                error = this.createElement(errors, "error");
                error.setAttribute("type", "other");
                error.setAttribute("desc", event.getError());
            } else if (!event.isSuccess()) {
                throw new BGException("Script Error");
            }
        } else {
            wasError = this.perFormChecks(activateType, errors, tariff, params, pswd, pswd2, useTariff, accept);
        }
        if (!wasError) {
            if (!Captcha.validate((String)this.getParameter("captcha"), (HttpSession)this.session)) {
                wasError = true;
                error = this.createElement(errors, "error");
                error.setAttribute("type", "captcha");
                this.session.removeAttribute("bitel.billing.server.card.login");
                this.session.removeAttribute("bitel.billing.server.card.pswd");
            } else if (event.isWasProcceced()) {
                this.setConfirmToRequest();
            } else {
                int serviceMid = this.moduleSetup.getInt("activate.login.service." + activateType + ".mid", -1);
                if (serviceMid <= 0) {
                    Element error2 = this.createElement(errors, "error");
                    error2.setAttribute("type", "system");
                    error2.setAttribute("error", "mid");
                } else {
                    Card card = this.findCard(activateType, cardManager, errors, login, pswd);
                    if (card != null) {
                        this.setConfirmToRequest();
                    }
                }
            }
        }
    }

    protected void setContactToRequest(Contract contract) {
        BalanceUtils bu = new BalanceUtils(this.con);
        if (contract != null) {
            BigDecimal balance = bu.getBalance(LocalDate.now(), contract.getId());
            Element ctr = this.createElement(this.rootNode, "contract");
            ctr.setAttribute("title", contract.getTitle());
            ctr.setAttribute("date1", TimeUtils.formatDate((Date)contract.getDateFrom()));
            ctr.setAttribute("comment", contract.getComment());
            ctr.setAttribute("balance", balance.toPlainString());
            ctr.setAttribute("pswd", contract.getPassword());
            bu.close();
        }
    }

    protected void setConfirmToRequest() {
        this.createElement(this.rootNode, "confirm");
        this.rootNode.setAttribute("action", "ContractConfirm");
    }

    protected boolean perFormChecks(int activateType, Element errors, int tariff, Map<Integer, String> params, String pswd, String pswd2, boolean useTariff, boolean accept) {
        Element error;
        boolean wasError = this.checkParams(errors, params);
        if (!wasError && pswd != null && !pswd.equals(pswd2)) {
            error = this.createElement(errors, "error");
            error.setAttribute("type", "passwords_not_equal");
            wasError = true;
        }
        if (!wasError) {
            wasError = this.checkTariff(activateType, tariff, useTariff, wasError);
        }
        if (!wasError && !accept) {
            error = this.createElement(errors, "error");
            error.setAttribute("type", "accept");
            wasError = true;
        }
        return wasError;
    }

    private boolean checkTariff(int activateType, int tariff, boolean useTariff, boolean wasError) {
        List tariffs = Utils.toIntegerList((String)this.moduleSetup.get("activate.login.service." + activateType + ".tariffs", ""));
        if (useTariff && !tariffs.contains(tariff)) {
            wasError = true;
        }
        return wasError;
    }

    private boolean checkParams(Element errors, Map<Integer, String> params) {
        boolean wasError = false;
        for (int i = 1; i <= this.mapParams.size(); ++i) {
            String param;
            ParamInfo paramInfo = this.mapParams.get(i);
            String string = param = params.size() >= i ? params.get(i) : null;
            if ("list".equals(paramInfo.getType())) {
                int val = Utils.parseInt((String)param, (int)-1);
                int pid = paramInfo.getPid();
                List<IdTitle> list = this.getListParam(pid, true);
                boolean set = false;
                for (IdTitle it : list) {
                    if (it.id != val) continue;
                    set = true;
                    break;
                }
                if (!set) {
                    param = "";
                }
            }
            if (Utils.isBlankString((String)param)) {
                if (!paramInfo.getRequire()) continue;
                wasError = true;
                Element error = this.createElement(errors, "error");
                error.setAttribute("type", "param");
                error.setAttribute("param", String.valueOf(i));
                error.setAttribute("error", "require");
                error.setAttribute("desc", this.moduleSetup.get("activate.login.param." + i + ".require.error", ""));
                continue;
            }
            if (Utils.isEmptyString((String)paramInfo.getPattern()) || param.matches(paramInfo.getPattern())) continue;
            wasError = true;
            Element error = this.createElement(errors, "error");
            error.setAttribute("type", "param");
            error.setAttribute("param", String.valueOf(i));
            error.setAttribute("error", "pattern");
            error.setAttribute("desc", this.moduleSetup.get("activate.login.param." + i + ".pattern.error", ""));
        }
        return wasError;
    }

    private Map<Integer, String> getContractParameters() {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        int i = 1;
        while (this.moduleSetup.getInt("activate.login.param." + i + ".pid", 0) > 0) {
            map.put(i, this.getParameter("param_" + i));
            ++i;
        }
        return map;
    }

    private void show(int activateType, int tariff, Map<Integer, String> params, boolean useTariff, String login) throws BGException {
        this.rootNode.setAttribute("activateType", String.valueOf(activateType));
        this.rootNode.setAttribute("activate", this.moduleSetup.get("activate.login.service." + activateType + ".title", ""));
        this.session.setAttribute(ACTIVATE_TYPE, (Object)activateType);
        Element paramsEl = this.createElement(this.rootNode, "params");
        paramsEl.setAttribute("tariff", String.valueOf(tariff));
        paramsEl.setAttribute("useTariff", useTariff ? "1" : "0");
        if (login != null) {
            paramsEl.setAttribute("login", login);
        }
        for (int i = 1; i <= this.mapParams.size(); ++i) {
            ParamInfo paramInfo = this.mapParams.get(i);
            Element paramEl = this.createElement(paramsEl, "param");
            paramEl.setAttribute("id", String.valueOf(i));
            paramEl.setAttribute("value", params.size() >= i ? params.get(i) : "");
            paramEl.setAttribute("title", paramInfo.getTitle());
            paramEl.setAttribute("type", paramInfo.getType());
            paramEl.setAttribute("require", paramInfo.getRequire() ? "1" : "0");
            if (!"list".equals(paramInfo.getType())) continue;
            List<IdTitle> list = this.getListParam(paramInfo.getPid(), paramInfo.getRequire());
            Element listEl = this.createElement(paramEl, "list");
            for (IdTitle it : list) {
                Element item = this.createElement(listEl, "item");
                item.setAttribute("id", String.valueOf(it.id));
                item.setAttribute("title", it.title);
            }
        }
        List tariffs = Utils.toIntegerList((String)this.moduleSetup.get("activate.login.service." + activateType + ".tariffs", ""));
        try (TariffPlanDao tariffPlanDao = new TariffPlanDao(this.con);){
            Map tariffMap = tariffPlanDao.getTariffPlanMap();
            Element tariffsEl = this.createElement(this.rootNode, "tariffs");
            for (Integer tp : tariffs) {
                TariffPlan plan = (TariffPlan)tariffMap.get(tp);
                if (plan == null) continue;
                Element planEl = this.createElement(tariffsEl, "tariff");
                planEl.setAttribute("id", String.valueOf(plan.getId()));
                planEl.setAttribute("title", plan.getTitle());
            }
        }
    }

    private Contract createContact(int activateType, int tariff, Map<Integer, String> params, boolean useTarif, Card card) throws Exception {
        Contract contract = null;
        int serviceMid = this.moduleSetup.getInt("activate.login.service." + activateType + ".mid", -1);
        CardManager cardManager = new CardManager(this.con, this.mid);
        int patternId = this.moduleSetup.getInt("activate.login.service." + activateType + ".patternId", -1);
        if (patternId <= 0) {
            patternId = card.getPatternId();
        }
        CardSeriesManager csm = new CardSeriesManager(this.con, this.mid);
        String cs = csm.getSeriesTitle(card.getSeriesId());
        HashMap<String, Object> titleMap = new HashMap<String, Object>(4);
        titleMap.put("card", card.getCardCode());
        titleMap.put("card_series", cs);
        HashMap<Object, Object> cardParams = new HashMap<Object, Object>();
        String cardParamName = card.getClass().getName();
        cardParams.put(cardParamName, card);
        cardParams.put(cardParamName + ".series", cs);
        cardParams.put("moduleId", serviceMid);
        try (ContractDao contractDao = new ContractDao(this.con, this.userId.intValue());){
            ContractCreateData data = ContractCreateData.builder().setPatternId(card.getPatternId()).setDateFrom(new Date()).setPassword(card.getCardPinCode()).setTitleParams(titleMap).build();
            contract = contractDao.createFromPattern(data, cardParams, true);
        }
        catch (Exception e) {
            throw new BGException((Throwable)e);
        }
        GregorianCalendar now = new GregorianCalendar();
        int contractId = contract.getId();
        card.setContractId(contractId);
        if (!cardManager.activated(card, 2)) {
            throw new BGException("Card was not activated");
        }
        card.setStatus(1);
        cardManager.addCardToContract(this.context, this.con, now, card, contractId);
        card.setStatus(2);
        try (ContractDao contractDao = new ContractDao(this.con, -1);
             ContractParameterManager cpm = new ContractParameterManager(this.con);){
            int group = this.moduleSetup.getInt("activate.login.service." + activateType + ".group", -1);
            if (group >= 0) {
                try {
                    new ContractManager(this.con).addContractGroup(contractId, group);
                }
                catch (Exception e) {
                    throw new BGException((Throwable)e);
                }
            }
            if (useTarif) {
                LocalDate date = TimeUtils.convertDateToLocalDate((Date)now.getTime());
                ContractTariffDao contractTariffDao = new ContractTariffDao(this.con);
                List list = contractTariffDao.list(contractId, date);
                for (Object t : list) {
                    contractTariffDao.delete(t.getId());
                }
                ContractTariff ct = ContractTariff.builder().setContractId(contractId).setTariffPlanId(tariff).setPeriod(new Period(date, null)).build();
                contractTariffDao.update((Object)ct);
                for (Integer tpid : Utils.toIntegerList((String)this.moduleSetup.get("activate.login.service." + activateType + ".tariffs.hidden", ""))) {
                    ct = ContractTariff.builder().setContractId(contractId).setTariffPlanId(tpid.intValue()).setPeriod(new Period(date, null)).build();
                    contractTariffDao.update((Object)ct);
                }
            }
            for (int i = 1; i <= this.mapParams.size(); ++i) {
                String param;
                ParamInfo paramInfo = this.mapParams.get(i);
                String string = param = params.size() >= i ? params.get(i) : null;
                if (!Utils.notBlankString(param)) continue;
                String type = paramInfo.getType();
                int pid = paramInfo.getPid();
                if ("list".equals(type)) {
                    contractDao.updateContractParameter(contractId, (EntityAttr)new EntityAttrList(contractId, pid, Utils.parseInt((String)param, (int)-1), ""));
                    continue;
                }
                if ("flag".equals(type)) {
                    contractDao.updateContractParameter(contractId, (EntityAttr)new EntityAttrBoolean(contractId, pid, true));
                    continue;
                }
                if ("email".equals(type)) {
                    EntityAttrEmail attrEmail = new EntityAttrEmail(contractId, pid);
                    attrEmail.setData(param);
                    contractDao.updateContractParameter(contractId, (EntityAttr)attrEmail);
                    continue;
                }
                if ("phone".equals(type)) {
                    EntityAttrPhone attrPhone = new EntityAttrPhone(contractId, pid);
                    attrPhone.addContact(param, "");
                    contractDao.updateContractParameter(contractId, (EntityAttr)attrPhone);
                    continue;
                }
                if ("multilist".equals(type)) {
                    MultiListParamValues listValues = new MultiListParamValues();
                    listValues.parseValue(param);
                    cpm.updateMultiListParameterAndItems(contractId, pid, listValues, 0);
                    continue;
                }
                contractDao.updateContractParameter(contractId, (EntityAttr)new EntityAttrText(contractId, pid, param));
            }
        }
        if (this.mapParams.size() > 0) {
            try {
                new CommentPatternManager(this.con).updateContractComment(contractId);
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
        EventProcessor.getInstance().request((QueueEvent)new ContractCreatedEvent(contract, this.userId.intValue()));
        return contract;
    }

    private List<IdTitle> getListParam(int pid, boolean require) {
        ArrayList<IdTitle> result = new ArrayList<IdTitle>();
        if (!require) {
            result.add(new IdTitle(this, -1, "---\u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e---"));
        }
        try {
            String query = "SELECT id, title FROM contract_parameter_type_7_values WHERE pid=? ORDER BY title";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, pid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(new IdTitle(this, rs.getInt(1), rs.getString(2)));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getContractName(Card card, int activateType) {
        StringBuilder sb = new StringBuilder();
        String pattern = this.moduleSetup.get("activate.login.service." + activateType + ".pattern.title", "");
        if (Utils.isEmptyString((String)pattern)) {
            return null;
        }
        if (!Utils.isBlankString((String)pattern)) {
            int pos = 0;
            Matcher m = patternTitle.matcher(pattern);
            while (m.find()) {
                sb.append(pattern.substring(pos, m.start()));
                String mask = m.group(1);
                if ("card".equals(mask)) {
                    fmt = m.group(2);
                    if (Utils.isEmptyString((String)fmt)) {
                        sb.append(String.valueOf(card.getCardCode()));
                    } else {
                        df = new DecimalFormat(fmt);
                        sb.append(((NumberFormat)df).format(card.getCardCode()));
                    }
                } else if ("time".equals(mask)) {
                    fmt = m.group(2);
                    if (Utils.isEmptyString((String)fmt)) {
                        fmt = "yy";
                    }
                    df = new SimpleDateFormat(fmt);
                    sb.append(((DateFormat)df).format(new GregorianCalendar().getTime()));
                }
                pos = m.end();
            }
        }
        if (sb.length() == 0) {
            DecimalFormat df = new DecimalFormat("000000");
            sb.append("K" + df.format(card.getCardCode()));
        }
        return sb.toString();
    }

    private Card findCard(int activateType, CardManager cardManager, Element errors, String login, String pswd) throws Exception {
        boolean is_pasw_valid;
        if (Utils.isEmptyString((String)pswd)) {
            Element error = this.createElement(errors, "error");
            error.setAttribute("type", "card_pswd_empty");
            return null;
        }
        Card card = cardManager.findCard(login);
        if (card == null) {
            Element error = this.createElement(errors, "error");
            error.setAttribute("type", "card_notfound");
            return null;
        }
        String pin_code = card.getCardPinCode();
        int status = card.getStatus();
        boolean bl = is_pasw_valid = Utils.getDigest((String)pswd, (String)"cp1251").equals(pin_code) || pswd.equals(pin_code);
        if (!is_pasw_valid) {
            Element error = this.createElement(errors, "error");
            error.setAttribute("type", "card_pswd");
            return null;
        }
        Date now = new Date();
        Date date1 = card.getDateBegin();
        Date date2 = card.getDateEnd();
        if (date1 != null && date1.after(now) || date2 != null && date2.before(now)) {
            Element error = this.createElement(errors, "error");
            error.setAttribute("type", "card_expired");
            return null;
        }
        if (status != 1) {
            switch (status) {
                case 0: {
                    Element error = this.createElement(errors, "error");
                    error.setAttribute("type", "card_blocked");
                    return null;
                }
                case 2: {
                    Element error = this.createElement(errors, "error");
                    error.setAttribute("type", "card_activated_contract");
                    return null;
                }
                case 3: {
                    Element error = this.createElement(errors, "error");
                    error.setAttribute("type", "card_activeted_balance");
                    return null;
                }
            }
        }
        List activateServices = Utils.toIntegerList((String)this.moduleSetup.get("activate.login.service." + activateType + ".sids", ""));
        if (card.getServiceActivateId() == 0 || !activateServices.contains(card.getServiceActivateId()) && !activateServices.contains(0)) {
            Element error = this.createElement(errors, "error");
            error.setAttribute("type", "card_service");
            error.setAttribute("serviceActivateId", String.valueOf(card.getServiceActivateId()));
            return null;
        }
        return card;
    }

    private void createElemPhonesFormats() {
        Element formatsElem = this.createElement(this.rootNode, "phonesFormats");
        String formats = this.setup.get("phones.formats");
        if (Utils.isEmptyString((String)formats)) {
            return;
        }
        formatsElem.setAttribute("format", formats);
    }

    private Map<Integer, ParamInfo> getParamsInfo() {
        if (this.mapParams == null) {
            this.mapParams = new HashMap<Integer, ParamInfo>();
            int i = 1;
            while (this.moduleSetup.getInt("activate.login.param." + i + ".pid", 0) > 0) {
                ParamInfo param = new ParamInfo(this);
                param.setTitle(this.moduleSetup.get("activate.login.param." + i + ".title", null));
                param.setPattern(this.moduleSetup.get("activate.login.param." + i + ".pattern", null));
                param.setRequire(this.moduleSetup.getInt("activate.login.param." + i + ".require", 0) == 1);
                param.setType(this.moduleSetup.get("activate.login.param." + i + ".type", null));
                param.setPid(this.moduleSetup.getInt("activate.login.param." + i + ".pid", 0));
                this.mapParams.put(i, param);
                ++i;
            }
        }
        return this.mapParams;
    }

    class ParamInfo {
        private String title;
        private String pattern;
        private boolean require;
        private String type;
        private int pid;

        public ParamInfo(ActionCreateContract this$0) {
            this.title = "";
            this.pattern = "";
            this.require = false;
            this.type = "";
            this.pid = 0;
        }

        public ParamInfo(ActionCreateContract this$0, String title, String pattern, boolean require, String type, int pid) {
            this.title = title;
            this.pattern = pattern;
            this.require = require;
            this.type = type;
            this.pid = pid;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public boolean getRequire() {
            return this.require;
        }

        public void setRequire(boolean require) {
            this.require = require;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public int getPid() {
            return this.pid;
        }

        public void setPid(int pid) {
            this.pid = pid;
        }
    }

    private class IdTitle {
        private int id;
        private String title;

        public IdTitle(ActionCreateContract actionCreateContract, int id, String title) {
            this.id = id;
            this.title = title;
        }
    }
}

