/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.client.botconfigure;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.dynamic.client.DynamicClassChooser;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialog;
import ru.bitel.bgbilling.modules.botmanager.common.bean.DialogProcessing;
import ru.bitel.bgbilling.modules.botmanager.common.bean.DialogProcessingWrapper;
import ru.bitel.bgbilling.modules.botmanager.common.service.BotManagerService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;

public class BotDialogSelectDialogProcessingPanel
extends BGUPanel {
    private final BotManagerService botManagerService;
    private List<DialogProcessingWrapper> wrapperList;
    private BGControlPanelListSelect dialogProcessingList;
    private DynamicClassChooser classChooser;

    protected BotDialogSelectDialogProcessingPanel(BotManagerService botManagerService) {
        this.botManagerService = botManagerService;
        this.setLayout(new GridBagLayout());
        this.setVisible(false);
        this.init();
    }

    protected void jbInit() throws Exception {
        this.dialogProcessingList = new BGControlPanelListSelect(true);
        this.dialogProcessingList.setButtonPanelVisible(false);
        this.classChooser = new DynamicClassChooser(false, 2);
        this.classChooser.setIfaceName(DialogProcessing.class.getName());
        this.classChooser.performAction("refresh");
        this.classChooser.setNewClassPrefix("ru.bitel.bgbilling.modules.botmanager.dyn.");
        JButton reload = new JButton();
        reload.setIcon(ClientUtils.getIcon((String)"refresh"));
        reload.setToolTipText("\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u043f\u0438\u0441\u043e\u043a \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u043e\u0432 \u0434\u0438\u0430\u043b\u043e\u0433\u0430");
        reload.addActionListener(e -> {
            this.classChooser.performAction("refresh");
            this.performAction("refresh");
        });
        GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 0, 0), 0, 0);
        this.add(new JLabel("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0434\u0438\u0430\u043b\u043e\u0433\u0430"), constraints);
        this.add(reload, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.add((Component)this.dialogProcessingList, new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(new JLabel("\u0421\u043e\u0437\u0434\u0430\u0442\u044c/\u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043a\u043b\u0430\u0441\u0441 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a\u0430"), constraints);
        constraints.gridwidth = 2;
        this.add((Component)this.classChooser, constraints);
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            this.botManagerService.reloadDialogProcessingClasses();
            this.wrapperList = this.botManagerService.getDialogProcessingClasses();
            this.buildList((JList<BGUListItem>)this.dialogProcessingList.getList(), this.wrapperList, this.dialogProcessingList.getSelectedElements());
        });
    }

    private void buildList(JList<BGUListItem> jList, List<DialogProcessingWrapper> wrappers, List<BGUListItem> selectedItems) {
        if (jList == null) {
            return;
        }
        List selectedClasses = selectedItems.stream().filter(listItem -> listItem.getAttribute("class") != null).map(listItem -> (String)listItem.getAttribute("class")).collect(Collectors.toList());
        DefaultListModel<BGUListItem> model = new DefaultListModel<BGUListItem>();
        for (DialogProcessingWrapper wrapper : wrappers) {
            String itemName = wrapper.getTitle();
            BGUListItem listItem2 = new BGUListItem(wrapper.getId(), itemName, false);
            String pathToImplClass = wrapper.getPathToImplClass();
            listItem2.setAttribute("class", (Object)pathToImplClass);
            if (selectedClasses.contains(pathToImplClass)) {
                listItem2.setSelected(true);
            }
            model.addElement(listItem2);
        }
        jList.setModel(model);
    }

    protected void setProcessingClass(BotDialog dialog) {
        List items = this.dialogProcessingList.getList().getData();
        items.forEach(a -> a.setSelected(false));
        if (dialog != null) {
            String processingClass = dialog.getProcessingClass();
            if (Utils.isBlankString((String)processingClass)) {
                return;
            }
            for (BGUListItem listItem : items) {
                Object o = listItem.getAttribute("class");
                if (o == null || !o.toString().equals(processingClass)) continue;
                listItem.setSelected(true);
                this.classChooser.setSelectedItem(o.toString());
                return;
            }
        }
    }

    protected String getSelectedPathToProcessingClass() {
        BGUListItem selectedElement;
        List elements = this.dialogProcessingList.getSelectedElements();
        BGUListItem bGUListItem = selectedElement = elements.size() > 0 ? (BGUListItem)elements.get(0) : null;
        if (selectedElement != null) {
            Object o = selectedElement.getAttribute("class");
            return o == null ? "" : o.toString();
        }
        return "";
    }
}

