/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client.bean;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGCalendarButton;
import ru.bitel.bgbilling.client.common.BGControlPanelMonth;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGToggleButton;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.field.BGIntTextField;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.bill.client.bean.BGBillTablePos;
import ru.bitel.bgbilling.modules.bill.client.bean.BillPositionsEditorTab;
import ru.bitel.bgbilling.modules.bill.client.bean.BillTableRow;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class BillPositionsEditor
extends BGPanel {
    private static final String MODE_INVOICE = "invoice";
    private static final String MODE_BILL = "bill";
    private static final String EXT_PARAMETER_PAY_DOC = "payDoc";
    private static final String EXT_PARAMETER_CORRECTION = "correction";
    private static final String EXT_PARAMETER_PAYMENT_DOCUMENT = "paymentDocument";
    private static final String EXT_PARAMETER_PAYMENT_DOCUMENT_FROM_DATE = "paymentDocumentFromDate";
    private static final String EXT_PARAMETER_IDENTIFIER_GOVERMENT_CONTRACT = "identifierGovermentContract";
    private static final String EXT_PARAMETER_SHIPMENT_DOCUMENT = "shipmentDocument";
    private String mode = "bill";
    private BGPanel parent;
    private ActionListener actionListener;
    private BGDialogToolBar toolBar = new BGDialogToolBar();
    private BGIntTextField number;
    private BGIntTextField numberInYear;
    private BGIntTextField numberInMonth;
    private JPanel numberPanel;
    private BGControlPanelMonth monthPanel = new BGControlPanelMonth(BorderFactory.createEmptyBorder());
    private BGCalendarButton calendarButton;
    private List<IdTitle> listTabData = new ArrayList<IdTitle>();
    private BGUList<IdTitle> listTab = new BGUList();
    private CardLayout cardLayout = new CardLayout();
    private JPanel tabbedPane = new JPanel(this.cardLayout);
    private Node positionList;
    private BillPositionsEditorTab mainTab;
    private JPanel positionsPanel = new JPanel(new GridBagLayout());
    private BGTableModel<Element> tableModel;
    private String currentId;
    private BGToggleButton exToggleButton;
    private JPanel extParameterPanel = null;
    private BGUTable extParameterTable = null;
    private ExtParameterTableModel extParameterTableModel = null;
    private long numberVal;
    private long numberInYearVal;
    private long numberInMonthVal;
    private int mm;
    private int yy;
    private Calendar dateVal;

    public BillPositionsEditor(BGPanel parent, ActionListener actionListener) {
        this(parent, actionListener, false, MODE_BILL, null);
    }

    public BillPositionsEditor(BGPanel parent, ActionListener actionListener, boolean showNumberPanel, String mode, BGTableModel<Element> tableModel) {
        this.mode = mode;
        this.parent = parent;
        this.actionListener = actionListener;
        this.tableModel = tableModel;
        this.tryCall(() -> this.jbInit(showNumberPanel));
    }

    private void jbInit(boolean showNumberPanel) {
        if (this.actionListener == null) {
            BillPositionsEditor editor = this;
            this.actionListener = e -> {
                String cmd = e.getActionCommand();
                if ("refresh".equals(cmd)) {
                    editor.reloadPos((BillTableRow)null, this.getBillPosList(this.currentId));
                }
            };
        }
        this.listTabData = Arrays.asList(new IdTitle(0, "\u041f\u043e\u0437\u0438\u0446\u0438\u0438"));
        this.listTab.setData(this.listTabData);
        this.mainTab = new BillPositionsEditorTab(this.actionListener);
        this.tabbedPane.add((Component)((Object)this.mainTab), String.valueOf(((IdTitle)this.listTab.getModel().getElementAt(0)).getId()));
        this.listTab.setSelectionMode(0);
        this.listTab.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                IdTitle idTitle = (IdTitle)this.listTab.getSelectedValue();
                this.toolBar.setEnabled(idTitle != null);
                this.getCurrentTab().setEnabled(idTitle != null);
                if (idTitle != null) {
                    this.cardLayout.show(this.tabbedPane, String.valueOf(idTitle.getId()));
                }
            }
        });
        this.listTab.setSelectedIndex(0);
        ActionListener posListener = e -> this.posAction(e.getActionCommand());
        this.toolBar.setDefaultButtons(posListener);
        this.toolBar.setToolBar(new String[]{"newItem", "editItem", "deleteItem", "separator", "refresh"});
        this.toolBar.setFloatable(false);
        this.toolBar.setOrientation(1);
        int leftInset = 15;
        int bottomInset = 3;
        this.numberPanel = new JPanel(new GridBagLayout());
        JPanel extPanel = new JPanel(new GridBagLayout());
        if (showNumberPanel) {
            this.number = new BGIntTextField();
            this.numberInYear = new BGIntTextField();
            this.numberInMonth = new BGIntTextField();
            this.calendarButton = new BGCalendarButton();
            this.number.setColumns(8);
            this.numberInMonth.setColumns(8);
            this.numberInYear.setColumns(8);
            this.number.setMinValue(0L);
            this.numberInMonth.setMinValue(0L);
            this.numberInMonth.setMinValue(0L);
            this.exToggleButton = new BGToggleButton("\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b...");
            this.exToggleButton.addActionListener(event -> {
                BGToggleButton bgToggleButton = (BGToggleButton)event.getSource();
                if (this.extParameterPanel != null) {
                    this.extParameterPanel.setVisible(bgToggleButton.isSelected());
                }
            });
            int gridx = 0;
            this.numberPanel.add((Component)new JLabel("\u041d\u043e\u043c\u0435\u0440:"), new GridBagConstraints(gridx, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, leftInset, bottomInset, 5), 0, 0));
            this.numberPanel.add((Component)this.number, new GridBagConstraints(gridx++, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, leftInset, bottomInset, 0), 0, 0));
            this.numberPanel.add((Component)new JLabel("\u041d\u043e\u043c\u0435\u0440 (\u0433\u043e\u0434):"), new GridBagConstraints(gridx, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, leftInset, bottomInset, 5), 0, 0));
            this.numberPanel.add((Component)this.numberInYear, new GridBagConstraints(gridx++, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, leftInset, bottomInset, 0), 0, 0));
            this.numberPanel.add((Component)new JLabel("\u041d\u043e\u043c\u0435\u0440 (\u043c\u0435\u0441\u044f\u0446):"), new GridBagConstraints(gridx, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, leftInset, bottomInset, 5), 0, 0));
            this.numberPanel.add((Component)this.numberInMonth, new GridBagConstraints(gridx++, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, leftInset, bottomInset, 0), 0, 0));
            this.numberPanel.add((Component)new JLabel("\u0414\u0430\u0442\u0430 \u0432\u044b\u043f\u0438\u0441\u043a\u0438:"), new GridBagConstraints(gridx, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, leftInset, bottomInset, 5), 0, 0));
            this.numberPanel.add((Component)this.calendarButton, new GridBagConstraints(gridx++, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, leftInset, bottomInset, 0), 0, 0));
            this.numberPanel.add((Component)new JLabel("\u0417\u0430 \u043c\u0435\u0441\u044f\u0446:"), new GridBagConstraints(gridx, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, leftInset, bottomInset, 5), 0, 0));
            this.numberPanel.add((Component)this.monthPanel, new GridBagConstraints(gridx++, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, leftInset, bottomInset, 0), 0, 0));
            this.numberPanel.add((Component)this.exToggleButton, new GridBagConstraints(gridx++, 0, 1, 2, 0.0, 0.0, 15, 2, new Insets(0, leftInset, bottomInset, 0), 0, 0));
            this.numberPanel.add((Component)extPanel, new GridBagConstraints(gridx++, 0, 1, 2, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.numberPanel.add(Box.createHorizontalGlue(), new GridBagConstraints(gridx, 0, 1, 2, 1.0, 0.0, 17, 1, new Insets(0, leftInset, bottomInset, 0), 0, 0));
        }
        BGButton accept = new BGButton("\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c", "ok");
        accept.addActionListener(e -> this.stopEdit(true));
        BGButton cancel = new BGButton("\u041e\u0442\u043c\u0435\u043d\u0438\u0442\u044c", "cancel");
        cancel.addActionListener(e -> this.stopEdit(false));
        this.positionsPanel.add((Component)((Object)this), new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 13, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.positionsPanel.add((Component)accept, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.positionsPanel.add((Component)cancel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.positionsPanel.setVisible(false);
        this.setLayout(new GridBagLayout());
        this.setMinimumSize(new Dimension(100, 250));
        this.add(this.numberPanel, new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(BGSwingUtilites.wrapScrollPane(this.listTab, (int)180, (int)100), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.toolBar, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.add(this.tabbedPane, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.add(this.getExtPanel(), new GridBagConstraints(3, 1, 1, 1, 0.0, 1.0, 18, 1, new Insets(5, 0, 5, 5), 0, 0));
    }

    private JPanel getExtPanel() {
        this.extParameterTableModel = new ExtParameterTableModel();
        this.extParameterTable = new BGUTable((TableModel)((Object)this.extParameterTableModel));
        ArrayList<ExtParameter> data = new ArrayList<ExtParameter>();
        if (MODE_INVOICE.equals(this.mode)) {
            data.add(new ExtParameter(this, EXT_PARAMETER_CORRECTION, "\u0418\u0441\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435"));
            data.add(new ExtParameter(this, EXT_PARAMETER_PAYMENT_DOCUMENT, "\u041d\u043e\u043c\u0435\u0440 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u043e-\u0440\u0430\u0441\u0447\u0435\u0442\u043d\u043e\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430"));
            data.add(new ExtParameter(this, EXT_PARAMETER_PAYMENT_DOCUMENT_FROM_DATE, "\u0414\u0430\u0442\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u043e-\u0440\u0430\u0441\u0447\u0435\u0442\u043d\u043e\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 (\u0414\u0414.\u041c\u041c.\u0413\u0413\u0413\u0413)"));
            data.add(new ExtParameter(this, EXT_PARAMETER_IDENTIFIER_GOVERMENT_CONTRACT, "\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u0430, \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 (\u0441\u043e\u0433\u043b\u0430\u0448\u0435\u043d\u0438\u044f)"));
            data.add(new ExtParameter(this, EXT_PARAMETER_SHIPMENT_DOCUMENT, "\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043e\u0431 \u043e\u0442\u0433\u0440\u0443\u0437\u043a\u0435 \u2116 \u043f/\u043f"));
        }
        this.extParameterTableModel.setData(data);
        this.extParameterPanel = new JPanel(new GridBagLayout());
        this.extParameterPanel.setVisible(false);
        this.extParameterPanel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)this.extParameterTable, (int)700, (int)100), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        return this.extParameterPanel;
    }

    public boolean isNumbersChanged() {
        Calendar date = this.calendarButton.getCalendar();
        return this.numberVal != this.number.getValue() || this.numberInMonthVal != this.numberInMonth.getValue() || this.numberInYearVal != this.numberInYear.getValue() || this.mm != this.monthPanel.getLocalDate().getMonthValue() - 1 || this.yy != this.monthPanel.getLocalDate().getYear() || this.dateVal == null && date != null || this.dateVal != null && date == null || this.dateVal != null && !this.dateVal.equals(date);
    }

    public long getNumber() {
        return this.number.getValue();
    }

    public long getNumberInYear() {
        return this.numberInYear.getValue();
    }

    public long getNumberInMonth() {
        return this.numberInMonth.getValue();
    }

    public String getDate() {
        return this.calendarButton.getText();
    }

    public long getCorrection() {
        return Long.parseLong(this.getExtParameterValue(EXT_PARAMETER_CORRECTION, "0"));
    }

    public String getPaymentDocumentData() {
        return this.getExtParameterValue(EXT_PARAMETER_PAYMENT_DOCUMENT, "") + ":" + this.getExtParameterValue(EXT_PARAMETER_PAYMENT_DOCUMENT_FROM_DATE, "");
    }

    public String getIdentifierGovermentContract() {
        return this.getExtParameterValue(EXT_PARAMETER_IDENTIFIER_GOVERMENT_CONTRACT, "");
    }

    public String getShipmentDocument() {
        return this.getExtParameterValue(EXT_PARAMETER_SHIPMENT_DOCUMENT, "");
    }

    private String getExtParameterValue(String name, String defaultValue) {
        String value = defaultValue;
        for (ExtParameter extParameter : this.extParameterTableModel.getRows()) {
            if (!name.equals(extParameter.getName())) continue;
            value = extParameter.getValue();
            break;
        }
        return value;
    }

    private void setExtParameterValue(String name, String value) {
        for (ExtParameter extParameter : this.extParameterTableModel.getRows()) {
            if (!name.equals(extParameter.getName())) continue;
            extParameter.setValue(value);
            break;
        }
    }

    public void reloadPos(List<BGBillTablePos> posList, Element docElement) {
        this.tryCall(() -> {
            this.number.setText(docElement.getAttribute("number"));
            this.numberInMonth.setText(docElement.getAttribute("number_in_month"));
            this.numberInYear.setText(docElement.getAttribute("number_in_year"));
            this.calendarButton.setText(docElement.getAttribute("date"));
            this.setExtParameterValue(EXT_PARAMETER_IDENTIFIER_GOVERMENT_CONTRACT, XMLUtils.getAttribute((Element)docElement, (String)EXT_PARAMETER_IDENTIFIER_GOVERMENT_CONTRACT, (String)""));
            if (this.mode.equals(MODE_INVOICE)) {
                this.setExtParameterValue(EXT_PARAMETER_CORRECTION, XMLUtils.getAttribute((Element)docElement, (String)EXT_PARAMETER_CORRECTION, (String)"0"));
                this.setExtParameterValue(EXT_PARAMETER_PAYMENT_DOCUMENT, XMLUtils.getAttribute((Element)docElement, (String)EXT_PARAMETER_PAYMENT_DOCUMENT, (String)XMLUtils.getAttribute((Element)docElement, (String)EXT_PARAMETER_PAY_DOC, (String)"")));
                this.setExtParameterValue(EXT_PARAMETER_PAYMENT_DOCUMENT_FROM_DATE, XMLUtils.getAttribute((Element)docElement, (String)EXT_PARAMETER_PAYMENT_DOCUMENT_FROM_DATE, (String)XMLUtils.getAttribute((Element)docElement, (String)"payDocDate", (String)"")));
                this.setExtParameterValue(EXT_PARAMETER_SHIPMENT_DOCUMENT, XMLUtils.getAttribute((Element)docElement, (String)EXT_PARAMETER_SHIPMENT_DOCUMENT, (String)""));
            }
            this.numberVal = this.number.getValue();
            this.numberInMonthVal = this.numberInMonth.getValue();
            this.numberInYearVal = this.numberInYear.getValue();
            this.dateVal = this.calendarButton.getCalendar();
            this.mm = this.monthPanel.getLocalDate().getMonthValue() - 1;
            this.yy = this.monthPanel.getLocalDate().getYear();
            this.reloadPos((BillTableRow)null, docElement);
        });
    }

    public void reloadPos(BillTableRow currentRow, Element bill) {
        this.tryCall(() -> {
            int tabCount = this.tabbedPane.getComponentCount();
            while (tabCount-- > 1) {
                this.tabbedPane.remove(tabCount);
            }
            BigDecimal billSumm = BigDecimal.ZERO;
            ArrayList<BGBillTablePos> posList = new ArrayList<BGBillTablePos>();
            if (currentRow != null) {
                currentRow.positionList = posList;
            }
            for (Element item : XMLUtils.selectElements((Node)bill, (String)"pos")) {
                BGBillTablePos pos = new BGBillTablePos();
                pos.fromElement(item);
                posList.add(pos);
                billSumm = billSumm.add(pos.getSum());
            }
            this.mainTab.showPositions(posList);
            this.listTabData = new ArrayList<IdTitle>();
            this.listTabData.add(new IdTitle(0, bill.getAttribute("contract")));
            this.listTab.setData(this.listTabData);
            this.listTab.setSelectedIndex(0);
            HashMap<Integer, BillTableRow> subBillMap = null;
            if (currentRow != null && currentRow.subBillList != null) {
                subBillMap = new HashMap<Integer, BillTableRow>();
                for (BillTableRow r : currentRow.subBillList) {
                    subBillMap.put(r.cid, r);
                }
            }
            for (Element subBill : XMLUtils.selectElements((Node)bill, (String)"sub_bill")) {
                posList = new ArrayList();
                if (subBillMap != null) {
                    ((BillTableRow)subBillMap.get((Object)Integer.valueOf((int)Utils.parseInt((String)subBill.getAttribute((String)"cid"))))).positionList = posList;
                }
                for (Element item : XMLUtils.selectElements((Node)subBill, (String)"pos")) {
                    BGBillTablePos pos = new BGBillTablePos();
                    pos.fromElement(item);
                    posList.add(pos);
                    billSumm = billSumm.add(pos.getSum());
                }
                BillPositionsEditorTab tab = new BillPositionsEditorTab(this.actionListener);
                tab.setContractId(Utils.parseInt((String)subBill.getAttribute("cid")));
                tab.setPositionList(this.positionList);
                tab.showPositions(posList);
                int index = this.listTabData.size();
                this.listTabData.add(new IdTitle(index, subBill.getAttribute("contract")));
                this.listTab.setData(this.listTabData);
                this.tabbedPane.add((Component)((Object)tab), String.valueOf(index));
            }
            this.actionListener.actionPerformed(new ActionEvent(Utils.formatBigDecimalSumm((BigDecimal)billSumm), 0, "reloadPos"));
        });
    }

    private BillPositionsEditorTab getCurrentTab() {
        BillPositionsEditorTab billPositionsEditorTab = null;
        for (Component component : this.tabbedPane.getComponents()) {
            if (!component.isVisible() || !(component instanceof BillPositionsEditorTab)) continue;
            billPositionsEditorTab = (BillPositionsEditorTab)((Object)component);
            break;
        }
        return billPositionsEditorTab;
    }

    private void posAction(String command) {
        this.getCurrentTab().posAction(command);
    }

    public void showPositions(BillTableRow bill) {
        this.listTabData = Arrays.asList(new IdTitle(0, "???"));
        int tabCount = this.tabbedPane.getComponentCount();
        while (tabCount-- > 1) {
            this.tabbedPane.remove(tabCount);
        }
        if (bill != null) {
            this.mainTab.showPositions(bill.positionList);
            this.listTabData = new ArrayList<IdTitle>();
            this.listTabData.add(new IdTitle(0, bill.contract));
            if (bill.subBillList != null) {
                for (BillTableRow subBill : bill.subBillList) {
                    BillPositionsEditorTab tab = new BillPositionsEditorTab(this.actionListener);
                    tab.setPositionList(this.positionList);
                    tab.showPositions(subBill.positionList);
                    int index = this.listTabData.size();
                    this.listTabData.add(new IdTitle(index, subBill.contract));
                    this.tabbedPane.add((Component)((Object)tab), String.valueOf(index));
                }
            }
        } else {
            this.mainTab.showPositions(null);
            this.listTabData = Arrays.asList(new IdTitle(0, "\u041f\u043e\u0437\u0438\u0446\u0438\u0438"));
        }
        this.listTab.setData(this.listTabData);
        this.listTab.setSelectedIndex(0);
    }

    public String serializePositions() throws Exception {
        Document doc = XMLUtils.newDocument();
        Element positions = doc.createElement("positions");
        doc.appendChild(positions);
        this.mainTab.serializePositions(positions);
        for (int tabCount = 1; tabCount < this.tabbedPane.getComponentCount(); ++tabCount) {
            BillPositionsEditorTab tab = (BillPositionsEditorTab)((Object)this.tabbedPane.getComponent(tabCount));
            Element subBill = doc.createElement("sub_bill");
            subBill.setAttribute("cid", String.valueOf(tab.getContractId()));
            tab.serializePositions(subBill);
            positions.appendChild(subBill);
        }
        return XMLUtils.serializeToString((Node)doc, (boolean)false);
    }

    public void hideExtParameterPanel() {
        this.exToggleButton.setSelected(false);
        this.extParameterPanel.setVisible(false);
    }

    public void setPositionList(Node node) {
        this.positionList = node;
        this.mainTab.setPositionList(node);
    }

    private Element getBillPosList(String currentId) {
        Element result = null;
        Request request = new Request().setAction(MODE_BILL.equals(this.mode) ? "GetBill" : "GetInvoice").setAttribute("id", currentId).setModule(this.module).setModuleId(this.getModuleId());
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            result = XMLUtils.getElement((Document)doc, (String)MODE_BILL);
        }
        return result;
    }

    public void editItem() {
        Element rowElement = (Element)this.tableModel.getSelectedRow();
        if (rowElement == null) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
        } else {
            this.hideExtParameterPanel();
            this.positionsPanel.setVisible(true);
            this.currentId = rowElement.getAttribute("id");
            this.startEdit();
        }
    }

    private void startEdit() {
        Element list = this.getBillPosList(this.currentId);
        this.monthPanel.setLocalDate(LocalDate.of(Utils.parseInt((String)list.getAttribute("yy")), Utils.parseInt((String)list.getAttribute("mm")) + 1, 1));
        this.reloadPos(new ArrayList<BGBillTablePos>(), list);
    }

    private void stopEdit(boolean save) {
        this.tryCall(() -> this._stopEdit(save));
    }

    private void _stopEdit(boolean save) throws BGException {
        if (save) {
            this.tryCall(() -> {
                Document doc;
                Request request;
                if (this.isNumbersChanged()) {
                    request = new Request().setModule(this.module).setModuleId(this.getModuleId()).setAction(MODE_BILL.equals(this.mode) ? "BillUpdatePositions" : "InvoiceUpdatePositions").setAttribute("id", this.currentId).setAttribute("mode", "updateNumber").setAttribute("number", String.valueOf(this.getNumber())).setAttribute("number_in_year", String.valueOf(this.getNumberInYear())).setAttribute("number_in_month", String.valueOf(this.getNumberInMonth())).setAttribute("date", this.getDate()).setAttribute("mm", this.monthPanel.getLocalDate().getMonthValue() - 1).setAttribute("yy", this.monthPanel.getLocalDate().getYear());
                    if (MODE_INVOICE.equals(this.mode)) {
                        request.setAttribute(EXT_PARAMETER_CORRECTION, this.getCorrection());
                        request.setAttribute(EXT_PARAMETER_PAY_DOC, this.getPaymentDocumentData());
                        request.setAttribute(EXT_PARAMETER_IDENTIFIER_GOVERMENT_CONTRACT, this.getIdentifierGovermentContract());
                        request.setAttribute(EXT_PARAMETER_SHIPMENT_DOCUMENT, this.getShipmentDocument());
                    }
                    if (!ClientUtils.checkStatus((Document)(doc = this.getDocument(request)))) {
                        return;
                    }
                }
                request = new Request().setModule(this.module).setModuleId(this.getModuleId()).setAction(MODE_BILL.equals(this.mode) ? "BillUpdatePositions" : "InvoiceUpdatePositions").setAttribute("id", this.currentId).setAttribute("positions", this.serializePositions());
                if (MODE_INVOICE.equals(this.mode)) {
                    request.setAttribute(EXT_PARAMETER_CORRECTION, this.getCorrection()).setAttribute(EXT_PARAMETER_PAY_DOC, this.getPaymentDocumentData()).setAttribute(EXT_PARAMETER_IDENTIFIER_GOVERMENT_CONTRACT, this.getIdentifierGovermentContract()).setAttribute(EXT_PARAMETER_SHIPMENT_DOCUMENT, this.getShipmentDocument());
                }
                if (ClientUtils.checkStatus((Document)(doc = this.getDocument(request)))) {
                    this.positionsPanel.setVisible(false);
                    this.parent.trySetData();
                }
            });
        } else {
            this.positionsPanel.setVisible(false);
        }
    }

    public JPanel getPositionsPanel() {
        return this.positionsPanel;
    }

    class ExtParameterTableModel
    extends BGTableModel<ExtParameter> {
        public ExtParameterTableModel() {
            super(ExtParameterTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440", 300, 400, 500, "title", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", 100, -1, -1, "value", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            String identifier = this.getIdentifier(columnIndex);
            return "value".equals(identifier) ? true : super.isCellEditable(rowIndex, columnIndex);
        }

        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (value instanceof String) {
                String val = (String)value;
                this.optSelectedRow().ifPresent(a -> a.setValue(val));
            }
        }
    }

    public class ExtParameter {
        private String name;
        private String title;
        private String value;

        public ExtParameter(BillPositionsEditor this$0, String name, String title) {
            this.name = name;
            this.title = title;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

