/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client.accounts;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.time.LocalDate;
import java.util.Optional;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGControlPanelDateNoB;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGSummaTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.table.client.BGDataSourceTableModel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGDialog;
import ru.bitel.common.client.BGSwingUtilites;

public class BillAccountsReceivablePanel
extends BGUPanel {
    private JLabel countLabel = new JLabel();
    private BGControlPanelPages panelPages = new BGControlPanelPages();
    private BGControlPanelDateNoB onDate = new BGControlPanelDateNoB();
    private BGDataSourceTableModel tableModel = new BGDataSourceTableModel("BillAccountsReceivable");
    private BGSummaTextField totalSum = new BGSummaTextField();

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(this.getTopPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 3, 0, 3), 0, 0));
        this.add(this.getTablePanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 3, 3, 3), 0, 0));
        this.add(this.getBottomPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 3, 3, 3), 0, 0));
    }

    private JPanel getTopPanel() {
        JButton nowButton = new JButton("\u043d\u0430 \u0441\u0435\u0433\u043e\u0434\u043d\u044f");
        nowButton.addActionListener(e -> this.onDate.setLocalDate(LocalDate.now()));
        JButton doButton = new JButton("\u0432\u044b\u0432\u0435\u0441\u0442\u0438");
        doButton.addActionListener(e -> {
            if (this.onDate.getLocalDate() == null) {
                ClientUtils.showMessageDialog((Object)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0434\u0430\u0442\u0443");
                return;
            }
            this.panelPages.reset();
            this.performAction("refresh");
        });
        this.panelPages.addPropertyChangeListener(e -> {
            if (e.getPropertyName().startsWith("to")) {
                this.performAction("refresh");
            }
        });
        this.onDate.setLocalDate(LocalDate.now());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041d\u0430 \u0434\u0430\u0442\u0443:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.onDate, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)nowButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)doButton, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.countLabel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.panelPages, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 15, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getTablePanel() {
        BGUTable table = new BGUTable((TableModel)this.tableModel);
        table.setSelectionMode(0);
        BGSwingUtilites.handleRMouseClicked((Component)table, e -> this.showTablePopupMenu((MouseEvent)e, (JTable)table, this.getPopupMenu()));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JScrollPane((Component)table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getBottomPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0418\u0442\u043e\u0433\u043e:"), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.totalSum, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    protected void getPopupMenuItems() {
        this.popupMenu.add("\u0414\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f").addActionListener(e -> this.showDetail());
        this.popupMenu.addSeparator();
        this.popupMenu.add("\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0434\u043e\u0433\u043e\u0432\u043e\u0440").addActionListener(e -> this.openContract());
    }

    private void showDetail() {
        new BillAccountsReceivableDialog((ClientContext)this.getContext()).showDialog();
    }

    private void openContract() {
        this.tableModel.optSelectedRow().ifPresent(a -> a.optValue("contractId").ifPresent(contractId -> BGClientBase.getFrame().getTabbedPane().addContractEditorTab(Utils.parseInt((String)contractId))));
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            BGUTableParams tableParams = new BGUTableParams().setPage(this.panelPages.getPage());
            Optional.ofNullable(this.onDate.getLocalDate()).ifPresent(a -> tableParams.addParam("onDate", a.toString()));
            this.tableModel.loadData((ClientContext)this.getContext(), tableParams, this.panelPages, this.countLabel);
            this.totalSum.setText(this.tableModel.getAttribute("totalSum"));
        });
    }

    class BillAccountsReceivableDialog
    extends BGDialog {
        private BGDataSourceTableModel tableModel;

        public BillAccountsReceivableDialog(ClientContext context) {
            super(context);
            this.tableModel = new BGDataSourceTableModel("BillAccountsReceivableDetail");
            this.setTitle("\u0414\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f");
            this.setDefaultCloseOperation(2);
            this.panel.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)this.getTable(), (int)1000, (int)600), new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.pack();
            this.moveWindowToCenterScreen();
        }

        private BGUTable getTable() {
            BGUTable table = new BGUTable((TableModel)this.tableModel);
            return table;
        }
    }
}

