/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeInfo;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeSet;
import ru.bitel.bgbilling.kernel.network.radius.RadiusDictionary;
import ru.bitel.bgbilling.kernel.network.tlv.Tlv;
import ru.bitel.common.Utils;

public class MSUtils {
    private static final Logger logger = LogManager.getLogger();
    public static final int MS_chap_response = 1;
    public static final int MS_chap_error = 2;
    public static final int MS_chap_cpw_1 = 3;
    public static final int MS_chap_cpw_2 = 4;
    public static final int MS_chap_lm_enc_pw = 5;
    public static final int MS_chap_nt_enc_pw = 6;
    public static final int MS_mppe_encryption_policy = 7;
    public static final int MS_mppe_encryption_types = 8;
    public static final int MS_ras_vendor = 9;
    public static final int MS_chap_domain = 10;
    public static final int MS_chap_challenge = 11;
    public static final int MS_chap_mppe_keys = 12;
    public static final int MS_bap_usage = 13;
    public static final int MS_link_utilization_threshold = 14;
    public static final int MS_link_drop_time_limit = 15;
    public static final int MS_mppe_send_key = 16;
    public static final int MS_mppe_recv_key = 17;
    public static final int MS_old_arap_password = 18;
    public static final int MS_ras_version = 19;
    public static final int MS_new_arap_password = 20;
    public static final int MS_arap_password_change_reason = 21;
    public static final int MS_filter = 22;
    public static final int MS_acct_auth_type = 23;
    public static final int MS_acct_eap_type = 24;
    public static final int MS_chap2_response = 25;
    public static final int MS_chap2_success = 26;
    public static final int MS_chap2_cpw = 27;
    public static final int MS_primary_dns_server = 28;
    public static final int MS_secondary_dns_server = 29;
    public static final int MS_primary_nbns_server = 30;
    public static final int MS_secondary_nbns_server = 31;
    public static final int MS_arap_challenge = 33;
    public static final int MS_framed_encryption_type = 200;
    private static final byte[] magic1 = new byte[]{84, 104, 105, 115, 32, 105, 115, 32, 116, 104, 101, 32, 77, 80, 80, 69, 32, 77, 97, 115, 116, 101, 114, 32, 75, 101, 121};
    private static final byte[] magic2 = new byte[]{79, 110, 32, 116, 104, 101, 32, 99, 108, 105, 101, 110, 116, 32, 115, 105, 100, 101, 44, 32, 116, 104, 105, 115, 32, 105, 115, 32, 116, 104, 101, 32, 115, 101, 110, 100, 32, 107, 101, 121, 59, 32, 111, 110, 32, 116, 104, 101, 32, 115, 101, 114, 118, 101, 114, 32, 115, 105, 100, 101, 44, 32, 105, 116, 32, 105, 115, 32, 116, 104, 101, 32, 114, 101, 99, 101, 105, 118, 101, 32, 107, 101, 121, 46};
    private static final byte[] magic3 = new byte[]{79, 110, 32, 116, 104, 101, 32, 99, 108, 105, 101, 110, 116, 32, 115, 105, 100, 101, 44, 32, 116, 104, 105, 115, 32, 105, 115, 32, 116, 104, 101, 32, 114, 101, 99, 101, 105, 118, 101, 32, 107, 101, 121, 59, 32, 111, 110, 32, 116, 104, 101, 32, 115, 101, 114, 118, 101, 114, 32, 115, 105, 100, 101, 44, 32, 105, 116, 32, 105, 115, 32, 116, 104, 101, 32, 115, 101, 110, 100, 32, 107, 101, 121, 46};
    private static final byte[] SHSpad1 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] SHSpad2 = new byte[]{-14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14, -14};
    private static final Random RANDOM = new Random();

    private static byte[] NTPasswordHash(byte[] userPassword) throws NoSuchAlgorithmException {
        MessageDigest md = Utils.newMD4();
        md.update(userPassword);
        byte[] passwordHash = md.digest();
        return passwordHash;
    }

    private static byte[] challengeHash(byte[] authenticatorChallenge, byte[] peerChallenge, byte[] userName) throws NoSuchAlgorithmException {
        byte[] challengeHash = new byte[8];
        MessageDigest md = MessageDigest.getInstance("SHA");
        md.update(peerChallenge);
        md.update(authenticatorChallenge);
        md.update(userName);
        System.arraycopy(md.digest(), 0, challengeHash, 0, 8);
        return challengeHash;
    }

    private static String generateAuthenticatorResponse(byte[] authenticatorChallenge, byte[] peerChallenge, byte[] userName, byte[] userPassword, byte[] ntResponse, String message) throws Exception {
        byte[] passwordHash = MSUtils.NTPasswordHash(userPassword);
        byte[] passwordHashHash = MSUtils.NTPasswordHash(passwordHash);
        byte[] Magic1 = new byte[]{77, 97, 103, 105, 99, 32, 115, 101, 114, 118, 101, 114, 32, 116, 111, 32, 99, 108, 105, 101, 110, 116, 32, 115, 105, 103, 110, 105, 110, 103, 32, 99, 111, 110, 115, 116, 97, 110, 116};
        byte[] Magic2 = new byte[]{80, 97, 100, 32, 116, 111, 32, 109, 97, 107, 101, 32, 105, 116, 32, 100, 111, 32, 109, 111, 114, 101, 32, 116, 104, 97, 110, 32, 111, 110, 101, 32, 105, 116, 101, 114, 97, 116, 105, 111, 110};
        MessageDigest md = MessageDigest.getInstance("SHA");
        md.update(passwordHashHash);
        md.update(ntResponse);
        md.update(Magic1);
        byte[] digest = md.digest();
        byte[] challenge = MSUtils.challengeHash(authenticatorChallenge, peerChallenge, userName);
        md.reset();
        md.update(digest);
        md.update(challenge);
        md.update(Magic2);
        digest = md.digest();
        StringBuilder result = new StringBuilder();
        result.append("S=");
        result.append(Utils.bytesToString((byte[])digest).replaceAll(" ", ""));
        if (message != null) {
            result.append(" M=");
            result.append(message);
        }
        return result.toString();
    }

    private static byte[] generateNTResponse(byte[] authenticatorChallenge, byte[] peerChallenge, byte[] userName, byte[] userPassword) {
        byte[] response = new byte[24];
        try {
            byte[] challengeHash = MSUtils.challengeHash(authenticatorChallenge, peerChallenge, userName);
            byte[] passwordHash = MSUtils.NTPasswordHash(userPassword);
            byte[] z_passwordHash = new byte[21];
            for (int i = 0; i < z_passwordHash.length; ++i) {
                z_passwordHash[i] = i < passwordHash.length ? passwordHash[i] : (byte)0;
            }
            byte[] DES_Key = new byte[7];
            System.arraycopy(z_passwordHash, 0, DES_Key, 0, 7);
            byte[] auth_1 = MSUtils.DES_Encrypt(challengeHash, DES_Key);
            System.arraycopy(z_passwordHash, 7, DES_Key, 0, 7);
            byte[] auth_2 = MSUtils.DES_Encrypt(challengeHash, DES_Key);
            System.arraycopy(z_passwordHash, 14, DES_Key, 0, 7);
            byte[] auth_3 = MSUtils.DES_Encrypt(challengeHash, DES_Key);
            System.arraycopy(auth_1, 0, response, 0, 8);
            System.arraycopy(auth_2, 0, response, 8, 8);
            System.arraycopy(auth_3, 0, response, 16, 8);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return response;
    }

    private static byte[] addParity(byte[] in) {
        byte[] result = new byte[8];
        int resultIx = 1;
        int bitCount = 0;
        for (int i = 0; i < 56; ++i) {
            boolean bit;
            boolean bl = bit = (in[6 - i / 8] & 1 << i % 8) > 0;
            if (bit) {
                int n = 7 - resultIx / 8;
                result[n] = (byte)(result[n] | 1 << resultIx % 8 & 0xFF);
                ++bitCount;
            }
            if ((i + 1) % 7 == 0) {
                if (bitCount % 2 == 0) {
                    int n = 7 - resultIx / 8;
                    result[n] = (byte)(result[n] | 1);
                }
                ++resultIx;
                bitCount = 0;
            }
            ++resultIx;
        }
        return result;
    }

    private static byte[] DES_Encrypt(byte[] clear, byte[] key) throws Exception {
        byte[] result = new byte[8];
        if (clear.length != 8 || key.length != 7) {
            throw new IllegalArgumentException("DES_Encrypt() params ERROR!");
        }
        byte[] keyNew = MSUtils.addParity(key);
        Cipher ecipher = Cipher.getInstance("DES/ECB/NoPadding");
        ecipher.init(1, new SecretKeySpec(keyNew, "DES"));
        result = ecipher.doFinal(clear);
        return result;
    }

    public static void addMppeKeys(RadiusAttributeSet request, RadiusAttributeSet response, byte[] sendKey, byte[] receiveKey, byte[] secret, byte[] authenticator, boolean addTypesAndPolicy) throws NoSuchAlgorithmException {
        response.setAttribute(new RadiusAttribute(311, 16, ByteBuffer.wrap(MSUtils.cryptMppeKey(sendKey, secret, authenticator))));
        response.setAttribute(new RadiusAttribute(311, 17, ByteBuffer.wrap(MSUtils.cryptMppeKey(receiveKey, secret, authenticator))));
        if (addTypesAndPolicy) {
            byte[] value = new byte[4];
            value[3] = (byte)(value[3] | 4);
            response.setAttribute(new RadiusAttribute(311, 8, ByteBuffer.wrap(value)));
            RadiusAttributeInfo mppeEncryptionPolicyInfo = RadiusDictionary.getAttributeInfo(311, 7);
            if (mppeEncryptionPolicyInfo != null && mppeEncryptionPolicyInfo.valueType == 4) {
                response.setAttribute(new RadiusAttribute<Integer>(311, 7, 0, Integer.valueOf(1)));
            } else {
                response.setAttribute(new RadiusAttribute<byte[]>(311, 7, 0, Utils.convertIntToBytes((int)1)));
            }
        }
    }

    public static byte[] mppeKey(byte[] masterKey, int startKeyLen, boolean isSend, boolean isServer) {
        byte[] magic = isSend ? (isServer ? magic3 : magic2) : (isServer ? magic2 : magic3);
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(masterKey);
            md.update(SHSpad1);
            md.update(magic);
            md.update(SHSpad2);
            byte[] digest = md.digest();
            byte[] key = new byte[startKeyLen];
            System.arraycopy(digest, 0, key, 0, startKeyLen);
            return key;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static byte[] mppeKey(byte[] masterKey, boolean isSend, byte[] requestAuth, byte[] secret) {
        byte[] result = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            md.update(masterKey);
            md.update(SHSpad1);
            if (isSend) {
                md.update(magic3);
            } else {
                md.update(magic2);
            }
            md.update(SHSpad2);
            result = new byte[16];
            System.arraycopy(md.digest(), 0, result, 0, 16);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    public static final byte[] cryptMppeKey(byte[] key, byte[] secret, byte[] requestAuth) {
        int random = RANDOM.nextInt();
        byte[] salt = new byte[]{(byte)(0x80 | random >> 8 & 0xFF), (byte)(random & 0xFF)};
        int authPassLen = 16;
        int len = key.length + 1;
        len += 16 - len % 16;
        byte[] buf = new byte[len];
        buf[0] = (byte)key.length;
        System.arraycopy(key, 0, buf, 1, key.length);
        byte[] b = null;
        byte[] c = null;
        for (int i = 0; i < len; i += 16) {
            if (i == 0) {
                byte[] hashBase = new byte[secret.length + requestAuth.length + salt.length];
                System.arraycopy(secret, 0, hashBase, 0, secret.length);
                System.arraycopy(requestAuth, 0, hashBase, secret.length, requestAuth.length);
                System.arraycopy(salt, 0, hashBase, secret.length + requestAuth.length, salt.length);
                b = Utils.getDigestBytes((byte[])hashBase);
            } else {
                byte[] secretAndC = new byte[secret.length + c.length];
                System.arraycopy(secret, 0, secretAndC, 0, secret.length);
                System.arraycopy(c, 0, secretAndC, secret.length, c.length);
                b = Utils.getDigestBytes((byte[])secretAndC);
            }
            c = new byte[16];
            for (int j = 0; j < 16; ++j) {
                c[j] = (byte)(buf[i + j] ^ b[j]);
            }
            System.arraycopy(c, 0, buf, i, 16);
        }
        byte[] result = new byte[salt.length + buf.length];
        System.arraycopy(salt, 0, result, 0, salt.length);
        System.arraycopy(buf, 0, result, salt.length, buf.length);
        return result;
    }

    public static byte[] checkMSChapV2Password(byte[] challenge, byte[] peerChallenge, byte[] ntResponse, String userName, String userPassword, String welcome) throws UnsupportedEncodingException, Exception {
        if (challenge != null && userName != null) {
            byte[] userNameBytes = userName.getBytes("ISO-8859-1");
            byte[] userPasswBytes = userPassword.getBytes("UTF-16LE");
            byte[] myNtResponse = MSUtils.generateNTResponse(challenge, peerChallenge, userNameBytes, userPasswBytes);
            for (int i = 0; i < myNtResponse.length && i < ntResponse.length; ++i) {
                if (myNtResponse[i] == ntResponse[i]) continue;
                return null;
            }
            return MSUtils.generateAuthenticatorResponse(challenge, peerChallenge, userNameBytes, userPasswBytes, ntResponse, welcome).getBytes("cp1251");
        }
        throw new IllegalArgumentException("Not valid MS Chap v2 request!");
    }

    public static boolean checkMSChapV2Password(RadiusAttributeSet request, RadiusAttributeSet response, String openPassword, byte[] secret, byte[] authenticator, boolean addTypesAndPolicy) {
        return MSUtils.checkMSChapV2Password(request, response, openPassword, secret, authenticator, addTypesAndPolicy, false);
    }

    public static boolean checkMSChapV2Password(RadiusAttributeSet request, RadiusAttributeSet response, String openPassword, byte[] secret, byte[] authenticator, boolean addTypesAndPolicy, boolean ident) {
        Object chapChallenge = request.getAttribute(311, 11);
        Object chapResponse = request.getAttribute(311, 25);
        RadiusAttribute.RadiusAttributeString userNameAttribute = (RadiusAttribute.RadiusAttributeString)request.getAttribute(-1, 1);
        try {
            if (chapResponse != null && userNameAttribute != null) {
                String userName = (String)userNameAttribute.getValue();
                int pos = userName.indexOf(92);
                if (pos >= 0) {
                    userName = userName.substring(pos + 1);
                }
                byte[] responseBytes = ((Tlv)chapResponse).getDataAsByteArray();
                byte[] peerChallenge = new byte[16];
                byte[] ntResponse = new byte[24];
                System.arraycopy(responseBytes, 2, peerChallenge, 0, 16);
                System.arraycopy(responseBytes, 26, ntResponse, 0, 24);
                byte[] challange = ((Tlv)chapChallenge).getDataAsByteArray();
                byte[] authMessage = MSUtils.checkMSChapV2Password(challange, peerChallenge, ntResponse, userName, openPassword, null);
                if (authMessage != null) {
                    byte[] success = new byte[authMessage.length + 1];
                    success[0] = ident ? responseBytes[0] : 63;
                    System.arraycopy(authMessage, 0, success, 1, authMessage.length);
                    response.setAttribute(new RadiusAttribute(311, 26, ByteBuffer.wrap(success)));
                    byte[] userPasswBytes = openPassword.getBytes("UTF-16LE");
                    byte[] passwordHash = MSUtils.NTPasswordHash(userPasswBytes);
                    byte[] passwordHashHash = MSUtils.NTPasswordHash(passwordHash);
                    MessageDigest md = MessageDigest.getInstance("SHA");
                    md.update(passwordHashHash);
                    md.update(ntResponse);
                    md.update(magic1);
                    byte[] masterKey = new byte[16];
                    System.arraycopy(md.digest(), 0, masterKey, 0, 16);
                    byte[] sendKey = MSUtils.mppeKey(masterKey, true, authenticator, secret);
                    byte[] receiveKey = MSUtils.mppeKey(masterKey, false, authenticator, secret);
                    MSUtils.addMppeKeys(request, response, sendKey, receiveKey, secret, authenticator, addTypesAndPolicy);
                    return true;
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

