/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.ws.server;

import bitel.billing.server.admin.bgsecure.bean.UserLoginModule;
import bitel.billing.server.util.FileUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.server.InstanceResolver;
import jakarta.jws.WebMethod;
import jakarta.jws.WebParam;
import jakarta.jws.WebService;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFactory;
import jakarta.xml.soap.SOAPHeader;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.ws.WebServiceContext;
import jakarta.xml.ws.handler.Handler;
import jakarta.xml.ws.handler.MessageContext;
import jakarta.xml.ws.handler.soap.SOAPHandler;
import jakarta.xml.ws.handler.soap.SOAPMessageContext;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.security.auth.Subject;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.BGSQueryLogDao;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.BGSQueryLogEntry;
import ru.bitel.bgbilling.kernel.container.security.server.FindAction;
import ru.bitel.bgbilling.kernel.container.security.server.ModuleAction;
import ru.bitel.bgbilling.kernel.container.security.server.PermissionOfRoles;
import ru.bitel.bgbilling.kernel.container.ws.server.AbstractJaxWsHandler;
import ru.bitel.bgbilling.kernel.container.ws.server.ModuleKey;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.system.ModuleConfigModifiedEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.server.util.ServletUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.io.Base64;

public class JaxWsHandler
extends AbstractJaxWsHandler {
    final String loginContextName;
    final PermissionOfRoles permissionChecker = PermissionOfRoles.getInstance();
    volatile boolean requestCheckAuthorization;
    volatile boolean requestLog;

    public JaxWsHandler(ServletContext context) throws BGException {
        super(context);
        Logger logger = LogManager.getLogger((String)"com.sun.xml.ws.server.sei.EndpointMethodHandler");
        Configurator.setLevel((String)logger.getName(), (Level)Level.OFF);
        System.setProperty("jakarta.xml.soap.SAAJMetaFactory", "com.sun.xml.messaging.saaj.soap.SAAJMetaFactoryImpl");
        this.loginContextName = "1".equals(this.setup.get("bgsecure.jaas.ldap", null)) ? "executer_ldap" : "executer";
        this.requestCheckAuthorization = this.setup.getInt("bgsecure.check", 1) > 0;
        this.requestLog = this.setup.getInt("bgsecure.log", 1) > 0;
        EventProcessor.getInstance().addListener(new EventListener<ModuleConfigModifiedEvent>(){

            @Override
            public void notify(ModuleConfigModifiedEvent e, EventListenerContext ctx) throws BGException {
                JaxWsHandler.this.requestCheckAuthorization = JaxWsHandler.this.setup.getInt("bgsecure.check", 1) > 0;
                JaxWsHandler.this.requestLog = JaxWsHandler.this.setup.getInt("bgsecure.log", 1) > 0;
            }
        }, ModuleConfigModifiedEvent.class);
    }

    @Override
    protected String getUrlPatternName(ModuleKey moduleKey, Class<?> implementorClass) {
        return "/executer/" + moduleKey.module + "/" + (String)(moduleKey.moduleId > 0 ? moduleKey.moduleId + "/" : "") + moduleKey.service;
    }

    @Override
    protected Class<?> findEndpointClass(ModuleKey moduleKey) {
        String dynservice = Setup.getSetup().get("dynservice:" + moduleKey.module + "." + moduleKey.service);
        if (dynservice != null) {
            this.getLogger().debug("load dynservice class for /{}/{}: {}...", new Object[]{moduleKey.module, moduleKey.service, dynservice});
            try {
                return DynamicClassManager.getInstance().loadClass(dynservice);
            }
            catch (Exception ex) {
                this.logError(String.format("error load dynservice class %s", dynservice), ex);
                return null;
            }
        }
        try {
            return this.findEndpointClass(".server.", moduleKey.module, moduleKey.service);
        }
        catch (ClassNotFoundException ex) {
            try {
                return this.findEndpointClass(".server.service.", moduleKey.module, moduleKey.service);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
    }

    /*
     * Loose catch block
     */
    private Class<?> findEndpointClass(String prefix, String module, String service) throws ClassNotFoundException {
        try {
            block5: {
                if (!"kernel".equals(module)) break block5;
                return Class.forName("ru.bitel.bgbilling.kernel.base" + prefix + service + "Impl");
            }
            return Class.forName(module + prefix + service + "Impl");
        }
        catch (ClassNotFoundException e1) {
            return Class.forName("ru.bitel.bgbilling." + module + prefix + service + "Impl");
            {
                catch (ClassNotFoundException e12) {
                    return Class.forName("ru.bitel.oss." + module + prefix + service + "Impl");
                }
            }
        }
    }

    @Override
    protected <T> Object invoke(String module, String mid, Integer userId, InstanceResolver<T> resolver, Class<T> clazz, WebServiceContext wsc, MessageContext mc, Packet p, Method m, Object[] args) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)mc.get((Object)"jakarta.xml.ws.servlet.request");
        HttpSession httpSession = httpServletRequest != null ? httpServletRequest.getSession(false) : null;
        Subject subject = httpSession != null ? (Subject)httpSession.getAttribute("subject") : null;
        Integer n = userId = httpSession != null ? (Integer)httpSession.getAttribute("user_id") : null;
        if (subject == null) {
            String unencoded;
            int colon;
            String authorization;
            String user = (String)mc.get((Object)"user");
            String pswd = (String)mc.get((Object)"pswd");
            if ((user == null || pswd == null) && (authorization = httpServletRequest.getHeader("Authorization")) != null && authorization.startsWith("Basic ") && (colon = (unencoded = Base64.decodeUTF8((String)(authorization = authorization.substring(6).trim()))).indexOf(58)) > 0) {
                try {
                    user = unencoded.substring(0, colon);
                    user = Utils.charsetConvert((String)user, (String)"UTF-8");
                    pswd = unencoded.substring(colon + 1);
                    pswd = Utils.charsetConvert((String)pswd, (String)"UTF-8");
                }
                catch (Exception ex) {
                    user = null;
                    pswd = null;
                    this.logError(ex);
                }
            }
            if (user == null || pswd == null) {
                throw new InvocationTargetException(new LoginException());
            }
            subject = this.login(user, pswd, httpSession);
            userId = UserLoginModule.getUser(subject).getId();
        }
        QName serviceName = (QName)mc.get((Object)"jakarta.xml.ws.wsdl.service");
        try {
            SOAPBody soapBody = ((SOAPMessage)mc.get((Object)"message")).getSOAPBody();
            Node nodecid = XMLUtils.selectNode((Node)soapBody, (String)"//cid/text()");
            if (nodecid == null) {
                nodecid = XMLUtils.selectNode((Node)soapBody, (String)"//contractId/text()");
            }
            if (nodecid == null) {
                nodecid = XMLUtils.selectNode((Node)soapBody, (String)"//@contractId|//@cid");
            }
            int contractId = nodecid != null ? Utils.parseInt((String)nodecid.getNodeValue()) : 0;
            String service = serviceName.getLocalPart();
            String operation = m.getName();
            Map<String, Object> argsMap = null;
            try {
                argsMap = this.getArgsMap(this.getMethodByName(this.findInterfaceClass(service, clazz), operation), args);
            }
            catch (Exception e) {
                throw new BGException("unknown error process method " + operation + " from ws-impl " + clazz, (Throwable)e);
            }
            String[] midRef = new String[]{mid};
            ModuleAction moduleAction = FindAction.find(midRef, service, operation, argsMap);
            if (this.requestCheckAuthorization) {
                try {
                    this.permissionChecker.checkActionAllow(userId, mid, moduleAction, service, operation, contractId, argsMap);
                }
                catch (Exception ex) {
                    User user = UserMap.getUser(userId);
                    if (user.isShowActionsPermitErrors()) {
                        throw ex;
                    }
                    return null;
                }
            }
            this.logRequest(httpServletRequest, userId, contractId, midRef, moduleAction, service, operation, soapBody);
        }
        catch (SOAPException e) {
            throw new InvocationTargetException(e);
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
        return this.invoke(module, mid, userId, resolver, clazz, wsc, mc, p, m, args, subject);
    }

    protected void logRequest(HttpServletRequest request, Integer userId, int contractId, String[] midRef, ModuleAction moduleAction, String service, String operation, Object body) throws BGException {
        if (!this.requestCheckAuthorization && moduleAction == null) {
            this.getLogger().debug("Action " + service + ":" + operation + " not found in dictionary for module " + midRef[0]);
        }
        User user = UserMap.getUser(userId);
        if (this.requestLog && !user.getConfigSetup().getBoolean("log.disabled", false)) {
            StringWriter sw = new StringWriter();
            if (moduleAction == null) {
                sw.append(service).append(":").append(operation).append("\n");
            }
            if (body instanceof SOAPBody) {
                SOAPBody soapBody = (SOAPBody)body;
                this.getQueryString(sw, (Node)soapBody);
            } else if (body instanceof JsonNode) {
                sw.append(((JsonNode)body).toString());
            } else {
                sw.append(String.valueOf(body));
            }
            Date now = new Date();
            try (Connection con = this.setup.getDBTrashOrMasterConnectionFromPool(BGSQueryLogDao.getTableName(now));){
                boolean moduleActionNotNull = moduleAction != null;
                BGSQueryLogEntry entry = BGSQueryLogEntry.builder().setUserId(userId).setRemoteAddr(ServletUtils.getIpFromHeader(request, this.setup)).setContractId(contractId).setActionTitle(moduleActionNotNull ? moduleAction.getTitle() : "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e").setActionId(moduleActionNotNull ? moduleAction.getId() : "0").setQueryString(sw.toString()).setModuleId(midRef[0]).setContractTitle("").setUserName("").setModuleName("").build();
                new BGSQueryLogDao(con).log(entry, now);
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    protected void getQueryString(StringWriter sw, Node body) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            NodeList nodeList = body.getChildNodes().item(0).getChildNodes();
            int size = nodeList.getLength();
            for (int i = 0; i < size; ++i) {
                Node node2;
                NamedNodeMap attrs;
                Node node = nodeList.item(i);
                sw.write(node.getNodeName());
                sw.write(" => ");
                if (node.hasAttributes() && ((attrs = node.getAttributes()).getLength() != 1 || !"xmlns".equals(attrs.item(0).getNodeName()))) {
                    transformer.transform(new DOMSource(node), new StreamResult(sw));
                    sw.append('\n');
                    continue;
                }
                NodeList nodeList2 = node.getChildNodes();
                if (nodeList2.getLength() == 1 && (node2 = nodeList2.item(0)).getNodeType() == 3) {
                    sw.write(node2.getNodeValue());
                    sw.append('\n');
                    continue;
                }
                transformer.transform(new DOMSource(node), new StreamResult(sw));
                sw.append('\n');
            }
        }
        catch (Exception ex) {
            try {
                XMLUtils.serialize((Node)body, (Result)new StreamResult(sw), (String)"utf-8", (boolean)false);
            }
            catch (Exception e1) {
                sw.append("error serialize xml " + e1.toString());
            }
        }
    }

    private Subject login(String userName, String userPswd, HttpSession session) throws InvocationTargetException {
        try {
            Subject subject = UserLoginModule.auth(this.loginContextName, userName, userPswd);
            User user = UserLoginModule.getUser(subject);
            if (session != null) {
                session.setAttribute("user_id", (Object)user.getId());
                session.setAttribute("subject", (Object)subject);
            }
            return subject;
        }
        catch (FailedLoginException e) {
            if (e.getCause() instanceof AuthenticationException) {
                throw new InvocationTargetException(new FailedLoginException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0432 LDAP. \u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c?"));
            }
            if (e.getCause() instanceof CommunicationException) {
                throw new InvocationTargetException(new FailedLoginException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0432 LDAP."));
            }
            if ("Cannot find user's LDAP entry".equals(e.getMessage())) {
                throw new InvocationTargetException(new FailedLoginException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0432 LDAP."));
            }
            throw new InvocationTargetException(new FailedLoginException(e.getLocalizedMessage()));
        }
        catch (LoginException e) {
            throw new InvocationTargetException(new FailedLoginException(e.getLocalizedMessage()));
        }
    }

    private Map<String, Object> getArgsMap(Method mIface, Object[] args) {
        int length = args.length;
        HashMap<String, Object> map = new HashMap<String, Object>(length);
        Annotation[][] paramsAnnotations = mIface.getParameterAnnotations();
        for (int i = 0; i < length && paramsAnnotations.length > i; ++i) {
            Annotation[] paramAnnotations = paramsAnnotations[i];
            if (paramAnnotations.length != 1 || !(paramAnnotations[0] instanceof WebParam)) continue;
            WebParam wp = (WebParam)paramAnnotations[0];
            map.put(wp.name(), args[i]);
        }
        return map;
    }

    @Override
    protected void setHandlers(List<Handler> list) {
        list.add((Handler)new ServiceAuthenticationSOAPHandler());
        super.setHandlers(list);
    }

    protected Class<?> findInterfaceClass(String service, Class<?> implementorClass) {
        for (Class<?> iface : implementorClass.getInterfaces()) {
            WebService webService = iface.getAnnotation(WebService.class);
            if (webService == null) continue;
            return iface;
        }
        return null;
    }

    protected Method getMethodByName(Class<?> clazz, String name) {
        for (Method mc : clazz.getMethods()) {
            WebMethod webMethod = mc.getAnnotation(WebMethod.class);
            if (webMethod != null) {
                if (webMethod.exclude()) continue;
                if (Utils.notEmptyString((String)webMethod.operationName())) {
                    if (!mc.getName().equals(webMethod.operationName())) continue;
                    return mc;
                }
            }
            if (!mc.getName().equals(name)) continue;
            return mc;
        }
        return null;
    }

    protected Method getMethodImpl(Class<?> clazz, Method ifaceMethod) {
        for (Method method : clazz.getMethods()) {
            if (method.getParameterCount() != ifaceMethod.getParameterCount() || !method.getName().equals(ifaceMethod.getName())) continue;
            return method;
        }
        return null;
    }

    public class ServiceAuthenticationSOAPHandler
    implements SOAPHandler<SOAPMessageContext> {
        public Set<QName> getHeaders() {
            return null;
        }

        public void close(MessageContext context) {
        }

        public boolean handleFault(SOAPMessageContext context) {
            return true;
        }

        public boolean handleMessage(SOAPMessageContext context) {
            try {
                boolean outbound = (Boolean)context.get((Object)"jakarta.xml.ws.handler.message.outbound");
                if (!outbound) {
                    SOAPMessage message = context.getMessage();
                    context.put((Object)"message", (Object)message);
                    context.setScope("message", MessageContext.Scope.APPLICATION);
                    SOAPEnvelope se = message.getSOAPPart().getEnvelope();
                    SOAPHeader sh = se.getHeader();
                    NodeList nodes = sh.getChildNodes();
                    int size = nodes.getLength();
                    for (int i = 0; i < size; ++i) {
                        Node node = nodes.item(i);
                        if (node.getNodeType() != 1 || !"auth".equals(node.getNodeName())) continue;
                        Element e = (Element)node;
                        context.put((Object)"user", (Object)e.getAttribute("user"));
                        context.put((Object)"pswd", (Object)e.getAttribute("pswd"));
                        context.setScope("user", MessageContext.Scope.APPLICATION);
                        context.setScope("pswd", MessageContext.Scope.APPLICATION);
                    }
                } else {
                    String msg = FileUtils.getInstance().normalize0();
                    if (msg != null) {
                        SOAPEnvelope se = context.getMessage().getSOAPPart().getEnvelope();
                        SOAPHeader sh = se.getHeader();
                        if (sh == null) {
                            sh = se.addHeader();
                        }
                        SOAPFactory soapFactory = SOAPFactory.newInstance();
                        SOAPElement auth = soapFactory.createElement("message", "", "http://ws.base.kernel.bgbilling.bitel.ru/");
                        auth.setTextContent(msg);
                        sh.addChildElement(auth);
                    }
                }
            }
            catch (SOAPException ex) {
                JaxWsHandler.this.logError(ex);
            }
            return true;
        }
    }
}

