/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.voice.accounting.mediation.runtime;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.VoiceRecord;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.ErrorTask;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.VoiceAccountFinder;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.VoiceResourceAuditor;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.runtime.VoiceSessionFakeRuntimeFlushingManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceError;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceSession;
import ru.bitel.bgbilling.modules.voice.common.mediation.RuntimeMediator;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceErrorDao;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceAccountRuntime;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceAccountRuntimeMap;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceApplication;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceOperAccountRuntimeMap;
import ru.bitel.bgbilling.modules.voice.server.runtime.VoiceSessionRuntime;
import ru.bitel.bgbilling.modules.voice.server.runtime.device.VoiceDeviceRuntime;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffWorkerContext;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.oss.kernel.quartz.server.QuartzContext;

public class RuntimeMediatorWorker
implements Callable {
    private Logger logger = LogManager.getLogger();
    private RuntimeMediator runtimeMediator;
    private VoiceApplication application;
    private VoiceAccountRuntimeMap accountRuntimeMap;
    private VoiceOperAccountRuntimeMap accountOperRuntimeMap;
    private ContractRuntimeMap contractRuntimeMap;
    private int deviceId;
    private VoiceDeviceRuntime deviceRuntime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call() throws Exception {
        QuartzContext context = (QuartzContext)QuartzContext.get();
        Map map = context.getParams();
        this.runtimeMediator = (RuntimeMediator)map.get("runtimeMediator");
        this.application = (VoiceApplication)((Object)map.get("application"));
        this.accountRuntimeMap = this.application.getVoiceAccountRuntimeMap();
        this.deviceId = (Integer)map.get("deviceId");
        this.contractRuntimeMap = this.application.getContractRuntimeMap();
        this.accountOperRuntimeMap = this.application.getVoiceOperAccountRuntimeMap();
        this.deviceRuntime = this.application.getDeviceRuntimeMap().get(this.deviceId);
        VoiceTariffWorkerContext workerContext = new VoiceTariffWorkerContext(context.getSetup(), context.getConnectionSet(), context.getModuleId());
        ServerContext parentContext = (ServerContext)ServerContext.get();
        try {
            ServerContext.push((ThreadContext)workerContext);
            this.processSessions(workerContext);
        }
        finally {
            workerContext.commit();
            workerContext.recycle();
            ServerContext.pop((ThreadContext)workerContext, (ThreadContext)parentContext);
        }
        return null;
    }

    private void processSessions(VoiceTariffWorkerContext workerContext) throws Exception {
        ConnectionSet connectionSet = workerContext.getConnectionSet();
        int moduleId = workerContext.getModuleId();
        VoiceResourceAuditor resourceAuditor = new VoiceResourceAuditor(workerContext.getModuleId());
        ModuleSetup moduleSetup = this.application.getSetup().getModuleSetup(Integer.valueOf(moduleId));
        resourceAuditor.load(connectionSet.getConnection(), Utils.toIntegerSet((String)moduleSetup.get("cdr.audit.resource.categories")));
        SortedMap recordMap = this.runtimeMediator.getNewRecords();
        if (recordMap == null || recordMap.size() == 0) {
            return;
        }
        VoiceAccountFinder finder = new VoiceAccountFinder(this.deviceRuntime, null, this.accountRuntimeMap, this.accountOperRuntimeMap, resourceAuditor, this.application.getOperatorRuntimeMap());
        TreeMap<Date, List<VoiceSessionRuntime>> hourMap = new TreeMap<Date, List<VoiceSessionRuntime>>();
        HashMap<Integer, Date> contractToFlushBalance = new HashMap<Integer, Date>();
        this.processRecords(workerContext.getModuleId(), connectionSet, resourceAuditor, recordMap, finder, hourMap, contractToFlushBalance);
        this.calcSessions(connectionSet, hourMap, workerContext.getModuleId());
        this.setBalances(connectionSet, contractToFlushBalance);
    }

    private void setBalances(ConnectionSet connectionSet, HashMap<Integer, Date> contractToFlushBalance) {
        for (Map.Entry<Integer, Date> entry : contractToFlushBalance.entrySet()) {
            int contractId = entry.getKey();
            Date month = entry.getValue();
            Calendar cal = TimeUtils.convertDateToCalendar((Date)month);
            int yy = cal.get(1);
            int mm = cal.get(2) + 1;
            try (BalanceDao balanceDao = new BalanceDao(connectionSet.getConnection());){
                ContractRuntime contractRuntime = this.contractRuntimeMap.getContractRuntime(connectionSet, Integer.valueOf(contractId));
                if (contractRuntime == null) {
                    throw new BGException("ContractRuntime is null for " + contractId);
                }
                balanceDao.setBalanceAccount(contractId, contractRuntime.getSuperContractId(), yy, mm);
            }
            catch (Exception ex) {
                this.logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private void calcSessions(ConnectionSet connectionSet, SortedMap<Date, List<VoiceSessionRuntime>> hourMap, int moduleId) throws Exception {
        Date prevHour = null;
        VoiceErrorDao errorDao = null;
        for (Map.Entry<Date, List<VoiceSessionRuntime>> entry : hourMap.entrySet()) {
            Date hour = entry.getKey();
            if (!hour.equals(prevHour)) {
                errorDao = new VoiceErrorDao(connectionSet, moduleId, hour);
                VoiceErrorDao.checkTables(connectionSet.getConnection(), moduleId, hour);
                prevHour = hour;
            }
            List<VoiceSessionRuntime> sessionList = entry.getValue();
            VoiceSessionFakeRuntimeFlushingManager manager = new VoiceSessionFakeRuntimeFlushingManager(this.application.getModuleId(), hour, this.application.getBalanceEP());
            for (VoiceSessionRuntime sessionRuntime : sessionList) {
                VoiceAccountRuntime accountRuntime = this.accountRuntimeMap.get(sessionRuntime.getSession().getAccountId());
                int errorCode = sessionRuntime.calculate(this.application.getRuntimeTariffContext(), true);
                if (errorCode > 0) {
                    VoiceSession session = sessionRuntime.getSession();
                    VoiceError error = new VoiceError().setCode(errorCode).setSessionStart(session.getSessionStart()).setDeviceId(this.deviceId).setHour(hour).setPhoneFrom(session.getE164CallingStationId()).setDuration(session.getSessionTime()).setPhoneTo(session.getE164CalledStationId()).setFromPort(session.getFromPort()).setToPort(session.getToPort()).setAccountId(accountRuntime.getAccountId());
                    errorDao.update(error);
                    connectionSet.commit();
                    continue;
                }
                manager.insert(connectionSet, sessionRuntime);
                connectionSet.commit();
            }
        }
    }

    private void processRecords(int moduleId, ConnectionSet connectionSet, VoiceResourceAuditor resourceAuditor, SortedMap<Date, List<VoiceRecord>> recordMap, VoiceAccountFinder finder, SortedMap<Date, List<VoiceSessionRuntime>> hourMap, HashMap<Integer, Date> contractToFlushBalance) throws Exception {
        Date prevHour = null;
        VoiceErrorDao errorDao = null;
        for (Map.Entry<Date, List<VoiceRecord>> entry : recordMap.entrySet()) {
            Date hour = TimeUtils.clear_MIN_MIL_SEC((Date)entry.getKey());
            if (!hour.equals(prevHour)) {
                errorDao = new VoiceErrorDao(connectionSet, moduleId, hour);
                VoiceErrorDao.checkTables(connectionSet.getConnection(), moduleId, hour);
                prevHour = hour;
            }
            List sessionsHourList = hourMap.computeIfAbsent(hour, h -> new ArrayList());
            ErrorTask errorTask = new ErrorTask();
            for (VoiceRecord record : entry.getValue()) {
                ArrayList<VoiceSessionRuntime> recordSessions = new ArrayList<VoiceSessionRuntime>();
                finder.getSessions(record, recordSessions, this.deviceId, hour, errorTask);
                if (recordSessions.size() == 0) continue;
                sessionsHourList.addAll(recordSessions);
            }
            if (errorTask.getErrors().size() <= 0) continue;
            VoiceErrorDao.checkTables(connectionSet.getConnection(), moduleId, hour);
            errorDao.insertErrors(errorTask.getErrors());
            connectionSet.commit();
        }
    }
}

