/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.directory.costmap;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.voice.client.directory.costmap.VoiceCostMapEditorForm;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceCostMap;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceCostMapService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;

public class VoiceCostMapImportDialog
extends BGEditorDialog<VoiceCostMap> {
    private BGControlPanelPeriodNoB importPeriod = new BGControlPanelPeriodNoB();
    private JCheckBox addNewGeocode = new JCheckBox("\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u0442\u044c \u0432 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0439 \u0438 \u0433\u0435\u043e\u0433\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u043a\u043e\u0434\u043e\u0432 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0449\u0438\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b");
    private JTextArea importContentTextArea = new JTextArea(5, 20);
    private BGComboBox<ComboBoxItem> importTemplate = new BGComboBox();
    private VoiceCostMapService voiceCostMapService;
    private VoiceCostMapEditorForm parentPanel;
    private int operatorId = 0;

    public VoiceCostMapImportDialog(String title, VoiceCostMap data, int operatorId, VoiceCostMapService voiceCostMapService, VoiceCostMapEditorForm parentPanel) {
        super(title, (Object)data);
        this.operatorId = operatorId;
        this.parentPanel = parentPanel;
        this.voiceCostMapService = voiceCostMapService;
    }

    public void doDialogPanel() {
        this.importContentTextArea.setMargin(new Insets(3, 3, 3, 3));
        JScrollPane scrollPane = new JScrollPane(this.importContentTextArea);
        scrollPane.setMinimumSize(new Dimension(900, 300));
        scrollPane.setPreferredSize(new Dimension(900, 300));
        try {
            JSONArray jsonArray = this.voiceCostMapService.importTemplateList();
            for (Object object : jsonArray) {
                if (!(object instanceof JSONObject)) continue;
                JSONObject json = (JSONObject)object;
                this.importTemplate.addItem((Object)new ComboBoxItem((Object)json.optString("id"), json.optString("title")));
            }
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
        this.panel.add((Component)new JLabel("\u041e\u0431\u0440\u0430\u0431\u043e\u0442\u0447\u0438\u043a \u0438\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u0435\u043c\u044b\u0445 \u0434\u0430\u043d\u043d\u044b\u0445:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 0, 3), 0, 0));
        this.panel.add((Component)this.importTemplate, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 0, 0, 0), 0, 0));
        this.panel.add((Component)new JLabel("\u0414\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u0438\u043c\u043f\u043e\u0440\u0442\u0430:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 3, 0, 0), 0, 0));
        this.panel.add((Component)this.getLoadDataButtonPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 0, 0, 3), 0, 0));
        this.panel.add((Component)BGSwingUtilites.wrapBorder((JComponent)scrollPane, (String)"\u0418\u043c\u043f\u043e\u0440\u0442\u0438\u0440\u0443\u0435\u043c\u043e\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 (\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f)"), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.panel.add((Component)this.getPeriodPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.panel.add((Component)this.addNewGeocode, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
    }

    private JPanel getLoadDataButtonPanel() {
        BGButton chooseFileButton = new BGButton("\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0438\u0437 \u0444\u0430\u0439\u043b\u0430...");
        chooseFileButton.addActionListener(l -> {
            BGFileChooser fileChooser = new BGFileChooser((Component)BGClientBase.getFrame());
            fileChooser.setMultiSelectionEnabled(false);
            if (fileChooser.showOpenDialog() == 0) {
                File selectedFile = fileChooser.getSelectedFile();
                try (FileInputStream fis = new FileInputStream(selectedFile);){
                    byte[] fileContent = Utils.readByBlock((InputStream)fis);
                    this.importContentTextArea.setText(new String(fileContent, "UTF-8"));
                }
                catch (Exception e) {
                    ClientUtils.showErrorMessageDialog((Throwable)e);
                }
            }
        });
        BGButton clipboardButton = new BGButton("\u0418\u0437 \u0431\u0443\u0444\u0435\u0440\u0430 \u043e\u0431\u043c\u0435\u043d\u0430");
        clipboardButton.addActionListener(e -> {
            try {
                this.importContentTextArea.setText((String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor));
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((String)ex.getLocalizedMessage());
            }
        });
        JPanel panel = new JPanel(new GridLayout(1, 2));
        panel.add((Component)chooseFileButton);
        panel.add((Component)clipboardButton);
        return panel;
    }

    private JPanel getPeriodPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434 \u0437\u0430\u0433\u0440\u0443\u0436\u0430\u0435\u043c\u044b\u0445 \u043a\u043e\u0434\u043e\u0432:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 3, 3), 0, 0));
        panel.add((Component)this.importPeriod, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 3, 3), 0, 0));
        return panel;
    }

    public boolean doApply() throws Exception {
        String importContent = this.importContentTextArea.getText();
        if (Utils.isBlankString((String)importContent)) {
            BGToolTip.showErrorMessage((JComponent)this.importContentTextArea, (String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0441 \u0433\u0435\u043e\u043a\u043e\u0434\u0430\u043c\u0438 \u0438\u0437 \u0444\u0430\u0439\u043b\u0430 \u0438\u043b\u0438 \u0432\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0438\u0445 \u0438\u0437 \u0431\u0443\u0444\u0435\u0440\u0430 \u043e\u0431\u043c\u0435\u043d\u0430!");
            return false;
        }
        this.voiceCostMapService.importCostMap(this.operatorId, ((VoiceCostMap)this.data).getId(), this.importPeriod.getPeriod(), this.addNewGeocode.isSelected(), String.valueOf(((ComboBoxItem)this.importTemplate.getSelectedItem()).getObject()), importContent);
        this.parentPanel.performAction("refresh");
        return true;
    }
}

