/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.phone.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.modules.phone.server.bean.NumberPool;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class NumberPoolManager {
    private final Connection con;
    private final String tableName;
    private final String itemTableName;

    public NumberPoolManager(Connection con, int mid) {
        this.con = con;
        this.tableName = "phone_number_pool_" + mid;
        this.itemTableName = "phone_number_pool_item_" + mid;
    }

    public void updateNumberPool(NumberPool pool) {
        try {
            PreparedStatement ps;
            if (pool.getId() < 0) {
                ps = this.con.prepareStatement("SELECT MAX(ord) FROM " + this.tableName);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    pool.setOrder(rs.getInt(1));
                }
                ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (title, ct_id, charge, range_start, range_end, ord) VALUES (?,?,?,?,?,?)", 1);
                ps.setInt(6, pool.getOrder());
            } else {
                ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET title=?, ct_id=?, charge=?, range_start=?, range_end=? WHERE id=?");
                ps.setInt(6, pool.getId());
            }
            ps.setString(1, pool.getTitle());
            ps.setInt(2, pool.getChargeTypeId());
            ps.setFloat(3, pool.getCharge());
            ps.setLong(4, pool.getRangeStart());
            ps.setLong(5, pool.getRangeEnd());
            if (pool.getId() < 0) {
                pool.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteNumberPool(int id) {
        try {
            Statement st = this.con.createStatement();
            st.executeUpdate("DELETE FROM " + this.tableName + " WHERE id=" + id);
            st.executeUpdate("DELETE FROM " + this.itemTableName + " WHERE np_id=" + id);
            st.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updateNumberPoolEntry(NumberPool.NumberPoolEntry item) {
        try {
            PreparedStatement ps;
            if (item.getId() < 0) {
                ps = this.con.prepareStatement("INSERT INTO " + this.itemTableName + " (np_id, pattern) VALUES (?,?)");
            } else {
                ps = this.con.prepareStatement("UPDATE " + this.itemTableName + " SET np_id=?, pattern=? WHERE id=?");
                ps.setInt(3, item.getId());
            }
            ps.setInt(1, item.getNumberPoolId());
            ps.setString(2, item.getPattern());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteNumberPoolEntry(int id) {
        try {
            Statement st = this.con.createStatement();
            st.executeUpdate("DELETE FROM " + this.itemTableName + " WHERE id=" + id);
            st.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public List<NumberPool> getNumberPoolList() {
        ArrayList<NumberPool> result = new ArrayList<NumberPool>();
        try {
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery("SELECT * FROM " + this.tableName + " ORDER BY ord");
            while (rs.next()) {
                result.add(this.getNumberPoolFromRS(rs));
            }
            rs.close();
            st.close();
            PreparedStatement ps = this.con.prepareStatement("SELECT * FROM " + this.itemTableName + " WHERE np_id=?");
            for (NumberPool p : result) {
                ps.setInt(1, p.getId());
                rs = ps.executeQuery();
                ArrayList<NumberPool.NumberPoolEntry> entryList = new ArrayList<NumberPool.NumberPoolEntry>();
                while (rs.next()) {
                    entryList.add(this.getNumberPoolEntryFromRS(rs));
                }
                rs.close();
                p.setEntryList(entryList);
            }
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private NumberPool getNumberPoolFromRS(ResultSet rs) throws SQLException {
        NumberPool result = new NumberPool();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setChargeTypeId(rs.getInt("ct_id"));
        result.setCharge(rs.getFloat("charge"));
        result.setOrder(rs.getInt("ord"));
        result.setRangeStart(rs.getLong("range_start"));
        result.setRangeEnd(rs.getLong("range_end"));
        return result;
    }

    private NumberPool.NumberPoolEntry getNumberPoolEntryFromRS(ResultSet rs) throws SQLException {
        NumberPool.NumberPoolEntry result = new NumberPool.NumberPoolEntry();
        result.setId(rs.getInt("id"));
        result.setNumberPoolId(rs.getInt("np_id"));
        result.setPattern(rs.getString("pattern"));
        return result;
    }
}

