/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.task.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.bean.emuns.BGEntityType;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.task.common.bean.BGFutureTask;
import ru.bitel.bgbilling.kernel.task.common.bean.enums.BGFutureTaskType;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class BGFutureTaskDao
extends AbstractIdDao<BGFutureTask> {
    public BGFutureTaskDao(Connection con) {
        super(con, 0, "task_future");
    }

    public List<BGFutureTask> list(int moduleId, BGFutureTaskType futureTaskType, BGEntityType entityType, int entityId) throws SQLException {
        return this.list("module_id=? AND type=? AND entity_type=? AND entity_id=?", "start_time", moduleId, futureTaskType.name(), entityType.name(), entityId);
    }

    public void delete(BGFutureTaskType futureTaskType, int id) throws SQLException {
        this.delete("type=? AND id=?", futureTaskType.name(), id);
    }

    public void delete(BGFutureTaskType futureTaskType, List<Integer> ids) throws SQLException {
        Objects.requireNonNull(ids);
        if (ids.isEmpty()) {
            return;
        }
        this.delete("type=? AND id IN ( " + Utils.toString(ids) + " )", futureTaskType.name());
    }

    @Override
    protected BGFutureTask getFromRS(ResultSet rs) throws SQLException {
        return BGFutureTask.builder().setId(rs.getInt("id")).setStartTime(TimeUtils.convertTimestampToLocalDateTime(rs.getTimestamp("start_time"))).setModuleId(rs.getInt("module_id")).setType(BGFutureTaskType.valueOf(rs.getString("type"))).setEntityType(BGEntityType.valueOf(rs.getString("entity_type"))).setEntityId(rs.getInt("entity_id")).setData(rs.getString("data")).setCreateTime(TimeUtils.convertTimestampToLocalDateTime(rs.getTimestamp("create_time"))).setCreateUserId(rs.getInt("create_user_id")).build();
    }

    @Override
    protected void updateImpl(BGFutureTask futureTask) throws SQLException {
        int index;
        PreparedStatement ps;
        boolean update;
        Objects.requireNonNull(futureTask);
        boolean bl = update = futureTask.getId() > 0;
        if (!update) {
            String query = "SELECT id FROM " + this.tableName + " WHERE start_time=? AND module_id=? AND type=? AND entity_type=? AND entity_id=?";
            ps = this.con.prepareStatement(query);
            try {
                index = 1;
                ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp(futureTask.getStartTime()));
                ps.setInt(index++, futureTask.getModuleId());
                ps.setString(index++, futureTask.getType().name());
                ps.setString(index++, futureTask.getEntityType().name());
                ps.setInt(index++, futureTask.getEntityId());
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        futureTask.setId(rs.getInt("id"));
                        update = true;
                    }
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        String querySet = "start_time=?, module_id=?, type=?, entity_type=?, entity_id=?, data=?, create_time=?, create_user_id=?";
        ps = this.prepareStatement(futureTask, querySet);
        try {
            index = 1;
            ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp(futureTask.getStartTime()));
            ps.setInt(index++, futureTask.getModuleId());
            ps.setString(index++, futureTask.getType().name());
            ps.setString(index++, futureTask.getEntityType().name());
            ps.setInt(index++, futureTask.getEntityId());
            ps.setString(index++, futureTask.getData());
            ps.setTimestamp(index++, TimeUtils.convertLocalDateTimeToTimestamp(futureTask.getCreateTime()));
            ps.setInt(index++, futureTask.getCreateUserId());
            this.executeUpdate(futureTask, index, ps);
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public List<BGFutureTask> listForRun() throws SQLException {
        return this.list("start_time < NOW()", "start_time", new Object[0]);
    }
}

