<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="1.0">

<xsl:output method="html" encoding="UTF-8" indent="yes"/>

<xsl:template match="/">
   <html>
   <head>
   <meta http-equiv="content-type" content="text/html; charset=UTF-8" />
   </head>
    <body>
    <center>
        <xsl:call-template name="head"/><br/>
        <xsl:call-template name="table"/><br/>
        <xsl:call-template name="sums"/>
    </center>
    </body>
    </html>
</xsl:template>

<xsl:template name="head">
    <xsl:for-each select="/data/table">
         <h2><xsl:value-of select="@reportTitle"/><br/>
         Контракт:&#160;<xsl:value-of select="@contractTitle"/>(<xsl:value-of select="@comment"/>)
         </h2><br/>
         Логин:<xsl:value-of select="@login"/>&#160;Период с: <xsl:value-of select="@date1"/> по <xsl:value-of select="@date2"/>
    </xsl:for-each>
</xsl:template>

<xsl:template name="table">
<table width="100%" border="1" cellspacing="0" cellpadding="3">
     <tr bgcolor="#f0f0f0">
         <td>Тип звонка</td>
         <td>Направление</td>
         <td>Время входа</td>
         <td>Длительность[в секундах]</td>
         <td>Окр. длительность[в секундах]</td>
         <td>Стоимость минуты</td>
         <td>Стоимость</td>
         <td>С номера / На номер</td>         
     </tr>
     <xsl:for-each select="/data/table/data/row">
         <tr bgcolor="#ffffff">
             <td><xsl:value-of select="@type"/></td>
             <td><xsl:value-of select="@dest"/></td>
             <td><xsl:value-of select="@session_start"/></td>
             <td><xsl:value-of select="@session_time"/></td>
             <td><xsl:value-of select="@round_session_time"/></td>
             <td><xsl:value-of select="@min_cost"/></td>
             <td><xsl:value-of select="@cost"/></td>
             <td><xsl:value-of select="@from_to"/></td>
         </tr>
     </xsl:for-each>
</table>
</xsl:template>

<xsl:template name="sums">
    <br/>
	Количество сессий:&#160;<xsl:value-of select="count(/data/table/data/row)"/>&#160;
    Время [сек.][мин.]:&#160;<xsl:value-of select="/data/table/data/@time_amount"/>&#160;
    Окр. время [сек.][мин.]:&#160;<xsl:value-of select="/data/table/data/@round_time_amount"/>&#160;
    Стоимость:&#160;<xsl:value-of select="/data/table/data/@money_amount"/>&#160;
</xsl:template>

</xsl:stylesheet>
