package ru.bitel.bgbilling.modules.cashcheck.dyn.reports;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.reports.server.bean.filter.BGReportFilter;
import ru.bitel.bgbilling.modules.reports.server.report.BGCSVReport.CSVFillerDataFields;
import ru.bitel.bgbilling.modules.reports.server.report.BGCSVReport.ReportResult;
import ru.bitel.bgbilling.plugins.cashcheck.common.Payment;
import ru.bitel.bgbilling.plugins.cashcheck.server.bean.Check;
import ru.bitel.bgbilling.plugins.cashcheck.server.bean.PaymentQueueManager;
import ru.bitel.common.model.Period;

/**
 * Отчёт по напечатанным чекам из лога чеков. Анализирует сохранённое содержимое чеков и делает аналитику.
 * @author dimon
 */
public class CashCheckLogReport
	implements CSVFillerDataFields
{
	@Override
	public void fillReport( Connection con, BGReportFilter filter, ReportResult result, Map<String, String> fields ) throws BGException
	{
	    Date dateFrom = filter.getDateParam( "date1" );
	    Date dateTo = filter.getDateParam( "date2" );
	    int printerId = filter.getIntParam( "kkm" );
	    if( printerId <= 0)
	    {
	        throw new BGMessageException("ККМ надо указать");
	    }
	    int checkType = filter.getIntParam( "checkType", -1 ); // "0"="Платежи", "1"="Возвраты"
	    if( checkType < 0)
        {
            throw new BGMessageException("тип чека надо указать");
        }
	    
	    PaymentQueueManager pqm = new PaymentQueueManager(con);
	    Period period = new Period(dateFrom, dateTo);
	    List<Payment> ccpayments = null;
	    if(checkType == 0)
        {
	        ccpayments = pqm.getPaymentLog( null, printerId, false, null, period, null, null ).getList(); // erroredType=false
        }
        else if(checkType == 1)
        {
            ccpayments = pqm.getChargeLog( null, printerId, false, null, period, null, null ).getList(); // erroredType=false;
        }
        else
        {
            throw new IllegalArgumentException();
        }
	    
	    int checkDataErrors = 0; // нераспознанных чеков
	    BigDecimal totalSum = BigDecimal.ZERO;
	    Map<String,CS> printModesMap = new HashMap<String,CS>(); // по маппингам - из записи лога (не содержимому чека)
	    Map<String,CS> checkTypesMap = new HashMap<String,CS>(); // по типам чеков - из чека
	    Map<String,CS> paymentTypeMap = new HashMap<String,CS>(); // по тип оплаты - из чека
//	    int totalPositions = 0; // позиций в чеке
        Map<String,CS> depMap = new HashMap<String,CS>(); // по отделам - из позиций
        Map<String,CS> payMethodMap = new HashMap<String,CS>(); // по Признак способа расчёта - из позиций или из чека
        Map<String,CS> payObjectMap = new HashMap<String,CS>(); // по Признак предмета расчёта - из позиций или из чека
        Map<String,CS> taxMap = new HashMap<String,CS>(); // по налогам - из позиций или из чека
	    
	    for( Payment ccpayment : ccpayments )
	    {
	        Check check = null;
	        try
	        {
	            check = Check.fromCheckData(ccpayment.getCheckData());
	        }
	        catch(BGException e)
	        {
	            ++checkDataErrors;
	            continue;
	        }
	        totalSum = totalSum.add( check.getPaymentsum() );
	        //
	        printModesMap.computeIfAbsent(ccpayment.getPosMapping(), k -> new CS()).add(check.getPaymentsum());
	        checkTypesMap.computeIfAbsent(String.valueOf(check.getCheckType()), k -> new CS()).add(check.getPaymentsum());
	        paymentTypeMap.computeIfAbsent(String.valueOf(check.getPaymentType()), k -> new CS()).add(check.getPaymentsum());
	        // позиции
	        for(Check.CheckLine line : check.getLines())
	        {
	            if( line.summa != null ) // строка - продажная позиция
	            {
//	                ++totalPositions;
	                depMap.computeIfAbsent(String.valueOf(line.dep), k -> new CS()).add(line.summa);
	                Integer payMethod = line.payMethod != null ? line.payMethod : check.getPayMethod();
	                Integer payObject = line.payObject != null ? line.payObject : check.getPayObject();
	                Integer tax = line.tax != null ? line.tax : check.getTax();
	                payMethodMap.computeIfAbsent(payMethod != null ? String.valueOf(payMethod) : "---", k -> new CS()).add(line.summa); // null может быть если ни там ни там не задан
	                payObjectMap.computeIfAbsent(payObject != null ? String.valueOf(payObject) : "---", k -> new CS()).add(line.summa); // null может быть если ни там ни там не задан
	                taxMap.computeIfAbsent((tax != null && tax != -1) ? String.valueOf(tax) : "---", k -> new CS()).add(line.summa);  // -1 может быть если ни там ни там не задан
	            }
	        }
	    }
	    
	    List<Map<String, String>> data = new ArrayList<>( 1000 );

	    // всего чеков
	    addrow(data, "*", "Сумма", "Чеков");
	    addrow(data, "Всего", totalSum.toPlainString(), String.valueOf(ccpayments.size() - checkDataErrors));
        if( checkDataErrors > 0 )
        {
            addrow(data, "[!] плюс нераспознанных", null, String.valueOf(checkDataErrors));
        }
        
        // режим маппинга
        addrow(data, null, null, null);
        addrow(data, "* Маппинг (запись лога)", "Сумма", "Записей");
        for(Map.Entry<String,CS> printModes : printModesMap.entrySet())
        {
            addrow(data, printModes.getKey(), printModes.getValue().sum, printModes.getValue().cnt);
        }
        
        // типы чеков
        addrow(data, null, null, null);
        addrow(data, "* Тип чека (чеки)", "Сумма", "Чеков");
        for(Map.Entry<String,CS> checkTypes : checkTypesMap.entrySet())
        {
            addrow(data, checkTypes.getKey(), checkTypes.getValue().sum, checkTypes.getValue().cnt);
        }
        
        // типы оплаты
        addrow(data, null, null, null);
        addrow(data, "* Тип оплаты (чеки)", "Сумма", "Чеков");
        for(Map.Entry<String,CS> paymentType : paymentTypeMap.entrySet())
        {
            addrow(data, paymentType.getKey(), paymentType.getValue().sum, paymentType.getValue().cnt);
        }
        
        // отделы
        addrow(data, null, null, null);
        addrow(data, "* Отдел (позиции)", "Сумма", "Позиций");
        for(Map.Entry<String,CS> dep : depMap.entrySet())
        {
            addrow(data, dep.getKey(), dep.getValue().sum, dep.getValue().cnt);
        }
        
        // Признак способа расчёта 
        addrow(data, null, null, null);
        addrow(data, "* Призн. способа расч. (позиции, чеки)", "Сумма", "Позиций");
        for(Map.Entry<String,CS> dep : payMethodMap.entrySet())
        {
            addrow(data, dep.getKey(), dep.getValue().sum, dep.getValue().cnt);
        }
        
        // Признак предмета расчёта
        addrow(data, null, null, null);
        addrow(data, "* Призн. предмета расч. (позиции, чеки)", "Сумма", "Позиций");
        for(Map.Entry<String,CS> dep : payObjectMap.entrySet())
        {
            addrow(data, dep.getKey(), dep.getValue().sum, dep.getValue().cnt);
        }
        
        // налог
        addrow(data, null, null, null);
        addrow(data, "* Налог (позиции, чеки)", "Сумма", "Позиций");
        for(Map.Entry<String,CS> dep : taxMap.entrySet())
        {
            addrow(data, dep.getKey(), dep.getValue().sum, dep.getValue().cnt);
        }
        
	    result.setData( data );
	    
	    /*
	    // формируем данные о столбцах
        for(int col=0; col<size; col++)
        {
            String colid = "c"+col;
            String colname = String.valueOf( col+1 );
            int colwidth = 24 + col;
            fields.put( colid, colname +"##" + String.valueOf( colwidth ) );
        }
        */
	    fields.put( "c0", ".##300" );
	    fields.put( "c1", ".##200" );
	    fields.put( "c2", ".##201" );
	}
	
	private void addrow(List<Map<String, String>> data, Object c0, Object c1, Object c2)
	{
	    Map<String, String> row = new HashMap<String, String>();
	    data.add( row );
	    if(c0 != null)
	    {
	        row.put("c0", String.valueOf(c0));
	    }
	    if(c1 != null)
        {
            row.put("c1", String.valueOf(c1));
        }
	    if(c2 != null)
        {
            row.put("c2", String.valueOf(c2));
        }
	}
	
	private static class CS
	{
	    BigDecimal sum = BigDecimal.ZERO;
	    int cnt = 0;
	    public void add(BigDecimal s)
	    {
	        this.sum = this.sum.add(s);
	        this.cnt += 1;
	    }
	}
}
