/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.modules.mobile.reports;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.reports.server.modules.mobile.MobileParamType;
import ru.bitel.bgbilling.modules.reports.server.modules.mobile.MobileReport;
import ru.bitel.bgbilling.modules.reports.server.modules.mobile.MobileReportType;
import ru.bitel.common.TimeUtils;

public class ContractStructureChanges
extends MobileReport {
    private ArrayList<String> descriptionList = null;
    private ArrayList<String> titleList = null;

    @Override
    public MobileReportType getReportType(Connection con) {
        ArrayList<MobileParamType> list = new ArrayList<MobileParamType>();
        list.add(new MobileParamType("Date1", 1, "\u041e\u0442 \u0434\u0430\u0442\u044b", "11.12.2010"));
        list.add(new MobileParamType("Date2", 1, "\u0414\u043e \u0434\u0430\u0442\u044b", "03.03.2014"));
        list.add(new MobileParamType("flag1", 5, "\u041f\u043e \u0434\u043d\u044f\u043c", "false"));
        return new MobileReportType("\u041f\u0440\u0438\u0445\u043e\u0434\u044b( \u043b\u0438\u043d\u0435\u0439\u043d\u044b\u0439 )", list);
    }

    @Override
    public List<Object> getData() throws BGIllegalArgumentException {
        this.grafType = 1;
        try {
            boolean flag1 = this.getBooleanParameter("flag1", false);
            StringBuilder query = new StringBuilder("SELECT SUM(summa), DATE_FORMAT(dt, '");
            query.append(flag1 ? "%d.%m" : "%m %Y");
            query.append("'), COUNT(id) FROM contract_payment WHERE dt>=? AND dt<? GROUP BY YEAR(dt),MONTH(dt)");
            query.append(flag1 ? ",DAY(dt)" : "");
            query.append(" ORDER BY dt ASC");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            Date date1 = this.getDateParameter("Date1", new Date());
            Date date2 = this.getDateParameter("Date2", new Date());
            if (date1 == null || date2 == null && TimeUtils.dateBefore((Date)date1, (Date)date2)) {
                throw new BGIllegalArgumentException();
            }
            ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)date1));
            ps.setDate(2, TimeUtils.convertDateToSqlDate((Date)date2));
            ArrayList<Object> dataList = new ArrayList<Object>();
            this.titleList = new ArrayList();
            this.descriptionList = new ArrayList();
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                dataList.add(rs.getDouble(1));
                this.titleList.add(rs.getString(2));
                this.descriptionList.add("\u043a\u043e\u043b-\u0432\u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439: " + rs.getInt(3));
            }
            return dataList;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Map<String, Object> getOptions() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.descriptionList != null && this.descriptionList.size() > 0) {
            map.put("description", this.descriptionList);
        }
        if (this.titleList != null && this.titleList.size() > 0) {
            map.put("titles", this.titleList);
        }
        return map.size() > 0 ? map : null;
    }
}

