/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.psb.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import jakarta.xml.ws.Holder;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.SearchParam;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.modules.psb.common.bean.Transaction;
import ru.bitel.bgbilling.modules.psb.common.service.PSBService;
import ru.bitel.bgbilling.modules.psb.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.psb.server.bean.Constants;
import ru.bitel.bgbilling.modules.psb.server.bean.TransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.psb.common.service.PSBService")
public class PSBServiceImpl
extends AbstractService
implements PSBService {
    private TransactionManager manager;

    @PostConstruct
    private void init() {
        this.manager = new TransactionManager(this.getConnection(), this.moduleId);
    }

    public SearchResult<Transaction> searchTransactionList(SearchParam searchParam) throws Exception {
        SearchResult searchResult = new SearchResult(searchParam.getPeriod(), searchParam.getPage());
        this.manager.searchTransaction(searchResult, searchParam);
        return searchResult;
    }

    public void refund(int paymentId) throws Exception {
    }

    public void beginTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> params) throws BGException {
        this.tryCall(() -> {
            if (mode != null) {
                mode.value = "post";
            }
            ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);
            Contract contract = (Contract)contractDao.get(contractId);
            contractDao.close();
            String contractTitle = contract.getTitle();
            ModuleSetup moduleSetup = this.getModuleSetup();
            TransactionManager transactionManager = new TransactionManager(this.getConnection(), this.moduleId);
            Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setSum(amount)).setContractId(contractId)).setCreateDate(new Date())).build();
            transactionManager.update(transaction);
            HashMap<String, String> dataMap = new HashMap<String, String>();
            DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
            decimalFormatSymbols.setDecimalSeparator('.');
            dataMap.put("AMOUNT", new DecimalFormat("###########0.00", decimalFormatSymbols).format(amount));
            dataMap.put("CURRENCY", "RUB");
            dataMap.put("ORDER", new DecimalFormat("000000").format(transaction.getId()));
            dataMap.put("MERCH_NAME", moduleSetup.get("psb.merchant.name"));
            dataMap.put("MERCHANT", moduleSetup.get("psb.merchant"));
            dataMap.put("TERMINAL", moduleSetup.get("psb.terminal"));
            dataMap.put("EMAIL", moduleSetup.get("psb.email"));
            dataMap.put("TRTYPE", "1");
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            dataMap.put("TIMESTAMP", dateFormat.format(transaction.getCreateDate()));
            byte[] nonceBytes = new byte[8];
            for (int i = 0; i < nonceBytes.length; ++i) {
                nonceBytes[i] = (byte)(256.0 * Math.random());
            }
            dataMap.put("NONCE", Utils.bytesToHexString((byte[])nonceBytes));
            dataMap.put("BACKREF", moduleSetup.get("psb.back.url"));
            dataMap.put("DESC", moduleSetup.get("psb.description", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116" + contractTitle));
            StringBuilder str = new StringBuilder();
            for (String paramName : Constants.PARAMS) {
                Object paramValue = dataMap.get(paramName);
                if (paramValue == null) {
                    String paramKey = null;
                    if ("MERCH_NAME".equals(paramName)) {
                        paramKey = "psb.merchant.name";
                    } else if ("MERCHANT".equals(paramName)) {
                        paramKey = "psb.merchant";
                    } else if ("TERMINAL".equals(paramName)) {
                        paramKey = "psb.terminal";
                    } else if ("EMAIL".equals(paramName)) {
                        paramKey = "psb.email";
                    } else if ("BACKREF".equals(paramName)) {
                        paramKey = "psb.back.url";
                    }
                    this.getLogger().error("\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u043e \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \"" + paramKey + "\"");
                }
                if (paramValue == null) {
                    str.append("-");
                    continue;
                }
                str.append(paramValue.toString().length() + paramValue.toString());
            }
            dataMap.put("P_SIGN", TransactionManager.doSign(str.toString(), (ParameterMap)moduleSetup));
            str = new StringBuilder();
            for (String name : Constants.PARAMS) {
                str.append(name).append(" = ").append((String)dataMap.get(name)).append("\n");
            }
            transaction.setParameters(str.toString());
            transactionManager.update(transaction);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("TRANSACTION DATA:\n" + str.toString());
            }
            url.value = moduleSetup.get("psb.gate.url");
            params.value = new MapHolder(dataMap);
        });
    }

    public void endTransaction(int contractId, BigDecimal amount, Holder<String> url, Holder<String> mode, Holder<MapHolder<String, String>> params) throws BGException {
    }

    public SearchResult<Autopayment> searchAutopaymentList(int contractId, Period period, String[] sort, Page page) throws Exception {
        SearchResult searchResult = new SearchResult(period, page, sort);
        AutopaymentManager autopaymentManager = new AutopaymentManager(this.getConnection(), this.moduleId);
        autopaymentManager.searchAutopayment(searchResult, contractId);
        return searchResult;
    }

    public void doManualAutopayment(int contractId, BigDecimal sum) throws BGException {
    }

    public Autopayment getAutopaymentCurrentMode(int contractId) throws BGException {
        return null;
    }
}

