/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean.protocol;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.mps.server.bean.Conf;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSException;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSRequest;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSResponse;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.MPSTransactionManager;
import ru.bitel.bgbilling.modules.mps.server.events.MPSBeforePaymentEvent;
import ru.bitel.common.Utils;

public class UepcTransactionManager
extends MPSTransactionManager {
    @Override
    protected byte[] processRequest(Connection con, int moduleId, String mpsId, Conf conf, Conf.MPSSystem system, HttpServletRequest request, HttpServletResponse response) {
        MPSResponse mpsResponse = new MPSResponse(moduleId, mpsId, response);
        mpsResponse.setResult(0);
        try {
            if (system == null || !system.mode) {
                throw new MPSException(9, "Service temporarily unavailable");
            }
            MPSRequest mpsRequest = this.parseRequest(con, moduleId, mpsId, system, request);
            switch (mpsRequest.getAction()) {
                case 2: {
                    Transaction transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), mpsRequest.getTime());
                    if (transaction != null && !transaction.getStatus().equals(TransactionStatus.PAYMENT_PAYED.getCode())) {
                        mpsResponse.setResult(0);
                        mpsResponse.setMessage("payment exist, but it was canceled");
                        break;
                    }
                    if (transaction == null) {
                        Contract contract = this.actionCheck(mpsRequest);
                        this.checkTime(mpsRequest);
                        MPSBeforePaymentEvent event = new MPSBeforePaymentEvent(moduleId, mpsRequest.getSum());
                        event = (MPSBeforePaymentEvent)EventProcessor.getInstance().request((QueueEvent)event);
                        BigDecimal scriptSum = event.getPaymentSum();
                        transaction = this.addTransaction(-1, con, moduleId, mpsId, system, contract.getId(), mpsRequest.getTime(), scriptSum, mpsRequest.getSum(), mpsRequest.getTransId(), mpsRequest.getRawNumber(), mpsRequest.getType(), system.title);
                        mpsResponse.setMessage("payment accepted: " + this.getComment(system, conf, con, contract));
                    } else {
                        Contract contract = new ContractManager(con).getContractById(transaction.getContractId());
                        if (contract != null) {
                            mpsResponse.setMessage("payment has already been accepted: " + this.getComment(system, conf, con, contract));
                        }
                    }
                    mpsResponse.setResult(1);
                    break;
                }
                case 4: {
                    mpsResponse.setMessage("notification of erroneous payments, ok, ignored");
                    mpsResponse.setResult(1);
                }
            }
        }
        catch (MPSException e) {
            this.processError(e, mpsResponse);
        }
        catch (Exception ex) {
            String message = "process request error: " + ex.getMessage();
            this.getLogger().error(message, (Throwable)ex);
            this.processError(new MPSException(-1, message), mpsResponse);
        }
        return this.getResponse(con, system, mpsResponse);
    }

    @Override
    protected MPSRequest parseRequest(Connection con, int moduleId, String mpsId, Conf.MPSSystem system, HttpServletRequest request) throws MPSException {
        this.getLogger().debug("parse request...");
        MPSRequest result = new MPSRequest(con, moduleId, mpsId, request, system);
        String r_id = request.getParameter("id");
        String r_result = request.getParameter("result");
        String r_pay_time = request.getParameter("pay_time");
        String r_account = request.getParameter("account[contract]");
        String r_amount = request.getParameter("amount");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("request parameters: id=" + r_id + "; result=" + r_result + "; pay_time=" + r_pay_time + "; account[contract]=" + r_account + "; amount=" + r_amount);
        }
        if (Utils.isBlankString((String)r_id) || Utils.isBlankString((String)r_result) || Utils.isBlankString((String)r_pay_time) || Utils.isBlankString((String)r_account) || Utils.isBlankString((String)r_amount)) {
            String message = "missing parameters! (id, result, pay_time, account[contract], amount)";
            this.getLogger().error(message);
            throw new MPSException(21, message);
        }
        BigDecimal amount = Utils.parseBigDecimal((String)r_amount, (BigDecimal)BigDecimal.ZERO);
        amount = amount.divide(new BigDecimal(100));
        int res = Utils.parseInt((String)r_result, (int)0);
        result.setAction(res == 1 ? 2 : 4);
        result.setType(0);
        result.setSum(amount);
        result.setTimeString(r_pay_time);
        result.setTime(new Date(Utils.parseLong((String)r_pay_time) * 1000L));
        result.setTransId(r_id);
        result.setNumber(r_account);
        result.setRawNumber(r_account);
        return result;
    }

    @Override
    protected void processError(MPSException ex, MPSResponse response) {
        response.setResult(0);
        response.setMessage(ex.message);
    }

    @Override
    protected List<Transaction> getTransactionListFromFile(Conf.MPSSystem system, String file) {
        return null;
    }

    @Override
    protected byte[] getResponse(Connection con, Conf.MPSSystem system, MPSResponse response) {
        try {
            return ((response.getResult() == 1 ? "OK" : "ERROR") + ": " + response.getMessage()).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

