/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.documents.client.pattern;

import bitel.billing.module.common.BGControlPanelDateNoB;
import bitel.billing.module.common.BGDialog;
import bitel.billing.module.common.BGTextArea;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPref;
import ru.bitel.bgbilling.kernel.contract.param.common.bean.ContractParameterPrefType;
import ru.bitel.bgbilling.kernel.contract.param.common.service.ContractParameterServiceOld;
import ru.bitel.bgbilling.kernel.customer.common.bean.Customer;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentVariable;
import ru.bitel.bgbilling.plugins.documents.common.bean.DocumentVariableType;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.model.IdTitle;

public class VariableEditorDialog
extends BGDialog {
    private JPanel mainPanel = new JPanel(new GridBagLayout());
    private BGTextArea toolTipText = new BGTextArea(3, 50);
    private BGTextField variableName = new BGTextField(20);
    private JComboBox<DocumentVariableType> variableType = new JComboBox<DocumentVariableType>(DocumentVariableType.values());
    private BGTextField oneLineVariableValue = new BGTextField(20);
    private BGTextArea multiLineVariableValue = new BGTextArea(3, 20);
    private JScrollPane scrollPane = new JScrollPane((Component)this.multiLineVariableValue);
    private BGControlPanelDateNoB dateCalendarValue = new BGControlPanelDateNoB();
    private BGTextField additionalDateParamValue = new BGTextField(20);
    private BGUComboBox<IdTitle> dateVariableCombobox = new BGUComboBox();
    private BGUComboBox<ContractParameterPrefType> contractParamType = new BGUComboBox();
    private BGUComboBox<ContractParameterPref> contractParam = new BGUComboBox();
    private BGUList<KeyValue> customerParamList = new BGUList();
    private JPanel valuePanel = new JPanel(new GridBagLayout());
    private BGButtonPanel buttonPanel = new BGButtonPanel(new BGButtonPanel.ButtonItem[]{BGButtonPanel.OK, BGButtonPanel.CANCEL});
    private boolean isNew = true;
    private DocumentVariable currentVariable;
    private List<DocumentVariable> existVarList;

    private VariableEditorDialog(DocumentVariable variable, boolean isNew) {
        super(null, "\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439", Dialog.ModalityType.APPLICATION_MODAL);
        this.isNew = isNew;
        this.currentVariable = variable;
        this.jbInit();
        this.setData();
        this.moveWindowToCenterScreen();
    }

    private void jbInit() {
        this.toolTipText.setEditable(false);
        this.contractParamType.setModel(this.getParamTypeModel());
        this.dateVariableCombobox.addItem((Object)new IdTitle(0, "\u0412\u044b\u0431\u043e\u0440 \u0434\u0430\u0442\u044b \u0438\u0437 \u043a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044f"));
        this.dateVariableCombobox.addItem((Object)new IdTitle(1, "\u0422\u0435\u043a\u0443\u0449\u0430\u044f \u0434\u0430\u0442\u0430"));
        this.dateVariableCombobox.addItem((Object)new IdTitle(2, "\u0414\u0430\u0442\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430"));
        this.mainPanel.add((Component)this.getLeftPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 1, new Insets(5, 10, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.valuePanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(5, 30, 5, 10), 0, 0));
        this.mainPanel.add((Component)new JScrollPane((Component)this.toolTipText), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 11, 1, new Insets(5, 10, 0, 10), 0, 0));
        this.mainPanel.add((Component)this.buttonPanel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(15, 5, 10, 5), 0, 0));
        this.getContentPane().setLayout(new GridBagLayout());
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(800, 300));
        this.add(this.mainPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.variableType.setEnabled(this.isNew);
        this.variableType.addActionListener(actionEvent -> {
            this.oneLineVariableValue.setText("");
            this.multiLineVariableValue.setText("");
            this.additionalDateParamValue.setText("");
            DocumentVariableType type = (DocumentVariableType)this.variableType.getSelectedItem();
            if (type != null) {
                switch (type) {
                    case CONST: {
                        this.valuePanel.removeAll();
                        this.valuePanel.add((Component)new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
                        this.valuePanel.add((Component)this.oneLineVariableValue, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 11, 2, new Insets(2, 0, 0, 0), 0, 0));
                        this.redraw();
                        if (this.currentVariable != null) {
                            this.oneLineVariableValue.setText(this.currentVariable.getValue());
                        } else {
                            this.oneLineVariableValue.setPromptText("<\u043a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0430>", true, true);
                        }
                        this.toolTipText.setText("\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u044b \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0435 \u043c\u0430\u043a\u0440\u043e\u043f\u043e\u0434\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438: ${contract_title} - \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430; ${contract_comment} - \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430; ${current_user} - \u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c; ${user_<id>} - \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u0441 \u043a\u043e\u0434\u043e\u043c <id>");
                        break;
                    }
                    case CONTRACT_PARAM: {
                        this.valuePanel.removeAll();
                        this.valuePanel.add((Component)new JLabel("\u0422\u0438\u043f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
                        this.valuePanel.add((Component)this.contractParamType, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(2, 0, 0, 0), 0, 0));
                        this.valuePanel.add((Component)new JLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
                        this.valuePanel.add((Component)this.contractParam, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 11, 2, new Insets(2, 0, 0, 0), 0, 0));
                        this.redraw();
                        if (this.currentVariable != null) {
                            this.contractParamType.setSelectedItem((Object)ContractParameterPrefType.getType((int)Utils.parseInt((String)this.currentVariable.getAdditionalParam(), (int)1)));
                        } else {
                            this.contractParamType.setSelectedIndex(0);
                        }
                        this.toolTipText.setText("");
                        break;
                    }
                    case CUSTOMER_PARAM: {
                        ArrayList<KeyValue> values = new ArrayList<KeyValue>();
                        values.addAll(Customer.F_VALUES.stream().map(a -> new KeyValue(a.key(), "\u0424\u0438\u0437.:" + a.description() + " [" + a.key() + "]")).toList());
                        values.addAll(Stream.of(Customer.CustomerFizDocument.values()).map(a -> new KeyValue(a.key(), "\u0424\u0438\u0437.\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442: " + a.description() + " [" + a.key() + "]")).toList());
                        values.addAll(Customer.U_VALUES.stream().map(a -> new KeyValue(a.key(), "\u042e\u0440.: " + a.description() + " [" + a.key() + "]")).toList());
                        values.addAll(Customer.U_BANK_VALUES.stream().map(a -> new KeyValue(a.key(), "\u042e\u0440.\u0411\u0430\u043d\u043a: " + a.description() + " [" + a.key() + "]")).toList());
                        values.addAll(Customer.U_DIRECTOR_VALUES.stream().map(a -> new KeyValue(a.key(), "\u042e\u0440.\u0420\u0443\u043a\u043e\u0432\u043e\u0434\u0438\u0442\u0435\u043b\u043b\u044c: " + a.description() + " [" + a.key() + "]")).toList());
                        values.addAll(Customer.CONTACT_VALUES.stream().map(a -> new KeyValue(a.key(), "\u041a\u043e\u043d\u0442\u0430\u043a\u0442: " + a.description() + " [" + a.key() + "]")).toList());
                        this.customerParamList.setData(values);
                        this.customerParamList.setSelectionMode(0);
                        this.valuePanel.removeAll();
                        this.valuePanel.add((Component)new JScrollPane((Component)this.customerParamList), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 0, 0, 0), 0, 0));
                        this.redraw();
                        if (this.currentVariable != null) {
                            ClientUtils.setKeyValueListSelection(this.customerParamList, (String)this.currentVariable.getValue(), null);
                        }
                        this.toolTipText.setText("");
                        break;
                    }
                    case DATE: {
                        this.additionalDateParamValue.setPromptText("\u041d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, dd.MM.yyyy", true, true);
                        this.valuePanel.removeAll();
                        this.valuePanel.add((Component)new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
                        this.valuePanel.add((Component)this.dateVariableCombobox, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 0, 0, 0), 0, 0));
                        this.valuePanel.add((Component)this.dateCalendarValue, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 10, 0, 0), 0, 0));
                        this.valuePanel.add((Component)new JLabel("\u0424\u043e\u0440\u043c\u0430\u0442 \u0434\u0430\u0442\u044b"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
                        this.valuePanel.add((Component)this.additionalDateParamValue, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 5, 0), 0, 0));
                        this.redraw();
                        if (this.currentVariable != null) {
                            String dt = this.currentVariable.getValue();
                            if (dt.contains("${contract_date}") || dt.contains("${date_now}")) {
                                if (dt.contains("${contract_date}")) {
                                    this.dateVariableCombobox.setSelectedIndex(2);
                                } else {
                                    this.dateVariableCombobox.setSelectedIndex(1);
                                }
                            } else {
                                this.dateVariableCombobox.setSelectedIndex(0);
                                this.dateCalendarValue.setDateString(this.currentVariable.getValue());
                            }
                            this.additionalDateParamValue.setText(this.currentVariable.getAdditionalParam());
                        } else {
                            this.dateVariableCombobox.setSelectedIndex(0);
                            this.dateCalendarValue.setLocalDate(LocalDate.now());
                        }
                        this.toolTipText.setText("");
                        break;
                    }
                    case URL: {
                        this.valuePanel.removeAll();
                        this.valuePanel.add((Component)new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
                        this.valuePanel.add((Component)this.oneLineVariableValue, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 11, 2, new Insets(2, 0, 0, 0), 0, 0));
                        this.redraw();
                        if (this.currentVariable != null) {
                            this.oneLineVariableValue.setText(this.currentVariable.getValue());
                        } else {
                            this.oneLineVariableValue.setPromptText("http://<\u0430\u0434\u0440\u0435\u0441>", true, true);
                        }
                        this.toolTipText.setText("");
                        break;
                    }
                    case SQL: {
                        this.valuePanel.removeAll();
                        this.valuePanel.add((Component)new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
                        this.valuePanel.add((Component)this.scrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 0, 0, 0), 0, 0));
                        this.redraw();
                        if (this.currentVariable != null) {
                            this.multiLineVariableValue.setText(this.currentVariable.getValue());
                        } else {
                            this.multiLineVariableValue.setPromptText("SELECT <\u0438\u043c\u044f_\u043f\u043e\u043b\u044f> FROM <\u0438\u043c\u044f_\u0442\u0430\u0431\u043b\u0438\u0446\u044b>", true, false);
                        }
                        this.toolTipText.setText("\u0412 SQL-\u0437\u0430\u043f\u0440\u043e\u0441\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u0430\u043a\u0440\u043e\u043f\u043e\u0434\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 ${cid} - \u043a\u043e\u0434 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430");
                        break;
                    }
                    case BARCODE: {
                        this.valuePanel.removeAll();
                        this.valuePanel.add((Component)new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
                        this.valuePanel.add((Component)this.scrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 0, 0, 0), 0, 0));
                        this.redraw();
                        if (this.currentVariable != null) {
                            this.multiLineVariableValue.setText(this.currentVariable.getValue());
                        } else {
                            String helpMessage = "\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u0448\u0442\u0440\u0438\u0445-\u043a\u043e\u0434\u0430 \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u0442\u0440\u043e\u043a\u043e\u0439, \u0432 \u043a\u043e\u0442\u043e\u0440\u043e\u0439 \u0437\u0430\u0434\u0430\u0435\u0442\u0441\u044f \u0440\u0430\u0437\u043c\u0435\u0440 \u0438 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435 \u0448\u0442\u0440\u0438\u0445-\u043a\u043e\u0434\u0430. \u0424\u043e\u0440\u043c\u0430\u0442 \u0441\u0442\u0440\u043e\u043a\u0438: MxN;text. \u0417\u0434\u0435\u0441\u044c M - \u0448\u0438\u0440\u0438\u043d\u0430, N - \u0432\u044b\u0441\u043e\u0442\u0430, text - \u0442\u0435\u043a\u0441\u0442\u043e\u0432\u043e\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u0435, \u043a\u043e\u0442\u043e\u0440\u043e\u0435 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0437\u0430\u043a\u043e\u0434\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432 \u0448\u0442\u0440\u0438\u0445-\u043a\u043e\u0434\u0435.\u041f\u0440\u0438 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e\u0441\u0442\u0438 \u043c\u043e\u0436\u043d\u043e \u0434\u0435\u043b\u0430\u0442\u044c \u0441\u0441\u044b\u043b\u043a\u0438 \u043d\u0430 \u0434\u0440\u0443\u0433\u0438\u0435 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0435, \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0435 \u0432 \u0434\u0430\u043d\u043d\u043e\u043c \u0448\u0430\u0431\u043b\u043e\u043d\u0435 \u043f\u0443\u0442\u0435\u043c \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u044f \u0438\u043c\u0435\u043d\u0438 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 \u0432 \u0444\u0438\u0433\u0443\u0440\u043d\u044b\u0445 \u0441\u043a\u043e\u0431\u043a\u0430\u0445.\u041d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, {param} \u043e\u0437\u043d\u0430\u0447\u0430\u0435\u0442, \u0447\u0442\u043e \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u0437\u044f\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 param \u0438\u0437 \u044d\u0442\u043e\u0433\u043e \u0436\u0435 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u0438 \u043f\u043e\u0434\u0441\u0442\u0430\u0432\u0438\u0442\u044c \u0435\u0435 \u043d\u0430 \u043c\u0435\u0441\u0442\u043e \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0439 \u0441\u0441\u044b\u043b\u043a\u0438.";
                            this.multiLineVariableValue.setPromptText(helpMessage, true, false);
                        }
                        this.toolTipText.setText("\u0412 \u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 \u043c\u043e\u0436\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0441\u0441\u044b\u043b\u043a\u0438 \u043d\u0430 \u0434\u0440\u0443\u0433\u0438\u0435 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u0435 \u0448\u0430\u0431\u043b\u043e\u043d\u0430 \u043f\u0443\u0442\u0435\u043c \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u044f \u0438\u043c\u0435\u043d\u0438 \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 \u0432 \u0444\u0438\u0433\u0443\u0440\u043d\u044b\u0445 \u0441\u043a\u043e\u0431\u043a\u0430\u0445. \u041d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, {param}");
                        break;
                    }
                    case NONE: {
                        this.valuePanel.removeAll();
                        this.toolTipText.setText("");
                        this.redraw();
                        break;
                    }
                }
            }
            this.pack();
        });
        this.contractParamType.addActionListener(actionEvent -> {
            ContractParameterPrefType selectedType = (ContractParameterPrefType)this.contractParamType.getSelectedItem();
            if (selectedType != null) {
                try {
                    List params = ((ContractParameterServiceOld)this.getContext().getPort(ContractParameterServiceOld.class)).getContractParameterPrefList(selectedType.getId());
                    this.contractParam.setData(params);
                    if (this.currentVariable != null && this.contractParamType.getSelectedItem() == ContractParameterPrefType.getType((int)Utils.parseInt((String)this.currentVariable.getAdditionalParam(), (int)1))) {
                        this.contractParam.setSelectedItem((Object)Utils.parseInt((String)this.currentVariable.getValue(), (int)1));
                    }
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        });
        this.buttonPanel.addActionListener(actionEvent -> {
            String actionCommand = actionEvent.getActionCommand();
            if (BGButtonPanel.CANCEL.command.equals(actionCommand)) {
                this.dispose();
            } else {
                DocumentVariableType selectedType;
                if (Utils.isBlankString((String)this.variableName.getText())) {
                    BGToolTip.showErrorMessage((JComponent)this.variableName, (String)"\u041f\u043e\u043b\u0435 \u0418\u043c\u044f \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u043e \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u044b\u043c!");
                }
                if ((selectedType = (DocumentVariableType)this.variableType.getSelectedItem()).equals((Object)DocumentVariableType.NONE)) {
                    BGToolTip.showErrorMessage((JComponent)this.variableName, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0442\u0438\u043f \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439!");
                }
                DocumentVariable current = new DocumentVariable(this.variableName.getText());
                current.setType(selectedType);
                switch (current.getType()) {
                    case CONTRACT_PARAM: {
                        ContractParameterPrefType typeSelectedItem = (ContractParameterPrefType)this.contractParamType.getSelectedItem();
                        if (typeSelectedItem == null) break;
                        current.setAdditionalParam(String.valueOf(typeSelectedItem.getId()));
                        ContractParameterPref paramSelectedItem = (ContractParameterPref)this.contractParam.getSelectedItem();
                        if (paramSelectedItem == null) {
                            BGToolTip.showErrorMessage((JComponent)this.buttonPanel, (String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0443\u044e!");
                            return;
                        }
                        current.setValue(String.valueOf(paramSelectedItem.getId()));
                        break;
                    }
                    case CUSTOMER_PARAM: {
                        KeyValue item = (KeyValue)this.customerParamList.getSelectedValue();
                        if (item == null) {
                            BGToolTip.showErrorMessage((JComponent)((JComponent)this.customerParamList.getParent()), (String)"\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0432\u044b\u0431\u0440\u0430\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435!");
                            return;
                        }
                        current.setValue(item.getKey());
                        break;
                    }
                    case DATE: {
                        String format = this.additionalDateParamValue.getText();
                        if (!Utils.notBlankString((String)format)) {
                            format = "dd.MM.yyyy";
                        }
                        current.setAdditionalParam(format);
                        IdTitle selectedDateValue = (IdTitle)this.dateVariableCombobox.getSelectedItem();
                        if (selectedDateValue == null) break;
                        current.setValue(selectedDateValue.getId() == 0 ? TimeUtils.format((Calendar)this.dateCalendarValue.getDateCalendar(), (String)"dd.MM.yyyy") : (selectedDateValue.getId() == 1 ? "${date_now}" : "${contract_date}"));
                        break;
                    }
                    case CONST: 
                    case URL: {
                        current.setValue(this.oneLineVariableValue.getText());
                        break;
                    }
                    case SQL: 
                    case BARCODE: {
                        current.setValue(this.multiLineVariableValue.getText());
                        break;
                    }
                }
                for (DocumentVariable var : this.existVarList) {
                    if (!var.equals((Object)current)) continue;
                    BGToolTip.showErrorMessage((JComponent)this.variableName, (String)"\u041f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u0430\u044f \u0441 \u0442\u0430\u043a\u0438\u043c \u0438\u043c\u0435\u043d\u0435\u043c \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442! \u041f\u043e\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0437\u0430\u0434\u0430\u0442\u044c \u0434\u0440\u0443\u0433\u043e\u0435 \u0438\u043c\u044f!");
                    this.variableName.setText(current.getTitle());
                    return;
                }
                this.currentVariable = current;
                this.dispose();
            }
        });
        this.dateVariableCombobox.addActionListener(actionEvent -> {
            IdTitle selectedItem = (IdTitle)this.dateVariableCombobox.getSelectedItem();
            if (selectedItem != null) {
                this.dateCalendarValue.setEnabled(selectedItem.getId() == 0);
            }
        });
        this.variableType.setSelectedIndex(0);
        this.contractParamType.setSelectedIndex(0);
    }

    private JPanel getLeftPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u0418\u043c\u044f \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)this.variableName, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 1, new Insets(2, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u0422\u0438\u043f \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        panel.add(this.variableType, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 2, new Insets(2, 0, 0, 0), 0, 0));
        return panel;
    }

    public void setData() {
        if (this.currentVariable != null) {
            this.variableName.setText(this.currentVariable.getTitle());
            this.variableType.setSelectedItem(this.currentVariable.getType());
        }
    }

    private DefaultComboBoxModel<ContractParameterPrefType> getParamTypeModel() {
        DefaultComboBoxModel<ContractParameterPrefType> result = new DefaultComboBoxModel<ContractParameterPrefType>();
        result.addElement(ContractParameterPrefType.TYPE_TEXT);
        result.addElement(ContractParameterPrefType.TYPE_ADDRESS);
        result.addElement(ContractParameterPrefType.TYPE_EMAIL);
        result.addElement(ContractParameterPrefType.TYPE_FLAG);
        result.addElement(ContractParameterPrefType.TYPE_DATE);
        result.addElement(ContractParameterPrefType.TYPE_LIST);
        result.addElement(ContractParameterPrefType.TYPE_CONTRACT_REF);
        result.addElement(ContractParameterPrefType.TYPE_PHONE);
        return result;
    }

    static DocumentVariable showVariableEditor(DocumentVariable var, List<DocumentVariable> varList, boolean isNew) {
        VariableEditorDialog dialog = new VariableEditorDialog(var, isNew);
        dialog.existVarList = varList;
        dialog.setVisible(true);
        return dialog.currentVariable;
    }

    private void redraw() {
        this.mainPanel.repaint();
        this.mainPanel.updateUI();
    }
}

