/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractService;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ContractServiceManager {
    private Connection con;

    public ContractServiceManager(Connection con) {
        this.con = con;
    }

    public List<ContractService> getContractServiceList(int cid, int mid) {
        ArrayList<ContractService> result = new ArrayList<ContractService>();
        try {
            String query = "SELECT contract_service.*, service.title FROM contract_service INNER JOIN service ON contract_service.sid=service.id AND service.mid=? WHERE cid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, mid);
            ps.setInt(2, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs, true));
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public List<ContractService> getContractServiceList(int cid, Calendar date) {
        ArrayList<ContractService> result = new ArrayList<ContractService>();
        try {
            String query = "SELECT * FROM contract_service WHERE cid=? AND ( ? IS NULL OR ( (date1<=?) AND (date2 IS NULL OR date2>=?) ) ) ORDER BY date1";
            PreparedStatement ps = this.con.prepareStatement(query);
            java.sql.Date sqlDate = TimeUtils.convertCalendarToSqlDate((Calendar)date);
            ps.setInt(1, cid);
            ps.setDate(2, sqlDate);
            ps.setDate(3, sqlDate);
            ps.setDate(4, sqlDate);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs, false));
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public List<ContractService> getContractServiceList(int cid, int mid, Date date) {
        ArrayList<ContractService> result = new ArrayList<ContractService>();
        try {
            String query = "SELECT * FROM contract_service as cs  INNER JOIN service ON cs.sid=service.id  WHERE cs.cid=? AND (? IS NULL OR ((cs.date1<=?) AND (cs.date2 IS NULL OR cs.date2>=?))) AND service.mid=? ORDER BY cs.date1";
            PreparedStatement ps = this.con.prepareStatement(query);
            java.sql.Date sqlDate = TimeUtils.convertDateToSqlDate((Date)date);
            ps.setInt(1, cid);
            ps.setDate(2, sqlDate);
            ps.setDate(3, sqlDate);
            ps.setDate(4, sqlDate);
            ps.setInt(5, mid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs, false));
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public Set<Integer> getContractServiceSet(int cid, Date date) {
        HashSet<Integer> result = new HashSet<Integer>();
        for (ContractService cs : this.getContractServiceList(cid, TimeUtils.convertDateToCalendar((Date)date))) {
            result.add(cs.getServiceId());
        }
        return result;
    }

    public ContractService getContractServiceById(int id) {
        ContractService result = null;
        try {
            String query = "SELECT * FROM contract_service WHERE id=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getFromRS(rs, false);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    @Deprecated
    public ContractService getContractServiceByID(int id) {
        return this.getContractServiceById(id);
    }

    public void updateContractService(String id, ContractService value) {
        try {
            PreparedStatement ps;
            if (id.equals("new")) {
                String query = "INSERT INTO contract_service (cid, sid, date1, date2, comment) VALUES (?, ?, ?, ?, ?)";
                ps = this.con.prepareStatement(query, 1);
            } else {
                String query = "UPDATE contract_service SET cid=?, sid=?, date1=?, date2=?, comment=? WHERE id=?";
                ps = this.con.prepareStatement(query);
                ps.setInt(6, Utils.parseInt((String)id, (int)-1));
            }
            ps.setInt(1, value.getContractId());
            ps.setInt(2, value.getServiceId());
            ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)value.getDateFrom()));
            ps.setDate(4, TimeUtils.convertDateToSqlDate((Date)value.getDateTo()));
            ps.setString(5, value.getComment());
            ps.executeUpdate();
            if (id.equals("new")) {
                value.setId(ServerUtils.lastInsertId(ps));
            } else {
                value.setId(Utils.parseInt((String)id, (int)-1));
            }
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteContractService(int id) {
        try {
            PreparedStatement ps = this.con.prepareStatement("DELETE FROM contract_service WHERE id=?");
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void deleteContractService(int contractId, int moduleId) {
        PreparedStatement ps;
        ArrayList<Integer> idlist = new ArrayList<Integer>();
        Object query = "SELECT csrv.id FROM service as srv LEFT JOIN contract_service as csrv ON csrv.sid=srv.id WHERE srv.mid=? AND csrv.cid=?";
        try {
            ps = this.con.prepareStatement((String)query);
            try {
                ps.setInt(1, moduleId);
                ps.setInt(2, contractId);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        idlist.add(rs.getInt(1));
                    }
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (!idlist.isEmpty()) {
            query = "DELETE FROM contract_service WHERE id IN (" + Utils.toString(idlist) + ")";
            try {
                ps = this.con.prepareStatement((String)query);
                try {
                    ps.executeUpdate();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void deleteContractService(String ids) {
        try {
            PreparedStatement ps = this.con.prepareStatement("DELETE FROM contract_service WHERE id IN (" + ids + ")");
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private ContractService getFromRS(ResultSet rs, boolean titleLoad) throws SQLException {
        return ContractService.builder().setId(rs.getInt("id")).setContractId(rs.getInt("cid")).setServiceId(rs.getInt("sid")).setDateFrom(rs.getDate("date1")).setDateTo(rs.getDate("date2")).setComment(rs.getString("comment")).setServiceTitle(titleLoad ? rs.getString("title") : "").build();
    }

    public List<ContractService> getContractServiceList(int contractId, List<Integer> serviceIds, Calendar date1, Calendar date2) {
        ArrayList<ContractService> result = new ArrayList<ContractService>();
        String query = "SELECT * FROM contract_service WHERE cid=? AND (date1 IS NULL OR TO_DAYS(date1)<=TO_DAYS(?)) AND (date2 IS NULL OR TO_DAYS(date2)>=TO_DAYS(?)) AND sid IN (" + Utils.toString(serviceIds) + ")";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)date1));
            ps.setDate(3, TimeUtils.convertCalendarToSqlDate((Calendar)date2));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(this.getFromRS(rs, false));
                }
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return result;
    }
}

