/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.network.radius;

import bitel.billing.server.util.RequestCounter;
import java.beans.ConstructorProperties;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.admin.errorlog.common.bean.AlarmErrorMessage;
import ru.bitel.bgbilling.kernel.admin.errorlog.server.AlarmSender;
import ru.bitel.bgbilling.kernel.network.processor.ProcessorListener;
import ru.bitel.bgbilling.kernel.network.processor.ProcessorRequest;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorkerContext;
import ru.bitel.bgbilling.kernel.network.radius.RadiusProcessor;
import ru.bitel.bgbilling.kernel.network.radius.datalog.hourly.RadiusHourlyDataLogger;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.io.DatagramChannelListener;
import ru.bitel.common.jmx.MBeanAttribute;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.common.worker.WorkerTask;

public class RadiusListener<N extends Nas<?, ?, ?>>
extends DatagramChannelListener
implements ProcessorListener {
    private static final Logger logger = LogManager.getLogger();
    @Deprecated
    public static RequestCounter accountingStartCounter = new RequestCounter(60);
    @Deprecated
    public static RequestCounter accountingStopCounter = new RequestCounter(60);
    @Deprecated
    public static RequestCounter accountingUpdateCounter = new RequestCounter(60);
    @Deprecated
    public static RequestCounter authenticationAcceptCounter = new RequestCounter(60);
    @Deprecated
    public static RequestCounter authenticationRejectCounter = new RequestCounter(60);
    @Deprecated
    public static RequestCounter authenticationIgnoreCount = new RequestCounter(60);
    @Deprecated
    public static RequestCounter accountingUpdateIgnoreCount = new RequestCounter(60);
    @Deprecated
    public static RequestCounter antispamIgnoreCount = new RequestCounter(60);
    protected final Mode mode;
    protected final Setup setup;
    protected final RadiusProcessor<?, N, ?> processor;
    protected final RadiusHourlyDataLogger dataLogger;
    private final ThreadPoolExecutor executorService;
    private final BlockingQueue<Runnable> workQueue;
    private volatile boolean skipAccountingRequestsOnSlow = false;
    private volatile int slow1QueueSize;
    private volatile int slow2QueueSize;
    private volatile int maxQueueSize;
    protected String threadCountParamName;
    protected String threadQueueParamName;
    private String listenerType;
    private final boolean autoCommit;

    @ConstructorProperties(value={"host", "port", "recvBufferSize", "soRCVBUF", "processor", "mode", "setup", "dataLogger", "threadCount", "maxQueueSize", "defaultAutoCommit"})
    public RadiusListener(String host, int port, int byteBufferCapacity, int socketRcvBuf, RadiusProcessor<?, N, ?> processor, Mode mode, Setup setup, RadiusHourlyDataLogger dataLogger, int threadCount, int maxQueueSize, Boolean defaultAutoCommit) {
        super(host, port, byteBufferCapacity, socketRcvBuf);
        int poolThreadCount;
        accountingStartCounter = processor.accountingStartCounter;
        accountingStopCounter = processor.accountingStopCounter;
        accountingUpdateCounter = processor.accountingUpdateCounter;
        authenticationAcceptCounter = processor.authenticationAcceptCounter;
        authenticationRejectCounter = processor.authenticationRejectCounter;
        authenticationIgnoreCount = processor.authenticationIgnoreCount;
        accountingUpdateIgnoreCount = processor.accountingUpdateIgnoreCount;
        antispamIgnoreCount = processor.antispamIgnoreCount;
        this.processor = processor;
        this.dataLogger = dataLogger;
        this.mode = mode;
        this.setup = setup;
        if (threadCount > 0 && maxQueueSize > 0) {
            poolThreadCount = threadCount;
            this.maxQueueSize = maxQueueSize;
        } else {
            switch (mode) {
                case authentication: {
                    poolThreadCount = setup.getInt("auth.thread.count", 10);
                    int poolThreadMustBeFree = setup.getInt("auth.thread.must.be.free.count", 2);
                    this.maxQueueSize = setup.getInt("auth.thread.queue", poolThreadCount - poolThreadMustBeFree);
                    break;
                }
                case accounting: {
                    poolThreadCount = setup.getInt("acct.thread.count", 10);
                    int poolThreadMustBeFree = setup.getInt("acct.thread.must.be.free.count", 2);
                    this.maxQueueSize = setup.getInt("acct.thread.queue", poolThreadCount - poolThreadMustBeFree);
                    break;
                }
                default: {
                    poolThreadCount = setup.getInt("acct.thread.count", 10);
                    this.maxQueueSize = setup.getInt("acct.thread.queue", 8);
                }
            }
        }
        switch (mode) {
            case authentication: {
                this.listenerType = "\u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0445";
                this.threadCountParamName = "auth.thread.count";
                this.threadQueueParamName = "auth.thread.queue";
                break;
            }
            case accounting: {
                this.listenerType = "\u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0438\u043d\u0433";
                this.threadCountParamName = "acct.thread.count";
                this.threadQueueParamName = "acct.thread.queue";
                break;
            }
            default: {
                this.listenerType = "\u0440\u0430\u0434\u0438\u0443\u0441";
                this.threadCountParamName = "thread.count";
                this.threadQueueParamName = "acct.thread.queue";
            }
        }
        this.executorService = (ThreadPoolExecutor)WorkerTask.newFixedThreadPool("rdsLstnr", "radius", this, poolThreadCount);
        this.workQueue = this.executorService.getQueue();
        this.setMaxQueueSize(this.maxQueueSize);
        int autoCommit = Boolean.TRUE.equals(defaultAutoCommit) ? 1 : 0;
        ModuleSetup moduleSetup = setup.getModuleSetup(Integer.valueOf(processor.moduleId));
        this.autoCommit = moduleSetup != null ? moduleSetup.getInt("radius.listener.autoCommit", setup.getInt("radius.listener.autoCommit", autoCommit)) > 0 : setup.getInt("radius.listener.autoCommit", autoCommit) > 0;
    }

    @Override
    public ThreadContext newThreadContext() {
        return new RadiusListenerWorkerContext(this.setup, this.processor.moduleId, this.autoCommit, this.dataLogger);
    }

    @Override
    public ProcessorRequest<?> newRequest(SocketAddress clientAddress, long millis, ByteBuffer data, int overloadLevel) {
        return new RadiusListenerWorker(this, clientAddress, millis, data, overloadLevel);
    }

    @Override
    public void onPacket(SocketAddress clientAddress, ByteBuffer data) {
        int overloadLevel;
        long millis = System.currentTimeMillis();
        byte packetType = data.get(0);
        int queueSize = this.workQueue.size();
        if (queueSize > this.slow1QueueSize) {
            if (queueSize > this.slow2QueueSize) {
                if (queueSize > this.maxQueueSize) {
                    String key;
                    overloadLevel = 3;
                    if (queueSize > 100) {
                        this.workQueue.poll();
                    }
                    if (AlarmSender.needAlarmSend(key = "radius.wait.thread", millis, 40000L)) {
                        String message = "\u0412 \u0440\u0430\u043c\u043a\u0430\u0445 \u043e\u0442\u0432\u0435\u0434\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u044b\u043c\u0438 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430 \u043f\u043e\u0442\u043e\u043a\u043e\u0432 " + this.threadCountParamName + "=" + this.executorService.getMaximumPoolSize() + " \u0438 \u0440\u0430\u0437\u043c\u0435\u0440\u043e\u043c \u043e\u0447\u0435\u0440\u0435\u0434\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 " + this.threadQueueParamName + "=" + this.maxQueueSize + " RADIUS \u0441\u0435\u0440\u0432\u0435\u0440 \u043d\u0435 \u0443\u0441\u043f\u0435\u0435\u0432\u0430\u0435\u0442 \u043f\u0440\u043e\u0438\u0437\u0432\u043e\u0434\u0438\u0442\u044c \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0443 " + this.listenerType + " \u0437\u0430\u043f\u0440\u043e\u0441\u043e\u0432.\n\u0412\u043e\u0437\u043c\u043e\u0436\u043d\u0430\u044f \u043f\u0440\u0438\u0447\u0438\u043d\u0430 - \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043d\u043e\u0441\u0442\u044c \u0431\u0430\u0437\u044b \u0434\u0430\u043d\u043d\u044b\u0445.\n\n" + this.processor.getStatus();
                        AlarmErrorMessage alarm = new AlarmErrorMessage(key, "RADIUS \u0441\u0435\u0440\u0432\u0435\u0440 \u043d\u0435 \u0443\u0441\u043f\u0435\u0432\u0430\u0435\u0442 \u043e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441\u044b", message);
                        alarm.setDumpStackTrace(true);
                        AlarmSender.sendAlarm(alarm, millis);
                        logger.error("RadiusListener " + this.mode + " queue is full!");
                    } else {
                        logger.warn("RadiusListener " + this.mode + " queue is full!");
                    }
                    if (packetType == 1) {
                        logger.warn("Auth packet skipping.");
                        this.processor.authenticationIgnoreCount.addRequestCount();
                        return;
                    }
                } else {
                    overloadLevel = 2;
                }
            } else {
                overloadLevel = 1;
            }
        } else {
            overloadLevel = 0;
        }
        this.executorService.execute(this.newRequest(clientAddress, millis, data, overloadLevel));
    }

    public Thread startListener() {
        if (!this.inited) {
            throw new IllegalStateException("ChannelListener not inited");
        }
        Thread result = new Thread((Runnable)this, this.getClass().getSimpleName());
        result.start();
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(super.toString()).append(' ').append('[');
        this.toString(result);
        result.append(']');
        return result.toString();
    }

    protected void toString(StringBuilder result) {
        ThreadPoolExecutor pool = this.executorService;
        if (pool != null) {
            result.append("queue_size: ");
            result.append(pool.getQueue().size());
            result.append("; threads_active: ");
            result.append(pool.getActiveCount());
            result.append("; largest: ");
            result.append(pool.getLargestPoolSize());
            result.append("; core: ");
            result.append(pool.getCorePoolSize());
            result.append("; pool_size: ");
            result.append(pool.getPoolSize());
            result.append("; ");
        }
        DecimalFormat df = new DecimalFormat("###,###,###,###");
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setGroupingSeparator(' ');
        df.setDecimalFormatSymbols(dfs);
        try {
            if (this.channel.isOpen()) {
                result.append("recv_socket_buf_size: ");
                result.append(df.format(this.channel.socket().getReceiveBufferSize()));
            }
        }
        catch (SocketException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        result.append("; recv_buf_size: ").append(df.format(this.byteBufferCapacity));
        try {
            if (!this.channel.isOpen()) {
                result.append("; closed");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @MBeanAttribute
    public int getThreadCount() {
        return this.executorService.getMaximumPoolSize();
    }

    public void setThreadCount(int count) {
        this.executorService.setCorePoolSize(count);
        this.executorService.setMaximumPoolSize(count);
    }

    @MBeanAttribute
    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
        int delta = this.maxQueueSize / 10;
        this.slow1QueueSize = Math.min(this.maxQueueSize, Math.max(this.maxQueueSize - 3 * delta, 10));
        this.slow2QueueSize = Math.min(this.maxQueueSize, Math.max(this.maxQueueSize - 1 * delta, 15));
    }

    @MBeanAttribute
    public int getSlow1QueueSize() {
        return this.slow1QueueSize;
    }

    @MBeanAttribute
    public int getSlow2QueueSize() {
        return this.slow2QueueSize;
    }

    @MBeanAttribute
    public int getCurrentThreadCount() {
        return this.executorService.getPoolSize();
    }

    @MBeanAttribute
    public int getActiveThreadCount() {
        return this.executorService.getActiveCount();
    }

    @MBeanAttribute
    public long getTaskCount() {
        return this.executorService.getTaskCount();
    }

    @MBeanAttribute
    public long getQueueSize() {
        return this.workQueue.size();
    }

    @MBeanAttribute
    public boolean isSkipAccountingRequestsOnSlow() {
        return this.skipAccountingRequestsOnSlow;
    }

    public void setSkipAccountingRequestsOnSlow(boolean skipAccountingRequestsOnSlow) {
        this.skipAccountingRequestsOnSlow = skipAccountingRequestsOnSlow;
    }

    public static enum Mode {
        authentication,
        accounting,
        both;

    }
}

