/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Contractable;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.LogEntry;

public abstract class LoggingAbstractManager<B extends Id>
extends AbstractIdDao<B> {
    protected int userId = 0;

    public LoggingAbstractManager(Connection con, int mid, String tableName, int userId) {
        this(con, mid, tableName, null, userId);
    }

    public LoggingAbstractManager(Connection con, int mid, String tableName, Date date, int userId) {
        super(con, mid, tableName, date);
        this.userId = userId;
    }

    private String getCreateLogTableQuery() {
        String query = "CREATE TABLE " + this.tableName + "_log ( id int  NOT NULL AUTO_INCREMENT,  `uid` INT  NOT NULL DEFAULT 0,  `cid` INT  NOT NULL DEFAULT 0,  `oid` INT  NOT NULL DEFAULT 0,  `description` TEXT ,  `action` INT  NOT NULL DEFAULT 0,  `dt` TIMESTAMP,   PRIMARY KEY (`id`) )";
        return query;
    }

    @Override
    public int delete(int id) throws Exception {
        Object b = this.get(id);
        LogEntry le = new LogEntry();
        le.setAction(2);
        le.setContractId(b instanceof Contractable ? ((Contractable)b).getContractId() : 0);
        le.setDescription(((Id)b).toString());
        le.setUserId(this.userId);
        le.setObjectId(((Id)b).getId());
        this.makeLogEntry(le);
        return super.delete(id);
    }

    @Override
    public void update(B b) throws BGException, SQLException {
        int action = ((Id)b).getId() > 0 ? 1 : 0;
        Object old = null;
        if (action == 1) {
            old = this.get(((Id)b).getId());
        }
        super.update(b);
        if (((Id)b).getId() > 0 && !((Id)b).equals(old)) {
            LogEntry le = new LogEntry();
            le.setAction(action);
            le.setContractId(b instanceof Contractable ? ((Contractable)b).getContractId() : 0);
            le.setDescription(((Id)b).toString());
            le.setUserId(this.userId);
            le.setObjectId(((Id)b).getId());
            this.makeLogEntry(le);
        }
    }

    private void makeLogEntry(LogEntry le) throws SQLException {
        if (!Setup.getSetup().getBoolean("created.log." + this.tableName, false)) {
            ServerUtils.checkTable((Connection)this.con, (String)(this.tableName + "_log"), (String)this.getCreateLogTableQuery());
            Setup.getSetup().putObject("created.log." + this.tableName, (Object)true);
        }
        StringBuilder insertLog = new StringBuilder();
        insertLog.append("INSERT INTO ");
        insertLog.append(this.tableName);
        insertLog.append("_log(dt, uid, cid, oid, description, action) VALUES(NOW(),?,?,?,?,?)");
        try (PreparedStatement ps = this.con.prepareStatement(insertLog.toString());){
            ps.setInt(1, le.getUserId());
            ps.setInt(2, le.getContractId());
            ps.setInt(3, le.getObjectId());
            ps.setString(4, le.getDescription());
            ps.setInt(5, le.getAction());
            ps.executeUpdate();
        }
    }

    public List<LogEntry> logListByCid(int cid) throws BGException {
        return this.logEntryList("cid=?", cid);
    }

    public List<LogEntry> logListByOid(int oid) throws BGException {
        return this.logEntryList("oid=?", oid);
    }

    private List<LogEntry> logEntryList(String where, int value) throws BGException {
        ArrayList<LogEntry> result = new ArrayList<LogEntry>();
        try {
            if (!Setup.getSetup().getBoolean("created.log." + this.tableName, false)) {
                ServerUtils.checkTable((Connection)this.con, (String)(this.tableName + "_log"), (String)this.getCreateLogTableQuery());
                Setup.getSetup().putObject("created.log." + this.tableName, (Object)true);
            }
            StringBuilder query = new StringBuilder(100);
            query.append("SELECT * FROM ");
            query.append(this.tableName);
            query.append("_log WHERE ");
            query.append(where);
            query.append(" ORDER BY dt DESC");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, value);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.readLogEntryFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
        return result;
    }

    private LogEntry readLogEntryFromRS(ResultSet rs) throws SQLException {
        LogEntry le = new LogEntry();
        le.setId(rs.getInt("id"));
        le.setAction(rs.getInt("action"));
        le.setContractId(rs.getInt("cid"));
        le.setObjectId(rs.getInt("oid"));
        le.setDescription(rs.getString("description"));
        le.setUserId(rs.getInt("uid"));
        le.setDate(TimeUtils.convertTimestampToDate(rs.getTimestamp("dt")));
        le.setUserName(UserMap.getUser((Integer)le.getUserId()).getName());
        return le;
    }
}

