/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.task.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGTextArea;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriod;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGToolBar;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.task.client.SchedulerTaskPanel;
import ru.bitel.bgbilling.kernel.task.client.TaskDataListItem;
import ru.bitel.bgbilling.kernel.task.client.TaskDependentEditor;
import ru.bitel.bgbilling.kernel.task.common.bean.DependentTask;
import ru.bitel.bgbilling.kernel.task.common.bean.LightweightTaskData;
import ru.bitel.bgbilling.kernel.task.common.bean.TaskStatus;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.action.BGUAction;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.model.IdTitle;

public class TaskEditor
extends BGEditorDialog<LightweightTaskData> {
    private JTextArea commentTextArea;
    private BGUList<TaskDataListItem> taskList;
    private BGControlPanelPeriod periodPanel = new BGControlPanelPeriod();
    private BGUComboBox<IdTitle> priorityComboBox;
    private BGComboBox<TaskStatus> statusComboBox;
    private JTextField min = new JTextField(30);
    private JTextField hh = new JTextField("");
    private JTextField dm = new JTextField("");
    private JTextField dw = new JTextField("");
    private JTextField mm = new JTextField("");
    private SchedulerTaskPanel parentPanel;
    private List<DependentTask> taskItems;
    BGUAction editAction = new BGUAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0437\u0430\u0434\u0430\u0447\u0438", (Icon)ClientUtils.getIcon("edit")){

        @Override
        public void actionPerformed(ActionEvent e) {
            TaskEditor.this.taskList.optSelectedValue().ifPresentOrElse(item -> new TaskDependentEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0437\u0430\u0434\u0430\u0447\u0438", item.getDependentTask(), TaskEditor.this.parentPanel).open(), () -> ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u0430\u0434\u0430\u0447\u0443"));
        }
    };

    public TaskEditor(String title, LightweightTaskData data, SchedulerTaskPanel parent) {
        super(title, data);
        this.parentPanel = parent;
        this.taskItems = data.getDependentTasks();
        if (this.taskItems == null || this.taskItems.isEmpty()) {
            this.taskItems = new ArrayList<DependentTask>();
            if (data.getClassName() != null) {
                DependentTask dependentTask = new DependentTask().setTitle(data.getTitle()).setClassName(data.getClassName()).setModuleId(data.getModuleId()).setPlugin(data.isPlugin()).setTaskStatus(data.getTaskStatus()).setParams(data.getParams()).setComment(data.getComment());
                this.taskItems.add(dependentTask);
            }
        }
    }

    @Override
    public void doDialogPanel() {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add((Component)this.getBasePanel(), "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b");
        tabbedPane.add((Component)this.getTasksPanel(), "\u0417\u0430\u0434\u0430\u0447\u0438");
        this.panel.add((Component)tabbedPane, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.setTask();
    }

    private JPanel getBasePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getBaseLeftPanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.getRunTimePanel(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.getCommentPanel(), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(10, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getBaseLeftPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.periodPanel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.getTaskPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 1, new Insets(10, 0, 0, 0), 0, 0));
        return panel;
    }

    private JPanel getTaskPanel() {
        this.priorityComboBox = new BGUComboBox();
        this.priorityComboBox.setData(this.parentPanel.priorityItems);
        this.priorityComboBox.setSelectedIndex(1);
        this.statusComboBox = new BGComboBox();
        this.statusComboBox.setModel(new DefaultComboBoxModel<TaskStatus>(TaskStatus.values()));
        this.statusComboBox.setSelectedIndex(0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add(this.priorityComboBox, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add(this.statusComboBox, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getRunTimePanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new BGTitleBorder("\u0412\u0440\u0435\u043c\u044f \u0437\u0430\u043f\u0443\u0441\u043a\u0430"));
        panel.add((Component)new JLabel("\u041c\u0438\u043d\u0443\u0442\u044b:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.min, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u0427\u0430\u0441\u044b:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.hh, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u0414\u043d\u0438 \u043c\u0435\u0441\u044f\u0446\u0430:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.dm, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u0414\u043d\u0438 \u043d\u0435\u0434\u0435\u043b\u0438:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.dw, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u041c\u0435\u0441\u044f\u0446\u044b:"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.mm, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getCommentPanel() {
        this.commentTextArea = new BGTextArea(2, 20);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)new JScrollPane(this.commentTextArea), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
        panel.add((Component)new JLabel("<html><small>* \u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u0438 \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043f\u0440\u0438 \u043d\u0430\u043b\u0438\u0447\u0438\u0438 2 \u0438 \u0431\u043e\u043b\u0435\u0435 \u0437\u0430\u0434\u0430\u0447<small></html>)"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 5, 0, 5), 0, 0));
        return panel;
    }

    private JPanel getTasksPanel() {
        BGToolBar toolBar = new BGToolBar(true);
        toolBar.add(new BGUAction("add", "\u041d\u043e\u0432\u0430\u044f \u0437\u0430\u0434\u0430\u0447\u0430", (Icon)ClientUtils.getIcon("add")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskDependentEditor editor = new TaskDependentEditor("\u041d\u043e\u0432\u0430\u044f \u0437\u0430\u0434\u0430\u0447\u0430", new DependentTask(), TaskEditor.this.parentPanel);
                editor.open();
                if (editor.getData() != null) {
                    TaskEditor.this.taskItems.add((DependentTask)editor.getData());
                    TaskEditor.this.setTaskData();
                }
            }
        });
        toolBar.add(Box.createHorizontalStrut(5));
        toolBar.add(this.editAction);
        toolBar.add(Box.createHorizontalStrut(5));
        toolBar.add(new BGUAction("delete", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0437\u0430\u0434\u0430\u0447\u0438", (Icon)ClientUtils.getIcon("delete")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskDataListItem item = (TaskDataListItem)TaskEditor.this.taskList.getSelectedValue();
                if (item == null) {
                    ClientUtils.showErrorMessageDialog("\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u0430\u0434\u0430\u0447\u0443");
                    return;
                }
                if (ClientUtils.confirmDelete(item.getDependentTask().getTitle())) {
                    TaskEditor.this.taskItems.remove(item.getDependentTask());
                    TaskEditor.this.setTaskData();
                }
            }
        });
        this.taskList = new BGUList();
        this.taskList.setDragEnabled(true);
        this.taskList.setDropMode(DropMode.INSERT);
        this.taskList.setTransferHandler(new ListItemTransferHandler());
        this.taskList.setCellRenderer(new TasksListCellRenrerer());
        this.taskList.setSelectionMode(0);
        this.taskList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                    TaskEditor.this.editAction.actionPerformed(null);
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)toolBar, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)BGSwingUtilites.wrapScrollPane(this.taskList, 800, 350), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        return panel;
    }

    public void setTask() {
        this.periodPanel.setPeriod(((LightweightTaskData)this.data).getPeriod());
        this.commentTextArea.setText(((LightweightTaskData)this.data).getComment());
        for (IdTitle idTitle : this.parentPanel.priorityItems) {
            if (idTitle.getId() != ((LightweightTaskData)this.data).getPriority()) continue;
            this.priorityComboBox.setSelectedItem(idTitle);
            break;
        }
        this.statusComboBox.setSelectedItem((Object)((LightweightTaskData)this.data).getTaskStatus());
        this.mm.setText(Utils.unpackValues(((LightweightTaskData)this.data).getMonth(), 1));
        this.dm.setText(Utils.unpackValues(((LightweightTaskData)this.data).getDay(), 1));
        this.dw.setText(Utils.unpackValues(((LightweightTaskData)this.data).getDayOfWeek(), 1));
        this.hh.setText(Utils.unpackValues(((LightweightTaskData)this.data).getHour(), 0));
        this.min.setText(Utils.unpackValues(((LightweightTaskData)this.data).getMin(), 0));
        this.setTaskData();
    }

    public void setTaskData() {
        this.taskList.setData(this.taskItems.stream().map(TaskDataListItem::new).collect(Collectors.toList()));
        boolean enable = this.taskItems.size() > 0;
        this.statusComboBox.setEnabled(enable);
        this.commentTextArea.setEnabled(enable);
    }

    @Override
    public boolean doApply() throws Exception {
        if (this.taskItems == null || this.taskItems.isEmpty()) {
            ClientUtils.showErrorMessageDialog("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0434\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0445\u043e\u0442\u044f \u0431\u044b \u043e\u0434\u043d\u0443 \u0437\u0430\u0434\u0430\u0447\u0443");
            return false;
        }
        ClientUtils.checkValues(this.min, 0, 59);
        ClientUtils.checkValues(this.hh, 0, 23);
        ClientUtils.checkValues(this.dw, 1, 7);
        ClientUtils.checkValues(this.dm, 1, 31);
        ClientUtils.checkValues(this.mm, 1, 12);
        ((LightweightTaskData)this.data).setMin(Utils.packValues(Utils.toList(this.min.getText()), 0));
        ((LightweightTaskData)this.data).setHour((int)Utils.packValues(Utils.toList(this.hh.getText()), 0));
        ((LightweightTaskData)this.data).setDay((int)Utils.packValues(Utils.toList(this.dm.getText()), 1));
        ((LightweightTaskData)this.data).setDayOfWeek((int)Utils.packValues(Utils.toList(this.dw.getText()), 1));
        ((LightweightTaskData)this.data).setMonth((int)Utils.packValues(Utils.toList(this.mm.getText()), 1));
        ((LightweightTaskData)this.data).setPeriod(this.periodPanel.getPeriod());
        ((LightweightTaskData)this.data).setTaskStatus(this.statusComboBox.getSelectedItem());
        ((LightweightTaskData)this.data).setPriority(((IdTitle)this.priorityComboBox.getSelectedItem()).getId());
        ((LightweightTaskData)this.data).setComment(this.commentTextArea.isEnabled() ? this.commentTextArea.getText() : "");
        ((LightweightTaskData)this.data).setDependentTasks(this.taskItems);
        ((LightweightTaskData)this.data).setParams("");
        ((LightweightTaskData)this.data).setClassName("");
        ((LightweightTaskData)this.data).setPlugin(false);
        ((LightweightTaskData)this.data).setModuleId(-2);
        this.parentPanel.getSchedulerService().updateTask((LightweightTaskData)this.data);
        this.parentPanel.performAction("refresh");
        return true;
    }

    class ListItemTransferHandler
    extends TransferHandler {
        private final DataFlavor localObjectFlavor = new DataFlavor(TaskDataListItem.class, "TaskDataListItem");

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        protected Transferable createTransferable(JComponent component) {
            return new Transferable(){

                @Override
                public boolean isDataFlavorSupported(DataFlavor flavor) {
                    return true;
                }

                @Override
                public DataFlavor[] getTransferDataFlavors() {
                    return new DataFlavor[]{ListItemTransferHandler.this.localObjectFlavor};
                }

                @Override
                public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                    return TaskEditor.this.taskList.getSelectedValue();
                }
            };
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return true;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            JList.DropLocation dropLocation = (JList.DropLocation)info.getDropLocation();
            info.getComponent().setCursor(Cursor.getPredefinedCursor(0));
            try {
                int toIndex = dropLocation.getIndex();
                TaskDataListItem taskDataListItem = (TaskDataListItem)info.getTransferable().getTransferData(this.localObjectFlavor);
                int fromIndex = TaskEditor.this.taskItems.indexOf(taskDataListItem.getDependentTask());
                if (fromIndex > toIndex) {
                    TaskEditor.this.taskItems.remove(fromIndex);
                    TaskEditor.this.taskItems.add(toIndex, taskDataListItem.getDependentTask());
                    TaskEditor.this.setTaskData();
                } else if (toIndex > fromIndex) {
                    TaskEditor.this.taskItems.add(toIndex, taskDataListItem.getDependentTask());
                    TaskEditor.this.taskItems.remove(fromIndex);
                    TaskEditor.this.setTaskData();
                }
                return true;
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog(e);
                return false;
            }
        }
    }

    public class TasksListCellRenrerer
    extends DefaultListCellRenderer {
        private JPanel panel = new JPanel(new GridBagLayout());
        private JLabel titleLabel = new JLabel();
        private JLabel moduleLabel = new JLabel();
        private JLabel priorityLabel = new JLabel();
        private JLabel statusLabel = new JLabel();
        private JLabel commentLabel = new JLabel();

        public TasksListCellRenrerer() {
            this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1).deriveFont(this.titleLabel.getFont().getSize2D() * 1.2f));
            this.commentLabel.setFont(this.commentLabel.getFont().deriveFont(2).deriveFont(this.commentLabel.getFont().getSize2D() * 1.0f));
            Color fgColor = UIManager.getColor("TextField.inactiveForeground");
            this.moduleLabel.setForeground(fgColor);
            this.priorityLabel.setForeground(fgColor);
            this.statusLabel.setForeground(fgColor);
            this.commentLabel.setForeground(fgColor);
            this.panel.add((Component)this.titleLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            this.panel.add((Component)this.getPropertyPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 15, 0, 5), 0, 0));
            this.panel.add((Component)this.commentLabel, new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 20, 5, 5), 0, 0));
        }

        private JPanel getPropertyPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.moduleLabel, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
            panel.add((Component)this.statusLabel, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 0, 5), 0, 0));
            panel.add((Component)this.priorityLabel, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 25, 0, 5), 0, 0));
            panel.setOpaque(false);
            return panel;
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            DependentTask dependentTask = ((TaskDataListItem)value).getDependentTask();
            String mid = (dependentTask.isPlugin() ? "p" : "") + dependentTask.getModuleId();
            KeyValue module = TaskEditor.this.parentPanel.modules.stream().filter(a -> a.getKey().equals(mid)).findFirst().orElse(new KeyValue("", mid));
            String title = dependentTask.getTitle();
            this.titleLabel.setText(title == null ? "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430" : title);
            this.moduleLabel.setText((dependentTask.isPlugin() ? "\u041f\u043b\u0430\u0433\u0438\u043d: " : "\u041c\u043e\u0434\u0443\u043b\u044c: ") + module.getValue());
            this.priorityLabel.setText("\u041f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442: " + TaskEditor.this.parentPanel.priorityItems.stream().filter(a -> a.getId() == dependentTask.getPriority()).findFirst().orElse(new IdTitle(0, "\u043f\u0430\u043a\u0435\u0442\u0430")).getTitle());
            TaskStatus taskStatus = dependentTask.getTaskStatus();
            this.statusLabel.setText("\u0421\u0442\u0430\u0442\u0443\u0441: " + (taskStatus != null ? taskStatus.getStatusTitle() : "?"));
            this.commentLabel.setText(dependentTask.getComment() + "\u00a0");
            this.panel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            return this.panel;
        }
    }
}

