/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.modules.dialup.server.bean.DialUpLoginParameter;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;

public class DialUpLoginParameterManager {
    private Connection con;
    private int mid;
    private Preferences moduleSetup;

    public DialUpLoginParameterManager(Connection con, int mid, Preferences moduleSetup) {
        this.con = con;
        this.mid = mid;
        this.moduleSetup = moduleSetup;
    }

    public Map<String, DialUpLoginParameter> getLoginParameter(int lid) throws SQLException {
        LinkedHashMap<String, DialUpLoginParameter> parameters = new LinkedHashMap<String, DialUpLoginParameter>();
        boolean stop = false;
        int i = 1;
        while (!stop) {
            String name = this.moduleSetup.get("login.parameter." + i + ".name", null);
            String title = this.moduleSetup.get("login.parameter." + i + ".title", null);
            String defaultValue = this.moduleSetup.get("login.parameter." + i + ".default", null);
            int type = this.moduleSetup.getInt("login.parameter." + i + ".type", 1);
            DialUpLoginParameter parameter = new DialUpLoginParameter();
            if (name == null || title == null || defaultValue == null) {
                stop = true;
                continue;
            }
            String listValue = this.moduleSetup.get("login.parameter." + i + ".listValue", "");
            parameter.setType(type);
            parameter.setName(name);
            parameter.setTitle(title);
            parameter.setValue(defaultValue);
            parameter.setListValue(listValue);
            parameters.put(parameter.getName(), parameter);
            ++i;
        }
        String query = "SELECT * FROM login_parameter_" + this.mid + " WHERE lid=? order by name";
        PreparedStatement ps = this.con.prepareStatement(query);
        ps.setInt(1, lid);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            String name = rs.getString("name");
            String value = rs.getString("value");
            if (!parameters.containsKey(name)) continue;
            ((DialUpLoginParameter)parameters.get(name)).setValue(value);
        }
        rs.close();
        ps.close();
        return parameters;
    }

    public boolean saveLoginParameter(int lid, String name, String value) throws SQLException {
        String query = "SELECT value FROM login_parameter_" + this.mid + " WHERE lid=? and name=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        int index = 1;
        ps.setInt(index++, lid);
        ps.setString(index++, name);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            String oldValue = rs.getString("value");
            if (oldValue.equals(value)) {
                rs.close();
                ps.close();
                return false;
            }
            query = "UPDATE login_parameter_" + this.mid + " SET value=? WHERE lid=? and name=?";
            ps.close();
            ps = this.con.prepareStatement(query);
            index = 1;
            ps.setString(index++, value);
            ps.setInt(index++, lid);
            ps.setString(index++, name);
            ps.executeUpdate();
            ps.close();
        } else {
            query = "INSERT INTO login_parameter_" + this.mid + " SET value=?,lid =?,name=?";
            ps.close();
            ps = this.con.prepareStatement(query);
            index = 1;
            ps.setString(index++, value);
            ps.setInt(index++, lid);
            ps.setString(index++, name);
            ps.executeUpdate();
            ps.close();
        }
        return true;
    }

    public void writeLog(int lid, String name, String value, int userId) throws SQLException {
        String query = "INSERT INTO login_parameter_log_" + this.mid + " SET lid=?,name=?,value=?,user=?,dt=?";
        PreparedStatement ps = this.con.prepareStatement(query);
        int index = 1;
        ps.setInt(index++, lid);
        ps.setString(index++, name);
        ps.setString(index++, value);
        ps.setInt(index++, userId);
        ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)new Date(System.currentTimeMillis())));
        ps.executeUpdate();
        ps.close();
    }

    public void getLogForLogins(Element logs, Element logins, String name, Map<Integer, User> userMap) throws Exception {
        NodeList loginList = logins.getChildNodes();
        if (loginList.getLength() == 0) {
            return;
        }
        Document doc = logs.getOwnerDocument();
        HashMap<Integer, String> loginMap = new HashMap<Integer, String>();
        StringBuilder loginQuery = new StringBuilder("( ");
        for (int i = 0; i < loginList.getLength(); ++i) {
            Element login = (Element)loginList.item(i);
            int id = Integer.parseInt(login.getAttribute("id"));
            String title = login.getAttribute("title");
            loginMap.put(id, title);
            loginQuery.append(id);
            if (i == loginList.getLength() - 1) continue;
            loginQuery.append(", ");
        }
        loginQuery.append(")");
        String query = "SELECT * FROM login_parameter_log_" + this.mid + " WHERE name='" + name + "' AND lid IN " + loginQuery.toString() + " ORDER BY dt DESC,lid";
        Statement st = this.con.createStatement();
        ResultSet rs = st.executeQuery(query);
        while (rs.next()) {
            Element item = doc.createElement("item");
            logs.appendChild(item);
            int lid = rs.getInt("lid");
            item.setAttribute("lid", String.valueOf(lid));
            item.setAttribute("login", (String)loginMap.get(lid));
            item.setAttribute("user", userMap.get(rs.getInt("user")).getName());
            item.setAttribute("date", TimeUtils.formatFullDate((Date)rs.getTimestamp("dt")));
            item.setAttribute("value", rs.getString("value"));
        }
    }

    public void getLogForLogins(Map<String, Object> dataMap, List<String[]> loginList, String name, Map<Integer, User> userMap) throws Exception {
        ArrayList<String[]> logList = new ArrayList<String[]>();
        dataMap.put("logList", logList);
        if (loginList.isEmpty()) {
            return;
        }
        HashMap<Integer, String> loginMap = new HashMap<Integer, String>();
        StringBuilder loginQuery = new StringBuilder("( ");
        int i = 0;
        for (String[] str : loginList) {
            int id = Integer.parseInt(str[0]);
            String title = str[1];
            loginMap.put(id, title);
            loginQuery.append(id);
            if (i != loginList.size() - 1) {
                loginQuery.append(", ");
            }
            ++i;
        }
        loginQuery.append(")");
        String query = "SELECT * FROM login_parameter_log_" + this.mid + " WHERE name='" + name + "' AND lid IN " + loginQuery.toString() + " ORDER BY dt DESC,lid";
        Statement st = this.con.createStatement();
        ResultSet rs = st.executeQuery(query);
        while (rs.next()) {
            String[] str = new String[5];
            int lid = rs.getInt("lid");
            str[0] = String.valueOf(lid);
            str[1] = (String)loginMap.get(lid);
            str[2] = userMap.get(rs.getInt("user")).getName();
            str[3] = TimeUtils.formatFullDate((Date)rs.getTimestamp("dt"));
            str[4] = rs.getString("value");
            logList.add(str);
        }
    }
}

