/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server;

import bitel.billing.server.util.telnet.TelnetSession;
import bitel.billing.server.util.terminal.AbstractTerminalSession;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.ipn.server.AbstractMikrotikGateWorker;
import ru.bitel.common.Preferences;

public class MikrotikTelnetGateWorker
extends AbstractMikrotikGateWorker {
    @Override
    protected void doSync() {
        String host = this.gate.getHost();
        int port = this.gate.getPort();
        Preferences gateSetup = new Preferences(this.gate.getConfig(), "\r\n");
        String login = gateSetup.get("login", "root");
        String pswd = this.gate.getKeyword();
        if (this.log.isDebugEnabled()) {
            this.log.debug(" gate: " + host + ":" + port + " login: " + login + " pswd: " + pswd);
        }
        TelnetSession session = null;
        try {
            int timeout = gateSetup.getInt("timeout", 10000);
            int socketTimeout = gateSetup.getInt("socket.timeout", 10000);
            session = new TelnetSession(host, port);
            session.setTimeout(timeout);
            session.setSocketTimeTimeout(socketTimeout);
            session.setEndString(": ");
            session.connect();
            this.doCommand((AbstractTerminalSession)session, login);
            session.setRegexp("\\[.+?@.+?\\] >.*\\[.+?@.+?\\] >");
            this.doCommand((AbstractTerminalSession)session, pswd);
            this.processSession((AbstractTerminalSession)session);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (session != null) {
                try {
                    session.disconnect();
                }
                catch (BGException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

