/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import ru.bitel.bgbilling.modules.dialup.server.bean.CalculatePeriod;
import ru.bitel.common.TimeUtils;

public class CalculatePeriodManager {
    private Connection con;
    private int mid;

    public CalculatePeriodManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
    }

    public List<CalculatePeriod> getPeriodList(int cid) {
        ArrayList<CalculatePeriod> result = new ArrayList<CalculatePeriod>();
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT * FROM calculate_period_" + this.mid + " WHERE cid=? ORDER BY id");
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getPeriodFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public CalculatePeriod getPeriod(int cid, int id) {
        CalculatePeriod result = null;
        try {
            PreparedStatement ps = this.con.prepareStatement("SELECT * FROM calculate_period_" + this.mid + " WHERE id=? AND cid=?");
            ps.setInt(1, id);
            ps.setInt(2, cid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getPeriodFromRS(rs);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private CalculatePeriod getPeriodFromRS(ResultSet rs) throws SQLException {
        CalculatePeriod result = new CalculatePeriod();
        result.setId(rs.getInt("id"));
        result.setCid(rs.getInt("cid"));
        result.setStart(TimeUtils.convertTimestampToCalendar((Timestamp)rs.getTimestamp("start")));
        result.setEnd(TimeUtils.convertTimestampToCalendar((Timestamp)rs.getTimestamp("end")));
        return result;
    }

    public boolean updatePeriod(int id, int cid, Calendar start, Calendar end) {
        return this.updatePeriod(id, cid, start, end, false);
    }

    public boolean updatePeriod(int id, int cid, Calendar start, Calendar end, boolean second) {
        if (start.after(end)) {
            return false;
        }
        String query = null;
        query = second ? "SELECT id FROM calculate_period_" + this.mid + " WHERE cid=? AND id!=? AND ?<=end AND start<=?" : "SELECT id FROM calculate_period_" + this.mid + " WHERE cid=? AND id!=? AND ((TO_DAYS(start)<=TO_DAYS(?) AND TO_DAYS(end)>=TO_DAYS(?))OR(TO_DAYS(start)<=TO_DAYS(?) AND TO_DAYS(end)>=TO_DAYS(?)))";
        try {
            Timestamp str = TimeUtils.convertCalendarToTimestamp((Calendar)start);
            Timestamp en = TimeUtils.convertCalendarToTimestamp((Calendar)end);
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cid);
            ps.setInt(2, id);
            if (second) {
                ps.setTimestamp(3, TimeUtils.convertCalendarToTimestamp((Calendar)start));
                ps.setTimestamp(4, TimeUtils.convertCalendarToTimestamp((Calendar)end));
            } else {
                ps.setTimestamp(3, str);
                ps.setTimestamp(4, str);
                ps.setTimestamp(5, en);
                ps.setTimestamp(6, en);
            }
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) {
                ps.close();
                if (id > 0) {
                    query = "UPDATE calculate_period_" + this.mid + " SET start=?, end=? WHERE id=? AND cid=?";
                    ps = this.con.prepareStatement(query);
                    ps.setTimestamp(1, str);
                    ps.setTimestamp(2, en);
                    ps.setInt(3, id);
                    ps.setInt(4, cid);
                } else {
                    query = "INSERT INTO calculate_period_" + this.mid + " (cid, start, end) VALUES (?, ?, ?)";
                    ps = this.con.prepareStatement(query);
                    ps.setInt(1, cid);
                    ps.setTimestamp(2, str);
                    ps.setTimestamp(3, en);
                }
                if (ps.executeUpdate() > 0) {
                    ps.close();
                    return true;
                }
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean deletePeriod(int id, int cid) {
        try {
            PreparedStatement ps = this.con.prepareStatement("DELETE FROM calculate_period_" + this.mid + " WHERE id=? AND cid=?");
            ps.setInt(1, id);
            ps.setInt(2, cid);
            if (ps.executeUpdate() > 0) {
                ps.close();
                return true;
            }
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }
}

