/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.sorm.server.upload.norsitrans;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractModuleManager;
import bitel.billing.server.load.bean.Source;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.net.util.SubnetUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.util.MACParser;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.AbstractBalanceBean;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentType;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.sorm.common.UploadModulesTitle;
import ru.bitel.bgbilling.modules.sorm.common.bean.Bunch;
import ru.bitel.bgbilling.modules.sorm.common.bean.InstalledInstanceModule;
import ru.bitel.bgbilling.modules.sorm.common.bean.ServiceSorm;
import ru.bitel.bgbilling.modules.sorm.common.bean.SormProject;
import ru.bitel.bgbilling.modules.sorm.common.service.SormService;
import ru.bitel.bgbilling.modules.sorm.server.bean.DialUpNAS;
import ru.bitel.bgbilling.modules.sorm.server.bean.InternalUser;
import ru.bitel.bgbilling.modules.sorm.server.bean.NumberRange;
import ru.bitel.bgbilling.modules.sorm.server.bean.SormCSVWriter;
import ru.bitel.bgbilling.modules.sorm.server.bean.SormContract;
import ru.bitel.bgbilling.modules.sorm.server.service.SormServiceImpl;
import ru.bitel.bgbilling.modules.sorm.server.upload.PaymentsToUpload;
import ru.bitel.bgbilling.modules.sorm.server.upload.Upload;
import ru.bitel.bgbilling.modules.sorm.server.upload.norsitrans.NorsiTransFileTitle;
import ru.bitel.bgbilling.modules.sorm.server.utils.SormUtils;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceAccountService;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpNet;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Pair;
import ru.bitel.common.model.Period;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.entity.common.bean.AddressStruct;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.systems.inventory.resource.common.bean.Device;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpCategory;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResource;

public class NorsiTransUpload
extends Upload {
    protected final Logger logger = LogManager.getLogger();
    protected final List<Path> otherFiles = new ArrayList<Path>();
    protected final String regionId = this.config.get("sorm.upload.regionid", "1");

    public NorsiTransUpload(int moduleId, SormProject sormProject, boolean isFullUpload) {
        super(moduleId, sormProject, isFullUpload);
    }

    @Override
    public Path abonents() {
        this.logger.info("\u0421\u0442\u0430\u0440\u0442 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432. \u0412\u0441\u0435\u0433\u043e \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u0434\u043b\u044f \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0438: " + this.contracts.size());
        Path inetFile = SormUtils.getUploadFile(this.localUserPath, NorsiTransFileTitle.INET_ABONENTS.getTitle(), "%s_%tQ.csv");
        Path phoneFile = SormUtils.getUploadFile(this.localUserPath, NorsiTransFileTitle.PHONE_ABONENTS.getTitle(), "%s_%tQ.csv");
        try (SormCSVWriter csvInetFile = SormUtils.getCSVFile(inetFile, "windows-1251");
             SormCSVWriter csvPhoneFile = SormUtils.getCSVFile(phoneFile, "windows-1251");){
            int inetCount = 0;
            int phoneCount = 0;
            int internalUserInetCount = 0;
            int internalUserPhoneCount = 0;
            Map<String, List<Integer>> telephoneModules = SormUtils.getTelephoneModulesIds(this.config);
            Map<Integer, List<InetServ>> abonentServices = SormUtils.getPairsAbonentInetServices(this.config, this.contracts, this.serverContext);
            List<IdTitle> documentTypes = SormUtils.getDocumentsTypes(this.config, this.cpm);
            for (SormContract contract : this.contracts) {
                List servList;
                this.helper.setCurrentContract(contract);
                int cid = contract.getContractId();
                if (this.checkInstalledModule(UploadModulesTitle.INET) && Utils.notEmptyCollection((Collection)(servList = (List)abonentServices.getOrDefault(cid, null)))) {
                    for (InetServ inetServ : servList) {
                        String[] item = this.getInetItem(contract, inetServ, documentTypes);
                        this.writeItemToFile(item, cid, NorsiTransFileTitle.INET_ABONENTS.getTitle(), csvInetFile);
                        ++inetCount;
                        if (contract.isFiz()) continue;
                        for (InternalUser internalUser : SormUtils.getInternalUsers(this.contractObjectDao, this.helper, this.config)) {
                            String[] internalUserItem = this.getInternalUserItem(item, internalUser, documentTypes);
                            this.writeItemToFile(internalUserItem, cid, NorsiTransFileTitle.INET_ABONENTS.getTitle(), csvPhoneFile);
                            ++internalUserInetCount;
                        }
                    }
                }
                if (!this.checkInstalledModule(UploadModulesTitle.VOICE)) continue;
                for (Integer voiceMid : telephoneModules.get(UploadModulesTitle.VOICE.getTitleModule())) {
                    VoiceAccountService accountService = (VoiceAccountService)this.serverContext.getService(VoiceAccountService.class, voiceMid.intValue());
                    List accounts = accountService.voiceAccountList(contract.getContractId(), 0, new Period(contract.getDateFrom(), contract.getDateTo()));
                    for (VoiceAccount account : accounts) {
                        String[] item = this.getPhoneItem(contract, String.valueOf(account.getNumber()), account.getDateFrom(), documentTypes);
                        this.writeItemToFile(item, cid, NorsiTransFileTitle.PHONE_ABONENTS.getTitle(), csvPhoneFile);
                        ++phoneCount;
                        if (contract.isFiz()) continue;
                        for (InternalUser internalUser : SormUtils.getInternalUsers(this.contractObjectDao, this.helper, this.config)) {
                            String[] internalUserItem = this.getInternalUserItem(item, internalUser, documentTypes);
                            this.writeItemToFile(internalUserItem, cid, NorsiTransFileTitle.PHONE_ABONENTS.getTitle(), csvPhoneFile);
                            ++internalUserPhoneCount;
                        }
                    }
                }
            }
            this.logger.info(String.format("\u0412\u0441\u0435\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u043e: %d. \u0410\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u0438\u043d\u0442\u0435\u0440\u043d\u0435\u0442\u0430: %d. \u0410\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0438\u0438: %d", this.contracts.size(), inetCount, phoneCount));
            if (Utils.notEmptyCollection((Collection)this.contracts)) {
                SormUtils.updateContractLogTable(this);
            }
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            this.logger.error(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text);
        }
        this.otherFiles.add(phoneFile);
        return inetFile;
    }

    private String[] getInternalUserItem(String[] item, InternalUser internalUser, List<IdTitle> documentTypes) {
        String fioType;
        String[] internalUserItem = Arrays.copyOfRange(item, 0, item.length);
        internalUserItem[8] = "0";
        String lastName = internalUser.getLastName();
        String firstName = internalUser.getFirstName();
        String middlename = internalUser.getMiddleName();
        Object unstructFio = "";
        if (Utils.notBlankString((String)lastName) && Utils.notBlankString((String)firstName) && Utils.notBlankString((String)middlename)) {
            fioType = "0";
        } else {
            fioType = "1";
            unstructFio = Utils.maskBlank((String)lastName, (String)"") + " " + Utils.maskBlank((String)firstName, (String)"") + " " + Utils.maskBlank((String)middlename, (String)"");
        }
        internalUserItem[9] = fioType;
        internalUserItem[10] = Utils.maskBlank((String)firstName, (String)"");
        internalUserItem[11] = Utils.maskBlank((String)middlename, (String)"");
        internalUserItem[12] = Utils.maskBlank((String)lastName, (String)"");
        internalUserItem[13] = Utils.maskBlank((String)unstructFio, (String)"");
        internalUserItem[14] = internalUser.getBirthday() != null ? TimeUtils.format((java.util.Date)internalUser.getBirthday(), (String)"dd.MM.yyyy") : "";
        int documentTypeId = 1;
        if (Utils.notBlankString((String)internalUser.getDocumentType())) {
            for (IdTitle docType : documentTypes) {
                if (!docType.getTitle().equals(internalUser.getDocumentType())) continue;
                documentTypeId = docType.getId();
                break;
            }
        }
        String documentDateString = TimeUtils.format((java.util.Date)internalUser.getDocumentWhenGive(), (String)"dd.MM.yyyy");
        internalUserItem[15] = "0";
        internalUserItem[16] = SormUtils.trimField(internalUser.getDocumentSerial(), 16);
        internalUserItem[17] = SormUtils.trimField(internalUser.getDocumentNumber(), 16);
        internalUserItem[18] = SormUtils.trimField(internalUser.getDocumentWhoGive() + " " + documentDateString, 256);
        internalUserItem[19] = "";
        internalUserItem[20] = String.valueOf(documentTypeId);
        internalUserItem[21] = "";
        internalUserItem[22] = "";
        internalUserItem[23] = "";
        internalUserItem[24] = "";
        internalUserItem[25] = "";
        internalUserItem[26] = "";
        internalUserItem[27] = "";
        internalUserItem[28] = "";
        internalUserItem[29] = "";
        internalUserItem[30] = "";
        return internalUserItem;
    }

    @Override
    public Path abonentsAddresses() {
        return null;
    }

    @Override
    public Path abonentLogins() {
        return null;
    }

    @Override
    public Path services() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0443\u0441\u043b\u0443\u0433 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430(\u0414\u0412\u041e)");
        Path file = SormUtils.getUploadFile(this.localUserPath, NorsiTransFileTitle.SUPPLEMENTARY_SERVICES.getTitle(), "%s_%tQ.csv");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, "windows-1251");){
            for (ServiceSorm service : SormUtils.getSelectedServicesForUpload(this.config)) {
                String[] item = new String[6];
                item[0] = this.regionId;
                item[1] = String.valueOf(service.getId());
                item[2] = Utils.isBlankString((String)service.getTitle()) ? "-" : service.getTitle();
                String operatorStartDate = this.config.get("sorm.upload.operator.startdate");
                item[3] = Utils.isBlankString((String)operatorStartDate) ? "01.01.2010" : operatorStartDate;
                item[4] = "";
                item[5] = Utils.maskBlank((String)service.getDescription(), (String)service.getTitle());
                this.writeItemToFile(item, -1, NorsiTransFileTitle.SUPPLEMENTARY_SERVICES.getTitle(), csvFile);
            }
        }
        catch (Exception ex) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0443\u0441\u043b\u0443\u0433(\u0414\u0412\u041e) \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            this.logger.error(text + ex);
            SormUtils.sendErrorToEmail(Setup.getSetup(), ex, text, this.adminEmail);
        }
        return file;
    }

    @Override
    public Path abonentServices() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0443\u0441\u043b\u0443\u0433 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432");
        Path abonentServices = SormUtils.getUploadFile(this.localUserPath, NorsiTransFileTitle.ABONENT_SERVICES.getTitle(), "%s_%tQ.csv");
        Path abonentServicesPstn = SormUtils.getUploadFile(this.localUserPath, NorsiTransFileTitle.ABONENT_SERVICES_PSTN.getTitle(), "%s_%tQ.csv");
        this.otherFiles.add(abonentServicesPstn);
        try (SormCSVWriter csvFileInetServices = SormUtils.getCSVFile(abonentServices, "windows-1251");
             SormCSVWriter csvFileVoiceServices = SormUtils.getCSVFile(abonentServicesPstn, "windows-1251");){
            String idsServices = Utils.toString(SormUtils.getIdsServices(this.config));
            Map<Integer, List<InetServ>> inetServices = SormUtils.getPairsAbonentInetServices(this.config, this.contracts, this.serverContext);
            Map<String, List<Integer>> telephoneModules = SormUtils.getTelephoneModulesIds(this.config);
            if (this.checkInstalledModule(UploadModulesTitle.INET)) {
                for (SormContract contract : this.contracts) {
                    this.helper.setCurrentContract(contract);
                    int cid = contract.getContractId();
                    ArrayList<String> abonentLogins = new ArrayList<String>();
                    List servList = inetServices.getOrDefault(cid, null);
                    if (Utils.notEmptyCollection((Collection)servList)) {
                        for (InetServ inetServ : servList) {
                            String ipv4 = inetServ.getAddressFrom() != null ? IpAddress.toString((byte[])inetServ.getAddressFrom()) : "";
                            abonentLogins.add(Utils.isBlankString((String)inetServ.getLogin()) ? ipv4 : inetServ.getLogin());
                        }
                    }
                    for (String[] item : this.getAbonentServiceItem(contract, abonentLogins, idsServices)) {
                        this.writeItemToFile(item, cid, NorsiTransFileTitle.ABONENT_SERVICES.getTitle(), csvFileInetServices);
                    }
                }
            }
            if (this.checkInstalledModule(UploadModulesTitle.VOICE)) {
                for (Integer voiceMid : telephoneModules.get(UploadModulesTitle.VOICE.getTitleModule())) {
                    VoiceAccountService accountService = (VoiceAccountService)this.serverContext.getService(VoiceAccountService.class, voiceMid.intValue());
                    for (SormContract contract : this.contracts) {
                        this.helper.setCurrentContract(contract);
                        int cid = contract.getContractId();
                        ArrayList<String> abonentLogins = new ArrayList<String>();
                        List accounts = accountService.voiceAccountList(contract.getContractId(), 0, new Period(contract.getDateFrom(), contract.getDateTo()));
                        for (VoiceAccount account : accounts) {
                            abonentLogins.add(String.valueOf(account.getNumber()));
                        }
                        for (String[] item : this.getAbonentServiceItem(contract, abonentLogins, idsServices)) {
                            this.writeItemToFile(item, cid, NorsiTransFileTitle.ABONENT_SERVICES_PSTN.getTitle(), csvFileVoiceServices);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0443\u0441\u043b\u0443\u0433 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432: ";
            this.logger.error(text + ex);
            SormUtils.sendErrorToEmail(Setup.getSetup(), ex, text, this.adminEmail);
        }
        return abonentServices;
    }

    private List<String[]> getAbonentServiceItem(SormContract contract, List<String> logins, String idsServices) throws Exception {
        ArrayList<String[]> items = new ArrayList<String[]>();
        List<InstalledInstanceModule> npayModules = new SormServiceImpl().getInstanceModules("npay");
        for (int x = 0; x < npayModules.size(); ++x) {
            String npayServiceTable = ServerUtils.getModuleTableName((String)"npay_service_object", (int)npayModules.get(x).getModuleId());
            String query = "SELECT nso.sid AS sid, s.title AS title, nso.date1 AS date1, nso.date2 AS date2 FROM " + npayServiceTable + " AS nso LEFT JOIN service AS s ON nso.sid=s.id WHERE cid=?";
            if (Utils.notBlankString((String)idsServices)) {
                query = query + " AND sid in (" + idsServices + ")";
            }
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                int cid = contract.getContractId();
                ps.setInt(1, cid);
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    int sid = rs.getInt("sid");
                    Date date1 = rs.getDate("date1");
                    Date date2 = rs.getDate("date2");
                    for (String login : logins) {
                        String[] item = new String[]{this.regionId, Utils.maskBlank((String)login, (String)""), contract.getContractTitle(), String.valueOf(sid), TimeUtils.format((java.util.Date)date1, (String)"dd.MM.yyyy"), date2 != null ? TimeUtils.format((java.util.Date)date2, (String)"dd.MM.yyyy") : "", ""};
                        items.add(item);
                    }
                }
                rs.close();
                continue;
            }
        }
        return items;
    }

    @Override
    public Path ipNumbering() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 ip-\u043d\u0443\u043c\u0435\u0440\u0430\u0446\u0438\u0438 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path file = SormUtils.getUploadFile(this.localUserPath, NorsiTransFileTitle.IP_NUMBERING.getTitle(), "%s_%tQ.csv");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, "windows-1251");){
            Map<IpCategory, List<IpResource>> categoriesWithResources = SormUtils.getIPResources(this.config, this.serverContext);
            for (Map.Entry<IpCategory, List<IpResource>> entry : categoriesWithResources.entrySet()) {
                String ipCategoryComment = entry.getKey().getComment();
                for (IpResource ipResource : entry.getValue()) {
                    SubnetUtils subnetUtils = new SubnetUtils(IpNet.newInstance((byte[])ipResource.getAddressFrom(), (byte[])ipResource.getAddressTo()).toString());
                    SubnetUtils.SubnetInfo info = subnetUtils.getInfo();
                    String cidrSignature = info.getCidrSignature();
                    String[] item = new String[6];
                    item[0] = this.regionId;
                    String resourceComment = Utils.notBlankString((String)ipResource.getComment()) ? ipResource.getComment() : "";
                    item[1] = Utils.isBlankString((String)ipCategoryComment) ? resourceComment : ipCategoryComment;
                    item[2] = cidrSignature.substring(0, cidrSignature.indexOf("/"));
                    item[3] = cidrSignature.substring(cidrSignature.indexOf("/") + 1);
                    item[4] = ipResource.getDateFrom() != null ? TimeUtils.formatDate((java.util.Date)ipResource.getDateFrom()) : "";
                    item[5] = ipResource.getDateTo() != null ? TimeUtils.formatDate((java.util.Date)ipResource.getDateTo()) : "";
                    this.writeItemToFile(item, -1, NorsiTransFileTitle.IP_NUMBERING.getTitle(), csvFile);
                }
            }
        }
        catch (Exception ex) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 ip-\u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            this.logger.error(text + ex);
            SormUtils.sendErrorToEmail(Setup.getSetup(), ex, text, this.adminEmail);
        }
        return file;
    }

    @Override
    public Path abonentsIpNumbering() {
        return null;
    }

    @Override
    public Path switches() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043a\u043e\u043c\u043c\u0443\u0442\u0430\u0442\u043e\u0440\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path uploadFile = SormUtils.getUploadFile(this.localUserPath, NorsiTransFileTitle.SWITCHES.getTitle(), "%s_%tQ.csv");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(uploadFile, "windows-1251");){
            String[] item;
            if (this.config.get("sorm.upload.switches.enable", "").equals("1")) {
                if (this.checkInstalledModule(UploadModulesTitle.INET)) {
                    List<Device> allInetDevices = SormUtils.getInetDevices(this.config, this.serverContext);
                    Iterator<Device> iterator = allInetDevices.iterator();
                    while (iterator.hasNext()) {
                        Device inetDevice = iterator.next();
                        String[] item2 = this.getSwitchItem(inetDevice.getId(), inetDevice.getDateFrom(), inetDevice.getDateTo(), inetDevice.getComment(), inetDevice, "Ethernet");
                        this.writeItemToFile(item2, -1, NorsiTransFileTitle.SWITCHES.getTitle(), csvFile);
                    }
                }
                if (this.checkInstalledModule(UploadModulesTitle.DIAL_UP)) {
                    for (DialUpNAS dialUpNAS : SormUtils.getDialUpNasList(this.serverContext, this.config, true)) {
                        item = this.getSwitchItem(dialUpNAS.getId(), dialUpNAS.getDateFrom(), dialUpNAS.getDateTo(), dialUpNAS.getComment(), null, "Ethernet");
                        this.writeItemToFile(item, -1, NorsiTransFileTitle.SWITCHES.getTitle(), csvFile);
                    }
                }
            }
            if (this.config.get("sorm.upload.commutators.enable").equals("1")) {
                if (this.checkInstalledModule(UploadModulesTitle.VOICE)) {
                    List<Device> allVoiceDevices = SormUtils.getVoiceDevices(this.config, this.serverContext);
                    Iterator<Device> iterator = allVoiceDevices.iterator();
                    while (iterator.hasNext()) {
                        Device voiceDevice = iterator.next();
                        String[] item2 = this.getSwitchItem(voiceDevice.getId(), voiceDevice.getDateFrom(), voiceDevice.getDateTo(), voiceDevice.getComment(), voiceDevice, "Ethernet");
                        this.writeItemToFile(item2, -1, NorsiTransFileTitle.SWITCHES.getTitle(), csvFile);
                    }
                }
                if (this.checkInstalledModule(UploadModulesTitle.PHONE)) {
                    for (Source source : SormUtils.getPhoneSources(this.config, this.serverContext)) {
                        item = this.getSwitchItem(source.getId(), TimeUtils.convertCalendarToDate((Calendar)source.getDate1()), TimeUtils.convertCalendarToDate((Calendar)source.getDate2()), source.getComment(), null, "PSTN");
                        this.writeItemToFile(item, -1, NorsiTransFileTitle.SWITCHES.getTitle(), csvFile);
                    }
                }
            }
        }
        catch (Exception ex) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u043a\u043e\u043c\u043c\u0443\u0442\u0430\u0442\u043e\u0440\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            this.logger.error(text + ex.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), ex, text, this.adminEmail);
        }
        return uploadFile;
    }

    protected String[] getSwitchItem(int id, java.util.Date dateFrom, java.util.Date dateTo, String comment, Device<?, ?> device, String netType) throws Exception {
        EntityAttrAddress address = device != null ? SormUtils.getAddressFromDeviceAttributes(device) : null;
        String addressStr = address != null ? address.toString() : "";
        String[] item = new String[]{this.regionId, String.valueOf(id), dateFrom != null ? TimeUtils.formatFullDate((java.util.Date)dateFrom) : "", dateTo != null ? TimeUtils.formatFullDate((java.util.Date)dateTo) : "", Utils.maskBlank((String)comment, (String)""), netType, "", "0", "1", "", "", "", "", "", "", "", "", "", Utils.isBlankString((String)addressStr) ? this.config.get("sorm.upload.operator.location") : addressStr};
        return item;
    }

    @Override
    public Path gateways() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0448\u043b\u044e\u0437\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path file = SormUtils.getUploadFile(this.localUserPath, NorsiTransFileTitle.GATEWAYS.getTitle(), "%s_%tQ.csv");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, "windows-1251");){
            if (this.checkInstalledModule(UploadModulesTitle.INET)) {
                for (Device device : SormUtils.getSelectedGateways(this.config, this.serverContext)) {
                    EntityAttrAddress address = SormUtils.getAddressFromDeviceAttributes(device);
                    House house = address != null ? this.houseDao.get(address.getHouseId()) : null;
                    String host = device.getHost();
                    if (Utils.isBlankString((String)host)) {
                        this.logger.warn("\u041f\u043e\u043b\u0435 host \u0434\u043b\u044f \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 Inet: " + device.getId() + " \u043f\u0443\u0441\u0442\u043e\u0435 \u0438 \u043d\u0435 \u0431\u0443\u0434\u0435\u0442 \u0432\u044b\u0433\u0440\u0443\u0436\u0435\u043d\u043e, \u0442.\u043a. \u0434\u0430\u043d\u043d\u043e\u0435 \u043f\u043e\u043b\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u043c");
                        continue;
                    }
                    this.writeItemToFile(this.getGatewayItem(device.getId(), host, device.getTitle(), device.getDateFrom(), device.getDateTo(), house, address), -1, NorsiTransFileTitle.GATEWAYS.getTitle(), csvFile);
                }
            }
            if (this.checkInstalledModule(UploadModulesTitle.DIAL_UP)) {
                for (DialUpNAS nas : SormUtils.getDialUpNasList(this.serverContext, this.config, false)) {
                    this.writeItemToFile(this.getGatewayItem(nas.getId(), nas.getIp(), nas.getTitle(), nas.getDateFrom(), nas.getDateTo(), null, null), 1, NorsiTransFileTitle.GATEWAYS.getTitle(), csvFile);
                }
            }
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0448\u043b\u044e\u0437\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            this.logger.error(text + e);
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text, this.adminEmail);
        }
        return file;
    }

    protected String[] getGatewayItem(int id, String host, String title, java.util.Date dateFrom, java.util.Date dateTo, House house, EntityAttrAddress address) throws Exception {
        String[] item = new String[]{this.regionId, host, dateFrom != null ? TimeUtils.formatFullDate((java.util.Date)dateFrom) : "", dateTo != null ? TimeUtils.formatFullDate((java.util.Date)dateTo) : "", title, "\u0420\u043e\u0441\u0441\u0438\u044f", this.config.get("sorm.upload.regiontitle"), house != null ? house.getArea().getTitle() : "", house != null ? house.getCity().getTitle() : this.config.get("sorm.upload.operator.address.city"), address != null ? address.getTitle() : this.config.get("sorm.upload.operator.address.street"), house != null ? house.getHouse() + house.getFrac() : this.config.get("sorm.upload.operator.address.house"), "7"};
        return item;
    }

    @Override
    public Path bunches() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043f\u0443\u0447\u043a\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path file = SormUtils.getUploadFile(this.localUserPath, NorsiTransFileTitle.BUNCHES.getTitle(), "%s_%tQ.csv");
        List<Bunch> bunches = SormUtils.getBunches(this.config);
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, "windows-1251");){
            for (Bunch bunch : bunches) {
                this.writeItemToFile(this.getBunchItem(bunch), -1, NorsiTransFileTitle.BUNCHES.getTitle(), csvFile);
            }
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u043f\u0443\u0447\u043a\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430";
            this.logger.error(text + e);
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text, this.adminEmail);
        }
        return file;
    }

    protected String[] getBunchItem(Bunch bunch) {
        String[] item = new String[]{this.regionId, String.valueOf(bunch.getId()), Utils.maskBlank((String)bunch.getIdCommutator(), (String)""), String.valueOf(bunch.getDirectional().getCode()), bunch.getDateStart() == null ? "01.01.2010" : TimeUtils.format((java.util.Date)bunch.getDateStart(), (String)"dd.MM.yyyy HH:mm:ss"), bunch.getDateEnd() == null ? "01.01.2010" : TimeUtils.format((java.util.Date)bunch.getDateEnd(), (String)"dd.MM.yyyy HH:mm:ss"), bunch.getTitle()};
        return item;
    }

    @Override
    public Path phoneNumbering() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u043d\u043e\u0439 \u043d\u0443\u043c\u0435\u0440\u0430\u0446\u0438\u0438 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430");
        Path file = SormUtils.getUploadFile(this.localUserPath, NorsiTransFileTitle.PHONE_NUMBERING.getTitle(), "%s_%tQ.csv");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, "windows-1251");){
            ArrayList<NumberRange> resources = new ArrayList<NumberRange>();
            if (this.checkInstalledModule(UploadModulesTitle.VOICE)) {
                resources.addAll(SormUtils.getUploadVoiceNumberingResources(this.config, this.serverContext));
            }
            if (this.checkInstalledModule(UploadModulesTitle.PHONE)) {
                resources.addAll(SormUtils.getUploadPhoneNumberingResources(this.config, this.con));
            }
            for (NumberRange numberRange : resources) {
                String phoneNumberPrefix = SormUtils.trimField(String.valueOf(numberRange.getFromNumber()), 15).substring(1, 4);
                String[] item = new String[]{this.regionId, "RUS", phoneNumberPrefix, String.valueOf(phoneNumberPrefix.length()), "11", "11", "\u0420\u043e\u0441\u0441\u0438\u044f", "3", String.valueOf(numberRange.getFromNumber()).replace(phoneNumberPrefix, ""), String.valueOf(numberRange.getToNumber()).replace(phoneNumberPrefix, ""), String.valueOf(numberRange.getToNumber() - numberRange.getFromNumber() + 1L), this.config.get("sorm.upload.operator.location", ""), this.config.get("sorm.upload.operator.title", ""), numberRange.getDateFrom() != null ? TimeUtils.formatDate((java.util.Date)numberRange.getDateFrom()) : "01.01.2010", "", "", "250", "000", "", ""};
                this.writeItemToFile(item, -1, NorsiTransFileTitle.PHONE_NUMBERING.getTitle(), csvFile);
            }
            this.logger.info("\u041f\u043e \u043d\u0443\u043c\u0435\u0440\u0430\u0446\u0438\u0438 \u0441\u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439 = " + resources.size());
        }
        catch (Exception ex) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u043d\u043e\u0439 \u043d\u0443\u043c\u0435\u0440\u0430\u0446\u0438\u0438 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            this.logger.error(text + ex);
            SormUtils.sendErrorToEmail(Setup.getSetup(), ex, text, this.adminEmail);
        }
        return file;
    }

    @Override
    public Path phoneNumberingAbonents() {
        return null;
    }

    @Override
    public Path documentTypes() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0442\u0438\u043f\u043e\u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432");
        Path file = SormUtils.getUploadFile(this.localUserPath, NorsiTransFileTitle.DOC_TYPE.getTitle(), "%s_%tQ.csv");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, "windows-1251");){
            for (IdTitle docType : SormUtils.getDocumentsTypes(this.config, this.cpm)) {
                String[] item = new String[]{this.regionId, String.valueOf(docType.getId()), "01.01.2010", "", docType.getTitle()};
                this.writeItemToFile(item, -1, NorsiTransFileTitle.DOC_TYPE.getTitle(), csvFile);
            }
        }
        catch (Exception ex) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0442\u0438\u043f\u043e\u0432 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ";
            this.logger.error(text + ex);
            SormUtils.sendErrorToEmail(Setup.getSetup(), ex, text, this.adminEmail);
        }
        return file;
    }

    @Override
    public Path paymentTypes() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u0442\u0438\u043f\u043e\u0432 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439");
        Path file = SormUtils.getUploadFile(this.localUserPath, NorsiTransFileTitle.PAYMENT_TYPE.getTitle(), "%s_%tQ.csv");
        try (SormCSVWriter csvFile = SormUtils.getCSVFile(file, "windows-1251");){
            for (PaymentType paymentType : this.paymentsToUpload.getPaymentTypesToUpload()) {
                int index = 0;
                String[] item = new String[5];
                item[index++] = this.regionId;
                item[index++] = String.valueOf(paymentType.getId());
                item[index++] = "01.01.2010";
                item[index++] = "";
                item[index] = paymentType.getTitle();
                this.writeItemToFile(item, -1, NorsiTransFileTitle.PAYMENT_TYPE.getTitle(), csvFile);
            }
        }
        catch (Exception e) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u0442\u0438\u043f\u043e\u0432 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439: ";
            this.logger.info(text + e.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), e, text, this.adminEmail);
        }
        return file;
    }

    @Override
    public Path abonentsPayments() {
        this.logger.info("\u0412\u044b\u0433\u0440\u0443\u0437\u043a\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432");
        Path inetPayments = SormUtils.getUploadFile(this.localUserPath, NorsiTransFileTitle.INET_PAYMENT.getTitle(), "%s_%tQ.csv");
        Path phonePayments = SormUtils.getUploadFile(this.localUserPath, NorsiTransFileTitle.PHONE_PAYMENT.getTitle(), "%s_%tQ.csv");
        try (SormCSVWriter inetCSVFile = SormUtils.getCSVFile(inetPayments, "windows-1251");
             SormCSVWriter phoneCSVFile = SormUtils.getCSVFile(phonePayments, "windows-1251");){
            List<Payment> payments = this.paymentsToUpload.getPaymentsToUpload(true);
            List<Integer> cids = payments.stream().mapToInt(AbstractBalanceBean::getContractId).boxed().toList();
            Map<Integer, List<InetServ>> inetAbonentServices = SormUtils.getPairsAbonentInetServicesByContractIds(this.config, cids, this.serverContext);
            Map<Integer, List<VoiceAccount>> voiceAccounts = SormUtils.getPairsAbonentVoiceAccountsByContractIds(this.config, cids, this.serverContext);
            for (Payment payment : payments) {
                Contract contract = this.contractManager.getContractById(payment.getContractId());
                if (contract == null) continue;
                this.helper.setCurrentContract(contract);
                if (inetAbonentServices.containsKey(payment.getContractId())) {
                    for (InetServ inetServ : inetAbonentServices.get(payment.getContractId())) {
                        this.writeItemToFile(this.getInetPaymentItem(payment, contract.getTitle(), this.getIPAddressByInetServ(inetServ)), this.helper.getCurrentContract().getContractId(), NorsiTransFileTitle.INET_PAYMENT.getTitle(), inetCSVFile);
                    }
                }
                if (!voiceAccounts.containsKey(payment.getContractId())) continue;
                for (VoiceAccount account : voiceAccounts.get(payment.getContractId())) {
                    String number = account.getNumber() > 0L ? String.valueOf(account.getNumber()) : "";
                    this.writeItemToFile(this.getPhonePaymentItem(payment, number), this.helper.getCurrentContract().getContractId(), NorsiTransFileTitle.PHONE_PAYMENT.getTitle(), phoneCSVFile);
                }
            }
            if (Utils.notEmptyCollection(payments)) {
                this.paymentsToUpload.updatePaymentsLogTable(payments.get(payments.size() - 1).getId());
            }
        }
        catch (Exception ex) {
            String text = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u0433\u0440\u0443\u0437\u043a\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u043e\u0432: ";
            this.logger.error(text + ex.getMessage());
            SormUtils.sendErrorToEmail(Setup.getSetup(), ex, text, this.adminEmail);
        }
        this.otherFiles.add(phonePayments);
        return inetPayments;
    }

    private String getIPAddressByInetServ(InetServ inetServ) throws UnknownHostException {
        byte[] addressFrom = inetServ.getAddressFrom();
        InetAddress inetAddress = null;
        if (addressFrom != null) {
            inetAddress = InetAddress.getByAddress(addressFrom);
        }
        return inetAddress != null ? inetAddress.getHostAddress() : "";
    }

    @Override
    public Path operatorInfo() {
        return null;
    }

    protected boolean isInetContract(Contract contract, ContractModuleManager contractModuleManager) throws BGException {
        Set contractModuleSet = contractModuleManager.getContractModuleSet(contract.getId());
        List ethernetMids = ((SormService)this.serverContext.getService(SormService.class, this.serverContext.getModuleId())).getInstalledEthernetModules().stream().mapToInt(InstalledInstanceModule::getModuleId).boxed().collect(Collectors.toList());
        for (Integer ethernetMid : ethernetMids) {
            if (!contractModuleSet.contains(ethernetMid)) continue;
            return true;
        }
        return false;
    }

    protected boolean isPhoneContract(Contract contract, ContractModuleManager contractModuleManager) throws BGException {
        Set contractModuleSet = contractModuleManager.getContractModuleSet(contract.getId());
        List<Integer> telephoneModulesIds = ((SormService)this.serverContext.getService(SormService.class, this.serverContext.getModuleId())).getInstalledPhoneModules().stream().mapToInt(InstalledInstanceModule::getModuleId).boxed().toList();
        for (Integer telephoneMid : telephoneModulesIds) {
            if (!contractModuleSet.contains(telephoneMid)) continue;
            return true;
        }
        return false;
    }

    protected String[] getInetPaymentItem(Payment payment, String contractTitle, String ipv4) throws Exception {
        String[] item = new String[]{this.regionId, String.valueOf(payment.getTypeId()), contractTitle, Utils.maskBlank((String)ipv4, (String)""), TimeUtils.formatFullDate((java.util.Date)payment.getDate()), Utils.formatBigDecimalSumm((BigDecimal)payment.getSum()), PaymentsToUpload.getAdditionalPaymentData(payment).replace("\n", " ")};
        return item;
    }

    protected String[] getPhonePaymentItem(Payment payment, String phone) throws Exception {
        String[] item = new String[]{this.regionId, String.valueOf(payment.getTypeId()), Utils.maskBlank((String)phone, (String)""), TimeUtils.formatFullDate((java.util.Date)payment.getDate()), Utils.formatBigDecimalSumm((BigDecimal)payment.getSum()), PaymentsToUpload.getAdditionalPaymentData(payment).replace("\n", " ")};
        return item;
    }

    @Override
    public List<Pair<String, Path>> getOtherFiles() {
        ArrayList<Pair<String, Path>> result = new ArrayList<Pair<String, Path>>();
        this.otherFiles.forEach(f -> result.add(new Pair(null, f)));
        return result;
    }

    protected String[] getInetItem(SormContract contract, InetServ serv, List<IdTitle> documentTypes) throws Exception {
        String fioType;
        String[] item = new String[76];
        boolean isFiz = contract.isFiz();
        String contractDate = TimeUtils.formatFullDate((java.util.Date)contract.getDateFrom());
        item[0] = this.regionId;
        item[1] = SormUtils.trimField(Utils.maskBlank((String)serv.getLogin(), (String)"-"), 64);
        item[2] = serv.getAddressFrom() != null ? IpAddress.toString((byte[])serv.getAddressFrom()) : "";
        String email = this.contractDao.getEmailFromContractParameter(contract.getContractId(), this.config.getInt("sorm.upload.fiz.email", -1));
        if (Utils.isBlankString((String)email)) {
            email = this.helper.getStringParam("sorm.upload.org.email");
        }
        item[3] = Utils.maskBlank((String)email, (String)"-").trim().replaceAll("\\n", ",");
        item[4] = isFiz ? this.helper.getPhoneParam("sorm.upload.fiz.phone") : this.helper.getPhoneParam("sorm.upload.org.phone");
        StringBuilder mac = new StringBuilder();
        List macAddressList = serv.getMacAddressList();
        if (Utils.notEmptyCollection((Collection)macAddressList)) {
            for (byte[] macAddress : macAddressList) {
                mac.append(MACParser.macAddressToString((byte[])macAddress)).append(", ");
            }
            if (mac.length() > 0) {
                mac = new StringBuilder(mac.substring(0, mac.length() - 2));
            }
        }
        item[5] = Utils.maskBlank((String)mac.toString(), (String)"").trim();
        item[6] = contractDate;
        item[7] = SormUtils.trimField(contract.getContractTitle(), 64);
        item[8] = this.helper.contractIsActive() ? "0" : "1";
        item[9] = serv.getDateFrom() != null ? TimeUtils.formatFullDate((java.util.Date)serv.getDateFrom()) : contractDate;
        String serviceDateTo = "";
        if (contract.getDateTo() != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -1);
            java.util.Date defaultDateTo = calendar.getTime();
            serviceDateTo = contract.getDateTo().before(defaultDateTo) ? TimeUtils.formatFullDate((java.util.Date)contract.getDateTo()) : TimeUtils.formatFullDate((java.util.Date)defaultDateTo);
        }
        item[10] = serviceDateTo;
        item[11] = isFiz ? "0" : "1";
        String lastName = this.helper.getLastName();
        String firstName = this.helper.getFirstName();
        String middlename = this.helper.getMiddleName();
        String unstructFio = "";
        if (Utils.notBlankString((String)lastName) && Utils.notBlankString((String)firstName) && Utils.notBlankString((String)middlename)) {
            fioType = "0";
        } else {
            fioType = "1";
            unstructFio = this.helper.getStringParam("sorm.upload.fiz.unstructfio");
        }
        item[12] = isFiz ? fioType : "";
        item[13] = isFiz ? Utils.maskBlank((String)firstName, (String)"") : "";
        item[14] = isFiz ? Utils.maskBlank((String)middlename, (String)"") : "";
        item[15] = isFiz ? Utils.maskBlank((String)lastName, (String)"") : "";
        item[16] = isFiz ? Utils.maskBlank((String)unstructFio, (String)"") : "";
        item[17] = isFiz ? this.helper.getBirthday("dd.MM.yyyy") : "";
        String series = this.helper.getDocumentSerial();
        String number = this.helper.getDocumentNumber();
        String whoGive = this.helper.getDocumentWhoGive();
        String whenGive = this.helper.getDocumentWhenGive("dd.MM.yyyy");
        String whoWhenGive = whenGive + " " + whoGive;
        String unstructDocument = this.helper.getStringParam("sorm.upload.fiz.documentunstruct");
        String documentDateString = this.helper.getDateParam("sorm.upload.fiz.documentwhengive", "dd.MM.yyyy");
        String docType = Utils.notBlankString((String)series) && Utils.notBlankString((String)number) && Utils.notBlankString((String)whoWhenGive) ? (isFiz ? "0" : "") : (isFiz ? "1" : "");
        boolean documentStruct = "0".equals(docType);
        if (isFiz) {
            item[18] = docType;
            item[19] = documentStruct ? SormUtils.trimField(series, 16) : "";
            item[20] = documentStruct ? SormUtils.trimField(number, 16) : "";
            item[21] = documentStruct ? SormUtils.trimField(whoGive + " " + documentDateString, 256) : "";
            item[22] = documentStruct ? "" : SormUtils.trimField(unstructDocument, 1024);
            item[23] = String.valueOf(SormUtils.getDocumentTypeIdOfContract(this.config, this.contractDao, contract.getContractId(), documentTypes));
        } else {
            item[18] = "";
            item[19] = "";
            item[20] = "";
            item[21] = "";
            item[22] = "";
            item[23] = "";
        }
        item[24] = "";
        item[25] = "";
        item[26] = isFiz ? "" : Utils.maskBlank((String)this.helper.getFullTitleOrg(), (String)"-");
        item[27] = isFiz ? "" : Utils.maskBlank((String)this.helper.getINN(), (String)"0000000000").trim();
        item[28] = isFiz ? "" : this.helper.getStringParam("sorm.upload.org.contactface").trim();
        item[29] = isFiz ? "" : SormUtils.trimField(this.helper.getPhoneParam("sorm.upload.org.phone"), 128);
        String bankTitle = this.helper.getBankTitle();
        String bankAccount = this.helper.getBankAccount().replaceAll("\u0440/\u0441 ", "").trim();
        item[30] = isFiz ? "" : SormUtils.trimField(bankTitle, 256);
        item[31] = isFiz ? "" : SormUtils.trimField(bankAccount.trim(), 30);
        AddressStruct address = this.helper.getAddress();
        boolean addressIsStruct = SormUtils.checkValidAddress(address);
        String region = "";
        String zone = "";
        if (addressIsStruct) {
            region = SormUtils.getParameterOfCity((Upload)this, address, "region");
            zone = SormUtils.getParameterOfCity((Upload)this, address, "zone");
        }
        item[32] = addressIsStruct ? "0" : "1";
        item[33] = addressIsStruct ? SormUtils.trimField(address.getIndex(), 32) : "";
        item[34] = addressIsStruct ? "\u0420\u043e\u0441\u0441\u0438\u044f" : "";
        item[35] = addressIsStruct ? region : "";
        item[36] = addressIsStruct ? zone : "";
        item[37] = addressIsStruct ? SormUtils.trimField(address.getCity(), 128) : "";
        item[38] = addressIsStruct ? SormUtils.trimField(address.getStreet(), 128) : "";
        item[39] = addressIsStruct ? SormUtils.trimField(address.getHouse(), 128) : "";
        item[40] = addressIsStruct ? SormUtils.trimField(address.getFrac(), 128) : "";
        item[41] = addressIsStruct ? SormUtils.trimField(address.getFlat(), 128) : "";
        String unstructAddress = SormUtils.trimField(this.helper.getUnstructAddress(), 1024);
        String string = item[42] = addressIsStruct ? "" : unstructAddress;
        if (!addressIsStruct && Utils.isBlankString((String)unstructAddress)) {
            item[32] = "";
        }
        if (addressIsStruct = SormUtils.checkValidAddress(address = this.helper.getCommutatorsAddress())) {
            region = SormUtils.getParameterOfCity((Upload)this, address, "region");
            zone = SormUtils.getParameterOfCity((Upload)this, address, "zone");
        }
        item[43] = addressIsStruct ? "0" : "1";
        item[44] = addressIsStruct ? SormUtils.trimField(address.getIndex(), 32) : "";
        item[45] = addressIsStruct ? "\u0420\u043e\u0441\u0441\u0438\u044f" : "";
        item[46] = addressIsStruct ? region : "";
        item[47] = addressIsStruct ? zone : "";
        item[48] = addressIsStruct ? SormUtils.trimField(address.getCity(), 128) : "";
        item[49] = addressIsStruct ? SormUtils.trimField(address.getStreet(), 128) : "";
        item[50] = addressIsStruct ? SormUtils.trimField(address.getHouse(), 128) : "";
        item[51] = addressIsStruct ? SormUtils.trimField(address.getFrac(), 128) : "";
        item[52] = addressIsStruct ? SormUtils.trimField(address.getFlat(), 128) : "";
        unstructAddress = SormUtils.trimField(this.helper.getUnstructCommutatorsAddress(), 1024);
        String string2 = item[53] = addressIsStruct ? "" : unstructAddress;
        if (!addressIsStruct && Utils.isBlankString((String)unstructAddress)) {
            item[43] = "";
        }
        if (isFiz) {
            item[54] = "";
            item[55] = "";
            item[56] = "";
            item[57] = "";
            item[58] = "";
            item[59] = "";
            item[60] = "";
            item[61] = "";
            item[62] = "";
            item[63] = "";
            item[64] = "";
            item[65] = "";
            item[66] = "";
            item[67] = "";
            item[68] = "";
            item[69] = "";
            item[70] = "";
            item[71] = "";
            item[72] = "";
            item[73] = "";
            item[74] = "";
            item[75] = "";
        } else {
            address = this.helper.getAddressBills();
            unstructAddress = this.helper.getUnstructAddressBills();
            addressIsStruct = SormUtils.checkValidAddress(address);
            if (!addressIsStruct && Utils.isBlankString((String)unstructAddress) && !(addressIsStruct = SormUtils.checkValidAddress(address = this.helper.getCommutatorsAddress()))) {
                unstructAddress = this.helper.getUnstructCommutatorsAddress();
            }
            if (addressIsStruct) {
                region = SormUtils.getParameterOfCity((Upload)this, address, "region");
                zone = SormUtils.getParameterOfCity((Upload)this, address, "zone");
            }
            item[54] = addressIsStruct ? "0" : "1";
            item[55] = addressIsStruct ? SormUtils.trimField(address.getIndex(), 32) : "";
            item[56] = addressIsStruct ? "\u0420\u043e\u0441\u0441\u0438\u044f" : "";
            item[57] = addressIsStruct ? region : "";
            item[58] = addressIsStruct ? zone : "";
            item[59] = addressIsStruct ? SormUtils.trimField(address.getCity(), 128) : "";
            item[60] = addressIsStruct ? SormUtils.trimField(address.getStreet(), 128) : "";
            item[61] = addressIsStruct ? SormUtils.trimField(address.getHouse(), 128) : "";
            item[62] = addressIsStruct ? SormUtils.trimField(address.getFrac(), 128) : "";
            item[63] = addressIsStruct ? SormUtils.trimField(address.getFlat(), 128) : "";
            String string3 = item[64] = addressIsStruct ? "" : unstructAddress;
            if (!addressIsStruct && Utils.isBlankString((String)unstructAddress)) {
                item[54] = "";
            }
            item[65] = addressIsStruct ? "0" : "1";
            item[66] = addressIsStruct ? SormUtils.trimField(address.getIndex(), 32) : "";
            item[67] = addressIsStruct ? "\u0420\u043e\u0441\u0441\u0438\u044f" : "";
            item[68] = addressIsStruct ? region : "";
            item[69] = addressIsStruct ? zone : "";
            item[70] = addressIsStruct ? SormUtils.trimField(address.getCity(), 128) : "";
            item[71] = addressIsStruct ? SormUtils.trimField(address.getStreet(), 128) : "";
            item[72] = addressIsStruct ? SormUtils.trimField(address.getHouse(), 128) : "";
            item[73] = addressIsStruct ? SormUtils.trimField(address.getFrac(), 128) : "";
            item[74] = addressIsStruct ? SormUtils.trimField(address.getFlat(), 128) : "";
            unstructAddress = SormUtils.trimField(this.helper.getUnstructAddressBills(), 1024);
            String string4 = item[75] = addressIsStruct ? "" : unstructAddress;
            if (!addressIsStruct && Utils.isBlankString((String)unstructAddress)) {
                item[65] = "";
            }
        }
        return item;
    }

    protected String[] getPhoneItem(SormContract contract, String phoneNumber, java.util.Date dateFrom, List<IdTitle> documentTypes) throws Exception {
        String fioType;
        boolean isFiz = contract.isFiz();
        String contractDate = TimeUtils.formatFullDate((java.util.Date)contract.getDateFrom());
        String[] item = new String[75];
        item[0] = this.regionId;
        item[1] = SormUtils.trimField(Utils.maskBlank((String)phoneNumber, (String)"-"), 32);
        item[2] = SormUtils.trimField("", 32);
        item[3] = contractDate;
        item[4] = SormUtils.trimField(contract.getContractTitle(), 64);
        item[5] = this.helper.contractIsActive() ? "0" : "1";
        item[6] = dateFrom != null ? TimeUtils.formatFullDate((java.util.Date)dateFrom) : contractDate;
        String endDate = "";
        if (contract.getStatus() != 0 && contract.getDateTo() != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -1);
            java.util.Date defaultDateTo = calendar.getTime();
            endDate = contract.getDateTo().before(defaultDateTo) ? TimeUtils.formatFullDate((java.util.Date)contract.getDateTo()) : TimeUtils.formatFullDate((java.util.Date)defaultDateTo);
        }
        item[7] = endDate;
        item[8] = isFiz ? "0" : "1";
        String lastName = this.helper.getLastName();
        String firstName = this.helper.getFirstName();
        String middlename = this.helper.getMiddleName();
        String unstructFio = "";
        if (Utils.notBlankString((String)lastName) && Utils.notBlankString((String)firstName) && Utils.notBlankString((String)middlename)) {
            fioType = "0";
        } else {
            fioType = "1";
            unstructFio = this.helper.getStringParam("sorm.upload.fiz.unstructfio");
        }
        item[9] = isFiz ? fioType : "";
        item[10] = isFiz ? Utils.maskBlank((String)firstName, (String)"") : "";
        item[11] = isFiz ? Utils.maskBlank((String)middlename, (String)"") : "";
        item[12] = isFiz ? Utils.maskBlank((String)lastName, (String)"") : "";
        item[13] = isFiz ? Utils.maskBlank((String)unstructFio, (String)"") : "";
        item[14] = isFiz ? this.helper.getBirthday("dd.MM.yyyy") : "";
        String series = this.helper.getDocumentSerial();
        String number = this.helper.getDocumentNumber();
        String whoGive = this.helper.getDocumentWhoGive();
        String whenGive = this.helper.getDocumentWhenGive("dd.MM.yyyy");
        String whoWhenGive = whenGive + " " + whoGive;
        String unstructDocument = this.helper.getStringParam("sorm.upload.fiz.documentunstruct");
        String documentDateString = this.helper.getDateParam("sorm.upload.fiz.documentwhengive", "dd.MM.yyyy");
        String docType = Utils.notBlankString((String)series) && Utils.notBlankString((String)number) && Utils.notBlankString((String)whoWhenGive) ? (isFiz ? "0" : "") : (isFiz ? "1" : "");
        boolean documentStruct = "0".equals(docType);
        if (isFiz) {
            item[15] = docType;
            item[16] = documentStruct ? SormUtils.trimField(series, 16) : "";
            item[17] = documentStruct ? SormUtils.trimField(number, 16) : "";
            item[18] = documentStruct ? SormUtils.trimField(whoGive + " " + documentDateString, 256) : "";
            item[19] = documentStruct ? "" : SormUtils.trimField(unstructDocument, 1024);
            item[20] = String.valueOf(SormUtils.getDocumentTypeIdOfContract(this.config, this.contractDao, contract.getContractId(), documentTypes));
        } else {
            item[15] = "";
            item[16] = "";
            item[17] = "";
            item[18] = "";
            item[19] = "";
            item[20] = "";
        }
        item[21] = "";
        item[22] = "";
        item[23] = isFiz ? "" : Utils.maskBlank((String)this.helper.getFullTitleOrg(), (String)"-");
        String inn = this.helper.getINN();
        item[24] = isFiz ? "" : SormUtils.trimField(Utils.maskBlank((String)inn, (String)"0000000000").trim(), 64);
        item[25] = isFiz ? "" : SormUtils.trimField(this.helper.getStringParam("sorm.upload.org.contactface"), 128);
        String phoneOrg = this.helper.getContactFacePhone();
        item[26] = isFiz ? "" : SormUtils.trimField(phoneOrg, 128);
        item[27] = isFiz ? "" : SormUtils.trimField("", 64);
        item[28] = isFiz ? "" : SormUtils.trimField("", 64);
        String bankTitle = this.helper.getBankTitle();
        String bankAccount = this.helper.getBankAccount().replaceAll("\u0440/\u0441 ", "").trim();
        item[29] = isFiz ? "" : SormUtils.trimField(Utils.maskBlank((String)bankTitle, (String)"").trim(), 256);
        item[30] = isFiz ? "" : SormUtils.trimField(Utils.maskBlank((String)bankAccount, (String)"").trim(), 30);
        AddressStruct address = this.helper.getAddress();
        boolean isAddressStruct = SormUtils.checkValidAddress(address);
        String region = "";
        String zone = "";
        if (isAddressStruct) {
            region = SormUtils.getParameterOfCity((Upload)this, address, "region");
            zone = SormUtils.getParameterOfCity((Upload)this, address, "zone");
        }
        item[31] = isAddressStruct ? "0" : "1";
        item[32] = isAddressStruct ? SormUtils.trimField(address.getIndex(), 32) : "";
        item[33] = isAddressStruct ? "\u0420\u043e\u0441\u0441\u0438\u044f" : "";
        item[34] = isAddressStruct ? region : "";
        item[35] = isAddressStruct ? zone : "";
        item[36] = isAddressStruct ? SormUtils.trimField(address.getCity(), 128) : "";
        item[37] = isAddressStruct ? SormUtils.trimField(address.getStreet(), 128) : "";
        item[38] = isAddressStruct ? SormUtils.trimField(address.getHouse(), 128) : "";
        item[39] = isAddressStruct ? SormUtils.trimField(address.getFrac(), 128) : "";
        item[40] = isAddressStruct ? SormUtils.trimField(address.getFlat(), 128) : "";
        item[41] = isAddressStruct ? "" : SormUtils.trimField(this.helper.getUnstructAddress(), 1024);
        address = this.helper.getCommutatorsAddress();
        isAddressStruct = SormUtils.checkValidAddress(address);
        item[42] = isAddressStruct ? "0" : "1";
        item[43] = isAddressStruct ? SormUtils.trimField(address.getIndex(), 32) : "";
        item[44] = isAddressStruct ? "\u0420\u043e\u0441\u0441\u0438\u044f" : "";
        item[45] = isAddressStruct ? region : "";
        item[46] = isAddressStruct ? zone : "";
        item[47] = isAddressStruct ? SormUtils.trimField(address.getCity(), 128) : "";
        item[48] = isAddressStruct ? SormUtils.trimField(address.getStreet(), 128) : "";
        item[49] = isAddressStruct ? SormUtils.trimField(address.getHouse(), 128) : "";
        item[50] = isAddressStruct ? SormUtils.trimField(address.getFrac(), 128) : "";
        item[51] = isAddressStruct ? SormUtils.trimField(address.getFlat(), 128) : "";
        String string = item[52] = isAddressStruct ? "" : SormUtils.trimField(this.helper.getUnstructCommutatorsAddress(), 1024);
        if (isFiz) {
            item[53] = "";
            item[54] = "";
            item[55] = "";
            item[56] = "";
            item[57] = "";
            item[58] = "";
            item[59] = "";
            item[60] = "";
            item[61] = "";
            item[62] = "";
            item[63] = "";
            item[64] = "";
            item[65] = "";
            item[66] = "";
            item[67] = "";
            item[68] = "";
            item[69] = "";
            item[70] = "";
            item[71] = "";
            item[72] = "";
            item[73] = "";
            item[74] = "";
        } else {
            address = this.helper.getAddressBills();
            String unstructBillAddress = this.helper.getUnstructAddressBills();
            isAddressStruct = SormUtils.checkValidAddress(address);
            if (!isAddressStruct && Utils.isBlankString((String)unstructBillAddress) && !(isAddressStruct = SormUtils.checkValidAddress(address = this.helper.getCommutatorsAddress()))) {
                unstructBillAddress = this.helper.getUnstructCommutatorsAddress();
            }
            if (isAddressStruct) {
                region = SormUtils.getParameterOfCity((Upload)this, address, "region");
                zone = SormUtils.getParameterOfCity((Upload)this, address, "zone");
            }
            item[53] = isAddressStruct ? "0" : "1";
            item[54] = isAddressStruct ? SormUtils.trimField(address.getIndex(), 32) : "";
            item[55] = isAddressStruct ? "\u0420\u043e\u0441\u0441\u0438\u044f" : "";
            item[56] = isAddressStruct ? region : "";
            item[57] = isAddressStruct ? zone : "";
            item[58] = isAddressStruct ? SormUtils.trimField(address.getCity(), 128) : "";
            item[59] = isAddressStruct ? SormUtils.trimField(address.getStreet(), 128) : "";
            item[60] = isAddressStruct ? SormUtils.trimField(address.getHouse(), 128) : "";
            item[61] = isAddressStruct ? SormUtils.trimField(address.getFrac(), 128) : "";
            item[62] = isAddressStruct ? SormUtils.trimField(address.getFlat(), 128) : "";
            item[63] = isAddressStruct ? "" : SormUtils.trimField(unstructBillAddress, 1024);
            item[64] = isAddressStruct ? "0" : "1";
            item[65] = isAddressStruct ? SormUtils.trimField(address.getIndex(), 32) : "";
            item[66] = isAddressStruct ? "\u0420\u043e\u0441\u0441\u0438\u044f" : "";
            item[67] = isAddressStruct ? region : "";
            item[68] = isAddressStruct ? zone : "";
            item[69] = isAddressStruct ? SormUtils.trimField(address.getCity(), 128) : "";
            item[70] = isAddressStruct ? SormUtils.trimField(address.getStreet(), 128) : "";
            item[71] = isAddressStruct ? SormUtils.trimField(address.getHouse(), 128) : "";
            item[72] = isAddressStruct ? SormUtils.trimField(address.getFrac(), 128) : "";
            item[73] = isAddressStruct ? SormUtils.trimField(address.getFlat(), 128) : "";
            item[74] = isAddressStruct ? "" : SormUtils.trimField(this.helper.getUnstructAddressBills(), 1024);
        }
        return item;
    }
}

