/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client.bean;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import ru.bitel.common.Utils;

public class BGBillTablePos {
    private int positionId;
    private String name;
    private BigDecimal summ;
    public BigDecimal sumUnscaled;
    private BigDecimal quantity;
    public int qtynums;
    public int qtynumsRnd;
    private String unit;
    public String unitCode;
    public boolean inSum = true;
    public boolean awlz = false;
    private Map<String, String> params = new HashMap<String, String>();
    private int serviceId = -1;
    private int moduleId = -1;

    public void fromElement(Element item) {
        this.name = item.getAttribute("name");
        this.summ = Utils.parseBigDecimal((String)item.getAttribute("summ"), (BigDecimal)BigDecimal.ZERO);
        this.sumUnscaled = Utils.parseBigDecimal((String)item.getAttribute("sumUnscaled"), (BigDecimal)this.summ);
        this.positionId = Utils.parseInt((String)item.getAttribute("position_id"), (int)0);
        this.quantity = Utils.parseBigDecimal((String)item.getAttribute("quantity"), (BigDecimal)BigDecimal.ONE);
        this.qtynums = Utils.parseInt((String)item.getAttribute("qtynums"), (int)0);
        this.qtynumsRnd = Utils.parseInt((String)item.getAttribute("qtynumsRnd"), (int)4);
        this.unit = item.getAttribute("unit");
        this.unitCode = item.getAttribute("unitCode");
        this.inSum = !item.getAttribute("insum").equals("0");
        this.awlz = item.getAttribute("awlz").equals("1");
        this.serviceId = Utils.parseInt((String)item.getAttribute("sid"), (int)-1);
        this.moduleId = Utils.parseInt((String)item.getAttribute("mid"), (int)-1);
    }

    public void fromElement(Attributes item) {
        this.summ = Utils.parseBigDecimal((String)item.getValue("summ"), (BigDecimal)BigDecimal.ZERO);
        this.sumUnscaled = Utils.parseBigDecimal((String)item.getValue("sumUnscaled"), (BigDecimal)this.summ);
        this.positionId = Utils.parseInt((String)item.getValue("position_id"), (int)0);
        this.quantity = Utils.parseBigDecimal((String)item.getValue("quantity"), (BigDecimal)BigDecimal.ONE);
        this.qtynums = Utils.parseInt((String)item.getValue("qtynums"), (int)0);
        this.qtynumsRnd = Utils.parseInt((String)item.getValue("qtynumsRnd"), (int)4);
        this.name = item.getValue("name");
        this.unit = item.getValue("unit");
        this.unitCode = item.getValue("unitCode");
        this.inSum = !item.getValue("insum").equals("0");
        this.awlz = item.getValue("awlz").equals("1");
        this.serviceId = Utils.parseInt((String)item.getValue("sid"), (int)-1);
        this.moduleId = Utils.parseInt((String)item.getValue("mid"), (int)-1);
        for (int i = 0; i < item.getLength(); ++i) {
            String[] names = item.getQName(i).split("_");
            if (names.length < 2 || !names[0].equals("param")) continue;
            this.params.put(names[1], item.getValue(i));
        }
    }

    public void toElement(Element item) {
        item.setAttribute("name", this.name);
        item.setAttribute("summ", Utils.formatBigDecimalSumm((BigDecimal)this.summ));
        item.setAttribute("sumUnscaled", this.sumUnscaled != null ? Utils.formatBigDecimal((BigDecimal)this.sumUnscaled, (int)5) : Utils.formatBigDecimal((BigDecimal)this.summ, (int)5));
        item.setAttribute("position_id", String.valueOf(this.positionId));
        item.setAttribute("quantity", Utils.maskNull((BigDecimal)this.quantity).setScale(this.qtynums, RoundingMode.valueOf(this.qtynumsRnd)).toString());
        item.setAttribute("qtynums", String.valueOf(this.qtynums));
        item.setAttribute("qtynumsRnd", String.valueOf(this.qtynumsRnd));
        item.setAttribute("unit", this.unit);
        item.setAttribute("unitCode", this.unitCode);
        item.setAttribute("insum", Utils.booleanToStringInt((boolean)this.inSum));
        item.setAttribute("awlz", Utils.booleanToStringInt((boolean)this.awlz));
        if (this.serviceId > 0) {
            item.setAttribute("sid", String.valueOf(this.serviceId));
        }
        if (this.moduleId > 0) {
            item.setAttribute("mid", String.valueOf(this.moduleId));
        }
        for (String name : this.params.keySet()) {
            String value = this.params.get(name);
            item.setAttribute("param_" + name, value);
        }
    }

    public void toElement(XMLStreamWriter item) throws XMLStreamException {
        item.writeAttribute("name", this.name);
        item.writeAttribute("summ", Utils.formatBigDecimalSumm((BigDecimal)this.summ));
        item.writeAttribute("sumUnscaled", this.sumUnscaled != null ? Utils.formatBigDecimal((BigDecimal)this.sumUnscaled, (int)5) : Utils.formatBigDecimal((BigDecimal)this.summ, (int)5));
        item.writeAttribute("position_id", String.valueOf(this.positionId));
        item.writeAttribute("quantity", Utils.maskNull((BigDecimal)this.quantity).setScale(this.qtynums, RoundingMode.valueOf(this.qtynumsRnd)).toString());
        item.writeAttribute("qtynums", String.valueOf(this.qtynums));
        item.writeAttribute("qtynumsRnd", String.valueOf(this.qtynumsRnd));
        item.writeAttribute("unit", this.unit);
        item.writeAttribute("unitCode", this.unitCode);
        item.writeAttribute("insum", Utils.booleanToStringInt((boolean)this.inSum));
        item.writeAttribute("awlz", Utils.booleanToStringInt((boolean)this.awlz));
        if (this.serviceId > 0) {
            item.writeAttribute("sid", String.valueOf(this.serviceId));
        }
        if (this.moduleId > 0) {
            item.writeAttribute("mid", String.valueOf(this.moduleId));
        }
        for (String name : this.params.keySet()) {
            String value = this.params.get(name);
            item.writeAttribute("param_" + name, value);
        }
    }

    public BGBillTablePos clone() {
        return new BGBillTablePos().setName(this.name).setPositionId(this.positionId).setQuantity(this.quantity).setQtynums(this.qtynums).setQtynumsRnd(this.qtynumsRnd).setSum(this.summ).setSumUnscaled(this.sumUnscaled).setUnit(this.unit).setUnitCode(this.unitCode).setInSum(this.inSum).setAwlz(this.awlz).setServiceId(this.serviceId).setModuleId(this.moduleId);
    }

    public int getPositionId() {
        return this.positionId;
    }

    public BGBillTablePos setPositionId(int positionId) {
        this.positionId = positionId;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public BGBillTablePos setName(String name) {
        this.name = name;
        return this;
    }

    public BGBillTablePos setSum(BigDecimal sum) {
        this.summ = sum;
        return this;
    }

    public BigDecimal getSum() {
        return this.summ;
    }

    public BGBillTablePos setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
        return this;
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public BGBillTablePos setUnit(String unit) {
        this.unit = unit;
        return this;
    }

    public String getUnit() {
        return this.unit;
    }

    public BGBillTablePos setQtynums(int qtynums) {
        this.qtynums = qtynums;
        return this;
    }

    public BGBillTablePos setQtynumsRnd(int qtynumsRnd) {
        this.qtynumsRnd = qtynumsRnd;
        return this;
    }

    public BGBillTablePos setSumUnscaled(BigDecimal sumUnscaled) {
        this.sumUnscaled = sumUnscaled;
        return this;
    }

    public BGBillTablePos setUnitCode(String unitCode) {
        this.unitCode = unitCode;
        return this;
    }

    public BGBillTablePos setInSum(boolean inSum) {
        this.inSum = inSum;
        return this;
    }

    public BGBillTablePos setAwlz(boolean awlz) {
        this.awlz = awlz;
        return this;
    }

    public BGBillTablePos setServiceId(int serviceId) {
        this.serviceId = serviceId;
        return this;
    }

    public BGBillTablePos setModuleId(int moduleId) {
        this.moduleId = moduleId;
        return this;
    }
}

