/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.converters;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.kernel.base.converters.AbstractBGConverter;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.Group;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.BGSActionGroupDao;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.PermissionKitDao;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.RoleDao;
import ru.bitel.bgbilling.kernel.bgsecure.server.bean.UserPermitionsManager;
import ru.bitel.bgbilling.kernel.module.common.bean.BGSAction;
import ru.bitel.bgbilling.kernel.module.common.bean.BGSActionGroup;
import ru.bitel.bgbilling.kernel.module.common.bean.PermissionKit;
import ru.bitel.bgbilling.kernel.module.common.bean.Role;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.module.server.bean.UserManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public class ConverterUserGroupToRoles
extends AbstractBGConverter {
    private static final String CONVERTER_DB_KEY = "roles.converter.run";
    private static final String ENABLE_CONVERTER_KEY = "bgsecure.usergroup.convert";
    private static final String ENABLE_CONVERT_WITH_DOMAIN = "bgsecure.usergroup.convert.user.domain.to.role";
    private static final String ENABLE_CONVERT_WITH_PERSONAL_ACTION = "bgsecure.usergroup.convert.user.action.to.role";
    private Setup setup;

    @Override
    public void runConverter(Connection connection) {
        this.setup = Setup.getSetup();
        boolean enableConverter = this.setup.getBoolean(ENABLE_CONVERTER_KEY, true);
        boolean needConvert = Utils.maskBlank((String)ServerUtils.getSetupValue(connection, CONVERTER_DB_KEY), (String)"0").equals("0");
        if (!enableConverter || !needConvert) {
            this.getLogger().info("\u041f\u0440\u043e\u043f\u0443\u0441\u043a \u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0430\u0446\u0438\u0438 \u0433\u0440\u0443\u043f\u043f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 \u0432 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0438 \u0441 \u043d\u043e\u0432\u043e\u0439 \u0441\u0445\u0435\u043c\u043e\u0439 \u0420\u043e\u043b\u0435\u0439 (bgsecure.usergroup.convert=" + enableConverter + "; roles.converter.run=" + needConvert + " )");
            return;
        }
        try {
            this.getLogger().info("\u0417\u0430\u043f\u0443\u0441\u043a \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0430\u0446\u0438\u0438 \u0433\u0440\u0443\u043f\u043f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 \u0432 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0438 \u0441 \u043d\u043e\u0432\u043e\u0439 \u0441\u0445\u0435\u043c\u043e\u0439 \u0420\u043e\u043b\u0435\u0439");
            this.convert(connection);
            ServerUtils.setSetupValue(connection, CONVERTER_DB_KEY, "1");
        }
        catch (Exception ex) {
            this.logError(ex);
        }
        this.getLogger().info("\u0417\u0430\u043a\u043e\u043d\u0447\u0438\u043b\u0438 \u043a\u043e\u043d\u0432\u0435\u0440\u0442\u0430\u0446\u0438\u044e \u0433\u0440\u0443\u043f\u043f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439");
    }

    private void convert(Connection connection) throws Exception {
        boolean createRoleIfDomainOnUser = this.setup.getBoolean(ENABLE_CONVERT_WITH_DOMAIN, true);
        boolean createRoleIfPersonalActionOnUser = this.setup.getBoolean(ENABLE_CONVERT_WITH_PERSONAL_ACTION, true);
        RoleDao roleDao = new RoleDao(connection);
        PermissionKitDao permissionKitDao = new PermissionKitDao(connection);
        BGSActionGroupDao bgsActionGroupDao = new BGSActionGroupDao(connection);
        UserManager userManager = new UserManager(connection);
        UserPermitionsManager userPermitionsManager = new UserPermitionsManager(connection);
        Map groupMap = this.getGroupList(connection).stream().collect(Collectors.toMap(Group::getId, Function.identity()));
        HashMap<Integer, BGSActionGroup> bgsActionGroupMap = new HashMap<Integer, BGSActionGroup>();
        HashMap<String, Role> idsKitsWithRoles = new HashMap<String, Role>();
        List<User> allUsers = userManager.list();
        this.getLogger().info("\u0412\u0441\u0435\u0433\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439 \u0434\u043b\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 = " + allUsers.size());
        for (User user : allUsers) {
            try {
                PermissionKit mainKit;
                this.getLogger().info("\u0412 \u0440\u0430\u0431\u043e\u0442\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c = " + user.getTitle());
                ArrayList<Integer> domainIds = new ArrayList<Integer>();
                int personalAction = 0;
                try (PreparedStatement ps = connection.prepareStatement("select domainIds, personal_action from user where id=?");){
                    ps.setInt(1, user.getId());
                    try (ResultSet rs = ps.executeQuery();){
                        if (rs.next()) {
                            domainIds.addAll(Utils.toIntegerList((String)rs.getString("domainIds")));
                            personalAction = rs.getInt("personal_action");
                        }
                    }
                }
                catch (SQLException ex) {
                    this.logError(ex);
                }
                Role role = null;
                if (Utils.notEmptyCollection(domainIds) && createRoleIfDomainOnUser || personalAction > 0 && createRoleIfPersonalActionOnUser) {
                    this.getLogger().info("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0439 \u0440\u043e\u043b\u0438 \u0438 \u043f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043d\u0430\u0431\u043e\u0440\u0430 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0439");
                    role = new Role();
                    PermissionKit personalKit = new PermissionKit();
                    personalKit.setTitle("\u041f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0439 \u043d\u0430\u0431\u043e\u0440 \u0434\u043b\u044f: " + user.getTitle());
                    personalKit.setActions(userPermitionsManager.getUserActions(user.getId()));
                    personalKit.setDomenIds(domainIds);
                    permissionKitDao.update((Object)personalKit);
                    role.setTitle("\u0420\u043e\u043b\u044c \u0434\u043b\u044f: " + user.getTitle());
                    role.setMenuId(user.getMenuId());
                    role.setPermissionKits(Arrays.asList(personalKit));
                }
                List<Integer> userGroupsIds = this.getUserGroups(connection, user.getId());
                if (role == null && Utils.notEmptyCollection(userGroupsIds)) {
                    String userGroupsStr = Utils.toString(userGroupsIds);
                    role = idsKitsWithRoles.getOrDefault(userGroupsStr, null);
                    if (role == null) {
                        this.getLogger().debug("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043d\u043e\u0432\u043e\u0439 \u0440\u043e\u043b\u0438 \u043d\u0430 \u043e\u0441\u043d\u043e\u0432\u0435 \u0433\u0440\u0443\u043f\u043f \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439");
                        role = new Role();
                        role.setTitle("");
                        roleDao.update((Object)role);
                        idsKitsWithRoles.put(userGroupsStr, role);
                        mainKit = new PermissionKit();
                        mainKit.setTitle("\u0421\u043e\u0437\u0434\u0430\u043d \u043d\u0430 \u043e\u0441\u043d\u043e\u0432\u0430\u043d\u0438\u0438 \u0433\u0440\u0443\u043f\u043f \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439 \u043f\u043e\u043b\u044c\u0437-\u044f: [" + userGroupsStr + "]");
                        permissionKitDao.update((Object)mainKit);
                        role.setPermissionKits(List.of(mainKit));
                    } else {
                        this.getLogger().debug("\u0421\u043e\u0437\u0434\u0430\u043d\u043d\u0430\u044f \u0440\u043e\u043b\u044c \u0434\u043b\u044f \u0442\u0430\u043a\u043e\u0433\u043e \u0436\u0435 \u043d\u0430\u0431\u043e\u0440\u0430 \u0433\u0440\u0443\u043f\u043f \u0431\u044b\u043b\u0430 \u043d\u0430\u0439\u0434\u0435\u043d\u0430");
                    }
                }
                if (role == null && Utils.notEmptyCollection(domainIds) && !createRoleIfDomainOnUser) {
                    this.getLogger().warn("\u0423 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0441 ID= " + user + " \u0435\u0441\u0442\u044c \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u0434\u043e\u043c\u0435\u043d\u044b, \u043d\u043e \u043d\u0435 \u0441\u043e\u0437\u0434\u0430\u043b\u0438 \u0440\u043e\u043b\u044c \u0434\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0442.\u043a. \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u043d\u0435 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430");
                } else if (role == null && personalAction > 0 && !createRoleIfPersonalActionOnUser) {
                    this.getLogger().warn("\u0423 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0441 ID=" + user + " \u0435\u0441\u0442\u044c \u043f\u0435\u0440\u0441\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f, \u043d\u043e \u043d\u0435 \u0441\u043e\u0437\u0434\u0430\u043b\u0438 \u0440\u043e\u043b\u044c \u0442.\u043a. \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u043d\u0435 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430");
                } else if (role != null && Utils.isEmptyCollection(role.getPermissionKits().get(0).getActionGroups())) {
                    StringBuilder title = new StringBuilder();
                    mainKit = role.getPermissionKits().get(0);
                    for (Integer userGroup : userGroupsIds) {
                        List<BGSActionGroup> groups;
                        BGSActionGroup bgsActionGroup = (BGSActionGroup)((Object)bgsActionGroupMap.get(userGroup));
                        if (bgsActionGroup == null) {
                            this.getLogger().debug("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0439 \u043d\u0430 \u043e\u0441\u043d\u043e\u0432\u0430\u043d\u0438\u0438 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u044b \u0441 id=" + userGroup);
                            bgsActionGroup = new BGSActionGroup();
                            bgsActionGroup.setTitle(((Group)groupMap.get(userGroup)).getTitle());
                            bgsActionGroup.setActions(this.getGroupActions(connection, userGroup));
                            bgsActionGroupDao.update((Object)bgsActionGroup);
                            bgsActionGroupMap.put(userGroup, bgsActionGroup);
                        }
                        if ((groups = mainKit.getActionGroups()) == null) {
                            groups = new ArrayList<BGSActionGroup>();
                        }
                        groups.add(bgsActionGroup);
                        mainKit.setActionGroups(groups);
                        permissionKitDao.update((Object)mainKit);
                        title.append(bgsActionGroup.getTitle()).append(",");
                    }
                    String title0 = title.toString();
                    if (title0.endsWith(",")) {
                        title0 = title0.substring(0, title0.length() - 1);
                    }
                    if (Utils.isBlankString((String)role.getTitle())) {
                        role.setTitle(title0);
                    }
                    if (Utils.isBlankString((String)mainKit.getTitle())) {
                        mainKit.setTitle(title0);
                    }
                    permissionKitDao.update((Object)mainKit);
                }
                if (role == null) {
                    this.getLogger().info("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u0440\u043e\u043b\u044c \u0434\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0441 ID=" + user);
                    continue;
                }
                this.getLogger().info("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f");
                roleDao.update((Object)role);
                user.setRoleId(role.getId());
                userManager.update((Object)user);
                this.getLogger().info("\u0420\u0430\u0431\u043e\u0442\u0430 \u0441 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430");
            }
            catch (Exception ex) {
                this.logError("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f UserId=" + user.getId(), ex);
            }
        }
    }

    private List<Integer> getUserGroups(Connection connection, int userId) throws SQLException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        String query = "SELECT gid FROM bgs_user_group userGroup WHERE uid=?";
        try (PreparedStatement ps = connection.prepareStatement(query);){
            ps.setInt(1, userId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(rs.getInt("gid"));
                }
            }
        }
        Collections.sort(result);
        return result;
    }

    private List<BGSAction> getGroupActions(Connection con, int groupId) throws SQLException {
        ArrayList<BGSAction> result = new ArrayList<BGSAction>();
        String query = "SELECT * FROM bgs_group_action WHERE gid=?";
        try (PreparedStatement ps = con.prepareStatement(query);){
            ps.setInt(1, groupId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    BGSAction action = new BGSAction();
                    action.mid = rs.getString("mid");
                    action.actionID = rs.getString("aid");
                    result.add(action);
                }
            }
        }
        return result;
    }

    private List<Group> getGroupList(Connection con) throws SQLException {
        ArrayList<Group> result = new ArrayList<Group>();
        String query = "SELECT * FROM bgs_group ORDER BY title";
        try (PreparedStatement ps = con.prepareStatement(query);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                Pattern pattern = Pattern.compile("^\\d+$");
                List pids = Utils.toList((String)rs.getString("pids"));
                for (int index = 0; index < pids.size(); ++index) {
                    if (!pattern.matcher((CharSequence)pids.get(index)).matches()) continue;
                    pids.set(index, ((String)pids.get(index)).concat("C"));
                }
                Group group = new Group().setId(rs.getInt("id")).setMenuId(rs.getInt("menu_id")).setTitle(rs.getString("title")).setComment(rs.getString("comment")).setContractGroups(rs.getLong("cgr")).setContractGroupsMode(rs.getInt("cgr_mode")).setRuleAccessContractParameter(pids).setRuleAccessObjectParameter(Utils.toList((String)rs.getString("opids")));
                result.add(group);
            }
        }
        return result;
    }
}

