/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client;

import bitel.billing.module.common.table.BGTable;
import bitel.billing.module.services.ServicePanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.ipn.client.VlanGateSelectPanel;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class ContractVlanPanel
extends ServicePanel {
    private CardLayout cardLayout = new CardLayout();
    private BGTable tableGates = new BGTable();
    private VlanGateSelectPanel editor = new VlanGateSelectPanel("GetContractVlanGateAvailableList");
    private JPanel vlanEditor = new JPanel();
    private JTextField gateText = new JTextField();
    private JTextField vlanText = new JTextField();
    private int gateId = -1;

    public ContractVlanPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.cardLayout);
        this.tableGates.setHeader(this.rb_name, this.moduleDoc, "contract_vlan");
        JPanel vlanTablePanel = new JPanel(new GridBagLayout());
        JScrollPane jScrollPanel = new JScrollPane();
        jScrollPanel.setViewportView((Component)this.tableGates);
        vlanTablePanel.add((Component)jScrollPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.5, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        vlanTablePanel.add((Component)this.vlanEditor, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.editor.addActionListener(e -> {
            if (e.getActionCommand().equals("ok")) {
                this.okPressed();
            } else {
                this.cancelPressed();
            }
        });
        this.vlanEditor.setLayout(new GridBagLayout());
        this.vlanEditor.setBorder((Border)new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"));
        this.gateText.setEditable(false);
        BGPanel panel = new BGPanel((LayoutManager)new GridBagLayout());
        panel.add((Component)new JLabel("\u0448\u043b\u044e\u0437"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.gateText, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel("vlan"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panel.add((Component)this.vlanText, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.addActionListener(e -> {
            String command = e.getActionCommand();
            if (command.equals("ok")) {
                this.stopEdit();
            } else {
                this.cancelPressed();
            }
        });
        this.vlanEditor.add((Component)panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 5, 5), 0, 0));
        this.vlanEditor.add((Component)okCancel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.tableGates.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ContractVlanPanel.this.editItem();
                }
            }
        });
        this.vlanEditor.setVisible(false);
        this.add(vlanTablePanel, "view");
        this.add((Component)((Object)this.editor), "select");
        this.cardLayout.show((Container)((Object)this), "view");
    }

    public void deleteItem() {
        this.id = ClientUtils.getRowId((BGTable)this.tableGates);
        if (this.id != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c vlan \u0434\u043b\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0448\u043b\u044e\u0437\u0430?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("DeleteContactGateVlan");
            request.setModuleId(this.getModuleId());
            request.setContractId(this.getContractId());
            request.setAttribute("gid", this.id);
            if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
                this.setData();
            }
        }
    }

    public void newItem() {
        this.editor.init(this.module, this.getModuleId());
        this.editor.setContractId(this.getContractId());
        this.editor.trySetData();
        this.cardLayout.show((Container)((Object)this), "select");
    }

    public void editItem() {
        this.id = ClientUtils.getRowId((BGTable)this.tableGates);
        if (this.id != null) {
            int index = this.tableGates.getSelectedRow();
            this.gateText.setText(this.tableGates.getColumnValueString(index, "gate"));
            this.vlanText.setText(this.tableGates.getColumnValueString(index, "vlan"));
            this.gateId = Utils.parseInt((String)this.id);
            this.vlanEditor.setVisible(true);
        }
    }

    public void stopEdit() {
        int vlanId = -1;
        try {
            vlanId = Utils.parseInt((String)this.vlanText.getText());
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d \u043d\u043e\u043c\u0435\u0440 VLAN");
            return;
        }
        if (vlanId > 4096 || vlanId < 2) {
            ClientUtils.showErrorMessageDialog((String)"\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0432\u0432\u0435\u0434\u0435\u043d \u043d\u043e\u043c\u0435\u0440 VLAN");
            return;
        }
        Request request = new Request();
        request.setModule(this.module);
        request.setAction("GetUsedVlan");
        request.setModuleId(this.getModuleId());
        request.setAttribute("gid", this.gateId);
        request.setAttribute("vlanId", vlanId);
        Document doc = this.getDocument(request);
        if (ClientUtils.checkStatus((Document)doc)) {
            String vl = XMLUtils.getAttribute((Element)XMLUtils.getElement((Document)doc, (String)"vlan"), (String)"vl");
            if (vl.equals("1")) {
                ClientUtils.showErrorMessageDialog((String)"\u042d\u0442\u043e\u0442 VLAN \u0443\u0436\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f");
                return;
            }
            request = new Request();
            request.setContractId(this.getContractId());
            request.setModule(this.module);
            request.setAction("UpdateVlan");
            request.setModuleId(this.getModuleId());
            request.setAttribute("gid", this.gateId);
            request.setAttribute("vlanId", vlanId);
            doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.setData();
                this.vlanEditor.setVisible(false);
            }
        }
    }

    public void okPressed() {
        String id = this.editor.getGateId();
        if (id != null) {
            Request req = new Request();
            req.setModule(this.module);
            req.setAction("UpdateContactGateVlan");
            req.setModuleId(this.getModuleId());
            req.setContractId(this.getContractId());
            req.setAttribute("gid", id);
            req.setAttribute("vlanId", this.editor.getVlanId());
            Document doc = this.getDocument(req);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.cardLayout.show((Container)((Object)this), "view");
                this.setData();
            }
        } else {
            this.cardLayout.show((Container)((Object)this), "view");
        }
    }

    private void cancelPressed() {
        this.vlanEditor.setVisible(false);
        this.cardLayout.show((Container)((Object)this), "view");
    }

    public void setData() {
        Request req = new Request();
        req.setModule(this.module);
        req.setAction("GetContractVlanList");
        req.setModuleId(this.getModuleId());
        req.setContractId(this.getContractId());
        Document doc = this.getDocument(req);
        if (ClientUtils.checkStatus((Document)doc)) {
            this.tableGates.updateData((Node)XMLUtils.getElement((Document)doc, (String)"table"));
        }
    }
}

