/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.HashSet;
import java.util.StringTokenizer;
import ru.bitel.bgbilling.modules.ipn.server.GateWorker;
import ru.bitel.bgbilling.modules.ipn.server.UserStatus;
import ru.bitel.bgbilling.modules.ipn.server.bean.GateType;
import ru.bitel.bgbilling.modules.ipn.server.bean.RuleType;
import ru.bitel.bgbilling.modules.ipn.server.bean.command.GateCommandUtil;

public class ManadGateWorker
extends GateWorker {
    @Override
    protected void doSync() {
        String host = this.gate.getHost();
        int port = this.gate.getPort();
        int gid = this.gate.getId();
        if (this.log.isDebugEnabled()) {
            this.log.debug(gid + " gate: " + host + ":" + port);
        }
        try {
            Socket socket = new Socket(host, port);
            PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
            InputStreamReader isr = new InputStreamReader(socket.getInputStream());
            BufferedReader in = new BufferedReader(isr);
            out.println("test");
            String kods = in.readLine();
            if (this.log.isDebugEnabled()) {
                this.log.debug(gid + " Test => " + kods + "\n");
            }
            HashSet<Integer> gateRules = new HashSet<Integer>(5, 5.0f);
            StringTokenizer st = new StringTokenizer(kods);
            while (st.hasMoreTokens()) {
                gateRules.add(Integer.valueOf(st.nextToken()));
            }
            for (int i = 0; i < this.statusList.size(); ++i) {
                String command;
                String rule;
                UserStatus status = (UserStatus)this.statusList.get(i);
                Integer cid = status.contractId;
                boolean flag = false;
                if (gateRules.contains(cid)) {
                    if (status.status > 0) {
                        rule = this.generateRule(status);
                        command = "remove\t" + cid + "\t" + rule;
                        out.println(command);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug(gid + " " + command);
                        }
                    }
                    flag = true;
                    gateRules.remove(cid);
                }
                if (flag || status.status != 0) continue;
                rule = this.generateRule(status);
                command = "add\t" + cid + "\t" + rule;
                out.println(command);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug(gid + " " + command);
            }
            in.close();
            out.close();
            socket.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String generateRule(UserStatus status) {
        String rule = null;
        rule = status.ruleType == null ? status.rule.getRuleText() : ManadGateWorker.generateRule(status.rule.getRuleText(), this.gateType, status.ruleType);
        rule = rule.replaceAll("\r", "");
        rule = rule.replaceAll("\n", "|");
        return rule;
    }

    public static String generateRule(String addresses, GateType gateType, RuleType ruleType) {
        String ruleText = GateCommandUtil.getRule(gateType, ruleType);
        return GateCommandUtil.generateRule(ruleText, addresses, null, ruleType);
    }
}

