/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.worker;

import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.MDC;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.worker.AccountingWorkerTask;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.jmx.MBeanAttribute;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.FrequencyCounter;

public class ServTrackingWorker
extends AccountingWorkerTask {
    private final Accounting accounting;
    private final Set<Integer> servTypeIds;
    private Iterator<InetServRuntime> iterator;
    private boolean accountingPeriodActivate;
    private final FrequencyCounter trackedPerMinute = new FrequencyCounter(60L, TimeUnit.SECONDS);
    private static final ThreadLocal<Boolean> workerThread = new ThreadLocal();

    public ServTrackingWorker(Accounting accounting, ScheduledExecutorService scheduledExecutorService, ParameterMap params, ParameterMap defaultParams) {
        super(scheduledExecutorService, "", params, defaultParams);
        this.accounting = accounting;
        this.accountingPeriodActivate = params.getInt("accountingPeriodActivate", defaultParams.getInt("accountingPeriodActivate", 0)) > 0;
        Set servTypeIds = Utils.toIntegerSet((String)params.get("servTypeIds", null));
        this.servTypeIds = servTypeIds == null || servTypeIds.size() == 0 ? null : servTypeIds;
        this.getLogger().info("Add serv tracking worker: delay={}, batchSize={}, accountingPeriodActivate={}", new Object[]{this.getDelay(), this.batchSize, this.accountingPeriodActivate});
    }

    public static boolean isWorkerThread() {
        return workerThread.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runImpl() throws BGException {
        this.getLogger().debug("Run serv tracker...");
        if (this.iterator == null || !this.iterator.hasNext()) {
            this.iterator = this.accounting.getInetServRuntimeMap().values().iterator();
        }
        EventProcessor ep = EventProcessor.getInstance();
        long millis = System.currentTimeMillis();
        ConnectionSet connectionSet = ((ServerContext)this.context).getConnectionSet();
        InetDeviceRuntime rootDeviceRuntime = this.accounting.deviceMap.get(this.accounting.rootDeviceId);
        int count = 0;
        workerThread.set(Boolean.TRUE);
        try {
            int size = this.batchSize;
            while (count < size && this.iterator.hasNext()) {
                InetServRuntime inetServRuntime = this.iterator.next();
                MDC.put((String)"inetServId", (String)String.valueOf(inetServRuntime.inetServId));
                Optional.ofNullable(inetServRuntime.contractRuntime).ifPresent(a -> MDC.put((String)"contractId", (String)String.valueOf(inetServRuntime.contractRuntime.contractId)));
                if (this.trackingProcess(this.accounting, connectionSet, ep, rootDeviceRuntime, inetServRuntime, millis, this.servTypeIds, true, this.accountingPeriodActivate, 100L)) {
                    ++count;
                }
                MDC.remove((String)"inetServId");
                MDC.remove((String)"contractId");
            }
        }
        finally {
            workerThread.remove();
        }
        long millis2 = System.currentTimeMillis();
        long duration = millis2 - millis;
        this.trackedPerMinute.add(millis2, (long)count);
        this.processTimePerMinute.add(millis2, duration);
        this.processTimePerTenMinutes.add(millis2, duration);
        this.invokePerMinute.add(millis2, 1L);
        this.invokePerTenMinutes.add(millis2, 1L);
        if (this.getLogger().isDebugEnabled() && count > 0) {
            this.getLogger().debug("Tracked " + count + " servs for " + duration + " ms.");
        }
    }

    @MBeanAttribute
    public long getTrackedPerMinute() {
        return this.trackedPerMinute.get(System.currentTimeMillis());
    }
}

