/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.drwebn.server.tariff;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.tariff.server.tree.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.server.tree.ModuleServiceTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.server.tree.ServiceCost;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffContext;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeNodeHolder;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TreeContext;
import ru.bitel.bgbilling.modules.drwebn.server.tariff.DrWebNTariffContext;
import ru.bitel.bgbilling.modules.drwebn.server.tariff.DrWebNTariffRequest;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.worker.ThreadContext;

public class CalculateModeTariffTreeNode
extends ModuleServiceTariffTreeNode<DrWebNTariffContext, DrWebNTariffRequest.DrWebNServiceCost, DrWebNTariffRequest> {
    public static final int MODE_MONTH = 0;
    public static final int MODE_DAY = 1;
    public static final int MODE_YEAR = 2;
    public static final int MODE_ADVANCE = 3;
    public static final int MODE_QUARTER = 4;
    private final int mode;
    private final int calcType;

    public CalculateModeTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        String modeParam = parameterMap.get("mode", null);
        this.mode = "day".equals(modeParam) ? 1 : 0;
        this.calcType = parameterMap.getInt("type", 0);
    }

    public int execute(Long treeNodeId, Long parentTreeNodeId, DrWebNTariffRequest req, TariffTreeNodeHolder holder, DrWebNTariffContext context, TreeContext treeContext, ThreadContext workerContext) {
        List serviceCostList = (List)req.getServiceCost().get(this.serviceId);
        if (serviceCostList == null) {
            return 0;
        }
        switch (this.mode) {
            case 0: {
                int size = serviceCostList.size();
                for (int i = 0; i < size; ++i) {
                    req.serviceCost = (ServiceCost)serviceCostList.get(i);
                    this.monthMode(treeNodeId, req, holder, context, treeContext, workerContext);
                }
                break;
            }
            case 1: {
                int size = serviceCostList.size();
                for (int i = 0; i < size; ++i) {
                    req.serviceCost = (ServiceCost)serviceCostList.get(i);
                    this.dayMode(treeNodeId, req, holder, context, treeContext, workerContext);
                }
                break;
            }
            default: {
                req.addError("Unknown mode");
            }
        }
        return 1;
    }

    public void dayMode(Long treeNodeId, DrWebNTariffRequest req, TariffTreeNodeHolder holder, DrWebNTariffContext ctx, TreeContext treeContext, ThreadContext workerContext) {
        Calendar end;
        Calendar date1 = ((DrWebNTariffRequest.DrWebNServiceCost)req.serviceCost).getDate1();
        Calendar date2 = ((DrWebNTariffRequest.DrWebNServiceCost)req.serviceCost).getDate2();
        Calendar time = req.getTime();
        BigDecimal inCost = ((DrWebNTariffRequest.DrWebNServiceCost)req.serviceCost).getCost();
        Map pushed = req.acceptedSetPush();
        Calendar day = (Calendar)date1.clone();
        TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)day);
        Calendar dayEnd = (Calendar)date1.clone();
        if (req.isInfoEnabled()) {
            req.addInfo("Day mode: " + ((DrWebNTariffRequest.DrWebNServiceCost)req.serviceCost).toString());
        }
        Calendar calendar = end = this.calcType == 1 ? ctx.getCurrentDay() : date2;
        if (TimeUtils.dateBefore((Calendar)date2, (Calendar)end)) {
            end = date2;
        }
        BigDecimal cost = BigDecimal.ZERO;
        while (TimeUtils.dateBeforeOrEq((Calendar)day, (Calendar)end)) {
            dayEnd.setTimeInMillis(day.getTimeInMillis());
            dayEnd.add(5, 1);
            dayEnd.add(14, -1);
            assert (TimeUtils.compare((Calendar)day, (Calendar)dayEnd, (int)5) == 0);
            ((DrWebNTariffRequest.DrWebNServiceCost)req.serviceCost).setDate1(day);
            ((DrWebNTariffRequest.DrWebNServiceCost)req.serviceCost).setDate2(dayEnd);
            req.setTime(day);
            ((DrWebNTariffRequest.DrWebNServiceCost)req.serviceCost).setCost(null);
            req.acceptedSetClear();
            super.executeChildren(treeNodeId, (AbstractTariffRequest)req, holder, (TariffContext)ctx, treeContext, workerContext);
            if (((DrWebNTariffRequest.DrWebNServiceCost)req.serviceCost).getCost() != null) {
                if (req.isInfoEnabled()) {
                    req.addInfo(TimeUtils.formatDate((Calendar)day) + "=>" + ((DrWebNTariffRequest.DrWebNServiceCost)req.serviceCost).getCost());
                }
            } else {
                cost = null;
                break;
            }
            cost = cost.add(((DrWebNTariffRequest.DrWebNServiceCost)req.serviceCost).getCost());
            day.add(5, 1);
        }
        ((DrWebNTariffRequest.DrWebNServiceCost)req.serviceCost).setDate1(date1);
        ((DrWebNTariffRequest.DrWebNServiceCost)req.serviceCost).setDate2(date2);
        ((DrWebNTariffRequest.DrWebNServiceCost)req.serviceCost).setCost(cost);
        req.setTime(time);
        req.acceptedSetPop(pushed);
        if (cost != null) {
            req.addInfo("process cost=" + cost);
            ((DrWebNTariffRequest.DrWebNServiceCost)req.serviceCost).setCost(cost);
            if (((DrWebNTariffRequest.DrWebNServiceCost)req.serviceCost).getAmount() != 1L && ((DrWebNTariffRequest.DrWebNServiceCost)req.serviceCost).getCost() != null) {
                ((DrWebNTariffRequest.DrWebNServiceCost)req.serviceCost).setCost(((DrWebNTariffRequest.DrWebNServiceCost)req.serviceCost).getCost().multiply(BigDecimal.valueOf(((DrWebNTariffRequest.DrWebNServiceCost)req.serviceCost).getAmount()), ctx.mc));
            }
        } else {
            req.addInfo("return cost=" + inCost);
            ((DrWebNTariffRequest.DrWebNServiceCost)req.serviceCost).setCost(inCost);
        }
    }

    public void monthMode(Long treeNodeId, DrWebNTariffRequest req, TariffTreeNodeHolder holder, DrWebNTariffContext ctx, TreeContext treeContext, ThreadContext workerContext) {
        int day1 = ((DrWebNTariffRequest.DrWebNServiceCost)req.serviceCost).getDate1().get(5);
        ((DrWebNTariffRequest.DrWebNServiceCost)req.serviceCost).setAccountingPeriodDays(((DrWebNTariffRequest.DrWebNServiceCost)req.serviceCost).getDate2().get(5) - day1 + 1);
        req.setTime(((DrWebNTariffRequest.DrWebNServiceCost)req.serviceCost).getDate2());
        ((DrWebNTariffRequest.DrWebNServiceCost)req.serviceCost).setCost(null);
        super.executeChildren(treeNodeId, (AbstractTariffRequest)req, holder, (TariffContext)ctx, treeContext, workerContext);
    }
}

