/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.tv.common.bean.TvAccountSpec;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractDirectoryIdDao;

public class TvAccountSpecDao
extends AbstractDirectoryIdDao<TvAccountSpec> {
    private PreparedStatement getGroupsPS = null;
    private PreparedStatement getTypesPS = null;

    public TvAccountSpecDao(Connection con, int mid) {
        super(con, mid, "tv_account_spec");
    }

    protected TvAccountSpec getFromRS(ResultSet rs) throws SQLException, BGException {
        TvAccountSpec result = new TvAccountSpec();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setEntitySpecId(rs.getInt("entitySpecId"));
        result.setParentTypeIds(Utils.toIntegerSet((String)rs.getString("parentTypeIds")));
        result.setNeedLogin(rs.getBoolean("needLogin"));
        result.setNeedPassword(rs.getBoolean("needPassword"));
        result.setNeedPin(rs.getBoolean("needPin"));
        result.setNeedDevice(rs.getBoolean("needDevice"));
        result.setNeedIdentifier(rs.getBoolean("needIdentifier"));
        result.setNeedMacAddress(rs.getBoolean("needMacAddress"));
        result.setConfig(rs.getString("config"));
        HashSet<Integer> deviceTypeIds = new HashSet<Integer>();
        if (this.getTypesPS == null) {
            this.getTypesPS = this.con.prepareStatement("SELECT deviceTypeId FROM tv_account_spec_device_type_link_" + this.moduleId + " WHERE tvAccountSpecId=?");
        }
        this.getTypesPS.setInt(1, result.getId());
        ResultSet getTypeRS = this.getTypesPS.executeQuery();
        while (getTypeRS.next()) {
            deviceTypeIds.add(getTypeRS.getInt(1));
        }
        HashSet<Integer> deviceGroupIds = new HashSet<Integer>();
        if (this.getGroupsPS == null) {
            this.getGroupsPS = this.con.prepareStatement("SELECT deviceGroupId FROM tv_account_spec_device_group_link_" + this.moduleId + " WHERE tvAccountSpecId=?");
        }
        this.getGroupsPS.setInt(1, result.getId());
        ResultSet getGroupsRS = this.getGroupsPS.executeQuery();
        while (getGroupsRS.next()) {
            deviceGroupIds.add(getGroupsRS.getInt(1));
        }
        getGroupsRS.close();
        result.setDeviceTypeIds(deviceTypeIds);
        result.setDeviceGroupIds(deviceGroupIds);
        return result;
    }

    protected void updateImpl(TvAccountSpec tvAccountSpec) throws BGException, SQLException {
        if (Utils.isBlankString((String)tvAccountSpec.getTitle())) {
            throw new BGIllegalArgumentException();
        }
        boolean update = tvAccountSpec.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET title=?, entitySpecId=?, parentTypeIds=?, needLogin=?, needPassword=?, needPin=?, needDevice=?, needIdentifier=?, needMacAddress=?, config=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, tvAccountSpec.getTitle());
            ps.setInt(index++, tvAccountSpec.getEntitySpecId());
            ps.setString(index++, Utils.toString((Iterable)tvAccountSpec.getParentTypeIds()));
            ps.setBoolean(index++, tvAccountSpec.isNeedLogin());
            ps.setBoolean(index++, tvAccountSpec.isNeedPassword());
            ps.setBoolean(index++, tvAccountSpec.isNeedPin());
            ps.setBoolean(index++, tvAccountSpec.isNeedDevice());
            ps.setBoolean(index++, tvAccountSpec.isNeedIdentifier());
            ps.setBoolean(index++, tvAccountSpec.isNeedMacAddress());
            ps.setString(index++, tvAccountSpec.getConfig());
            if (update) {
                ps.setInt(index++, tvAccountSpec.getId());
            }
            ps.executeUpdate();
            if (!update) {
                tvAccountSpec.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
        if (update) {
            try (PreparedStatement deleteLinkPS = this.con.prepareStatement("DELETE FROM tv_account_spec_device_type_link_" + this.moduleId + " WHERE tvAccountSpecId=?");){
                deleteLinkPS.setInt(1, tvAccountSpec.getId());
                deleteLinkPS.executeUpdate();
            }
            deleteLinkPS = this.con.prepareStatement("DELETE FROM tv_account_spec_device_group_link_" + this.moduleId + " WHERE tvAccountSpecId=?");
            try {
                deleteLinkPS.setInt(1, tvAccountSpec.getId());
                deleteLinkPS.executeUpdate();
            }
            finally {
                if (deleteLinkPS != null) {
                    deleteLinkPS.close();
                }
            }
        }
        ps = this.con.prepareStatement("INSERT INTO tv_account_spec_device_type_link_" + this.moduleId + " SET tvAccountSpecId=?, deviceTypeId=?");
        try {
            ps.setInt(1, tvAccountSpec.getId());
            for (Integer i : tvAccountSpec.getDeviceTypeIds()) {
                ps.setInt(2, i);
                ps.executeUpdate();
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        ps = this.con.prepareStatement("INSERT INTO tv_account_spec_device_group_link_" + this.moduleId + " SET tvAccountSpecId=?, deviceGroupId=?");
        try {
            ps.setInt(1, tvAccountSpec.getId());
            for (Integer i : tvAccountSpec.getDeviceGroupIds()) {
                ps.setInt(2, i);
                ps.executeUpdate();
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public TvAccountSpec get(String title) throws BGException {
        throw new UnsupportedOperationException();
    }

    public List<TvAccountSpec> list() throws BGException {
        return this.list(null, "id", new Object[0]);
    }
}

