/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.runtel.server.task;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.task.server.TaskBase;
import ru.bitel.bgbilling.modules.runtel.common.bean.RunTelContractTariff;
import ru.bitel.bgbilling.modules.runtel.common.bean.RunTelTariff;
import ru.bitel.bgbilling.modules.runtel.common.bean.TariffAdditionalItem;
import ru.bitel.bgbilling.modules.runtel.server.bean.RunTelContractTariffDao;
import ru.bitel.bgbilling.modules.runtel.server.bean.RunTelTariffDao;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;

public class RunTelCalculator
extends TaskBase {
    private Connection con;
    private ConnectionSet connectionSet;

    protected boolean initTask() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTask() {
        ServerContext threadContext = (ServerContext)ThreadContext.get();
        this.connectionSet = threadContext != null ? threadContext.getConnectionSet() : ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);
        this.con = this.connectionSet.getConnection();
        try (BalanceDao balanceDao = new BalanceDao(this.con);
             BalanceUtils balanceUtils = new BalanceUtils(this.con);){
            String tableName;
            RunTelTariffDao runTelTariffDao = new RunTelTariffDao(this.con, this.moduleId);
            RunTelContractTariffDao runTelContractTariffDao = new RunTelContractTariffDao(this.con, this.moduleId);
            LocalDateTime operatingTime = TimeUtils.convertDateToLocalDateTime((Date)this.getOperatingTime().getTime());
            LocalDateTime startMonth = operatingTime.withDayOfMonth(1);
            LocalDateTime endMonth = operatingTime.plusMonths(1L).withDayOfMonth(1).minusDays(1L);
            int dayAll = endMonth.getDayOfMonth();
            Period period = new Period(startMonth.toLocalDate(), endMonth.toLocalDate());
            int month = startMonth.getMonthValue();
            int year = startMonth.getYear();
            if (this.getLogger().isDebugEnabled()) {
                DateTimeFormatter formatter = TimeUtils.getDateTimeFormatter((String)"dd.MM.yyyy HH:mm:ss");
                this.getLogger().debug("operatingTime = {}", (Object)TimeUtils.format((LocalDateTime)operatingTime, (DateTimeFormatter)formatter));
                this.getLogger().debug("startMonth = {}", (Object)TimeUtils.format((LocalDateTime)startMonth, (DateTimeFormatter)formatter));
                this.getLogger().debug("endMonth = {}", (Object)TimeUtils.format((LocalDateTime)endMonth, (DateTimeFormatter)formatter));
                this.getLogger().debug("period = {}", (Object)period);
                this.getLogger().debug("year = {}; month = {}", (Object)year, (Object)month);
            }
            if (!ServerUtils.tableExists((Connection)this.con, (String)(tableName = "runtel_service_detail_" + this.moduleId + "_" + year))) {
                this.createDetailTable(tableName);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("tableName = {}", (Object)tableName);
                this.getLogger().debug("month = {}", (Object)month);
                this.getLogger().debug("dayAll = {}", (Object)dayAll);
            }
            PreparedStatement psDelete = this.con.prepareStatement("DELETE FROM " + tableName + " WHERE month=? AND contract_id=?");
            psDelete.setInt(1, month);
            PreparedStatement psInsert = this.con.prepareStatement("INSERT INTO " + tableName + " SET contract_id=?, tariff_contract_id=?, month=?, days=?, service_id=?, amount=?, cost=?, sum=?");
            SearchResult searchResultTariffs = new SearchResult();
            runTelTariffDao.searchRunTelTariffList((SearchResult<RunTelTariff>)searchResultTariffs);
            HashMap runTelTariffs = new HashMap();
            HashMap a = new HashMap();
            searchResultTariffs.getList().forEach(item -> {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("runtel tariff = {}", item);
                    this.getLogger().debug("\tid = {}", (Object)item.getId());
                    this.getLogger().debug("\tserviceId = {}", (Object)item.getServiceId());
                    this.getLogger().debug("\tcost = {}", (Object)item.getCost());
                    this.getLogger().debug("\tconfig = {}", (Object)item.getConfig());
                }
                runTelTariffs.put(item.getId(), item);
                JSONObject runTelTariffConfig = new JSONObject(item.getConfig());
                JSONObject additionalJsonObject = runTelTariffConfig.optJSONObject("additional");
                ArrayList<TariffAdditionalItem> additionalItems = new ArrayList<TariffAdditionalItem>();
                for (String name : additionalJsonObject.keySet()) {
                    JSONObject jsonObject = additionalJsonObject.getJSONObject(name);
                    TariffAdditionalItem additionalItem = new TariffAdditionalItem();
                    additionalItem.setName(name);
                    additionalItem.setCost(jsonObject.optBigDecimal("cost", BigDecimal.ZERO));
                    additionalItem.setServiceId(jsonObject.optInt("serviceId", 0));
                    additionalItem.setSelected(jsonObject.optBoolean("enable", false));
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("\t" + (additionalItem.isSelected() && additionalItem.getServiceId() > 0 ? "ADD" : "IGNORE") + " => additionalItem " + additionalItem);
                    }
                    if (!additionalItem.isSelected() || additionalItem.getServiceId() <= 0) continue;
                    additionalItems.add(additionalItem);
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("\tadditionalItems = {}", additionalItems);
                }
                a.put(item.getId(), additionalItems);
            });
            this.getLogger().info("Starting RunTel calculated...");
            HashSet<Integer> contractIds = new HashSet<Integer>();
            List<RunTelContractTariff> contractTariffs = runTelContractTariffDao.getRunTelContractTariffs(period);
            for (RunTelContractTariff runTelContractTariff : contractTariffs) {
                PeriodWithTime periodTariff = runTelContractTariff.getPeriod();
                int tariffId = runTelContractTariff.getTariffId();
                int contractId = runTelContractTariff.getContractId();
                int dayFrom = periodTariff.getLocalDateTimeFrom().compareTo(startMonth) == -1 ? 1 : periodTariff.getLocalDateTimeFrom().getDayOfMonth();
                int dayTo = periodTariff.getLocalDateTimeTo() == null || endMonth.compareTo(periodTariff.getLocalDateTimeTo()) == -1 ? dayAll : periodTariff.getLocalDateTimeTo().getDayOfMonth();
                String days = (dayFrom < 10 ? "0" : "") + dayFrom + "-" + (dayTo < 10 ? "0" : "") + dayTo;
                if (!contractIds.contains(contractId)) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Delete data from " + tableName + " for contractId = " + contractId);
                    }
                    psDelete.setInt(2, contractId);
                    psDelete.executeUpdate();
                    contractIds.add(contractId);
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Worked runTelContractTariff [id = " + runTelContractTariff.getId() + "; contractId = " + contractId + "; tariffId = " + tariffId + "]");
                    this.getLogger().debug("\tperiod = " + periodTariff + "; dayFrom = " + dayFrom + "; dayTo = " + dayTo);
                    this.getLogger().debug("\tconfig = " + runTelContractTariff.getConfig());
                }
                psInsert.setInt(1, contractId);
                psInsert.setInt(2, tariffId);
                psInsert.setInt(3, month);
                psInsert.setString(4, days);
                RunTelTariff runTelTariff = (RunTelTariff)runTelTariffs.get(tariffId);
                BigDecimal cost = this.getCost(dayFrom, dayTo, dayAll, runTelTariff.getCost());
                BigDecimal sum = this.getSum(1, cost);
                psInsert.setInt(5, runTelTariff.getServiceId());
                psInsert.setInt(6, 1);
                psInsert.setBigDecimal(7, cost);
                psInsert.setBigDecimal(8, sum);
                psInsert.executeUpdate();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("\tBase service:  serviceId = " + runTelTariff.getServiceId() + "; tariffCost = " + runTelTariff.getCost() + "; cost = " + cost + "; sum = " + sum);
                }
                JSONObject jsonObject = new JSONObject(runTelContractTariff.getConfig());
                List additionalItems = (List)a.get(tariffId);
                if (additionalItems == null) continue;
                for (TariffAdditionalItem additionalItem : additionalItems) {
                    int amount = jsonObject.optInt(additionalItem.getName(), 0);
                    if (additionalItem.getName().startsWith("singlePayment")) {
                        if (periodTariff.getLocalDateTimeFrom().compareTo(startMonth) == -1) continue;
                        cost = additionalItem.getCost();
                    } else {
                        cost = this.getCost(dayFrom, dayTo, dayAll, additionalItem.getCost());
                    }
                    sum = this.getSum(amount, cost);
                    psInsert.setInt(5, additionalItem.getServiceId());
                    psInsert.setInt(6, amount);
                    psInsert.setBigDecimal(7, cost);
                    psInsert.setBigDecimal(8, sum);
                    psInsert.executeUpdate();
                    if (!this.getLogger().isDebugEnabled()) continue;
                    this.getLogger().debug("\tOptional service: name = " + additionalItem.getName() + "; serviceId = " + additionalItem.getServiceId() + "; tariffCost = " + additionalItem.getCost() + "; cost = " + cost + "; amount = " + amount + "; sum = " + sum);
                }
            }
            psInsert.close();
            psDelete.close();
            psDelete = this.con.prepareStatement("DELETE FROM contract_account WHERE yy=? AND mm=? AND sid IN ( SELECT id FROM service WHERE mid=? )");
            psDelete.setInt(1, year);
            psDelete.setInt(2, month);
            psDelete.setInt(3, this.moduleId);
            psDelete.executeUpdate();
            psDelete.close();
            psInsert = this.con.prepareStatement("INSERT INTO contract_account ( yy, mm, cid, sid, summa ) SELECT ?, ?, contract_id, service_id, SUM(`sum`) FROM " + tableName + " WHERE month=? GROUP BY contract_id, service_id");
            psInsert.setInt(1, year);
            psInsert.setInt(2, month);
            psInsert.setInt(3, month);
            psInsert.executeUpdate();
            psInsert.close();
            Iterator<Object> iterator = contractIds.iterator();
            while (iterator.hasNext()) {
                int contractId = (Integer)iterator.next();
                balanceUtils.setBalanceFromAccount(contractId, TimeUtils.convertLocalDateTimeToCalendar((LocalDateTime)startMonth));
            }
        }
        catch (Exception ex) {
            this.logError(ex);
            this.error = ex;
        }
        finally {
            if (threadContext == null) {
                this.connectionSet.close();
            }
        }
    }

    private BigDecimal getCost(int dayFrom, int dayTo, int dayAll, BigDecimal cost) {
        BigDecimal d = new BigDecimal(dayTo - dayFrom + 1).setScale(20).divide(new BigDecimal(dayAll), RoundingMode.HALF_UP);
        return cost.multiply(d).setScale(2, RoundingMode.HALF_UP);
    }

    private BigDecimal getSum(int amount, BigDecimal cost) {
        return cost.setScale(2, RoundingMode.HALF_UP).multiply(new BigDecimal(amount));
    }

    public String getDescription() {
        return this.defaultDescription + "\u041c\u043e\u0434\u0443\u043b\u044c RunTel. \u041d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435 \u043d\u0430\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0430 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430. \u041a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f: " + this.moduleId + ".";
    }

    private void createDetailTable(String tableName) throws SQLException {
        String sql = "CREATE TABLE " + tableName + " ( `contract_id` int(11) NOT NULL DEFAULT 0, `service_id` int(11) NOT NULL DEFAULT 0, `tariff_contract_id` int(11) NOT NULL DEFAULT 0, `month` int(11) NOT NULL DEFAULT 0, `days` char(5) NOT NULL, `cost` decimal(12,2) NOT NULL, `amount` decimal(12,2) NOT NULL, `sum` decimal(12,2) NOT NULL, KEY (`contract_id`) )";
        this.con.createStatement().executeUpdate(sql);
    }
}

