/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voiceip.server.bean;

import bitel.billing.server.call.bean.Login;
import bitel.billing.server.call.bean.ReportUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.modules.voiceip.server.bean.VoiceIpLoginManager;
import ru.bitel.bgbilling.modules.voiceip.server.bean.VoiceUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class VoiceIpReportUtils
extends ReportUtils {
    public VoiceIpReportUtils(Connection con, int mid, Preferences moduleSetup) {
        super(con, mid, moduleSetup);
        this.loginManager = new VoiceIpLoginManager(con, mid);
    }

    public void addSessions(ResultSet rs, Element data) {
        VoiceUtils vu = new VoiceUtils(this.con, this.mid);
        try {
            if (rs != null) {
                while (rs.next()) {
                    Element element = data.getOwnerDocument().createElement("row");
                    data.appendChild(element);
                    Timestamp session_start = rs.getTimestamp("session_start");
                    element.setAttribute("type", rs.getInt("type") == 1 ? "<<" : ">>");
                    element.setAttribute("log_id", rs.getString("lr"));
                    element.setAttribute("dest", vu.getDestTitle(rs.getInt("dest_code")));
                    element.setAttribute("session_start", TimeUtils.formatFullDate((Date)session_start));
                    element.setAttribute("session_time", Utils.formatSessionTime((int)rs.getInt("session_time")));
                    element.setAttribute("round_session_time", Utils.formatSessionTime((int)rs.getInt("round_session_time")));
                    element.setAttribute("min_cost", Utils.formatSessionCost((float)rs.getFloat("min_cost")));
                    element.setAttribute("cost", rs.getBigDecimal("session_cost").toPlainString());
                    element.setAttribute("from_to", rs.getString("from_number") + " / " + rs.getString("to_number"));
                    element.setAttribute("h323_id", rs.getString("h323_id"));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addLoginsAmounts(Period period, int cid, Element data, String module, String filter) throws SQLException {
        List logins = this.loginManager.getContractLogins(cid);
        int timeAmount = 0;
        int roundTimeAmount = 0;
        int sessionsCol = 0;
        BigDecimal moneyAmount = BigDecimal.ZERO;
        for (Login login : logins) {
            List<Object> sums = this.getSessionsColSumTime(Utils.toIntegerList((String)String.valueOf(login.getId())), period, filter);
            int col = (Integer)sums.get(0);
            BigDecimal cost = (BigDecimal)sums.get(1);
            int time = (Integer)sums.get(2);
            int roundTime = (Integer)sums.get(3);
            timeAmount += time;
            roundTimeAmount += roundTime;
            moneyAmount = moneyAmount.add(cost);
            sessionsCol += col;
            Element row = data.getOwnerDocument().createElement("row");
            data.appendChild(row);
            row.setAttribute("login", login.getLogin() + this.loginManager.getLoginAliases(login.getId()));
            row.setAttribute("count", String.valueOf(col));
            row.setAttribute("time", Utils.formatSessionTime((int)time));
            row.setAttribute("round_time", Utils.formatSessionTime((int)roundTime));
            row.setAttribute("cost", cost.toPlainString());
        }
        data.setAttribute("time_amount", Utils.formatSessionTime((int)timeAmount) + " [" + Math.round(timeAmount / 60) + "]");
        data.setAttribute("round_time_amount", Utils.formatSessionTime((int)roundTimeAmount) + " [" + Math.round(roundTimeAmount / 60) + "]");
        data.setAttribute("count_amount", String.valueOf(sessionsCol));
        data.setAttribute("money_amount", Utils.formatCost((BigDecimal)moneyAmount));
    }

    public void addLoginsAmounts(Period period, int cid, Map<String, Object> dataMap, String module, String filter) throws SQLException {
        List logins = this.loginManager.getContractLogins(cid);
        int timeAmount = 0;
        int roundTimeAmount = 0;
        int sessionsCol = 0;
        BigDecimal moneyAmount = BigDecimal.ZERO;
        ArrayList<String[]> rowList = new ArrayList<String[]>();
        for (Login login : logins) {
            List<Object> sums = this.getSessionsColSumTime(Utils.toIntegerList((String)String.valueOf(login.getId())), period, filter);
            String[] str = new String[5];
            int col = (Integer)sums.get(0);
            BigDecimal cost = (BigDecimal)sums.get(1);
            int time = (Integer)sums.get(2);
            int roundTime = (Integer)sums.get(3);
            timeAmount += time;
            roundTimeAmount += roundTime;
            moneyAmount = moneyAmount.add(cost);
            sessionsCol += col;
            str[0] = login.getLogin() + this.loginManager.getLoginAliases(login.getId());
            str[1] = String.valueOf(col);
            str[2] = Utils.formatSessionTime((int)time);
            str[3] = Utils.formatSessionTime((int)roundTime);
            str[4] = cost.toPlainString();
            rowList.add(str);
        }
        dataMap.put("rowList", rowList);
        dataMap.put("time_amount", Utils.formatSessionTime((int)timeAmount) + " [" + Math.round(timeAmount / 60) + "]");
        dataMap.put("round_time_amount", Utils.formatSessionTime((int)roundTimeAmount) + " [" + Math.round(roundTimeAmount / 60) + "]");
        dataMap.put("count_amount", String.valueOf(sessionsCol));
        dataMap.put("money_amount", Utils.formatCost((BigDecimal)moneyAmount));
    }

    public int addSums(Element data, List<Integer> lids, Period per, String filter) throws SQLException {
        List<Object> sums = this.getSessionsColSumTime(lids, per, filter);
        int col = (Integer)sums.get(0);
        data.setAttribute("count_amount", String.valueOf(col));
        BigDecimal sum = (BigDecimal)sums.get(1);
        int time = (Integer)sums.get(2);
        data.setAttribute("time_amount", Utils.formatSessionTime((int)time) + " [" + Math.round((float)time / 60.0f) + "]");
        time = (Integer)sums.get(3);
        data.setAttribute("round_time_amount", Utils.formatSessionTime((int)time) + " [" + Math.round((float)time / 60.0f) + "]");
        data.setAttribute("money_amount", Utils.formatCost((BigDecimal)sum));
        return col;
    }

    private List<Object> getSessionsColSumTime(List<Integer> lids, Period period, String filter) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(0);
        result.add(new BigDecimal(0));
        result.add(0);
        result.add(0);
        String whatSelect = " COUNT(id), SUM(session_cost), SUM(session_time), SUM(round_session_time) ";
        PreparedStatement ps = this.selectSomethingFromSessions(lids, period, whatSelect, filter, null, null, null);
        if (ps != null) {
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result.set(0, rs.getInt(1));
                result.set(1, rs.getBigDecimal(2) != null ? rs.getBigDecimal(2) : new BigDecimal(0));
                result.add(2, rs.getInt(3));
                result.add(3, rs.getInt(4));
            }
            rs.close();
            ps.close();
        }
        return result;
    }
}

