/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.processor.dialup;

import bitel.billing.server.processor.dialup.DialUpSessionRealtime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpNas;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpNasConnection;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpRadiusProcessor;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.StopableThread;

public class UpdateSuspendedSetter
extends StopableThread {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateSuspendedSetter.class);
    private DialUpRadiusProcessor processor;
    private int maxUpdateTimeout = 900;

    public UpdateSuspendedSetter(DefaultServerSetup setup, DialUpRadiusProcessor processor) {
        this.processor = processor;
        this.maxUpdateTimeout = setup.getInt("max.update.timeout", this.maxUpdateTimeout);
        LOGGER.info("UPDATE mode SLEEP setter, timeout=" + this.maxUpdateTimeout);
        this.start();
    }

    public void run() {
        while (this.working) {
            try {
                long now = System.currentTimeMillis();
                for (DialUpNas nas : this.processor.getNasList().nases()) {
                    if (nas.getWorkMode() != 1) continue;
                    for (DialUpNasConnection con : nas.connections()) {
                        long stopTime;
                        long timeAfterLastUpdate;
                        DialUpSessionRealtime session = (DialUpSessionRealtime)con.getSession();
                        if (con.getStatus() != NasConnection.Status.working || (timeAfterLastUpdate = (now - (stopTime = session.getStopTime().getTimeInMillis())) / 1000L) <= (long)this.maxUpdateTimeout) continue;
                        session.addLogInfo("Set status SUSPENDED on UpdateSuspendedSetter, time after last update: " + timeAfterLastUpdate);
                        con.setStatus(NasConnection.Status.suspended);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            try {
                UpdateSuspendedSetter.sleep((long)30000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        LOGGER.info("Stopping UpdateSuspendSetter");
    }
}

