/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.StatusEvent;
import ru.bitel.bgbilling.modules.cerbercrypt.server.bean.CardPacketManager;
import ru.bitel.common.TimeUtils;

public class StatusEventManager {
    private Connection con;
    private int mid;

    public StatusEventManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
    }

    public List<StatusEvent> getEvents(int cardPacketID, Calendar fromDate) throws BGException {
        ArrayList<StatusEvent> result = new ArrayList<StatusEvent>(10);
        try {
            String query = "SELECT * FROM event_log_" + this.mid + " WHERE cpid=? AND dt>=? ORDER BY dt";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cardPacketID);
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)fromDate));
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(StatusEventManager.loadFromRS(rs));
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public List<StatusEvent> getEvents(int cardPacketID) throws BGException {
        ArrayList<StatusEvent> result = new ArrayList<StatusEvent>();
        try {
            String query = "SELECT * FROM event_log_" + this.mid + " WHERE cpid=? ORDER BY dt";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cardPacketID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(StatusEventManager.loadFromRS(rs));
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public StatusEvent getLastEventBefore(int cardPacketID, Calendar date) throws BGException {
        StatusEvent result = null;
        try {
            String query = "SELECT * FROM event_log_" + this.mid + " WHERE cpid=? AND dt<=? ORDER BY dt DESC LIMIT 1";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cardPacketID);
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)date));
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = StatusEventManager.loadFromRS(rs);
            }
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
        return result;
    }

    public void addEvent(CardPacket cardPacket, StatusEvent event) throws BGException {
        try {
            TimeUtils.clear_MIN_MIL_SEC((Calendar)event.getTime());
            String query = null;
            PreparedStatement ps = null;
            query = "DELETE FROM event_log_" + this.mid + " WHERE cpid=? AND dt=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, event.getCardPacketId());
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)event.getTime()));
            ps.executeUpdate();
            ps.close();
            query = "INSERT INTO event_log_" + this.mid + " ( cpid, dt, type, uid ) VALUES (?, ?, ?, ?)";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, event.getCardPacketId());
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)event.getTime()));
            ps.setInt(3, event.getStatus());
            ps.setInt(4, event.getUserId());
            ps.executeUpdate();
            ps.close();
            StatusEvent lastEvent = this.getLastEventBefore(event.getCardPacketId(), new GregorianCalendar());
            if (lastEvent != null && lastEvent.getStatus() != cardPacket.getStatus()) {
                cardPacket.setStatus(lastEvent.getStatus());
                new CardPacketManager(this.con, this.mid).updateCardPacket(cardPacket);
            }
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void deleteEvent(int cardPacketId, Calendar date) throws BGException {
        try {
            String query = "DELETE FROM event_log_" + this.mid + " WHERE cpid=? AND dt=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, cardPacketId);
            ps.setDate(2, TimeUtils.convertCalendarToSqlDate((Calendar)date));
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    private static StatusEvent loadFromRS(ResultSet rs) throws SQLException {
        return StatusEvent.builder().setCardPacketId(rs.getInt("cpid")).setTime(TimeUtils.convertDateToCalendar((Date)rs.getDate("dt"))).setStatus(rs.getInt("type")).setUserId(rs.getInt("uid")).build();
    }
}

