/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.server.inbuild;

import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import java.util.HashMap;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.reports.server.bean.filter.BGReportFilter;
import ru.bitel.bgbilling.modules.reports.server.datasource.BGDataSource;
import ru.bitel.bgbilling.modules.reports.server.report.BGJasperReport;
import ru.bitel.common.TimeUtils;

public class Report_Tariff
extends BGJasperReport {
    public Report_Tariff() {
        this.id = "kernel_contract_tariff";
    }

    @Override
    public void fillReportToStream(OutputStream out) throws BGException {
        BGReportFilter filter = this.createBGReportFilter();
        try {
            String tariffs = filter.getStringParam("tariffs");
            java.sql.Date date = TimeUtils.convertDateToSqlDate((Date)TimeUtils.parseDate((String)filter.getStringParam("date"), (String)"dd.MM.yyyy"));
            if (tariffs != null) {
                if (tariffs.length() == 0) {
                    tariffs = null;
                } else if (tariffs.contains(";")) {
                    tariffs = null;
                }
            }
            Object query = "SELECT DISTINCT contract.id, contract.title, contract.comment, plan.id as plan_id, plan.title as plan_title FROM contract_tariff as tariff LEFT JOIN tariff_plan as plan ON plan.id=tariff.tpid LEFT JOIN contract ON contract.id=tariff.cid WHERE ";
            if (tariffs != null) {
                query = (String)query + " tariff.tpid IN (" + tariffs + ") AND ";
            }
            query = (String)query + "((tariff.date1 IS NULL OR tariff.date1<=?) AND (tariff.date2 IS NULL OR tariff.date2>=?)) AND !(plan.id IS NULL) AND !(contract.id IS NULL) ORDER BY plan_title";
            PreparedStatement ps = this.con.prepareStatement(((String)query).toString());
            ps.setDate(1, date);
            ps.setDate(2, date);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("addInfo", "\u0417\u0430 \u0434\u0430\u0442\u0443: " + TimeUtils.formatDate((Date)date));
            ResultSet rs = ps.executeQuery();
            BGDataSource bds = new BGDataSource();
            while (rs.next()) {
                HashMap<String, Object> row = new HashMap<String, Object>();
                row.put("contract", rs.getString("title") + " (" + rs.getString("comment") + ") ");
                row.put("plan", rs.getString("plan_title"));
                bds.addRow(row);
            }
            rs.close();
            ps.close();
            HashMap<String, String> total = new HashMap<String, String>();
            query = "SELECT plan.id, plan.title as plan_title, COUNT(DISTINCT tariff.cid) FROM contract_tariff as tariff LEFT JOIN tariff_plan as plan ON plan.id=tariff.tpid LEFT JOIN contract ON contract.id=tariff.cid WHERE ";
            if (tariffs != null) {
                query = (String)query + " tariff.tpid IN (" + tariffs + ") AND ";
            }
            query = (String)query + "((tariff.date1 IS NULL OR tariff.date1<=?) AND (tariff.date2 IS NULL OR tariff.date2>=?)) AND !(plan.id IS NULL) AND !(contract.id IS NULL) GROUP BY tariff.tpid";
            ps = this.con.prepareStatement((String)query);
            ps.setDate(1, date);
            ps.setDate(2, date);
            rs = ps.executeQuery();
            while (rs.next()) {
                total.put(rs.getString(2), String.valueOf(rs.getInt(3)));
            }
            rs.close();
            ps.close();
            params.put("total", total);
            this.fillReportToStream(this.id, out, params, bds);
        }
        catch (Exception ex) {
            throw new BGException("\u041e\u0448\u0438\u0431\u043a\u0430 \u0444\u043e\u0440\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u043e\u0442\u0447\u0451\u0442\u0430", (Throwable)ex);
        }
    }
}

