/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.client;

import java.awt.Toolkit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class PatternDocumentFilter
extends DocumentFilter {
    private Pattern pattern;

    public PatternDocumentFilter(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
        String newStr = fb.getDocument().getText(0, offset) + string + fb.getDocument().getText(offset, fb.getDocument().getLength() - offset);
        Matcher m = this.pattern.matcher(newStr);
        if (m.matches()) {
            super.insertString(fb, offset, string, attr);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String string, AttributeSet attr) throws BadLocationException {
        if (string != null) {
            String newStr = fb.getDocument().getText(0, offset) + string + fb.getDocument().getText(offset + length, fb.getDocument().getLength() - (offset + length));
            Matcher m = this.pattern.matcher(newStr);
            if (m.matches()) {
                super.replace(fb, offset, length, string, attr);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    @Override
    public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
        String newStr = fb.getDocument().getText(0, offset) + fb.getDocument().getText(offset + length, fb.getDocument().getLength() - (offset + length));
        Matcher m = this.pattern.matcher(newStr);
        if (m.matches()) {
            super.remove(fb, offset, length);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

