/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import ru.bitel.bgbilling.modules.card.common.bean.Dealer;
import ru.bitel.bgbilling.modules.card.server.idealer.DealerFindException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class DealerManager {
    Connection con;
    int mid;

    public DealerManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dealer getDealer(String login, String pswd) throws DealerFindException {
        Dealer result;
        block10: {
            result = null;
            try {
                String tableName = "card_dealer_" + this.mid;
                if (!ServerUtils.tableExists((Connection)this.con, (String)tableName)) {
                    throw new DealerFindException("14", "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d \u043a\u043e\u0434 \u043c\u043e\u0434\u0443\u043b\u044f (mid)!");
                }
                String query = "SELECT * FROM " + tableName + " WHERE login=?";
                PreparedStatement ps = this.con.prepareStatement(query);
                ps.setString(1, login);
                ResultSet rs = ps.executeQuery();
                try {
                    if (rs.next()) {
                        result = this.getDealerFromRS(rs);
                        if (result.getError() > 5) {
                            result = null;
                            throw new DealerFindException("6", "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d \u043b\u0438\u043c\u0438\u0442 \u043d\u0435\u0443\u0434\u0430\u0447\u043d\u044b\u0445 \u043f\u043e\u043f\u044b\u0442\u043e\u043a \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f. \u041b\u043e\u0433\u0438\u043d \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d.");
                        }
                        if (!rs.getString("pswd").equals(pswd)) {
                            this.incDealerError(result.getId());
                            result = null;
                            throw new DealerFindException("2", "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c!");
                        }
                        GregorianCalendar now = new GregorianCalendar();
                        if (result.getDate1() != null && now.before(result.getDate1()) || result.getDate2() != null && now.after(result.getDate2())) {
                            result = null;
                            throw new DealerFindException("4", "\u0412\u044b \u0432\u043d\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0438!");
                        }
                        break block10;
                    }
                    throw new DealerFindException("1", "\u041b\u043e\u0433\u0438\u043d \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
                }
                finally {
                    rs.close();
                    ps.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public List<Dealer> getDealersByContractId(int cid, int type) {
        ArrayList<Dealer> result = new ArrayList<Dealer>();
        String query = "SELECT * FROM card_dealer_" + this.mid + " WHERE contract_id=?";
        if (type != 0) {
            query = query + " AND (type & " + type + ") > 0 ";
        }
        try {
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, cid);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getDealerFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public List<Dealer> getDealerList(String title, Calendar from, Calendar until, int type) {
        ArrayList<Dealer> result = new ArrayList<Dealer>();
        StringBuffer query = new StringBuffer("SELECT * FROM card_dealer_").append(this.mid).append(" WHERE id=id");
        if (title != null && title.trim().length() > 0) {
            query.append(" AND title REGEXP ?");
        }
        if (type != 0) {
            query.append(" AND (type & ?)>0");
        }
        if (from != null) {
            query.append(" AND ( isNull(date1) or date1>=? )");
        }
        if (until != null) {
            query.append(" AND ( isNull(date2) or date2<=? )");
        }
        query.append(" ORDER BY title");
        int i = 1;
        try {
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            if (title != null && title.trim().length() > 0) {
                ps.setString(i++, title);
            }
            if (type != 0) {
                ps.setInt(i++, type);
            }
            if (from != null) {
                ps.setDate(i++, TimeUtils.convertCalendarToSqlDate((Calendar)from));
            }
            if (until != null) {
                ps.setDate(i++, TimeUtils.convertCalendarToSqlDate((Calendar)until));
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getDealerFromRS(rs));
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void incDealerError(int id) {
        String query = "UPDATE card_dealer_" + this.mid + " SET error=error+1 WHERE id=?";
        try {
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public void incDealerFinded(int id) {
        String query = "UPDATE card_dealer_" + this.mid + " SET st_finded=st_finded+1 WHERE id=?";
        try {
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void incDealerFinded(int id, int count) {
        try {
            PreparedStatement ps = this.con.prepareStatement("UPDATE card_dealer_" + this.mid + " SET st_finded=st_finded+? WHERE id=?");
            ps.setInt(1, count);
            ps.setInt(2, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void incDealerPayed(int id) {
        String query = "UPDATE card_dealer_" + this.mid + " SET st_payed=st_payed+1 WHERE id=?";
        try {
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, id);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private Dealer getDealerFromRS(ResultSet rs) throws SQLException {
        Dealer result = new Dealer();
        result.setDate1(TimeUtils.convertDateToCalendar((Date)rs.getDate("date1")));
        result.setDate2(TimeUtils.convertDateToCalendar((Date)rs.getDate("date2")));
        result.setParams(rs.getInt("params"));
        result.setFindmodes(rs.getLong("findmodes"));
        result.setAllowcontracts(rs.getLong("allowcontracts"));
        result.setAllowcontractsMode(rs.getInt("allowcontracts_mode"));
        result.setId(rs.getInt("id"));
        result.setIp(rs.getString("ip"));
        result.setPt(rs.getString("pt"));
        result.setTitle(rs.getString("title"));
        result.setType(rs.getInt("type"));
        result.setContractId(rs.getInt("cid"));
        result.setCardPercent(rs.getFloat("card_percent"));
        result.setPayPercent(rs.getFloat("pay_percent"));
        result.setCardContract(rs.getString("card_contract"));
        result.setPayContract(rs.getString("pay_contract"));
        result.setCanselTime(rs.getInt("cansel_time"));
        result.setLogin(rs.getString("login"));
        result.setPassword(rs.getString("pswd"));
        result.setError(rs.getInt("error"));
        result.setComment(rs.getString("comment"));
        result.setStatRequest(rs.getInt("st_request"));
        result.setStatFinded(rs.getInt("st_finded"));
        result.setStatPayed(rs.getInt("st_payed"));
        result.setPayComissionType(rs.getInt("pay_comission_type"));
        result.setContractId(rs.getInt("contract_id"));
        return result;
    }
}

