/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.web.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.kernel.admin.web.common.bean.WebMenuItem;

public class WebMenuDao
extends AbstractIdDao<WebMenuItem> {
    public static final String TABLE_CONTRACT_WEB_MENU = "contract_web_menu";

    public WebMenuDao(Connection con) {
        super(con, 0, "web_menu");
    }

    public int getWebMenuIdForContract(int contractId) throws SQLException {
        int id = -1;
        String query = "SELECT web_menu_id FROM contract_web_menu WHERE contract_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    id = rs.getInt(1);
                }
            }
        }
        return id;
    }

    public void setWebMenuIdForContract(int webMenuItemId, int contractId) throws SQLException {
        String queryDelete = "DELETE FROM contract_web_menu WHERE contract_id=?";
        String queryInsert = "INSERT INTO contract_web_menu SET web_menu_id=?, contract_id=?";
        try (PreparedStatement psDelete = this.con.prepareStatement(queryDelete);
             PreparedStatement psInsert = this.con.prepareStatement(queryInsert);){
            psDelete.setInt(1, contractId);
            psDelete.executeUpdate();
            psInsert.setInt(1, webMenuItemId);
            psInsert.setInt(2, contractId);
            psInsert.executeUpdate();
        }
    }

    public String getData(int webMenuItemId) throws SQLException {
        String data = null;
        String query = "SELECT data FROM " + this.tableName + " WHERE id=?";
        try (PreparedStatement psSelect = this.con.prepareStatement(query);){
            psSelect.setInt(1, webMenuItemId);
            try (ResultSet rs = psSelect.executeQuery();){
                while (rs.next()) {
                    data = rs.getString(1);
                }
            }
        }
        return data;
    }

    public void deleteData(int webMenuItemId) throws BGMessageException, SQLException {
        int count = 0;
        Object query = "SELECT count(*) FROM contract_web_menu WHERE web_menu_id=?";
        try (PreparedStatement ps = this.con.prepareStatement((String)query);){
            ps.setInt(1, webMenuItemId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    count = rs.getInt(1);
                }
            }
        }
        if (count > 0) {
            throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e. Web-\u043c\u0435\u043d\u044e (id=" + webMenuItemId + ") \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430\u0445 [" + count + " \u0434\u043e\u0433.]");
        }
        query = "DELETE FROM " + this.tableName + " WHERE id=?";
        ps = this.con.prepareStatement((String)query);
        try {
            ps.setInt(1, webMenuItemId);
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public List<WebMenuItem> list() throws SQLException {
        ArrayList<WebMenuItem> list = new ArrayList<WebMenuItem>();
        String query = "SELECT * FROM " + this.tableName + " ORDER BY title";
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                list.add(this.getFromRS(rs));
            }
        }
        return list;
    }

    public Map<Integer, Integer> getContractCount() throws SQLException {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        String query = "SELECT web_menu_id, count(*) FROM contract_web_menu GROUP BY web_menu_id";
        try (Statement st = this.con.createStatement();
             ResultSet rs = st.executeQuery(query);){
            while (rs.next()) {
                map.put(rs.getInt(1), rs.getInt(2));
            }
        }
        return map;
    }

    public WebMenuItem updateInfo(WebMenuItem webMenuItem) throws Exception {
        super.update(webMenuItem);
        return webMenuItem;
    }

    public void updateData(int webMenuItemId, String data) throws Exception {
        String query = "UPDATE " + this.tableName + " SET data=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, data);
            ps.setInt(2, webMenuItemId);
            ps.executeUpdate();
        }
    }

    @Override
    protected WebMenuItem getFromRS(ResultSet rs) throws SQLException {
        return WebMenuItem.builder().setId(rs.getInt("id")).setDefault(rs.getBoolean("default")).setTitle(rs.getString("title")).build();
    }

    @Override
    protected void updateImpl(WebMenuItem webMenuItem) throws SQLException {
        Objects.requireNonNull(webMenuItem);
        boolean update = webMenuItem.getId() > 0;
        String query = this.sqlCommandAndTable(update) + " SET `default`=?, `title`=?" + this.sqlWhereId(update);
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setBoolean(index++, webMenuItem.isDefault());
            ps.setString(index++, webMenuItem.getTitle());
            this.executeUpdate(webMenuItem, index, ps);
        }
        if (webMenuItem.isDefault()) {
            query = "UPDATE " + this.tableName + " SET `default`=false WHERE id<>?";
            ps = this.con.prepareStatement(query);
            try {
                ps.setInt(1, webMenuItem.getId());
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
    }
}

