/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.subscription.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractDirectoryIdDao;
import ru.bitel.oss.systems.inventory.subscription.common.bean.SubscriptionMode;

public class SubscriptionModeDao
extends AbstractDirectoryIdDao<SubscriptionMode> {
    public SubscriptionModeDao(Connection con, int mid) {
        super(con, mid, "inv_subscription_mode");
    }

    protected SubscriptionMode getFromRS(ResultSet rs) throws SQLException, BGException {
        SubscriptionMode result = new SubscriptionMode();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        result.setTypeId(rs.getInt("typeId"));
        result.setDateFrom(TimeUtils.convertSqlDateToDate((java.sql.Date)rs.getDate("dateFrom")));
        result.setDateTo(TimeUtils.convertSqlDateToDate((java.sql.Date)rs.getDate("dateTo")));
        result.setPeriodMode(rs.getInt("periodMode"));
        result.setPeriodValue(rs.getInt("periodValue"));
        result.setUnsubscribeMode(rs.getInt("unsubscribeMode"));
        return result;
    }

    protected void updateImpl(SubscriptionMode b) throws BGException, SQLException {
        PreparedStatement ps;
        if (b.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (title, typeId, dateFrom, dateTo, periodMode, periodValue, unsubscribeMode) VALUES (?, ?, ?, ?, ?, ?, ?)", 1);
        } else {
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET title=?, typeId=?, dateFrom=?, dateTo=?, periodMode=?, periodValue=?, unsubscribeMode=? WHERE id=?");
            ps.setInt(8, b.getId());
        }
        ps.setString(1, b.getTitle());
        ps.setInt(2, b.getTypeId());
        ps.setDate(3, TimeUtils.convertDateToSqlDate((Date)b.getDateFrom()));
        ps.setDate(4, TimeUtils.convertDateToSqlDate((Date)b.getDateTo()));
        ps.setInt(5, b.getPeriodMode());
        ps.setInt(6, b.getPeriodValue());
        ps.setInt(7, b.getUnsubscribeMode());
        ps.executeUpdate();
        if (b.getId() <= 0) {
            b.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    public SubscriptionMode get(String title) throws BGException {
        throw new UnsupportedOperationException();
    }

    public List<SubscriptionMode> list() throws BGException {
        return this.list(null, "id", new Object[0]);
    }

    public List<SubscriptionMode> list(int subscriptionTypeId, Date date) throws BGException {
        java.sql.Date sqlDate = TimeUtils.convertDateToSqlDate((Date)date);
        return this.list("typeId=? AND (? OR ((dateFrom IS NULL OR dateFrom<=?) AND (dateTo IS NULL OR ?<=dateTo)))", "id", new Object[]{subscriptionTypeId, sqlDate == null, sqlDate, sqlDate});
    }
}

