/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tinkoff.server.event.worker;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.HashMap;
import org.slf4j.MDC;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.BGTransactionType;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.EventWorker;
import ru.bitel.bgbilling.modules.tinkoff.common.bean.Transaction;
import ru.bitel.bgbilling.modules.tinkoff.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.tinkoff.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.tinkoff.server.event.TinkoffAutopaymentEvent;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;

public class TinkoffAutopaymentEventWorker
extends EventWorker {
    private final int moduleId;
    private TransactionManager transactionManager;
    private AutopaymentManager autopaymentManager;
    private ContractDao contractDao;

    public TinkoffAutopaymentEventWorker(Setup setup, int moduleId) throws BGException {
        super(EventProcessor.getInstance(), TinkoffAutopaymentEvent.class, moduleId, -1, null);
        this.moduleId = moduleId;
        this.context = new EventListenerContext(setup, moduleId, SetupParam.getApplicationName());
        this.errorPause = 60000L;
        this.getLogger().info("Starting TinkoffAutopaymentEventWorker for moduleId: " + moduleId);
        new Thread((Runnable)((Object)this), "tinkoff-autopayment-event-wrkr-" + moduleId).start();
    }

    protected boolean runWorker() throws BGException {
        this.transactionManager = new TransactionManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
        this.autopaymentManager = new AutopaymentManager(((EventListenerContext)this.context).getConnection(), this.moduleId);
        this.contractDao = new ContractDao(((EventListenerContext)this.context).getConnection(), 0);
        try {
            boolean bl = this.doTasks();
            return bl;
        }
        finally {
            this.contractDao.close();
            this.contractDao = null;
        }
    }

    public Object doTask(Object task) throws BGException {
        TinkoffAutopaymentEvent event = (TinkoffAutopaymentEvent)((Object)task);
        int contractId = event.getContractId();
        MDC.put((String)"module", (String)"tinkoff");
        MDC.put((String)"moduleId", (String)String.valueOf(this.moduleId));
        MDC.put((String)"contractId", (String)String.valueOf(contractId));
        try {
            Contract contract;
            Autopayment autopayment = this.autopaymentManager.getCurrentAutopayment(contractId);
            BigDecimal sum = event.getSum();
            if (sum == null) {
                sum = autopayment.getSum();
            }
            if (autopayment != null && autopayment.getMode().getCode() == event.getMode() && (contract = (Contract)this.contractDao.get(contractId)) != null) {
                String customerAddress = ContractUtils.getCustomerAddress((Connection)((EventListenerContext)this.context).getConnection(), (int)this.moduleId, (int)contractId);
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                String paymentPhone = ContractUtils.getPaymentPhone((Connection)((EventListenerContext)this.context).getConnection(), (int)this.moduleId, (int)contractId);
                Transaction transaction = this.transactionManager.registerOrder(contractId, contract.getTitle(), customerAddress, sum, dataMap, true, false, BGTransactionType.CARD, paymentPhone);
                this.transactionManager.doCharge(transaction, autopayment);
            }
            Object var6_7 = null;
            return var6_7;
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        finally {
            MDC.remove((String)"module");
            MDC.remove((String)"moduleId");
            MDC.remove((String)"contractId");
        }
    }
}

